/***************************************************************************
**
** Copyright (C) 2015 Jochen Becher
** Contact: http://www.qt.io/licensing
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company.  For licensing terms and
** conditions see http://www.qt.io/terms-conditions.  For further information
** use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file.  Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, The Qt Company gives you certain additional
** rights.  These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
****************************************************************************/

#ifndef QMT_RESIZABLE_H
#define QMT_RESIZABLE_H

#include <QtGlobal>

QT_BEGIN_NAMESPACE
class QPointF;
class QRectF;
class QSizeF;
QT_END_NAMESPACE


namespace qmt {

class IResizable {
public:

    enum Side {
        SIDE_NONE,
        SIDE_LEFT_OR_TOP,
        SIDE_RIGHT_OR_BOTTOM
    };

public:
    virtual ~IResizable() { }

    virtual QPointF getPos() const = 0;

    virtual QRectF getRect() const = 0;

    virtual QSizeF getMinimumSize() const = 0;

    virtual void setPosAndRect(const QPointF &original_pos, const QRectF &original_rect, const QPointF &top_left_delta, const QPointF &bottom_right_delta) = 0;

    virtual void alignItemSizeToRaster(Side adjust_horizontal_side, Side adjust_vertical_side, double raster_width, double raster_height) = 0;
};

}

#endif // QMT_RESIZABLE_H
