/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtCore/QtDebug>
#include <QtGui/QApplication>

#include <string.h>

#include "qmljsengine_p.h"
#include "qmljslexer_p.h"
#include "qmljsast_p.h"
#include "qmljsnodepool_p.h"



#include "qmljsparser_p.h"
#include <QVarLengthArray>

//
// This file is automatically generated from qmljs.g.
// Changes will be lost.
//

using namespace QmlJS;

QT_QML_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (qRealloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (qRealloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<AST::SourceLocation*> (qRealloc(location_stack, stack_size * sizeof(AST::SourceLocation)));
}

inline static bool automatic(Engine *driver, int token)
{
    return token == QmlJSGrammar::T_RBRACE
        || token == 0
        || driver->lexer()->prevTerminator();
}


Parser::Parser(Engine *engine):
    driver(engine),
    tos(0),
    stack_size(0),
    sym_stack(0),
    state_stack(0),
    location_stack(0),
    first_token(0),
    last_token(0)
{
}

Parser::~Parser()
{
    if (stack_size) {
        qFree(sym_stack);
        qFree(state_stack);
        qFree(location_stack);
    }
}

static inline AST::SourceLocation location(Lexer *lexer)
{
    AST::SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->startLineNo();
    loc.startColumn = lexer->startColumnNo();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<NameId *, 4> nameIds;
    QVarLengthArray<AST::SourceLocation, 4> locations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = makeAstNode<AST::UiQualifiedId>(driver->nodePool(), idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = makeAstNode<AST::UiQualifiedId>(driver->nodePool(), currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
        }

        return currentId->finish();
    }

    return 0;
}

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    int yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    last_token = &token_buffer[1];

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->dval();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yylloc = first_token->loc;
                ++first_token;
            }
        }

        action = t_action(action, yytoken);
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yytoken = -1;
                sym(1).dval = yylval;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

          switch (r) {

case 0: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 1: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 2: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 3: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 4: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 5: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 6: {
  sym(1).UiProgram = makeAstNode<AST::UiProgram> (driver->nodePool(), sym(1).UiImportList,
        sym(2).UiObjectMemberList->finish());
} break;

case 8: {
    sym(1).Node = sym(1).UiImportList->finish();
} break;

case 9: {
    sym(1).Node = makeAstNode<AST::UiImportList> (driver->nodePool(), sym(1).UiImport);
} break;

case 10: {
    sym(1).Node = makeAstNode<AST::UiImportList> (driver->nodePool(),
        sym(1).UiImportList, sym(2).UiImport);
} break;

case 13: {
    sym(1).UiImport->semicolonToken = loc(2);
} break;

case 15: {
    sym(1).UiImport->versionToken = loc(2);
    sym(1).UiImport->semicolonToken = loc(3);
} break;

case 17: {
    sym(1).UiImport->versionToken = loc(2);
    sym(1).UiImport->asToken = loc(3);
    sym(1).UiImport->importIdToken = loc(4);
    sym(1).UiImport->importId = sym(4).sval;
    sym(1).UiImport->semicolonToken = loc(5);
} break;

case 19: {
    sym(1).UiImport->asToken = loc(2);
    sym(1).UiImport->importIdToken = loc(3);
    sym(1).UiImport->importId = sym(3).sval;
    sym(1).UiImport->semicolonToken = loc(4);
} break;

case 20: {
    AST::UiImport *node = 0;

    if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
        node = makeAstNode<AST::UiImport>(driver->nodePool(), importIdLiteral->value);
        node->fileNameToken = loc(2);
    } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
        QString text;
        for (AST::UiQualifiedId *q = qualifiedId; q; q = q->next) {
	   text += q->name->asString();
           if (q->next) text += QLatin1String(".");
        }
        node = makeAstNode<AST::UiImport>(driver->nodePool(), qualifiedId);
        node->fileNameToken = loc(2);
    }

    sym(1).Node = node;

    if (! node) {
       diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, loc(1),
         QLatin1String("Expected a qualified name id or a string literal")));

        return false; // ### remove me
    }
} break;

case 21: {
    sym(1).Node = 0;
} break;

case 22: {
    sym(1).Node = makeAstNode<AST::UiObjectMemberList> (driver->nodePool(), sym(1).UiObjectMember);
} break;

case 23: {
    sym(1).Node = makeAstNode<AST::UiObjectMemberList> (driver->nodePool(), sym(1).UiObjectMember);
} break;

case 24: {
    AST::UiObjectMemberList *node = makeAstNode<AST:: UiObjectMemberList> (driver->nodePool(),
        sym(1).UiObjectMemberList, sym(2).UiObjectMember);
    sym(1).Node = node;
} break;

case 25: {
    sym(1).Node = makeAstNode<AST::UiArrayMemberList> (driver->nodePool(), sym(1).UiObjectMember);
} break;

case 26: {
    AST::UiArrayMemberList *node = makeAstNode<AST::UiArrayMemberList> (driver->nodePool(),
        sym(1).UiArrayMemberList, sym(3).UiObjectMember);
    node->commaToken = loc(2);
    sym(1).Node = node;
} break;

case 27: {
    AST::UiObjectInitializer *node = makeAstNode<AST::UiObjectInitializer> (driver->nodePool(), (AST::UiObjectMemberList*)0);
    node->lbraceToken = loc(1);
    node->rbraceToken = loc(2);
    sym(1).Node = node;
}   break;

case 28: {
    AST::UiObjectInitializer *node = makeAstNode<AST::UiObjectInitializer> (driver->nodePool(), sym(2).UiObjectMemberList->finish());
    node->lbraceToken = loc(1);
    node->rbraceToken = loc(3);
    sym(1).Node = node;
}   break;

case 29: {
    AST::UiObjectDefinition *node = makeAstNode<AST::UiObjectDefinition> (driver->nodePool(), sym(1).UiQualifiedId,
        sym(2).UiObjectInitializer);
    sym(1).Node = node;
}   break;

case 31: {
    AST::UiArrayBinding *node = makeAstNode<AST::UiArrayBinding> (driver->nodePool(),
        sym(1).UiQualifiedId, sym(4).UiArrayMemberList->finish());
    node->colonToken = loc(2);
    node->lbracketToken = loc(3);
    node->rbracketToken = loc(5);
    sym(1).Node = node;
}   break;

case 32: {
    AST::UiObjectBinding *node = makeAstNode<AST::UiObjectBinding> (driver->nodePool(),
      sym(1).UiQualifiedId, sym(3).UiQualifiedId, sym(4).UiObjectInitializer);
    node->colonToken = loc(2);
    sym(1).Node = node;
} break;

case 33: {
    AST::UiObjectBinding *node = makeAstNode<AST::UiObjectBinding> (driver->nodePool(),
      sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
    node->colonToken = loc(2);
    node->hasOnToken = true;
    sym(1).Node = node;
} break;
case 34:case 35:case 36:case 37:
{
    AST::UiScriptBinding *node = makeAstNode<AST::UiScriptBinding> (driver->nodePool(),
        sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
}   break;

case 38:

case 39: {
    sym(1).sval = driver->intern(lexer->characterBuffer(), lexer->characterCount());
    break;
}

case 41: {
  sym(1).Node = 0;
} break;

case 42: {
  sym(1).Node = sym(1).UiParameterList->finish ();
} break;

case 43: {
  AST::UiParameterList *node = makeAstNode<AST::UiParameterList> (driver->nodePool(), sym(1).sval, sym(2).sval);
  node->identifierToken = loc(2);
  sym(1).Node = node;
} break;

case 44: {
  AST::UiParameterList *node = makeAstNode<AST::UiParameterList> (driver->nodePool(), sym(1).UiParameterList, sym(3).sval, sym(4).sval);
  node->commaToken = loc(2);
  node->identifierToken = loc(4);
  sym(1).Node = node;
} break;

case 46: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), (NameId *)0, sym(2).sval);
    node->type = AST::UiPublicMember::Signal;
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(2);
    node->parameters = sym(4).UiParameterList;
    node->semicolonToken = loc(6);
    sym(1).Node = node;
}   break;

case 48: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), (NameId *)0, sym(2).sval);
    node->type = AST::UiPublicMember::Signal;
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(2);
    node->semicolonToken = loc(3);
    sym(1).Node = node;
}   break;

case 50: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), sym(4).sval, sym(6).sval);
    node->typeModifier = sym(2).sval;
    node->propertyToken = loc(1);
    node->typeModifierToken = loc(2);
    node->typeToken = loc(4);
    node->identifierToken = loc(6);
    node->semicolonToken = loc(7);
    sym(1).Node = node;
}   break;

case 52: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), sym(2).sval, sym(3).sval);
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(3);
    node->semicolonToken = loc(4);
    sym(1).Node = node;
}   break;

case 54: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), sym(3).sval, sym(4).sval);
    node->isDefaultMember = true;
    node->defaultToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->semicolonToken = loc(5);
    sym(1).Node = node;
}   break;

case 56: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), sym(2).sval, sym(3).sval,
        sym(5).Expression);
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(3);
    node->colonToken = loc(4);
    node->semicolonToken = loc(6);
    sym(1).Node = node;
}   break;

case 58: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), sym(3).sval, sym(4).sval,
        sym(6).Expression);
    node->isReadonlyMember = true;
    node->readonlyToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->colonToken = loc(5);
    node->semicolonToken = loc(7);
    sym(1).Node = node;
}   break;

case 60: {
    AST::UiPublicMember *node = makeAstNode<AST::UiPublicMember> (driver->nodePool(), sym(3).sval, sym(4).sval,
        sym(6).Expression);
    node->isDefaultMember = true;
    node->defaultToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->colonToken = loc(5);
    node->semicolonToken = loc(7);
    sym(1).Node = node;
}   break;

case 61: {
    sym(1).Node = makeAstNode<AST::UiSourceElement>(driver->nodePool(), sym(1).Node);
}   break;

case 62: {
    sym(1).Node = makeAstNode<AST::UiSourceElement>(driver->nodePool(), sym(1).Node);
}   break;

case 64: {
    QString s = QLatin1String(QmlJSGrammar::spell[T_PROPERTY]);
    sym(1).sval = driver->intern(s.constData(), s.length());
    break;
}

case 65: {
    QString s = QLatin1String(QmlJSGrammar::spell[T_SIGNAL]);
    sym(1).sval = driver->intern(s.constData(), s.length());
    break;
}

case 66: {
    QString s = QLatin1String(QmlJSGrammar::spell[T_READONLY]);
    sym(1).sval = driver->intern(s.constData(), s.length());
    break;
}

case 67: {
    QString s = QLatin1String(QmlJSGrammar::spell[T_READONLY]);
    sym(1).sval = driver->intern(s.constData(), s.length());
    break;
}

case 68: {
  AST::ThisExpression *node = makeAstNode<AST::ThisExpression> (driver->nodePool());
  node->thisToken = loc(1);
  sym(1).Node = node;
} break;

case 69: {
  AST::IdentifierExpression *node = makeAstNode<AST::IdentifierExpression> (driver->nodePool(), sym(1).sval);
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 70: {
  AST::NullExpression *node = makeAstNode<AST::NullExpression> (driver->nodePool());
  node->nullToken = loc(1);
  sym(1).Node = node;
} break;

case 71: {
  AST::TrueLiteral *node = makeAstNode<AST::TrueLiteral> (driver->nodePool());
  node->trueToken = loc(1);
  sym(1).Node = node;
} break;

case 72: {
  AST::FalseLiteral *node = makeAstNode<AST::FalseLiteral> (driver->nodePool());
  node->falseToken = loc(1);
  sym(1).Node = node;
} break;

case 73: {
  AST::NumericLiteral *node = makeAstNode<AST::NumericLiteral> (driver->nodePool(), sym(1).dval);
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;
case 74:
case 75: {
  AST::StringLiteral *node = makeAstNode<AST::StringLiteral> (driver->nodePool(), sym(1).sval);
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;

case 76: {
  bool rx = lexer->scanRegExp(Lexer::NoPrefix);
  if (!rx) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, location(lexer), lexer->errorMessage()));
    return false; // ### remove me
  }
  AST::RegExpLiteral *node = makeAstNode<AST::RegExpLiteral> (driver->nodePool(), lexer->pattern, lexer->flags);
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;

case 77: {
  bool rx = lexer->scanRegExp(Lexer::EqualPrefix);
  if (!rx) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, location(lexer), lexer->errorMessage()));
    return false;
  }
  AST::RegExpLiteral *node = makeAstNode<AST::RegExpLiteral> (driver->nodePool(), lexer->pattern, lexer->flags);
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;

case 78: {
  AST::ArrayLiteral *node = makeAstNode<AST::ArrayLiteral> (driver->nodePool(), (AST::Elision *) 0);
  node->lbracketToken = loc(1);
  node->rbracketToken = loc(2);
  sym(1).Node = node;
} break;

case 79: {
  AST::ArrayLiteral *node = makeAstNode<AST::ArrayLiteral> (driver->nodePool(), sym(2).Elision->finish());
  node->lbracketToken = loc(1);
  node->rbracketToken = loc(3);
  sym(1).Node = node;
} break;

case 80: {
  AST::ArrayLiteral *node = makeAstNode<AST::ArrayLiteral> (driver->nodePool(), sym(2).ElementList->finish ());
  node->lbracketToken = loc(1);
  node->rbracketToken = loc(3);
  sym(1).Node = node;
} break;

case 81: {
  AST::ArrayLiteral *node = makeAstNode<AST::ArrayLiteral> (driver->nodePool(), sym(2).ElementList->finish (),
    (AST::Elision *) 0);
  node->lbracketToken = loc(1);
  node->commaToken = loc(3);
  node->rbracketToken = loc(4);
  sym(1).Node = node;
} break;

case 82: {
  AST::ArrayLiteral *node = makeAstNode<AST::ArrayLiteral> (driver->nodePool(), sym(2).ElementList->finish (),
    sym(4).Elision->finish());
  node->lbracketToken = loc(1);
  node->commaToken = loc(3);
  node->rbracketToken = loc(5);
  sym(1).Node = node;
} break;

case 83: {
  AST::ObjectLiteral *node = 0;
  if (sym(2).Node)
    node = makeAstNode<AST::ObjectLiteral> (driver->nodePool(),
        sym(2).PropertyNameAndValueList->finish ());
  else
    node = makeAstNode<AST::ObjectLiteral> (driver->nodePool());
  node->lbraceToken = loc(1);
  node->lbraceToken = loc(3);
  sym(1).Node = node;
} break;

case 84: {
  AST::ObjectLiteral *node = makeAstNode<AST::ObjectLiteral> (driver->nodePool(),
    sym(2).PropertyNameAndValueList->finish ());
  node->lbraceToken = loc(1);
  node->lbraceToken = loc(4);
  sym(1).Node = node;
} break;

case 85: {
  AST::NestedExpression *node = makeAstNode<AST::NestedExpression>(driver->nodePool(), sym(2).Expression);
  node->lparenToken = loc(1);
  node->rparenToken = loc(3);
  sym(1).Node = node;
} break;

case 86: {
  if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Warning, mem->lbracketToken,
      QLatin1String("Ignored annotation")));

    sym(1).Expression = mem->base;
  }

  if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
    sym(1).UiQualifiedId = qualifiedId;
  } else {
    sym(1).UiQualifiedId = 0;

    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, loc(1),
      QLatin1String("Expected a qualified name id")));

    return false; // ### recover
  }
} break;

case 87: {
  sym(1).Node = makeAstNode<AST::ElementList> (driver->nodePool(), (AST::Elision *) 0, sym(1).Expression);
} break;

case 88: {
  sym(1).Node = makeAstNode<AST::ElementList> (driver->nodePool(), sym(1).Elision->finish(), sym(2).Expression);
} break;

case 89: {
  AST::ElementList *node = makeAstNode<AST::ElementList> (driver->nodePool(), sym(1).ElementList,
    (AST::Elision *) 0, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 90: {
  AST::ElementList *node = makeAstNode<AST::ElementList> (driver->nodePool(), sym(1).ElementList, sym(3).Elision->finish(),
    sym(4).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 91: {
  AST::Elision *node = makeAstNode<AST::Elision> (driver->nodePool());
  node->commaToken = loc(1);
  sym(1).Node = node;
} break;

case 92: {
  AST::Elision *node = makeAstNode<AST::Elision> (driver->nodePool(), sym(1).Elision);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 93: {
  AST::PropertyNameAndValueList *node = makeAstNode<AST::PropertyNameAndValueList> (driver->nodePool(),
      sym(1).PropertyName, sym(3).Expression);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;

case 94: {
  AST::PropertyNameAndValueList *node = makeAstNode<AST::PropertyNameAndValueList> (driver->nodePool(),
      sym(1).PropertyNameAndValueList, sym(3).PropertyName, sym(5).Expression);
  node->commaToken = loc(2);
  node->colonToken = loc(4);
  sym(1).Node = node;
} break;

case 95: {
  AST::IdentifierPropertyName *node = makeAstNode<AST::IdentifierPropertyName> (driver->nodePool(), sym(1).sval);
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;
case 96:
case 97: {
  AST::IdentifierPropertyName *node = makeAstNode<AST::IdentifierPropertyName> (driver->nodePool(), driver->intern(lexer->characterBuffer(), lexer->characterCount()));
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 98: {
  AST::StringLiteralPropertyName *node = makeAstNode<AST::StringLiteralPropertyName> (driver->nodePool(), sym(1).sval);
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 99: {
  AST::NumericLiteralPropertyName *node = makeAstNode<AST::NumericLiteralPropertyName> (driver->nodePool(), sym(1).dval);
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 100: {
  AST::IdentifierPropertyName *node = makeAstNode<AST::IdentifierPropertyName> (driver->nodePool(), sym(1).sval);
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 101:

case 102:

case 103:

case 104:

case 105:

case 106:

case 107:

case 108:

case 109:

case 110:

case 111:

case 112:

case 113:

case 114:

case 115:

case 116:

case 117:

case 118:

case 119:

case 120:

case 121:

case 122:

case 123:

case 124:

case 125:

case 126:

case 127:

case 128:

case 129:

case 130:

case 131:
{
  sym(1).sval = driver->intern(lexer->characterBuffer(), lexer->characterCount());
} break;

case 136: {
  AST::ArrayMemberExpression *node = makeAstNode<AST::ArrayMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  node->lbracketToken = loc(2);
  node->rbracketToken = loc(4);
  sym(1).Node = node;
} break;

case 137: {
  AST::FieldMemberExpression *node = makeAstNode<AST::FieldMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).sval);
  node->dotToken = loc(2);
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 138: {
  AST::NewMemberExpression *node = makeAstNode<AST::NewMemberExpression> (driver->nodePool(), sym(2).Expression, sym(4).ArgumentList);
  node->newToken = loc(1);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  sym(1).Node = node;
} break;

case 140: {
  AST::NewExpression *node = makeAstNode<AST::NewExpression> (driver->nodePool(), sym(2).Expression);
  node->newToken = loc(1);
  sym(1).Node = node;
} break;

case 141: {
  AST::CallExpression *node = makeAstNode<AST::CallExpression> (driver->nodePool(), sym(1).Expression, sym(3).ArgumentList);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 142: {
  AST::CallExpression *node = makeAstNode<AST::CallExpression> (driver->nodePool(), sym(1).Expression, sym(3).ArgumentList);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 143: {
  AST::ArrayMemberExpression *node = makeAstNode<AST::ArrayMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  node->lbracketToken = loc(2);
  node->rbracketToken = loc(4);
  sym(1).Node = node;
} break;

case 144: {
  AST::FieldMemberExpression *node = makeAstNode<AST::FieldMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).sval);
  node->dotToken = loc(2);
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 145: {
  sym(1).Node = 0;
} break;

case 146: {
  sym(1).Node = sym(1).ArgumentList->finish();
} break;

case 147: {
  sym(1).Node = makeAstNode<AST::ArgumentList> (driver->nodePool(), sym(1).Expression);
} break;

case 148: {
  AST::ArgumentList *node = makeAstNode<AST::ArgumentList> (driver->nodePool(), sym(1).ArgumentList, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 152: {
  AST::PostIncrementExpression *node = makeAstNode<AST::PostIncrementExpression> (driver->nodePool(), sym(1).Expression);
  node->incrementToken = loc(2);
  sym(1).Node = node;
} break;

case 153: {
  AST::PostDecrementExpression *node = makeAstNode<AST::PostDecrementExpression> (driver->nodePool(), sym(1).Expression);
  node->decrementToken = loc(2);
  sym(1).Node = node;
} break;

case 155: {
  AST::DeleteExpression *node = makeAstNode<AST::DeleteExpression> (driver->nodePool(), sym(2).Expression);
  node->deleteToken = loc(1);
  sym(1).Node = node;
} break;

case 156: {
  AST::VoidExpression *node = makeAstNode<AST::VoidExpression> (driver->nodePool(), sym(2).Expression);
  node->voidToken = loc(1);
  sym(1).Node = node;
} break;

case 157: {
  AST::TypeOfExpression *node = makeAstNode<AST::TypeOfExpression> (driver->nodePool(), sym(2).Expression);
  node->typeofToken = loc(1);
  sym(1).Node = node;
} break;

case 158: {
  AST::PreIncrementExpression *node = makeAstNode<AST::PreIncrementExpression> (driver->nodePool(), sym(2).Expression);
  node->incrementToken = loc(1);
  sym(1).Node = node;
} break;

case 159: {
  AST::PreDecrementExpression *node = makeAstNode<AST::PreDecrementExpression> (driver->nodePool(), sym(2).Expression);
  node->decrementToken = loc(1);
  sym(1).Node = node;
} break;

case 160: {
  AST::UnaryPlusExpression *node = makeAstNode<AST::UnaryPlusExpression> (driver->nodePool(), sym(2).Expression);
  node->plusToken = loc(1);
  sym(1).Node = node;
} break;

case 161: {
  AST::UnaryMinusExpression *node = makeAstNode<AST::UnaryMinusExpression> (driver->nodePool(), sym(2).Expression);
  node->minusToken = loc(1);
  sym(1).Node = node;
} break;

case 162: {
  AST::TildeExpression *node = makeAstNode<AST::TildeExpression> (driver->nodePool(), sym(2).Expression);
  node->tildeToken = loc(1);
  sym(1).Node = node;
} break;

case 163: {
  AST::NotExpression *node = makeAstNode<AST::NotExpression> (driver->nodePool(), sym(2).Expression);
  node->notToken = loc(1);
  sym(1).Node = node;
} break;

case 165: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Mul, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 166: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Div, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 167: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Mod, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 169: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Add, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 170: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Sub, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 172: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::LShift, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 173: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::RShift, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 174: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::URShift, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 176: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Lt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 177: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Gt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 178: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Le, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 179: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Ge, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 180: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::InstanceOf, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 181: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::In, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 183: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Lt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 184: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Gt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 185: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Le, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 186: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
   QSOperator::Ge, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 187: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::InstanceOf, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 189: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Equal, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 190: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::NotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 191: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::StrictEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 192: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::StrictNotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 194: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Equal, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 195: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::NotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 196: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::StrictEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 197: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::StrictNotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 199: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::BitAnd, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 201: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::BitAnd, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 203: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::BitXor, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 205: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::BitXor, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 207: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::BitOr, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 209: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::BitOr, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 211: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::And, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 213: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::And, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 215: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Or, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 217: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    QSOperator::Or, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 219: {
  AST::ConditionalExpression *node = makeAstNode<AST::ConditionalExpression> (driver->nodePool(), sym(1).Expression,
    sym(3).Expression, sym(5).Expression);
  node->questionToken = loc(2);
  node->colonToken = loc(4);
  sym(1).Node = node;
} break;

case 221: {
  AST::ConditionalExpression *node = makeAstNode<AST::ConditionalExpression> (driver->nodePool(), sym(1).Expression,
    sym(3).Expression, sym(5).Expression);
  node->questionToken = loc(2);
  node->colonToken = loc(4);
  sym(1).Node = node;
} break;

case 223: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    sym(2).ival, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 225: {
  AST::BinaryExpression *node = makeAstNode<AST::BinaryExpression> (driver->nodePool(), sym(1).Expression,
    sym(2).ival, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 226: {
  sym(1).ival = QSOperator::Assign;
} break;

case 227: {
  sym(1).ival = QSOperator::InplaceMul;
} break;

case 228: {
  sym(1).ival = QSOperator::InplaceDiv;
} break;

case 229: {
  sym(1).ival = QSOperator::InplaceMod;
} break;

case 230: {
  sym(1).ival = QSOperator::InplaceAdd;
} break;

case 231: {
  sym(1).ival = QSOperator::InplaceSub;
} break;

case 232: {
  sym(1).ival = QSOperator::InplaceLeftShift;
} break;

case 233: {
  sym(1).ival = QSOperator::InplaceRightShift;
} break;

case 234: {
  sym(1).ival = QSOperator::InplaceURightShift;
} break;

case 235: {
  sym(1).ival = QSOperator::InplaceAnd;
} break;

case 236: {
  sym(1).ival = QSOperator::InplaceXor;
} break;

case 237: {
  sym(1).ival = QSOperator::InplaceOr;
} break;

case 239: {
  AST::Expression *node = makeAstNode<AST::Expression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 240: {
  sym(1).Node = 0;
} break;

case 243: {
  AST::Expression *node = makeAstNode<AST::Expression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 244: {
  sym(1).Node = 0;
} break;

case 261: {
  AST::Block *node = makeAstNode<AST::Block> (driver->nodePool(), sym(2).StatementList);
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(3);
  sym(1).Node = node;
} break;

case 262: {
  sym(1).Node = makeAstNode<AST::StatementList> (driver->nodePool(), sym(1).Statement);
} break;

case 263: {
  sym(1).Node = makeAstNode<AST::StatementList> (driver->nodePool(), sym(1).StatementList, sym(2).Statement);
} break;

case 264: {
  sym(1).Node = 0;
} break;

case 265: {
  sym(1).Node = sym(1).StatementList->finish ();
} break;

case 267: {
  AST::VariableStatement *node = makeAstNode<AST::VariableStatement> (driver->nodePool(),
     sym(2).VariableDeclarationList->finish (/*readOnly=*/sym(1).ival == T_CONST));
  node->declarationKindToken = loc(1);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 268: {
  sym(1).ival = T_CONST;
} break;

case 269: {
  sym(1).ival = T_VAR;
} break;

case 270: {
  sym(1).Node = makeAstNode<AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclaration);
} break;

case 271: {
  AST::VariableDeclarationList *node = makeAstNode<AST::VariableDeclarationList> (driver->nodePool(),
    sym(1).VariableDeclarationList, sym(3).VariableDeclaration);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 272: {
  sym(1).Node = makeAstNode<AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclaration);
} break;

case 273: {
  sym(1).Node = makeAstNode<AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclarationList, sym(3).VariableDeclaration);
} break;

case 274: {
  AST::VariableDeclaration *node = makeAstNode<AST::VariableDeclaration> (driver->nodePool(), sym(1).sval, sym(2).Expression);
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 275: {
  AST::VariableDeclaration *node = makeAstNode<AST::VariableDeclaration> (driver->nodePool(), sym(1).sval, sym(2).Expression);
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 276: {
  // ### TODO: AST for initializer
  sym(1) = sym(2);
} break;

case 277: {
  sym(1).Node = 0;
} break;

case 279: {
  // ### TODO: AST for initializer
  sym(1) = sym(2);
} break;

case 280: {
  sym(1).Node = 0;
} break;

case 282: {
  AST::EmptyStatement *node = makeAstNode<AST::EmptyStatement> (driver->nodePool());
  node->semicolonToken = loc(1);
  sym(1).Node = node;
} break;

case 284: {
  AST::ExpressionStatement *node = makeAstNode<AST::ExpressionStatement> (driver->nodePool(), sym(1).Expression);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 285: {
  AST::IfStatement *node = makeAstNode<AST::IfStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement, sym(7).Statement);
  node->ifToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  node->elseToken = loc(5);
  sym(1).Node = node;
} break;

case 286: {
  AST::IfStatement *node = makeAstNode<AST::IfStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement);
  node->ifToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 288: {
  AST::DoWhileStatement *node = makeAstNode<AST::DoWhileStatement> (driver->nodePool(), sym(2).Statement, sym(5).Expression);
  node->doToken = loc(1);
  node->whileToken = loc(3);
  node->lparenToken = loc(4);
  node->rparenToken = loc(6);
  node->semicolonToken = loc(7);
  sym(1).Node = node;
} break;

case 289: {
  AST::WhileStatement *node = makeAstNode<AST::WhileStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement);
  node->whileToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 290: {
  AST::ForStatement *node = makeAstNode<AST::ForStatement> (driver->nodePool(), sym(3).Expression,
    sym(5).Expression, sym(7).Expression, sym(9).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->firstSemicolonToken = loc(4);
  node->secondSemicolonToken = loc(6);
  node->rparenToken = loc(8);
  sym(1).Node = node;
} break;

case 291: {
  AST::LocalForStatement *node = makeAstNode<AST::LocalForStatement> (driver->nodePool(),
     sym(4).VariableDeclarationList->finish (/*readOnly=*/false), sym(6).Expression,
     sym(8).Expression, sym(10).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->varToken = loc(3);
  node->firstSemicolonToken = loc(5);
  node->secondSemicolonToken = loc(7);
  node->rparenToken = loc(9);
  sym(1).Node = node;
} break;

case 292: {
  AST:: ForEachStatement *node = makeAstNode<AST::ForEachStatement> (driver->nodePool(), sym(3).Expression,
    sym(5).Expression, sym(7).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->inToken = loc(4);
  node->rparenToken = loc(6);
  sym(1).Node = node;
} break;

case 293: {
  AST::LocalForEachStatement *node = makeAstNode<AST::LocalForEachStatement> (driver->nodePool(),
    sym(4).VariableDeclaration, sym(6).Expression, sym(8).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->varToken = loc(3);
  node->inToken = loc(5);
  node->rparenToken = loc(7);
  sym(1).Node = node;
} break;

case 295: {
  AST::ContinueStatement *node = makeAstNode<AST::ContinueStatement> (driver->nodePool());
  node->continueToken = loc(1);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 297: {
  AST::ContinueStatement *node = makeAstNode<AST::ContinueStatement> (driver->nodePool(), sym(2).sval);
  node->continueToken = loc(1);
  node->identifierToken = loc(2);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 299: {
  AST::BreakStatement *node = makeAstNode<AST::BreakStatement> (driver->nodePool());
  node->breakToken = loc(1);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 301: {
  AST::BreakStatement *node = makeAstNode<AST::BreakStatement> (driver->nodePool(), sym(2).sval);
  node->breakToken = loc(1);
  node->identifierToken = loc(2);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 303: {
  AST::ReturnStatement *node = makeAstNode<AST::ReturnStatement> (driver->nodePool(), sym(2).Expression);
  node->returnToken = loc(1);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 304: {
  AST::WithStatement *node = makeAstNode<AST::WithStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement);
  node->withToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 305: {
  AST::SwitchStatement *node = makeAstNode<AST::SwitchStatement> (driver->nodePool(), sym(3).Expression, sym(5).CaseBlock);
  node->switchToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 306: {
  AST::CaseBlock *node = makeAstNode<AST::CaseBlock> (driver->nodePool(), sym(2).CaseClauses);
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(3);
  sym(1).Node = node;
} break;

case 307: {
  AST::CaseBlock *node = makeAstNode<AST::CaseBlock> (driver->nodePool(), sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(5);
  sym(1).Node = node;
} break;

case 308: {
  sym(1).Node = makeAstNode<AST::CaseClauses> (driver->nodePool(), sym(1).CaseClause);
} break;

case 309: {
  sym(1).Node = makeAstNode<AST::CaseClauses> (driver->nodePool(), sym(1).CaseClauses, sym(2).CaseClause);
} break;

case 310: {
  sym(1).Node = 0;
} break;

case 311: {
  sym(1).Node = sym(1).CaseClauses->finish ();
} break;

case 312: {
  AST::CaseClause *node = makeAstNode<AST::CaseClause> (driver->nodePool(), sym(2).Expression, sym(4).StatementList);
  node->caseToken = loc(1);
  node->colonToken = loc(3);
  sym(1).Node = node;
} break;

case 313: {
  AST::DefaultClause *node = makeAstNode<AST::DefaultClause> (driver->nodePool(), sym(3).StatementList);
  node->defaultToken = loc(1);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;
case 314:
case 315: {
  AST::LabelledStatement *node = makeAstNode<AST::LabelledStatement> (driver->nodePool(), driver->intern(lexer->characterBuffer(), lexer->characterCount()), sym(3).Statement);
  node->identifierToken = loc(1);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;

case 316: {
  AST::LabelledStatement *node = makeAstNode<AST::LabelledStatement> (driver->nodePool(), sym(1).sval, sym(3).Statement);
  node->identifierToken = loc(1);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;

case 318: {
  AST::ThrowStatement *node = makeAstNode<AST::ThrowStatement> (driver->nodePool(), sym(2).Expression);
  node->throwToken = loc(1);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 319: {
  AST::TryStatement *node = makeAstNode<AST::TryStatement> (driver->nodePool(), sym(2).Statement, sym(3).Catch);
  node->tryToken = loc(1);
  sym(1).Node = node;
} break;

case 320: {
  AST::TryStatement *node = makeAstNode<AST::TryStatement> (driver->nodePool(), sym(2).Statement, sym(3).Finally);
  node->tryToken = loc(1);
  sym(1).Node = node;
} break;

case 321: {
  AST::TryStatement *node = makeAstNode<AST::TryStatement> (driver->nodePool(), sym(2).Statement, sym(3).Catch, sym(4).Finally);
  node->tryToken = loc(1);
  sym(1).Node = node;
} break;

case 322: {
  AST::Catch *node = makeAstNode<AST::Catch> (driver->nodePool(), sym(3).sval, sym(5).Block);
  node->catchToken = loc(1);
  node->lparenToken = loc(2);
  node->identifierToken = loc(3);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 323: {
  AST::Finally *node = makeAstNode<AST::Finally> (driver->nodePool(), sym(2).Block);
  node->finallyToken = loc(1);
  sym(1).Node = node;
} break;

case 325: {
  AST::DebuggerStatement *node = makeAstNode<AST::DebuggerStatement> (driver->nodePool());
  node->debuggerToken = loc(1);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 326: {
  AST::FunctionDeclaration *node = makeAstNode<AST::FunctionDeclaration> (driver->nodePool(), sym(2).sval, sym(4).FormalParameterList, sym(7).FunctionBody);
  node->functionToken = loc(1);
  node->identifierToken = loc(2);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  node->lbraceToken = loc(6);
  node->rbraceToken = loc(8);
  sym(1).Node = node;
} break;

case 327: {
  AST::FunctionExpression *node = makeAstNode<AST::FunctionExpression> (driver->nodePool(), sym(2).sval, sym(4).FormalParameterList, sym(7).FunctionBody);
  node->functionToken = loc(1);
  if (sym(2).sval)
      node->identifierToken = loc(2);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  node->lbraceToken = loc(6);
  node->rbraceToken = loc(8);
  sym(1).Node = node;
} break;

case 328: {
  AST::FormalParameterList *node = makeAstNode<AST::FormalParameterList> (driver->nodePool(), sym(1).sval);
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 329: {
  AST::FormalParameterList *node = makeAstNode<AST::FormalParameterList> (driver->nodePool(), sym(1).FormalParameterList, sym(3).sval);
  node->commaToken = loc(2);
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 330: {
  sym(1).Node = 0;
} break;

case 331: {
  sym(1).Node = sym(1).FormalParameterList->finish ();
} break;

case 332: {
  sym(1).Node = 0;
} break;

case 334: {
  sym(1).Node = makeAstNode<AST::FunctionBody> (driver->nodePool(), sym(1).SourceElements->finish ());
} break;

case 335: {
  sym(1).Node = makeAstNode<AST::Program> (driver->nodePool(), sym(1).SourceElements->finish ());
} break;

case 336: {
  sym(1).Node = makeAstNode<AST::SourceElements> (driver->nodePool(), sym(1).SourceElement);
} break;

case 337: {
  sym(1).Node = makeAstNode<AST::SourceElements> (driver->nodePool(), sym(1).SourceElements, sym(2).SourceElement);
} break;

case 338: {
  sym(1).Node = makeAstNode<AST::StatementSourceElement> (driver->nodePool(), sym(1).Statement);
} break;

case 339: {
  sym(1).Node = makeAstNode<AST::FunctionSourceElement> (driver->nodePool(), sym(1).FunctionDeclaration);
} break;

case 340: {
  sym(1).sval = 0;
} break;

case 342: {
  sym(1).Node = 0;
} break;

            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of `;'
        if (yytoken != -1 && t_action(errorState, T_AUTOMATIC_SEMICOLON) && automatic(driver, yytoken)) {
            SavedToken &tk = token_buffer[0];
            tk.token = yytoken;
            tk.dval = yylval;
            tk.loc = yylloc;

            yylloc = yyprevlloc;
            yylloc.offset += yylloc.length;
            yylloc.startColumn += yylloc.length;
            yylloc.length = 0;

            //const QString msg = qApp->translate("QmlParser", "Missing `;'");
            //diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Warning, yylloc, msg));

            first_token = &token_buffer[0];
            last_token = &token_buffer[1];

            yytoken = T_SEMICOLON;
            yylval = 0;

            action = errorState;

            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken = lexer->lex();
        token_buffer[1].dval  = yylval  = lexer->dval();
        token_buffer[1].loc   = yylloc  = location(lexer);

        if (t_action(errorState, yytoken)) {
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = qApp->translate("QmlParser", "Syntax error");
            else
                msg = qApp->translate("QmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = qApp->translate("QmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));

                yytoken = *tk;
                yylval = 0;
                yylloc = token_buffer[0].loc;
                yylloc.length = 0;

                first_token = &token_buffer[0];
                last_token = &token_buffer[2];

                action = errorState;
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION ||
                tk == T_FEED_JS_SOURCE_ELEMENT)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = qApp->translate("QmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));

                yytoken = tk;
                yylval = 0;
                yylloc = token_buffer[0].loc;
                yylloc.length = 0;

                action = errorState;
                goto _Lcheck_token;
            }
        }

        const QString msg = qApp->translate("QmlParser", "Syntax error");
        diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));
    }

    return false;
}

QT_QML_END_NAMESPACE


