/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "/home/buildbot/git/sql/myskel.m4"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         ORAparse
#define yylex           ORAlex
#define yyerror         ORAerror
#define yydebug         ORAdebug
#define yynerrs         ORAnerrs


/* Copy the first part of user declarations.  */
#line 25 "/home/buildbot/git/sql/sql_yacc.yy"


#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include "mariadb.h"
#include "sql_priv.h"
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* partition_info, HASH_PARTITION */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_show.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "sql_cte.h"
#include "sql_window.h"
#include "item_windowfunc.h"
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"
#include "lex_token.h"
#include "sql_lex.h"
#include "sql_sequence.h"
#include "my_base.h"
#include "sql_type_json.h"
#include "json_table.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    size_t val= *(F);                          \
    if (unlikely(my_yyoverflow((B), (D), &val))) \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)                  \
  if (unlikely(!(A)))                            \
  {                                              \
    thd->parse_error();                          \
    MYSQL_YYABORT;                               \
  }

#define my_yyabort_error(A)                      \
  do { my_error A; MYSQL_YYABORT; } while(0)

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif


static Item* escape(THD *thd)
{
  thd->lex->escape_used= false;
  const char *esc= thd->variables.sql_mode & MODE_NO_BACKSLASH_ESCAPES ? "" : "\\";
  return new (thd->mem_root) Item_string_ascii(thd, esc, MY_TEST(esc[0]));
}


/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use thd->parse_error() or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

static void yyerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER_THD(thd, ER_SYNTAX_ERROR);
  thd->parse_error(s, 0);
}


#ifndef DBUG_OFF
#define __CONCAT_UNDERSCORED(x,y)  x ## _ ## y
#define _CONCAT_UNDERSCORED(x,y)   __CONCAT_UNDERSCORED(x,y)
void _CONCAT_UNDERSCORED(turn_parser_debug_on,yyparse)()
{
  /*
     MYSQLdebug is in sql/yy_*.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

#ifndef _AIX
  extern int yydebug;
#else
  static int yydebug;
#endif
  yydebug= 1;
}
#endif


#define bincmp_collation(X,Y)           \
  do                                    \
  {                                     \
     if (unlikely(Lex->set_bincmp(X,Y))) \
       MYSQL_YYABORT;                   \
  } while(0)

#define set_collation(X)           \
  do {  \
    if (X)  \
    {  \
      if (unlikely(Lex->charset && !my_charset_same(Lex->charset,X)))  \
        my_yyabort_error((ER_COLLATION_CHARSET_MISMATCH, MYF(0),  \
                          X->coll_name.str,Lex->charset->cs_name.str));  \
      Lex->charset= X;  \
    }  \
  } while(0)



#line 261 "/home/buildbot/git/mkdist/sql/yy_oracle.cc"


# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "yy_oracle.hh".  */
#ifndef YY_ORA_HOME_BUILDBOT_GIT_MKDIST_SQL_YY_ORACLE_HH_INCLUDED
# define YY_ORA_HOME_BUILDBOT_GIT_MKDIST_SQL_YY_ORACLE_HH_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int ORAdebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ABORT_SYM = 258,
    IMPOSSIBLE_ACTION = 259,
    END_OF_INPUT = 260,
    COLON_ORACLE_SYM = 261,
    PARAM_MARKER = 262,
    FOR_SYSTEM_TIME_SYM = 263,
    LEFT_PAREN_ALT = 264,
    LEFT_PAREN_WITH = 265,
    LEFT_PAREN_LIKE = 266,
    ORACLE_CONCAT_SYM = 267,
    PERCENT_ORACLE_SYM = 268,
    WITH_CUBE_SYM = 269,
    WITH_ROLLUP_SYM = 270,
    WITH_SYSTEM_SYM = 271,
    IDENT = 272,
    IDENT_QUOTED = 273,
    LEX_HOSTNAME = 274,
    UNDERSCORE_CHARSET = 275,
    BIN_NUM = 276,
    DECIMAL_NUM = 277,
    FLOAT_NUM = 278,
    HEX_NUM = 279,
    HEX_STRING = 280,
    LONG_NUM = 281,
    NCHAR_STRING = 282,
    NUM = 283,
    TEXT_STRING = 284,
    ULONGLONG_NUM = 285,
    AND_AND_SYM = 286,
    DOT_DOT_SYM = 287,
    EQUAL_SYM = 288,
    GE = 289,
    LE = 290,
    MYSQL_CONCAT_SYM = 291,
    NE = 292,
    NOT2_SYM = 293,
    OR2_SYM = 294,
    SET_VAR = 295,
    SHIFT_LEFT = 296,
    SHIFT_RIGHT = 297,
    ACCESSIBLE_SYM = 298,
    ADD = 299,
    ALL = 300,
    ALTER = 301,
    ANALYZE_SYM = 302,
    AND_SYM = 303,
    ASC = 304,
    ASENSITIVE_SYM = 305,
    AS = 306,
    BEFORE_SYM = 307,
    BETWEEN_SYM = 308,
    BIGINT = 309,
    BINARY = 310,
    BIT_AND = 311,
    BIT_OR = 312,
    BIT_XOR = 313,
    BLOB_MARIADB_SYM = 314,
    BLOB_ORACLE_SYM = 315,
    BODY_ORACLE_SYM = 316,
    BOTH = 317,
    BY = 318,
    CALL_SYM = 319,
    CASCADE = 320,
    CASE_SYM = 321,
    CAST_SYM = 322,
    CHANGE = 323,
    CHAR_SYM = 324,
    CHECK_SYM = 325,
    COLLATE_SYM = 326,
    CONDITION_SYM = 327,
    CONSTRAINT = 328,
    CONTINUE_MARIADB_SYM = 329,
    CONTINUE_ORACLE_SYM = 330,
    CONVERT_SYM = 331,
    COUNT_SYM = 332,
    CREATE = 333,
    CROSS = 334,
    CUME_DIST_SYM = 335,
    CURDATE = 336,
    CURRENT_ROLE = 337,
    CURRENT_USER = 338,
    CURSOR_SYM = 339,
    CURTIME = 340,
    DATABASE = 341,
    DATABASES = 342,
    DATE_ADD_INTERVAL = 343,
    DATE_SUB_INTERVAL = 344,
    DAY_HOUR_SYM = 345,
    DAY_MICROSECOND_SYM = 346,
    DAY_MINUTE_SYM = 347,
    DAY_SECOND_SYM = 348,
    DECIMAL_SYM = 349,
    DECLARE_MARIADB_SYM = 350,
    DECLARE_ORACLE_SYM = 351,
    DEFAULT = 352,
    DELETE_DOMAIN_ID_SYM = 353,
    DELETE_SYM = 354,
    DENSE_RANK_SYM = 355,
    DESCRIBE = 356,
    DESC = 357,
    DETERMINISTIC_SYM = 358,
    DISTINCT = 359,
    DIV_SYM = 360,
    DO_DOMAIN_IDS_SYM = 361,
    DOUBLE_SYM = 362,
    DROP = 363,
    DUAL_SYM = 364,
    EACH_SYM = 365,
    ELSEIF_MARIADB_SYM = 366,
    ELSE = 367,
    ELSIF_ORACLE_SYM = 368,
    EMPTY_SYM = 369,
    ENCLOSED = 370,
    ESCAPED = 371,
    EXCEPT_SYM = 372,
    EXISTS = 373,
    EXTRACT_SYM = 374,
    FALSE_SYM = 375,
    FETCH_SYM = 376,
    FIRST_VALUE_SYM = 377,
    FLOAT_SYM = 378,
    FOREIGN = 379,
    FOR_SYM = 380,
    FROM = 381,
    FULLTEXT_SYM = 382,
    GOTO_ORACLE_SYM = 383,
    GRANT = 384,
    GROUP_CONCAT_SYM = 385,
    JSON_ARRAYAGG_SYM = 386,
    JSON_OBJECTAGG_SYM = 387,
    JSON_TABLE_SYM = 388,
    GROUP_SYM = 389,
    HAVING = 390,
    HOUR_MICROSECOND_SYM = 391,
    HOUR_MINUTE_SYM = 392,
    HOUR_SECOND_SYM = 393,
    IF_SYM = 394,
    IGNORE_DOMAIN_IDS_SYM = 395,
    IGNORE_SYM = 396,
    IGNORED_SYM = 397,
    INDEX_SYM = 398,
    INFILE = 399,
    INNER_SYM = 400,
    INOUT_SYM = 401,
    INSENSITIVE_SYM = 402,
    INSERT = 403,
    IN_SYM = 404,
    INTERSECT_SYM = 405,
    INTERVAL_SYM = 406,
    INTO = 407,
    INT_SYM = 408,
    IS = 409,
    ITERATE_SYM = 410,
    JOIN_SYM = 411,
    KEYS = 412,
    KEY_SYM = 413,
    KILL_SYM = 414,
    LAG_SYM = 415,
    LEADING = 416,
    LEAD_SYM = 417,
    LEAVE_SYM = 418,
    LEFT = 419,
    LIKE = 420,
    LIMIT = 421,
    LINEAR_SYM = 422,
    LINES = 423,
    LOAD = 424,
    LOCATOR_SYM = 425,
    LOCK_SYM = 426,
    LONGBLOB = 427,
    LONG_SYM = 428,
    LONGTEXT = 429,
    LOOP_SYM = 430,
    LOW_PRIORITY = 431,
    MASTER_SSL_VERIFY_SERVER_CERT_SYM = 432,
    MATCH = 433,
    MAX_SYM = 434,
    MAXVALUE_SYM = 435,
    MEDIAN_SYM = 436,
    MEDIUMBLOB = 437,
    MEDIUMINT = 438,
    MEDIUMTEXT = 439,
    MIN_SYM = 440,
    MINUS_ORACLE_SYM = 441,
    MINUTE_MICROSECOND_SYM = 442,
    MINUTE_SECOND_SYM = 443,
    MODIFIES_SYM = 444,
    MOD_SYM = 445,
    NATURAL = 446,
    NEG = 447,
    NESTED_SYM = 448,
    NOT_SYM = 449,
    NO_WRITE_TO_BINLOG = 450,
    NOW_SYM = 451,
    NTH_VALUE_SYM = 452,
    NTILE_SYM = 453,
    NULL_SYM = 454,
    NUMERIC_SYM = 455,
    ON = 456,
    OPTIMIZE = 457,
    OPTIONALLY = 458,
    ORDER_SYM = 459,
    ORDINALITY_SYM = 460,
    OR_SYM = 461,
    OTHERS_ORACLE_SYM = 462,
    OUTER = 463,
    OUTFILE = 464,
    OUT_SYM = 465,
    OVER_SYM = 466,
    PACKAGE_ORACLE_SYM = 467,
    PAGE_CHECKSUM_SYM = 468,
    PARSE_VCOL_EXPR_SYM = 469,
    PARTITION_SYM = 470,
    PATH_SYM = 471,
    PERCENTILE_CONT_SYM = 472,
    PERCENTILE_DISC_SYM = 473,
    PERCENT_RANK_SYM = 474,
    PORTION_SYM = 475,
    POSITION_SYM = 476,
    PRECISION = 477,
    PRIMARY_SYM = 478,
    PROCEDURE_SYM = 479,
    PURGE = 480,
    RAISE_ORACLE_SYM = 481,
    RANGE_SYM = 482,
    RANK_SYM = 483,
    READS_SYM = 484,
    READ_SYM = 485,
    READ_WRITE_SYM = 486,
    REAL = 487,
    RECURSIVE_SYM = 488,
    REFERENCES = 489,
    REF_SYSTEM_ID_SYM = 490,
    REGEXP = 491,
    RELEASE_SYM = 492,
    RENAME = 493,
    REPEAT_SYM = 494,
    REPLACE = 495,
    REQUIRE_SYM = 496,
    RESIGNAL_SYM = 497,
    RESTRICT = 498,
    RETURNING_SYM = 499,
    RETURN_MARIADB_SYM = 500,
    RETURN_ORACLE_SYM = 501,
    REVOKE = 502,
    RIGHT = 503,
    ROW_NUMBER_SYM = 504,
    ROWS_SYM = 505,
    ROWTYPE_ORACLE_SYM = 506,
    SECOND_MICROSECOND_SYM = 507,
    SELECT_SYM = 508,
    SENSITIVE_SYM = 509,
    SEPARATOR_SYM = 510,
    SERVER_OPTIONS = 511,
    SET = 512,
    SHOW = 513,
    SIGNAL_SYM = 514,
    SMALLINT = 515,
    SPATIAL_SYM = 516,
    SPECIFIC_SYM = 517,
    SQL_BIG_RESULT = 518,
    SQLEXCEPTION_SYM = 519,
    SQL_SMALL_RESULT = 520,
    SQLSTATE_SYM = 521,
    SQL_SYM = 522,
    SQLWARNING_SYM = 523,
    SSL_SYM = 524,
    STARTING = 525,
    STATS_AUTO_RECALC_SYM = 526,
    STATS_PERSISTENT_SYM = 527,
    STATS_SAMPLE_PAGES_SYM = 528,
    STDDEV_SAMP_SYM = 529,
    STD_SYM = 530,
    STRAIGHT_JOIN = 531,
    SUBSTRING = 532,
    SUM_SYM = 533,
    SYSDATE = 534,
    TABLE_REF_PRIORITY = 535,
    TABLE_SYM = 536,
    TERMINATED = 537,
    THEN_SYM = 538,
    TINYBLOB = 539,
    TINYINT = 540,
    TINYTEXT = 541,
    TO_SYM = 542,
    TRAILING = 543,
    TRIGGER_SYM = 544,
    TRIM = 545,
    TRUE_SYM = 546,
    UNDO_SYM = 547,
    UNION_SYM = 548,
    UNIQUE_SYM = 549,
    UNLOCK_SYM = 550,
    UNSIGNED = 551,
    UPDATE_SYM = 552,
    USAGE = 553,
    USE_SYM = 554,
    USING = 555,
    UTC_DATE_SYM = 556,
    UTC_TIMESTAMP_SYM = 557,
    UTC_TIME_SYM = 558,
    VALUES_IN_SYM = 559,
    VALUES_LESS_SYM = 560,
    VALUES = 561,
    VARBINARY = 562,
    VARCHAR = 563,
    VARIANCE_SYM = 564,
    VAR_SAMP_SYM = 565,
    VARYING = 566,
    WHEN_SYM = 567,
    WHERE = 568,
    WHILE_SYM = 569,
    WITH = 570,
    XOR = 571,
    YEAR_MONTH_SYM = 572,
    ZEROFILL = 573,
    BODY_MARIADB_SYM = 574,
    ELSEIF_ORACLE_SYM = 575,
    ELSIF_MARIADB_SYM = 576,
    EXCEPTION_ORACLE_SYM = 577,
    GOTO_MARIADB_SYM = 578,
    OTHERS_MARIADB_SYM = 579,
    PACKAGE_MARIADB_SYM = 580,
    RAISE_MARIADB_SYM = 581,
    ROWTYPE_MARIADB_SYM = 582,
    ROWNUM_SYM = 583,
    ACCOUNT_SYM = 584,
    ACTION = 585,
    ADMIN_SYM = 586,
    ADDDATE_SYM = 587,
    ADD_MONTHS_SYM = 588,
    AFTER_SYM = 589,
    AGAINST = 590,
    AGGREGATE_SYM = 591,
    ALGORITHM_SYM = 592,
    ALWAYS_SYM = 593,
    ANY_SYM = 594,
    ASCII_SYM = 595,
    AT_SYM = 596,
    ATOMIC_SYM = 597,
    AUTHORS_SYM = 598,
    AUTOEXTEND_SIZE_SYM = 599,
    AUTO_INC = 600,
    AUTO_SYM = 601,
    AVG_ROW_LENGTH = 602,
    AVG_SYM = 603,
    BACKUP_SYM = 604,
    BEGIN_MARIADB_SYM = 605,
    BEGIN_ORACLE_SYM = 606,
    BINLOG_SYM = 607,
    BIT_SYM = 608,
    BLOCK_SYM = 609,
    BOOL_SYM = 610,
    BOOLEAN_SYM = 611,
    BTREE_SYM = 612,
    BYTE_SYM = 613,
    CACHE_SYM = 614,
    CASCADED = 615,
    CATALOG_NAME_SYM = 616,
    CHAIN_SYM = 617,
    CHANGED = 618,
    CHARSET = 619,
    CHECKPOINT_SYM = 620,
    CHECKSUM_SYM = 621,
    CIPHER_SYM = 622,
    CLASS_ORIGIN_SYM = 623,
    CLIENT_SYM = 624,
    CLOB_MARIADB_SYM = 625,
    CLOB_ORACLE_SYM = 626,
    CLOSE_SYM = 627,
    COALESCE = 628,
    CODE_SYM = 629,
    COLLATION_SYM = 630,
    COLUMNS = 631,
    COLUMN_ADD_SYM = 632,
    COLUMN_CHECK_SYM = 633,
    COLUMN_CREATE_SYM = 634,
    COLUMN_DELETE_SYM = 635,
    COLUMN_GET_SYM = 636,
    COLUMN_SYM = 637,
    COLUMN_NAME_SYM = 638,
    COMMENT_SYM = 639,
    COMMITTED_SYM = 640,
    COMMIT_SYM = 641,
    COMPACT_SYM = 642,
    COMPLETION_SYM = 643,
    COMPRESSED_SYM = 644,
    CONCURRENT = 645,
    CONNECTION_SYM = 646,
    CONSISTENT_SYM = 647,
    CONSTRAINT_CATALOG_SYM = 648,
    CONSTRAINT_NAME_SYM = 649,
    CONSTRAINT_SCHEMA_SYM = 650,
    CONTAINS_SYM = 651,
    CONTEXT_SYM = 652,
    CONTRIBUTORS_SYM = 653,
    CPU_SYM = 654,
    CUBE_SYM = 655,
    CURRENT_SYM = 656,
    CURRENT_POS_SYM = 657,
    CURSOR_NAME_SYM = 658,
    CYCLE_SYM = 659,
    DATAFILE_SYM = 660,
    DATA_SYM = 661,
    DATETIME = 662,
    DATE_FORMAT_SYM = 663,
    DATE_SYM = 664,
    DAY_SYM = 665,
    DEALLOCATE_SYM = 666,
    DECODE_MARIADB_SYM = 667,
    DECODE_ORACLE_SYM = 668,
    DEFINER_SYM = 669,
    DELAYED_SYM = 670,
    DELAY_KEY_WRITE_SYM = 671,
    DES_KEY_FILE = 672,
    DIAGNOSTICS_SYM = 673,
    DIRECTORY_SYM = 674,
    DISABLE_SYM = 675,
    DISCARD = 676,
    DISK_SYM = 677,
    DO_SYM = 678,
    DUMPFILE = 679,
    DUPLICATE_SYM = 680,
    DYNAMIC_SYM = 681,
    ENABLE_SYM = 682,
    END = 683,
    ENDS_SYM = 684,
    ENGINES_SYM = 685,
    ENGINE_SYM = 686,
    ENUM = 687,
    ERROR_SYM = 688,
    ERRORS = 689,
    ESCAPE_SYM = 690,
    EVENTS_SYM = 691,
    EVENT_SYM = 692,
    EVERY_SYM = 693,
    EXCHANGE_SYM = 694,
    EXAMINED_SYM = 695,
    EXCLUDE_SYM = 696,
    EXECUTE_SYM = 697,
    EXCEPTION_MARIADB_SYM = 698,
    EXIT_MARIADB_SYM = 699,
    EXIT_ORACLE_SYM = 700,
    EXPANSION_SYM = 701,
    EXPIRE_SYM = 702,
    EXPORT_SYM = 703,
    EXTENDED_SYM = 704,
    EXTENT_SIZE_SYM = 705,
    FAST_SYM = 706,
    FAULTS_SYM = 707,
    FEDERATED_SYM = 708,
    FILE_SYM = 709,
    FIRST_SYM = 710,
    FIXED_SYM = 711,
    FLUSH_SYM = 712,
    FOLLOWS_SYM = 713,
    FOLLOWING_SYM = 714,
    FORCE_SYM = 715,
    FORMAT_SYM = 716,
    FOUND_SYM = 717,
    FULL = 718,
    FUNCTION_SYM = 719,
    GENERAL = 720,
    GENERATED_SYM = 721,
    GET_FORMAT = 722,
    GET_SYM = 723,
    GLOBAL_SYM = 724,
    GRANTS = 725,
    HANDLER_SYM = 726,
    HARD_SYM = 727,
    HASH_SYM = 728,
    HELP_SYM = 729,
    HIGH_PRIORITY = 730,
    HISTORY_SYM = 731,
    HOST_SYM = 732,
    HOSTS_SYM = 733,
    HOUR_SYM = 734,
    ID_SYM = 735,
    IDENTIFIED_SYM = 736,
    IGNORE_SERVER_IDS_SYM = 737,
    IMMEDIATE_SYM = 738,
    IMPORT = 739,
    INCREMENT_SYM = 740,
    INDEXES = 741,
    INITIAL_SIZE_SYM = 742,
    INSERT_METHOD = 743,
    INSTALL_SYM = 744,
    INVOKER_SYM = 745,
    IO_SYM = 746,
    IPC_SYM = 747,
    ISOLATION = 748,
    ISOPEN_SYM = 749,
    ISSUER_SYM = 750,
    INVISIBLE_SYM = 751,
    JSON_SYM = 752,
    KEY_BLOCK_SIZE = 753,
    LANGUAGE_SYM = 754,
    LAST_SYM = 755,
    LAST_VALUE = 756,
    LASTVAL_SYM = 757,
    LEAVES = 758,
    LESS_SYM = 759,
    LEVEL_SYM = 760,
    LIST_SYM = 761,
    LOCAL_SYM = 762,
    LOCKED_SYM = 763,
    LOCKS_SYM = 764,
    LOGFILE_SYM = 765,
    LOGS_SYM = 766,
    MASTER_CONNECT_RETRY_SYM = 767,
    MASTER_DELAY_SYM = 768,
    MASTER_GTID_POS_SYM = 769,
    MASTER_HOST_SYM = 770,
    MASTER_LOG_FILE_SYM = 771,
    MASTER_LOG_POS_SYM = 772,
    MASTER_PASSWORD_SYM = 773,
    MASTER_PORT_SYM = 774,
    MASTER_SERVER_ID_SYM = 775,
    MASTER_SSL_CAPATH_SYM = 776,
    MASTER_SSL_CA_SYM = 777,
    MASTER_SSL_CERT_SYM = 778,
    MASTER_SSL_CIPHER_SYM = 779,
    MASTER_SSL_CRL_SYM = 780,
    MASTER_SSL_CRLPATH_SYM = 781,
    MASTER_SSL_KEY_SYM = 782,
    MASTER_SSL_SYM = 783,
    MASTER_SYM = 784,
    MASTER_USER_SYM = 785,
    MASTER_USE_GTID_SYM = 786,
    MASTER_HEARTBEAT_PERIOD_SYM = 787,
    MAX_CONNECTIONS_PER_HOUR = 788,
    MAX_QUERIES_PER_HOUR = 789,
    MAX_ROWS = 790,
    MAX_SIZE_SYM = 791,
    MAX_UPDATES_PER_HOUR = 792,
    MAX_STATEMENT_TIME_SYM = 793,
    MAX_USER_CONNECTIONS_SYM = 794,
    MEDIUM_SYM = 795,
    MEMORY_SYM = 796,
    MERGE_SYM = 797,
    MESSAGE_TEXT_SYM = 798,
    MICROSECOND_SYM = 799,
    MIGRATE_SYM = 800,
    MINUTE_SYM = 801,
    MINVALUE_SYM = 802,
    MIN_ROWS = 803,
    MODE_SYM = 804,
    MODIFY_SYM = 805,
    MONITOR_SYM = 806,
    MONTH_SYM = 807,
    MUTEX_SYM = 808,
    MYSQL_SYM = 809,
    MYSQL_ERRNO_SYM = 810,
    NAMES_SYM = 811,
    NAME_SYM = 812,
    NATIONAL_SYM = 813,
    NCHAR_SYM = 814,
    NEVER_SYM = 815,
    NEW_SYM = 816,
    NEXT_SYM = 817,
    NEXTVAL_SYM = 818,
    NOCACHE_SYM = 819,
    NOCYCLE_SYM = 820,
    NODEGROUP_SYM = 821,
    NONE_SYM = 822,
    NOTFOUND_SYM = 823,
    NO_SYM = 824,
    NOMAXVALUE_SYM = 825,
    NOMINVALUE_SYM = 826,
    NO_WAIT_SYM = 827,
    NOWAIT_SYM = 828,
    NUMBER_MARIADB_SYM = 829,
    NUMBER_ORACLE_SYM = 830,
    NVARCHAR_SYM = 831,
    OF_SYM = 832,
    OFFSET_SYM = 833,
    OLD_PASSWORD_SYM = 834,
    ONE_SYM = 835,
    ONLY_SYM = 836,
    ONLINE_SYM = 837,
    OPEN_SYM = 838,
    OPTIONS_SYM = 839,
    OPTION = 840,
    OVERLAPS_SYM = 841,
    OWNER_SYM = 842,
    PACK_KEYS_SYM = 843,
    PAGE_SYM = 844,
    PARSER_SYM = 845,
    PARTIAL = 846,
    PARTITIONS_SYM = 847,
    PARTITIONING_SYM = 848,
    PASSWORD_SYM = 849,
    PERIOD_SYM = 850,
    PERSISTENT_SYM = 851,
    PHASE_SYM = 852,
    PLUGINS_SYM = 853,
    PLUGIN_SYM = 854,
    PORT_SYM = 855,
    PRECEDES_SYM = 856,
    PRECEDING_SYM = 857,
    PREPARE_SYM = 858,
    PRESERVE_SYM = 859,
    PREV_SYM = 860,
    PREVIOUS_SYM = 861,
    PRIVILEGES = 862,
    PROCESS = 863,
    PROCESSLIST_SYM = 864,
    PROFILE_SYM = 865,
    PROFILES_SYM = 866,
    PROXY_SYM = 867,
    QUARTER_SYM = 868,
    QUERY_SYM = 869,
    QUICK = 870,
    RAW_MARIADB_SYM = 871,
    RAW_ORACLE_SYM = 872,
    READ_ONLY_SYM = 873,
    REBUILD_SYM = 874,
    RECOVER_SYM = 875,
    REDOFILE_SYM = 876,
    REDO_BUFFER_SIZE_SYM = 877,
    REDUNDANT_SYM = 878,
    RELAY = 879,
    RELAYLOG_SYM = 880,
    RELAY_LOG_FILE_SYM = 881,
    RELAY_LOG_POS_SYM = 882,
    RELAY_THREAD = 883,
    RELOAD = 884,
    REMOVE_SYM = 885,
    REORGANIZE_SYM = 886,
    REPAIR = 887,
    REPEATABLE_SYM = 888,
    REPLAY_SYM = 889,
    REPLICATION = 890,
    RESET_SYM = 891,
    RESTART_SYM = 892,
    RESOURCES = 893,
    RESTORE_SYM = 894,
    RESUME_SYM = 895,
    RETURNED_SQLSTATE_SYM = 896,
    RETURNS_SYM = 897,
    REUSE_SYM = 898,
    REVERSE_SYM = 899,
    ROLE_SYM = 900,
    ROLLBACK_SYM = 901,
    ROLLUP_SYM = 902,
    ROUTINE_SYM = 903,
    ROWCOUNT_SYM = 904,
    ROW_SYM = 905,
    ROW_COUNT_SYM = 906,
    ROW_FORMAT_SYM = 907,
    RTREE_SYM = 908,
    SAVEPOINT_SYM = 909,
    SCHEDULE_SYM = 910,
    SCHEMA_NAME_SYM = 911,
    SECOND_SYM = 912,
    SECURITY_SYM = 913,
    SEQUENCE_SYM = 914,
    SERIALIZABLE_SYM = 915,
    SERIAL_SYM = 916,
    SESSION_SYM = 917,
    SERVER_SYM = 918,
    SETVAL_SYM = 919,
    SHARE_SYM = 920,
    SHUTDOWN = 921,
    SIGNED_SYM = 922,
    SIMPLE_SYM = 923,
    SKIP_SYM = 924,
    SLAVE = 925,
    SLAVES = 926,
    SLAVE_POS_SYM = 927,
    SLOW = 928,
    SNAPSHOT_SYM = 929,
    SOCKET_SYM = 930,
    SOFT_SYM = 931,
    SONAME_SYM = 932,
    SOUNDS_SYM = 933,
    SOURCE_SYM = 934,
    SQL_BUFFER_RESULT = 935,
    SQL_CACHE_SYM = 936,
    SQL_CALC_FOUND_ROWS = 937,
    SQL_NO_CACHE_SYM = 938,
    SQL_THREAD = 939,
    STAGE_SYM = 940,
    STARTS_SYM = 941,
    START_SYM = 942,
    STATEMENT_SYM = 943,
    STATUS_SYM = 944,
    STOP_SYM = 945,
    STORAGE_SYM = 946,
    STORED_SYM = 947,
    STRING_SYM = 948,
    SUBCLASS_ORIGIN_SYM = 949,
    SUBDATE_SYM = 950,
    SUBJECT_SYM = 951,
    SUBPARTITIONS_SYM = 952,
    SUBPARTITION_SYM = 953,
    SUPER_SYM = 954,
    SUSPEND_SYM = 955,
    SWAPS_SYM = 956,
    SWITCHES_SYM = 957,
    SYSTEM = 958,
    SYSTEM_TIME_SYM = 959,
    TABLES = 960,
    TABLESPACE = 961,
    TABLE_CHECKSUM_SYM = 962,
    TABLE_NAME_SYM = 963,
    TEMPORARY = 964,
    TEMPTABLE_SYM = 965,
    TEXT_SYM = 966,
    THAN_SYM = 967,
    TIES_SYM = 968,
    TIMESTAMP = 969,
    TIMESTAMP_ADD = 970,
    TIMESTAMP_DIFF = 971,
    TIME_SYM = 972,
    TRANSACTION_SYM = 973,
    TRANSACTIONAL_SYM = 974,
    THREADS_SYM = 975,
    TRIGGERS_SYM = 976,
    TRIM_ORACLE = 977,
    TRUNCATE_SYM = 978,
    TYPES_SYM = 979,
    TYPE_SYM = 980,
    UDF_RETURNS_SYM = 981,
    UNBOUNDED_SYM = 982,
    UNCOMMITTED_SYM = 983,
    UNDEFINED_SYM = 984,
    UNDOFILE_SYM = 985,
    UNDO_BUFFER_SIZE_SYM = 986,
    UNICODE_SYM = 987,
    UNINSTALL_SYM = 988,
    UNKNOWN_SYM = 989,
    UNTIL_SYM = 990,
    UPGRADE_SYM = 991,
    USER_SYM = 992,
    USE_FRM = 993,
    VALUE_SYM = 994,
    VARCHAR2_MARIADB_SYM = 995,
    VARCHAR2_ORACLE_SYM = 996,
    VARIABLES = 997,
    VERSIONING_SYM = 998,
    VIA_SYM = 999,
    VIEW_SYM = 1000,
    VISIBLE_SYM = 1001,
    VIRTUAL_SYM = 1002,
    WAIT_SYM = 1003,
    WARNINGS = 1004,
    WEEK_SYM = 1005,
    WEIGHT_STRING_SYM = 1006,
    WINDOW_SYM = 1007,
    WITHIN = 1008,
    WITHOUT = 1009,
    WORK_SYM = 1010,
    WRAPPER_SYM = 1011,
    WRITE_SYM = 1012,
    X509_SYM = 1013,
    XA_SYM = 1014,
    XML_SYM = 1015,
    YEAR_SYM = 1016,
    CONDITIONLESS_JOIN = 1017,
    ON_SYM = 1018,
    PREC_BELOW_NOT = 1019,
    SUBQUERY_AS_EXPR = 1020,
    PREC_BELOW_IDENTIFIER_OPT_SPECIAL_CASE = 1021,
    USER = 1022,
    PREC_BELOW_CONTRACTION_TOKEN2 = 1023,
    EMPTY_FROM_CLAUSE = 1024
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 212 "/home/buildbot/git/sql/sql_yacc.yy"


  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  uint sp_instr_addr;

  /* structs */
  LEX_CSTRING lex_str;
  Lex_ident_cli_st kwd;
  Lex_ident_cli_st ident_cli;
  Lex_ident_sys_st ident_sys;
  Lex_column_list_privilege_st column_list_privilege;
  Lex_string_with_metadata_st lex_string_with_metadata;
  Lex_spblock_st spblock;
  Lex_spblock_handlers_st spblock_handlers;
  Lex_length_and_dec_st Lex_length_and_dec;
  Lex_cast_type_st Lex_cast_type;
  Lex_field_type_st Lex_field_type;
  Lex_dyncol_type_st Lex_dyncol_type;
  Lex_for_loop_st for_loop;
  Lex_for_loop_bounds_st for_loop_bounds;
  Lex_trim_st trim;
  Json_table_column::On_response json_on_response;
  vers_history_point_t vers_history_point;
  struct
  {
    enum sub_select_type unit_type;
    bool distinct;
  } unit_operation;
  struct
  {
    SELECT_LEX *first;
    SELECT_LEX *prev_last;
  } select_list;
  SQL_I_List<ORDER> *select_order;
  Lex_select_lock select_lock;
  Lex_select_limit select_limit;
  Lex_order_limit_lock *order_limit_lock;

  /* pointers */
  Lex_ident_sys *ident_sys_ptr;
  Create_field *create_field;
  Spvar_definition *spvar_definition;
  Row_definition_list *spvar_definition_list;
  const Type_handler *type_handler;
  const class Sp_handler *sp_handler;
  CHARSET_INFO *charset;
  Condition_information_item *cond_info_item;
  DYNCALL_CREATE_DEF *dyncol_def;
  Diagnostics_information *diag_info;
  Item *item;
  Item_num *item_num;
  Item_param *item_param;
  Item_basic_constant *item_basic_constant;
  Key_part_spec *key_part;
  LEX *lex;
  sp_expr_lex *expr_lex;
  sp_assignment_lex *assignment_lex;
  class sp_lex_cursor *sp_cursor_stmt;
  LEX_CSTRING *lex_str_ptr;
  LEX_USER *lex_user;
  USER_AUTH *user_auth;
  List<Condition_information_item> *cond_info_list;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  List<Item> *item_list;
  List<sp_assignment_lex> *sp_assignment_lex_list;
  List<Statement_information_item> *stmt_info_list;
  List<String> *string_list;
  List<Lex_ident_sys> *ident_sys_list;
  Statement_information_item *stmt_info_item;
  String *string;
  TABLE_LIST *table_list;
  Table_ident *table;
  Qualified_column_ident *qualified_column_ident;
  char *simple_string;
  const char *const_simple_string;
  chooser_compare_func_creator boolfunc2creator;
  class Lex_grant_privilege *lex_grant;
  class Lex_grant_object_name *lex_grant_ident;
  class my_var *myvar;
  class sp_condition_value *spcondvalue;
  class sp_head *sphead;
  class sp_name *spname;
  class sp_variable *spvar;
  class With_element_head *with_element_head;
  class With_clause *with_clause;
  class Virtual_column_info *virtual_column;

  handlerton *db_type;
  st_select_lex *select_lex;
  st_select_lex_unit *select_lex_unit;
  struct p_elem_val *p_elem_value;
  class Window_frame *window_frame;
  class Window_frame_bound *window_frame_bound;
  udf_func *udf;
  st_trg_execution_order trg_execution_order;

  /* enums */
  enum enum_sp_suid_behaviour sp_suid;
  enum enum_sp_aggregate_type sp_aggregate_type;
  enum enum_view_suid view_suid;
  enum Condition_information_item::Name cond_info_item_name;
  enum enum_diag_condition_item_name diag_condition_item_name;
  enum Diagnostics_information::Which_area diag_area;
  enum enum_fk_option m_fk_option;
  enum Item_udftype udf_type;
  enum Key::Keytype key_type;
  enum Statement_information_item::Name stmt_info_item_name;
  enum enum_filetype filetype;
  enum enum_tx_isolation tx_isolation;
  enum enum_var_type var_type;
  enum enum_yes_no_unknown m_yes_no_unk;
  enum ha_choice choice;
  enum ha_key_alg key_alg;
  enum ha_rkey_function ha_rkey_mode;
  enum index_hint_type index_hint;
  enum interval_type interval, interval_time_st;
  enum row_type row_type;
  enum sp_variable::enum_mode spvar_mode;
  enum thr_lock_type lock_type;
  enum enum_mysql_timestamp_type date_time_type;
  enum Window_frame_bound::Bound_precedence_type bound_precedence_type;
  enum Window_frame::Frame_units frame_units;
  enum Window_frame::Frame_exclusion frame_exclusion;
  enum trigger_order_type trigger_action_order_type;
  DDL_options_st object_ddl_options;
  enum vers_kind_t vers_range_unit;
  enum Column_definition::enum_column_versioning vers_column_versioning;
  enum plsql_cursor_attr_t plsql_cursor_attr;
  privilege_t privilege;

#line 1206 "/home/buildbot/git/mkdist/sql/yy_oracle.cc"

};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int ORAparse (THD *thd);

#endif /* !YY_ORA_HOME_BUILDBOT_GIT_MKDIST_SQL_YY_ORACLE_HH_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 345 "/home/buildbot/git/sql/sql_yacc.yy"


/* avoid unintentional %union size increases, it's what a parser stack made of */
static_assert(sizeof(YYSTYPE) == sizeof(void*)*2+8, "%union size check");
bool my_yyoverflow(short **a, YYSTYPE **b, size_t *yystacksize);

#line 1227 "/home/buildbot/git/mkdist/sql/yy_oracle.cc"


#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  765
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   106754

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  791
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1330
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3893
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  6565

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   1024

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   786,     2,     2,     2,   775,   770,     2,
     782,   783,   773,   772,   785,   771,   790,   774,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   789,
     768,   766,   767,     2,     3,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   776,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   787,   769,   788,   777,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   447,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   633,   634,   635,
     636,   637,   638,   639,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   654,   655,
     656,   657,   658,   659,   660,   661,   662,   663,   664,   665,
     666,   667,   668,   669,   670,   671,   672,   673,   674,   675,
     676,   677,   678,   679,   680,   681,   682,   683,   684,   685,
     686,   687,   688,   689,   690,   691,   692,   693,   694,   695,
     696,   697,   698,   699,   700,   701,   702,   703,   704,   705,
     706,   707,   708,   709,   710,   711,   712,   713,   714,   715,
     716,   717,   718,   719,   720,   721,   722,   723,   724,   725,
     726,   727,   728,   729,   730,   731,   732,   733,   734,   735,
     736,   737,   738,   739,   740,   741,   742,   743,   744,   745,
     746,   747,   748,   749,   750,   751,   752,   753,   754,   755,
     756,   757,   758,   759,   760,   761,   762,   763,   764,   765,
     778,   779,   780,   781,   784
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1875,  1875,  1885,  1884,  1909,  1916,  1918,  1922,  1923,
    1924,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,
    1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,  1946,  1947,
    1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,
    1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,
    1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,  1977,
    1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
    1991,  1998,  1999,  2004,  2003,  2014,  2020,  2022,  2019,  2031,
    2033,  2032,  2042,  2047,  2059,  2058,  2075,  2074,  2083,  2084,
    2088,  2092,  2096,  2100,  2104,  2108,  2118,  2123,  2127,  2131,
    2135,  2139,  2143,  2148,  2152,  2157,  2185,  2189,  2193,  2198,
    2201,  2203,  2204,  2208,  2214,  2216,  2217,  2221,  2227,  2229,
    2230,  2234,  2241,  2245,  2260,  2264,  2270,  2276,  2282,  2292,
    2296,  2300,  2314,  2326,  2313,  2349,  2348,  2404,  2411,  2403,
    2423,  2430,  2422,  2443,  2449,  2442,  2461,  2467,  2460,  2479,
    2478,  2494,  2492,  2507,  2505,  2518,  2517,  2528,  2527,  2537,
    2544,  2551,  2555,  2559,  2559,  2562,  2566,  2567,  2571,  2572,
    2576,  2581,  2587,  2593,  2601,  2607,  2613,  2621,  2629,  2637,
    2645,  2653,  2661,  2673,  2690,  2689,  2701,  2702,  2706,  2711,
    2716,  2721,  2726,  2731,  2736,  2744,  2743,  2776,  2775,  2782,
    2789,  2790,  2796,  2802,  2812,  2818,  2824,  2826,  2833,  2834,
    2838,  2848,  2849,  2857,  2857,  2899,  2908,  2909,  2914,  2915,
    2916,  2917,  2922,  2927,  2935,  2936,  2940,  2941,  2946,  2948,
    2950,  2952,  2954,  2956,  2958,  2964,  2965,  2969,  2970,  2975,
    2974,  2987,  2989,  2992,  2994,  2998,  3002,  3011,  3016,  3016,
    3026,  3027,  3031,  3039,  3044,  3049,  3053,  3055,  3059,  3060,
    3064,  3065,  3066,  3071,  3070,  3082,  3086,  3087,  3091,  3092,
    3097,  3103,  3109,  3119,  3127,  3132,  3140,  3144,  3153,  3151,
    3165,  3173,  3178,  3177,  3191,  3193,  3198,  3208,  3207,  3226,
    3227,  3228,  3229,  3234,  3236,  3241,  3256,  3264,  3268,  3288,
    3289,  3293,  3297,  3303,  3309,  3315,  3321,  3331,  3336,  3344,
    3352,  3357,  3363,  3364,  3370,  3373,  3377,  3385,  3402,  3404,
    3422,  3428,  3430,  3432,  3434,  3436,  3438,  3440,  3442,  3444,
    3446,  3448,  3450,  3455,  3463,  3479,  3480,  3485,  3491,  3500,
    3507,  3516,  3525,  3530,  3539,  3541,  3543,  3552,  3557,  3564,
    3573,  3582,  3584,  3586,  3588,  3590,  3592,  3594,  3596,  3598,
    3600,  3602,  3604,  3606,  3611,  3612,  3620,  3632,  3648,  3647,
    3658,  3658,  3680,  3681,  3685,  3692,  3703,  3708,  3713,  3718,
    3726,  3731,  3736,  3741,  3750,  3758,  3766,  3775,  3775,  3799,
    3809,  3808,  3830,  3829,  3850,  3856,  3864,  3865,  3869,  3870,
    3871,  3875,  3883,  3888,  3893,  3901,  3902,  3910,  3928,  3944,
    3964,  3969,  3963,  3981,  3983,  3984,  3985,  3990,  3989,  4060,
    4059,  4066,  4071,  4072,  4076,  4077,  4082,  4081,  4097,  4096,
    4111,  4121,  4125,  4126,  4131,  4132,  4136,  4144,  4149,  4156,
    4165,  4179,  4187,  4196,  4195,  4203,  4202,  4210,  4215,  4222,
    4209,  4232,  4231,  4242,  4241,  4251,  4250,  4260,  4267,  4259,
    4282,  4281,  4293,  4295,  4300,  4302,  4304,  4321,  4326,  4332,
    4339,  4340,  4348,  4354,  4363,  4369,  4375,  4376,  4380,  4380,
    4385,  4386,  4387,  4391,  4392,  4393,  4397,  4401,  4402,  4403,
    4407,  4408,  4409,  4410,  4411,  4412,  4413,  4414,  4418,  4422,
    4423,  4424,  4428,  4429,  4430,  4431,  4432,  4436,  4440,  4441,
    4442,  4446,  4447,  4448,  4449,  4450,  4451,  4452,  4456,  4460,
    4461,  4462,  4466,  4467,  4468,  4473,  4481,  4489,  4497,  4510,
    4523,  4528,  4533,  4541,  4549,  4557,  4565,  4573,  4581,  4589,
    4599,  4609,  4619,  4621,  4625,  4630,  4640,  4641,  4654,  4653,
    4656,  4657,  4671,  4672,  4676,  4677,  4684,  4689,  4700,  4737,
    4738,  4743,  4742,  4758,  4773,  4772,  4794,  4793,  4799,  4807,
    4806,  4809,  4811,  4814,  4813,  4822,  4825,  4824,  4833,  4834,
    4840,  4841,  4858,  4859,  4863,  4864,  4868,  4882,  4892,  4903,
    4912,  4913,  4926,  4928,  4927,  4932,  4930,  4941,  4942,  4946,
    4960,  4972,  4973,  4986,  4995,  5017,  5018,  5023,  5022,  5046,
    5058,  5074,  5073,  5088,  5087,  5101,  5106,  5111,  5131,  5149,
    5153,  5180,  5192,  5193,  5198,  5207,  5197,  5232,  5233,  5237,
    5248,  5267,  5280,  5306,  5307,  5312,  5311,  5348,  5357,  5358,
    5362,  5363,  5367,  5369,  5375,  5381,  5383,  5385,  5387,  5389,
    5391,  5396,  5397,  5404,  5420,  5423,  5434,  5435,  5439,  5440,
    5444,  5445,  5449,  5450,  5451,  5460,  5463,  5471,  5474,  5481,
    5485,  5491,  5493,  5497,  5498,  5502,  5503,  5504,  5508,  5523,
    5528,  5533,  5538,  5543,  5548,  5553,  5568,  5574,  5589,  5594,
    5609,  5615,  5633,  5638,  5643,  5648,  5653,  5658,  5664,  5663,
    5689,  5690,  5691,  5696,  5701,  5706,  5708,  5710,  5712,  5718,
    5723,  5728,  5737,  5746,  5752,  5758,  5763,  5766,  5768,  5772,
    5791,  5799,  5814,  5824,  5835,  5836,  5837,  5838,  5839,  5840,
    5841,  5845,  5846,  5847,  5851,  5852,  5853,  5854,  5859,  5866,
    5873,  5874,  5878,  5879,  5880,  5881,  5882,  5886,  5888,  5899,
    5898,  5906,  5905,  5913,  5912,  5920,  5919,  5929,  5926,  5937,
    5935,  5944,  5943,  5962,  5970,  5978,  5986,  5987,  5991,  6001,
    6002,  6006,  6007,  6011,  6016,  6015,  6054,  6053,  6060,  6059,
    6069,  6070,  6074,  6075,  6079,  6080,  6084,  6085,  6089,  6090,
    6091,  6092,  6094,  6093,  6099,  6104,  6112,  6113,  6118,  6121,
    6125,  6129,  6136,  6137,  6141,  6142,  6146,  6152,  6158,  6159,
    6167,  6166,  6188,  6189,  6199,  6207,  6219,  6219,  6222,  6223,
    6230,  6237,  6241,  6249,  6250,  6251,  6252,  6253,  6254,  6259,
    6264,  6272,  6276,  6277,  6293,  6297,  6301,  6305,  6307,  6314,
    6316,  6321,  6323,  6324,  6325,  6329,  6333,  6338,  6343,  6347,
    6351,  6356,  6361,  6369,  6387,  6388,  6395,  6402,  6410,  6415,
    6420,  6425,  6430,  6435,  6440,  6445,  6447,  6449,  6451,  6453,
    6455,  6457,  6459,  6467,  6469,  6474,  6478,  6479,  6483,  6484,
    6488,  6489,  6490,  6491,  6492,  6496,  6497,  6498,  6499,  6500,
    6504,  6510,  6511,  6516,  6518,  6525,  6526,  6527,  6531,  6535,
    6536,  6537,  6538,  6539,  6540,  6544,  6548,  6549,  6550,  6551,
    6555,  6556,  6560,  6561,  6566,  6567,  6571,  6572,  6573,  6580,
    6581,  6587,  6594,  6598,  6599,  6603,  6604,  6608,  6609,  6613,
    6621,  6629,  6638,  6642,  6648,  6652,  6653,  6662,  6671,  6677,
    6683,  6696,  6702,  6712,  6713,  6717,  6724,  6728,  6729,  6733,
    6734,  6738,  6747,  6751,  6752,  6756,  6765,  6766,  6770,  6771,
    6775,  6776,  6780,  6781,  6782,  6789,  6796,  6797,  6801,  6802,
    6803,  6804,  6805,  6811,  6815,  6816,  6821,  6820,  6833,  6834,
    6838,  6841,  6842,  6843,  6844,  6848,  6856,  6863,  6864,  6868,
    6878,  6879,  6883,  6884,  6887,  6889,  6893,  6905,  6906,  6910,
    6917,  6930,  6931,  6933,  6935,  6941,  6946,  6952,  6958,  6965,
    6975,  6976,  6977,  6978,  6979,  6983,  6984,  6988,  6989,  6993,
    6994,  6998,  6999,  7000,  7004,  7008,  7020,  7021,  7025,  7026,
    7030,  7031,  7035,  7036,  7040,  7041,  7045,  7046,  7050,  7051,
    7056,  7057,  7058,  7062,  7064,  7069,  7074,  7076,  7080,  7084,
    7092,  7100,  7106,  7115,  7116,  7120,  7124,  7125,  7135,  7136,
    7137,  7141,  7142,  7146,  7150,  7157,  7158,  7166,  7172,  7184,
    7185,  7189,  7191,  7201,  7217,  7200,  7240,  7239,  7258,  7257,
    7273,  7282,  7281,  7289,  7288,  7296,  7295,  7309,  7303,  7317,
    7316,  7355,  7360,  7365,  7370,  7376,  7375,  7382,  7389,  7401,
    7411,  7388,  7420,  7424,  7432,  7435,  7439,  7443,  7451,  7453,
    7454,  7455,  7456,  7460,  7461,  7462,  7463,  7467,  7468,  7480,
    7481,  7486,  7487,  7490,  7492,  7500,  7508,  7510,  7512,  7513,
    7521,  7522,  7528,  7537,  7535,  7548,  7561,  7560,  7573,  7571,
    7584,  7591,  7601,  7602,  7611,  7618,  7622,  7628,  7626,  7643,
    7645,  7650,  7658,  7657,  7671,  7675,  7674,  7686,  7687,  7691,
    7704,  7705,  7709,  7713,  7720,  7725,  7729,  7736,  7743,  7747,
    7752,  7760,  7768,  7778,  7789,  7799,  7810,  7820,  7826,  7832,
    7839,  7849,  7854,  7868,  7873,  7883,  7897,  7902,  7906,  7911,
    7912,  7913,  7918,  7923,  7927,  7937,  7939,  7940,  7941,  7942,
    7946,  7951,  7959,  7964,  7972,  7973,  7977,  7978,  7982,  7982,
    7985,  7987,  7991,  7992,  7996,  7997,  8005,  8006,  8007,  8011,
    8012,  8017,  8026,  8027,  8028,  8029,  8034,  8033,  8043,  8042,
    8050,  8057,  8067,  8084,  8087,  8094,  8098,  8105,  8109,  8113,
    8120,  8120,  8126,  8127,  8131,  8132,  8133,  8137,  8138,  8147,
    8154,  8155,  8160,  8159,  8171,  8172,  8173,  8177,  8179,  8178,
    8185,  8184,  8205,  8206,  8210,  8211,  8215,  8216,  8217,  8221,
    8222,  8227,  8226,  8247,  8248,  8252,  8257,  8258,  8265,  8267,
    8272,  8274,  8273,  8286,  8288,  8287,  8301,  8302,  8307,  8316,
    8317,  8318,  8322,  8329,  8339,  8347,  8356,  8358,  8357,  8363,
    8362,  8385,  8386,  8390,  8391,  8395,  8396,  8397,  8398,  8399,
    8400,  8404,  8405,  8410,  8409,  8430,  8431,  8432,  8437,  8436,
    8447,  8454,  8460,  8469,  8470,  8474,  8490,  8489,  8502,  8503,
    8507,  8508,  8512,  8523,  8534,  8535,  8540,  8539,  8554,  8555,
    8559,  8560,  8564,  8575,  8587,  8586,  8594,  8594,  8603,  8604,
    8609,  8610,  8620,  8619,  8634,  8633,  8652,  8651,  8668,  8666,
    8687,  8688,  8693,  8692,  8706,  8715,  8705,  8725,  8737,  8801,
    8806,  8821,  8822,  8837,  8836,  8852,  8851,  8864,  8866,  8881,
    8889,  8887,  8902,  8920,  8922,  8932,  8936,  8977,  8986,  8996,
    8997,  9001,  9005,  9011,  9018,  9020,  9029,  9033,  9037,  9044,
    9053,  9057,  9064,  9081,  9084,  9092,  9095,  9102,  9106,  9110,
    9114,  9121,  9122,  9126,  9127,  9136,  9149,  9155,  9166,  9169,
    9177,  9180,  9186,  9192,  9201,  9202,  9203,  9217,  9222,  9244,
    9250,  9256,  9262,  9263,  9264,  9265,  9266,  9270,  9271,  9272,
    9276,  9277,  9278,  9282,  9283,  9288,  9339,  9346,  9389,  9395,
    9401,  9407,  9413,  9419,  9425,  9431,  9437,  9443,  9449,  9455,
    9461,  9465,  9471,  9480,  9486,  9494,  9500,  9509,  9515,  9523,
    9533,  9539,  9546,  9553,  9561,  9567,  9576,  9580,  9586,  9592,
    9598,  9604,  9611,  9617,  9623,  9629,  9635,  9642,  9648,  9654,
    9660,  9666,  9672,  9678,  9684,  9690,  9694,  9695,  9699,  9700,
    9704,  9705,  9709,  9710,  9714,  9715,  9716,  9717,  9718,  9719,
    9723,  9724,  9729,  9733,  9737,  9738,  9739,  9743,  9744,  9745,
    9746,  9747,  9748,  9752,  9753,  9754,  9759,  9758,  9764,  9772,
    9795,  9802,  9811,  9812,  9813,  9814,  9818,  9827,  9828,  9829,
    9830,  9831,  9832,  9833,  9834,  9866,  9867,  9868,  9869,  9870,
    9871,  9872,  9873,  9874,  9882,  9890,  9891,  9898,  9904,  9909,
    9919,  9925,  9930,  9936,  9942,  9948,  9959,  9966,  9971,  9976,
    9981,  9986,  9991,  9996, 10004, 10005, 10006, 10007, 10015, 10016,
   10024, 10025, 10031, 10035, 10041, 10047, 10056, 10057, 10066, 10073,
   10087, 10093, 10099, 10108, 10117, 10123, 10129, 10135, 10141, 10156,
   10167, 10173, 10179, 10185, 10191, 10197, 10205, 10212, 10216, 10221,
   10229, 10250, 10257, 10264, 10270, 10277, 10284, 10290, 10296, 10302,
   10308, 10314, 10320, 10326, 10332, 10339, 10345, 10356, 10363, 10369,
   10374, 10379, 10384, 10390, 10396, 10401, 10406, 10412, 10418, 10423,
   10430, 10437, 10445, 10452, 10459, 10466, 10473, 10490, 10496, 10502,
   10508, 10514, 10521, 10527, 10533, 10542, 10553, 10560, 10566, 10572,
   10579, 10587, 10593, 10599, 10604, 10610, 10618, 10624, 10630, 10636,
   10642, 10650, 10662, 10682, 10681, 10755, 10761, 10767, 10773, 10781,
   10783, 10788, 10789, 10793, 10794, 10798, 10799, 10803, 10810, 10818,
   10845, 10851, 10857, 10863, 10869, 10875, 10884, 10891, 10893, 10890,
   10900, 10911, 10917, 10923, 10929, 10935, 10941, 10947, 10953, 10959,
   10966, 10965, 10986, 10985, 11016, 11015, 11029, 11038, 11056, 11058,
   11063, 11080, 11087, 11094, 11101, 11108, 11115, 11122, 11129, 11136,
   11143, 11154, 11161, 11172, 11183, 11203, 11202, 11208, 11225, 11231,
   11240, 11249, 11259, 11258, 11270, 11280, 11288, 11293, 11301, 11302,
   11307, 11312, 11315, 11317, 11321, 11326, 11334, 11335, 11340, 11347,
   11357, 11356, 11373, 11376, 11375, 11380, 11379, 11384, 11383, 11387,
   11392, 11393, 11394, 11399, 11404, 11412, 11413, 11414, 11415, 11416,
   11417, 11418, 11419, 11423, 11424, 11425, 11426, 11433, 11434, 11438,
   11443, 11451, 11452, 11456, 11463, 11471, 11480, 11490, 11491, 11500,
   11509, 11521, 11522, 11534, 11538, 11542, 11550, 11554, 11559, 11560,
   11566, 11565, 11594, 11593, 11609, 11618, 11629, 11639, 11640, 11641,
   11646, 11655, 11656, 11657, 11658, 11659, 11663, 11667, 11671, 11681,
   11688, 11696, 11702, 11695, 11748, 11749, 11755, 11760, 11774, 11782,
   11780, 11800, 11798, 11811, 11823, 11821, 11841, 11840, 11852, 11865,
   11863, 11884, 11883, 11896, 11910, 11911, 11912, 11916, 11917, 11925,
   11926, 11930, 11939, 11940, 11941, 11946, 11947, 11951, 11952, 11956,
   11957, 11961, 11962, 11970, 11978, 11986, 11987, 12000, 12016, 12023,
   12035, 12036, 12041, 12044, 12045, 12046, 12050, 12051, 12056, 12055,
   12061, 12060, 12068, 12069, 12072, 12074, 12074, 12078, 12078, 12083,
   12084, 12088, 12090, 12095, 12096, 12100, 12111, 12125, 12126, 12127,
   12128, 12129, 12130, 12131, 12132, 12133, 12134, 12135, 12136, 12140,
   12141, 12142, 12143, 12144, 12145, 12146, 12147, 12148, 12152, 12153,
   12154, 12155, 12158, 12160, 12161, 12165, 12166, 12170, 12178, 12180,
   12184, 12186, 12185, 12199, 12202, 12201, 12219, 12221, 12225, 12230,
   12238, 12239, 12256, 12279, 12280, 12286, 12287, 12291, 12304, 12303,
   12312, 12313, 12322, 12323, 12327, 12328, 12332, 12333, 12347, 12348,
   12352, 12362, 12371, 12378, 12385, 12395, 12396, 12403, 12413, 12414,
   12416, 12418, 12420, 12422, 12431, 12435, 12436, 12440, 12454, 12455,
   12461, 12460, 12471, 12477, 12486, 12487, 12488, 12494, 12495, 12500,
   12507, 12513, 12518, 12529, 12539, 12550, 12557, 12565, 12575, 12576,
   12580, 12581, 12585, 12586, 12591, 12598, 12605, 12612, 12622, 12627,
   12632, 12636, 12642, 12648, 12657, 12665, 12669, 12676, 12677, 12681,
   12686, 12691, 12704, 12708, 12712, 12716, 12721, 12724, 12728, 12742,
   12750, 12761, 12763, 12767, 12768, 12772, 12773, 12774, 12775, 12776,
   12777, 12781, 12782, 12783, 12784, 12785, 12789, 12790, 12791, 12792,
   12796, 12797, 12798, 12799, 12800, 12804, 12805, 12806, 12807, 12808,
   12812, 12817, 12818, 12822, 12823, 12827, 12828, 12829, 12834, 12833,
   12865, 12866, 12870, 12871, 12875, 12885, 12885, 12897, 12898, 12901,
   12921, 12925, 12930, 12938, 12944, 12955, 12943, 12957, 12972, 12984,
   12983, 13006, 13005, 13015, 13014, 13037, 13043, 13047, 13052, 13051,
   13060, 13065, 13071, 13076, 13081, 13088, 13086, 13097, 13101, 13102,
   13106, 13118, 13131, 13132, 13136, 13150, 13154, 13163, 13166, 13173,
   13174, 13182, 13187, 13181, 13199, 13204, 13198, 13214, 13222, 13231,
   13239, 13240, 13244, 13245, 13249, 13250, 13258, 13258, 13261, 13261,
   13274, 13275, 13277, 13276, 13289, 13295, 13297, 13301, 13303, 13309,
   13313, 13314, 13318, 13319, 13323, 13333, 13334, 13338, 13339, 13343,
   13344, 13348, 13349, 13354, 13353, 13369, 13368, 13383, 13384, 13388,
   13389, 13393, 13398, 13406, 13414, 13425, 13426, 13432, 13440, 13442,
   13444, 13442, 13454, 13466, 13473, 13483, 13502, 13472, 13509, 13510,
   13514, 13523, 13524, 13528, 13538, 13539, 13546, 13545, 13563, 13566,
   13573, 13574, 13582, 13597, 13605, 13616, 13622, 13615, 13627, 13633,
   13626, 13641, 13645, 13644, 13664, 13665, 13669, 13684, 13702, 13703,
   13707, 13708, 13712, 13713, 13714, 13719, 13730, 13718, 13740, 13742,
   13745, 13747, 13750, 13751, 13754, 13758, 13762, 13766, 13770, 13774,
   13778, 13782, 13786, 13794, 13797, 13807, 13806, 13825, 13832, 13840,
   13848, 13856, 13864, 13872, 13879, 13886, 13892, 13894, 13896, 13905,
   13909, 13914, 13913, 13920, 13919, 13925, 13934, 13941, 13946, 13951,
   13956, 13961, 13966, 13968, 13970, 13972, 13979, 13987, 13989, 13997,
   14004, 14011, 14019, 14025, 14030, 14038, 14046, 14054, 14058, 14062,
   14069, 14078, 14085, 14092, 14099, 14105, 14111, 14117, 14123, 14129,
   14137, 14142, 14149, 14156, 14163, 14170, 14177, 14184, 14189, 14194,
   14199, 14204, 14209, 14216, 14238, 14240, 14242, 14247, 14248, 14251,
   14253, 14257, 14258, 14262, 14263, 14267, 14268, 14272, 14273, 14277,
   14278, 14282, 14283, 14292, 14304, 14303, 14322, 14321, 14331, 14332,
   14333, 14334, 14335, 14336, 14340, 14341, 14345, 14352, 14353, 14355,
   14356, 14360, 14361, 14374, 14375, 14376, 14391, 14390, 14402, 14401,
   14413, 14418, 14419, 14432, 14435, 14434, 14447, 14448, 14453, 14455,
   14457, 14459, 14461, 14463, 14471, 14473, 14475, 14477, 14482, 14484,
   14492, 14494, 14496, 14498, 14500, 14502, 14519, 14520, 14524, 14528,
   14541, 14540, 14555, 14565, 14566, 14569, 14571, 14572, 14576, 14592,
   14593, 14598, 14597, 14607, 14608, 14612, 14612, 14616, 14615, 14621,
   14625, 14626, 14630, 14631, 14638, 14643, 14642, 14657, 14656, 14671,
   14672, 14673, 14677, 14678, 14679, 14688, 14689, 14693, 14697, 14705,
   14705, 14710, 14711, 14720, 14732, 14746, 14757, 14770, 14731, 14781,
   14782, 14786, 14787, 14791, 14792, 14800, 14804, 14805, 14806, 14809,
   14811, 14815, 14816, 14820, 14825, 14832, 14837, 14844, 14846, 14850,
   14851, 14855, 14860, 14868, 14869, 14873, 14875, 14883, 14884, 14888,
   14889, 14890, 14894, 14896, 14901, 14902, 14911, 14912, 14916, 14917,
   14921, 14934, 14939, 14944, 14949, 14957, 14965, 14970, 14978, 14986,
   15001, 15008, 15014, 15024, 15025, 15033, 15034, 15035, 15036, 15050,
   15056, 15062, 15068, 15074, 15080, 15101, 15111, 15121, 15127, 15134,
   15144, 15151, 15158, 15169, 15168, 15192, 15193, 15198, 15199, 15204,
   15228, 15231, 15230, 15246, 15250, 15255, 15259, 15269, 15275, 15284,
   15302, 15303, 15307, 15312, 15320, 15325, 15333, 15338, 15343, 15348,
   15354, 15359, 15367, 15372, 15377, 15382, 15388, 15396, 15397, 15408,
   15416, 15420, 15426, 15432, 15442, 15448, 15457, 15467, 15468, 15472,
   15473, 15474, 15478, 15486, 15494, 15502, 15510, 15511, 15519, 15520,
   15524, 15525, 15530, 15539, 15540, 15548, 15549, 15557, 15558, 15559,
   15563, 15574, 15603, 15612, 15612, 15614, 15624, 15625, 15626, 15627,
   15628, 15629, 15630, 15631, 15632, 15633, 15634, 15635, 15640, 15641,
   15642, 15643, 15644, 15645, 15646, 15647, 15648, 15649, 15650, 15651,
   15652, 15656, 15657, 15658, 15659, 15660, 15661, 15662, 15663, 15664,
   15665, 15666, 15667, 15668, 15672, 15673, 15674, 15675, 15676, 15677,
   15678, 15679, 15680, 15681, 15682, 15683, 15684, 15688, 15689, 15690,
   15691, 15692, 15693, 15694, 15695, 15708, 15709, 15710, 15711, 15712,
   15713, 15714, 15715, 15716, 15717, 15718, 15719, 15720, 15721, 15722,
   15723, 15724, 15725, 15726, 15727, 15728, 15729, 15730, 15731, 15732,
   15733, 15734, 15735, 15736, 15737, 15738, 15739, 15740, 15741, 15742,
   15743, 15744, 15745, 15746, 15747, 15748, 15749, 15750, 15751, 15752,
   15753, 15754, 15755, 15756, 15757, 15758, 15759, 15760, 15761, 15802,
   15803, 15804, 15805, 15806, 15807, 15818, 15819, 15820, 15821, 15822,
   15823, 15824, 15825, 15826, 15827, 15831, 15832, 15833, 15837, 15838,
   15839, 15848, 15849, 15850, 15851, 15852, 15853, 15854, 15855, 15856,
   15857, 15858, 15859, 15860, 15861, 15862, 15863, 15864, 15865, 15866,
   15867, 15868, 15869, 15870, 15871, 15872, 15873, 15878, 15886, 15887,
   15888, 15889, 15890, 15891, 15892, 15893, 15894, 15895, 15896, 15897,
   15898, 15899, 15900, 15901, 15902, 15903, 15904, 15905, 15906, 15907,
   15908, 15909, 15910, 15911, 15912, 15913, 15914, 15915, 15916, 15917,
   15918, 15919, 15920, 15921, 15922, 15923, 15924, 15925, 15926, 15927,
   15928, 15929, 15930, 15931, 15932, 15933, 15938, 15939, 15940, 15941,
   15942, 15943, 15944, 15945, 15946, 15947, 15948, 15949, 15950, 15951,
   15952, 15953, 15954, 15955, 15956, 15957, 15958, 15959, 15960, 15961,
   15962, 15963, 15964, 15965, 15966, 15967, 15968, 15969, 15970, 15971,
   15972, 15973, 15974, 15975, 15976, 15977, 15978, 15979, 15980, 15981,
   15982, 15983, 15984, 15985, 15986, 15987, 15988, 15989, 15990, 15991,
   15992, 15993, 15994, 15995, 15996, 15997, 15998, 15999, 16000, 16001,
   16002, 16003, 16004, 16005, 16006, 16007, 16008, 16009, 16010, 16011,
   16012, 16013, 16014, 16015, 16016, 16017, 16018, 16019, 16020, 16021,
   16022, 16023, 16024, 16025, 16026, 16027, 16028, 16029, 16030, 16031,
   16032, 16033, 16034, 16035, 16036, 16037, 16038, 16039, 16040, 16041,
   16042, 16043, 16044, 16045, 16046, 16047, 16048, 16049, 16050, 16051,
   16052, 16053, 16054, 16055, 16056, 16057, 16061, 16062, 16063, 16064,
   16065, 16066, 16067, 16068, 16069, 16070, 16071, 16072, 16073, 16074,
   16075, 16076, 16077, 16078, 16079, 16080, 16081, 16082, 16083, 16084,
   16085, 16086, 16087, 16088, 16089, 16090, 16091, 16092, 16093, 16094,
   16095, 16096, 16097, 16098, 16099, 16100, 16101, 16102, 16103, 16104,
   16105, 16106, 16107, 16108, 16109, 16110, 16111, 16112, 16113, 16114,
   16115, 16116, 16117, 16118, 16119, 16120, 16121, 16122, 16123, 16124,
   16125, 16126, 16127, 16128, 16129, 16130, 16131, 16132, 16133, 16134,
   16135, 16136, 16137, 16138, 16139, 16140, 16141, 16142, 16143, 16144,
   16148, 16149, 16150, 16151, 16152, 16153, 16154, 16155, 16156, 16157,
   16158, 16159, 16160, 16161, 16162, 16163, 16164, 16165, 16166, 16167,
   16168, 16169, 16170, 16171, 16172, 16173, 16174, 16175, 16176, 16177,
   16178, 16179, 16180, 16181, 16182, 16186, 16187, 16188, 16189, 16190,
   16191, 16192, 16193, 16194, 16195, 16196, 16197, 16198, 16199, 16200,
   16201, 16202, 16203, 16204, 16205, 16206, 16207, 16208, 16209, 16210,
   16211, 16212, 16213, 16214, 16215, 16216, 16217, 16218, 16219, 16220,
   16221, 16222, 16223, 16224, 16225, 16226, 16227, 16232, 16233, 16234,
   16235, 16236, 16237, 16238, 16239, 16240, 16241, 16242, 16243, 16244,
   16245, 16246, 16247, 16248, 16249, 16250, 16251, 16252, 16253, 16254,
   16255, 16256, 16257, 16258, 16259, 16260, 16261, 16262, 16263, 16264,
   16265, 16266, 16267, 16268, 16269, 16270, 16271, 16272, 16273, 16274,
   16275, 16276, 16277, 16278, 16279, 16280, 16281, 16282, 16283, 16284,
   16285, 16286, 16287, 16288, 16289, 16290, 16291, 16292, 16293, 16294,
   16295, 16296, 16297, 16298, 16299, 16300, 16301, 16302, 16303, 16304,
   16305, 16306, 16307, 16308, 16309, 16310, 16311, 16312, 16313, 16314,
   16315, 16316, 16317, 16318, 16319, 16320, 16321, 16322, 16323, 16324,
   16325, 16326, 16327, 16328, 16329, 16330, 16331, 16332, 16333, 16334,
   16335, 16336, 16337, 16338, 16339, 16340, 16341, 16342, 16343, 16344,
   16345, 16346, 16347, 16348, 16349, 16350, 16351, 16352, 16354, 16356,
   16357, 16358, 16359, 16360, 16361, 16362, 16363, 16364, 16365, 16366,
   16367, 16368, 16369, 16370, 16371, 16372, 16373, 16374, 16375, 16376,
   16377, 16378, 16379, 16380, 16381, 16382, 16383, 16384, 16385, 16386,
   16387, 16388, 16389, 16390, 16391, 16392, 16393, 16394, 16395, 16396,
   16397, 16398, 16399, 16400, 16401, 16402, 16403, 16404, 16405, 16406,
   16407, 16408, 16409, 16410, 16411, 16412, 16413, 16414, 16415, 16416,
   16417, 16418, 16419, 16420, 16421, 16422, 16423, 16424, 16425, 16426,
   16427, 16428, 16429, 16430, 16431, 16432, 16433, 16434, 16435, 16436,
   16437, 16438, 16439, 16440, 16441, 16442, 16443, 16444, 16445, 16446,
   16447, 16448, 16449, 16450, 16451, 16452, 16453, 16454, 16455, 16456,
   16457, 16458, 16459, 16460, 16461, 16462, 16463, 16464, 16465, 16466,
   16467, 16468, 16469, 16470, 16482, 16481, 16494, 16495, 16497, 16496,
   16508, 16507, 16514, 16512, 16532, 16533, 16538, 16539, 16541, 16540,
   16554, 16555, 16561, 16560, 16565, 16569, 16570, 16571, 16575, 16576,
   16577, 16578, 16582, 16583, 16584, 16585, 16594, 16593, 16607, 16606,
   16621, 16620, 16638, 16637, 16651, 16650, 16664, 16663, 16679, 16678,
   16692, 16691, 16705, 16704, 16717, 16716, 16728, 16727, 16739, 16738,
   16750, 16749, 16760, 16778, 16789, 16811, 16833, 16849, 16861, 16860,
   16874, 16873, 16885, 16884, 16898, 16899, 16900, 16901, 16905, 16924,
   16942, 16943, 16947, 16948, 16949, 16950, 16955, 16960, 16965, 16976,
   16977, 16978, 16984, 16990, 17002, 17001, 17015, 17016, 17022, 17031,
   17032, 17036, 17037, 17041, 17060, 17061, 17062, 17067, 17068, 17073,
   17072, 17090, 17089, 17101, 17110, 17120, 17119, 17162, 17163, 17167,
   17168, 17172, 17173, 17174, 17175, 17177, 17176, 17189, 17190, 17191,
   17192, 17193, 17199, 17204, 17209, 17214, 17218, 17223, 17232, 17234,
   17239, 17244, 17250, 17256, 17261, 17273, 17274, 17278, 17279, 17283,
   17288, 17296, 17306, 17325, 17328, 17330, 17334, 17335, 17342, 17344,
   17348, 17353, 17360, 17364, 17373, 17380, 17381, 17382, 17383, 17387,
   17388, 17389, 17390, 17391, 17392, 17393, 17394, 17395, 17396, 17397,
   17398, 17399, 17400, 17401, 17402, 17403, 17404, 17405, 17406, 17407,
   17408, 17409, 17410, 17411, 17412, 17413, 17414, 17415, 17416, 17417,
   17418, 17419, 17420, 17421, 17422, 17423, 17424, 17425, 17426, 17427,
   17428, 17432, 17433, 17437, 17438, 17442, 17449, 17456, 17466, 17475,
   17481, 17488, 17496, 17501, 17509, 17514, 17522, 17527, 17534, 17534,
   17535, 17535, 17538, 17544, 17550, 17555, 17562, 17568, 17575, 17584,
   17588, 17594, 17602, 17604, 17608, 17612, 17616, 17623, 17628, 17633,
   17638, 17643, 17651, 17652, 17656, 17657, 17662, 17663, 17667, 17668,
   17672, 17673, 17677, 17678, 17683, 17682, 17692, 17701, 17702, 17706,
   17707, 17712, 17713, 17714, 17719, 17720, 17721, 17725, 17737, 17746,
   17752, 17761, 17770, 17783, 17785, 17787, 17795, 17796, 17797, 17801,
   17802, 17808, 17809, 17810, 17811, 17812, 17813, 17814, 17824, 17825,
   17830, 17843, 17857, 17858, 17859, 17863, 17864, 17868, 17869, 17874,
   17875, 17879, 17885, 17894, 17894, 17908, 17909, 17910, 17911, 17921,
   17923, 17929, 17935, 17945, 17954, 17960, 17965, 17969, 17943, 18018,
   18018, 18035, 18039, 18043, 18047, 18051, 18055, 18063, 18064, 18080,
   18087, 18094, 18107, 18108, 18109, 18113, 18114, 18115, 18119, 18120,
   18125, 18127, 18126, 18132, 18133, 18137, 18142, 18149, 18154, 18163,
   18169, 18580, 18581, 18585, 18587, 18586, 18596, 18595, 18606, 18610,
   18614, 18619, 18620, 18626, 18627, 18628, 18629, 18630, 18631, 18632,
   18633, 18637, 18638, 18639, 18640, 18641, 18642, 18643, 18644, 18648,
   18649, 18650, 18655, 18659, 18668, 18667, 18680, 18686, 18690, 18700,
   18709, 18710, 18711, 18715, 18716, 18717, 18721, 18727, 18733, 18739,
   18745, 18751, 18761, 18761, 18773, 18779, 18780, 18781, 18782, 18783,
   18784, 18785, 18786, 18790, 18791, 18799, 18800, 18806, 18805, 18822,
   18821, 18840, 18839, 18863, 18864, 18868, 18877, 18878, 18882, 18883,
   18888, 18887, 18902, 18910, 18911, 18915, 18916, 18921, 18922, 18927,
   18928, 18932, 18933, 18937, 18941, 18945, 18951, 18941, 18960, 18962,
   18967, 18968, 18972, 18973, 18977, 18977, 18983, 18989, 18997, 18998,
   18999, 19005, 19006, 19012, 19013, 19019, 19030, 19029, 19057, 19056,
   19082, 19091, 19100, 19106, 19105, 19124, 19123, 19142, 19146, 19147,
   19151, 19152, 19156, 19163, 19173, 19181, 19192, 19197, 19202, 19207,
   19217, 19216, 19232, 19240, 19231, 19254, 19259, 19264, 19269, 19277,
   19290, 19289, 19300, 19298, 19314, 19312, 19326, 19337, 19333, 19357,
   19369, 19374, 19353, 19387, 19391, 19396, 19395, 19404, 19408, 19409,
   19416, 19417, 19424, 19425, 19429, 19430, 19437, 19448, 19447, 19466,
   19467, 19468, 19469, 19470, 19471, 19475, 19476, 19477, 19478, 19479,
   19480, 19481, 19482, 19483, 19484, 19485, 19489, 19490, 19491, 19492,
   19499, 19497, 19513, 19517, 19511, 19533, 19534, 19539, 19538, 19553,
   19559, 19552, 19576, 19574
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "'@'", "ABORT_SYM", "IMPOSSIBLE_ACTION",
  "END_OF_INPUT", "COLON_ORACLE_SYM", "PARAM_MARKER",
  "FOR_SYSTEM_TIME_SYM", "LEFT_PAREN_ALT", "LEFT_PAREN_WITH",
  "LEFT_PAREN_LIKE", "ORACLE_CONCAT_SYM", "PERCENT_ORACLE_SYM",
  "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WITH_SYSTEM_SYM", "IDENT",
  "IDENT_QUOTED", "LEX_HOSTNAME", "UNDERSCORE_CHARSET", "BIN_NUM",
  "DECIMAL_NUM", "FLOAT_NUM", "HEX_NUM", "HEX_STRING", "LONG_NUM",
  "NCHAR_STRING", "NUM", "TEXT_STRING", "ULONGLONG_NUM", "AND_AND_SYM",
  "DOT_DOT_SYM", "EQUAL_SYM", "GE", "LE", "MYSQL_CONCAT_SYM", "NE",
  "NOT2_SYM", "OR2_SYM", "SET_VAR", "SHIFT_LEFT", "SHIFT_RIGHT",
  "ACCESSIBLE_SYM", "ADD", "ALL", "ALTER", "ANALYZE_SYM", "AND_SYM", "ASC",
  "ASENSITIVE_SYM", "AS", "BEFORE_SYM", "BETWEEN_SYM", "BIGINT", "BINARY",
  "BIT_AND", "BIT_OR", "BIT_XOR", "BLOB_MARIADB_SYM", "BLOB_ORACLE_SYM",
  "BODY_ORACLE_SYM", "BOTH", "BY", "CALL_SYM", "CASCADE", "CASE_SYM",
  "CAST_SYM", "CHANGE", "CHAR_SYM", "CHECK_SYM", "COLLATE_SYM",
  "CONDITION_SYM", "CONSTRAINT", "CONTINUE_MARIADB_SYM",
  "CONTINUE_ORACLE_SYM", "CONVERT_SYM", "COUNT_SYM", "CREATE", "CROSS",
  "CUME_DIST_SYM", "CURDATE", "CURRENT_ROLE", "CURRENT_USER", "CURSOR_SYM",
  "CURTIME", "DATABASE", "DATABASES", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DECIMAL_SYM", "DECLARE_MARIADB_SYM",
  "DECLARE_ORACLE_SYM", "DEFAULT", "DELETE_DOMAIN_ID_SYM", "DELETE_SYM",
  "DENSE_RANK_SYM", "DESCRIBE", "DESC", "DETERMINISTIC_SYM", "DISTINCT",
  "DIV_SYM", "DO_DOMAIN_IDS_SYM", "DOUBLE_SYM", "DROP", "DUAL_SYM",
  "EACH_SYM", "ELSEIF_MARIADB_SYM", "ELSE", "ELSIF_ORACLE_SYM",
  "EMPTY_SYM", "ENCLOSED", "ESCAPED", "EXCEPT_SYM", "EXISTS",
  "EXTRACT_SYM", "FALSE_SYM", "FETCH_SYM", "FIRST_VALUE_SYM", "FLOAT_SYM",
  "FOREIGN", "FOR_SYM", "FROM", "FULLTEXT_SYM", "GOTO_ORACLE_SYM", "GRANT",
  "GROUP_CONCAT_SYM", "JSON_ARRAYAGG_SYM", "JSON_OBJECTAGG_SYM",
  "JSON_TABLE_SYM", "GROUP_SYM", "HAVING", "HOUR_MICROSECOND_SYM",
  "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "IF_SYM", "IGNORE_DOMAIN_IDS_SYM",
  "IGNORE_SYM", "IGNORED_SYM", "INDEX_SYM", "INFILE", "INNER_SYM",
  "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "IN_SYM", "INTERSECT_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "IS", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LAG_SYM", "LEADING", "LEAD_SYM",
  "LEAVE_SYM", "LEFT", "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LOAD",
  "LOCATOR_SYM", "LOCK_SYM", "LONGBLOB", "LONG_SYM", "LONGTEXT",
  "LOOP_SYM", "LOW_PRIORITY", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MATCH",
  "MAX_SYM", "MAXVALUE_SYM", "MEDIAN_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MIN_SYM", "MINUS_ORACLE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MODIFIES_SYM", "MOD_SYM", "NATURAL", "NEG",
  "NESTED_SYM", "NOT_SYM", "NO_WRITE_TO_BINLOG", "NOW_SYM",
  "NTH_VALUE_SYM", "NTILE_SYM", "NULL_SYM", "NUMERIC_SYM", "ON",
  "OPTIMIZE", "OPTIONALLY", "ORDER_SYM", "ORDINALITY_SYM", "OR_SYM",
  "OTHERS_ORACLE_SYM", "OUTER", "OUTFILE", "OUT_SYM", "OVER_SYM",
  "PACKAGE_ORACLE_SYM", "PAGE_CHECKSUM_SYM", "PARSE_VCOL_EXPR_SYM",
  "PARTITION_SYM", "PATH_SYM", "PERCENTILE_CONT_SYM",
  "PERCENTILE_DISC_SYM", "PERCENT_RANK_SYM", "PORTION_SYM", "POSITION_SYM",
  "PRECISION", "PRIMARY_SYM", "PROCEDURE_SYM", "PURGE", "RAISE_ORACLE_SYM",
  "RANGE_SYM", "RANK_SYM", "READS_SYM", "READ_SYM", "READ_WRITE_SYM",
  "REAL", "RECURSIVE_SYM", "REFERENCES", "REF_SYSTEM_ID_SYM", "REGEXP",
  "RELEASE_SYM", "RENAME", "REPEAT_SYM", "REPLACE", "REQUIRE_SYM",
  "RESIGNAL_SYM", "RESTRICT", "RETURNING_SYM", "RETURN_MARIADB_SYM",
  "RETURN_ORACLE_SYM", "REVOKE", "RIGHT", "ROW_NUMBER_SYM", "ROWS_SYM",
  "ROWTYPE_ORACLE_SYM", "SECOND_MICROSECOND_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERVER_OPTIONS", "SET", "SHOW",
  "SIGNAL_SYM", "SMALLINT", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQL_BIG_RESULT", "SQLEXCEPTION_SYM", "SQL_SMALL_RESULT", "SQLSTATE_SYM",
  "SQL_SYM", "SQLWARNING_SYM", "SSL_SYM", "STARTING",
  "STATS_AUTO_RECALC_SYM", "STATS_PERSISTENT_SYM",
  "STATS_SAMPLE_PAGES_SYM", "STDDEV_SAMP_SYM", "STD_SYM", "STRAIGHT_JOIN",
  "SUBSTRING", "SUM_SYM", "SYSDATE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TERMINATED", "THEN_SYM", "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM",
  "TRAILING", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "UNDO_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNLOCK_SYM", "UNSIGNED", "UPDATE_SYM", "USAGE", "USE_SYM",
  "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES_IN_SYM", "VALUES_LESS_SYM", "VALUES", "VARBINARY", "VARCHAR",
  "VARIANCE_SYM", "VAR_SAMP_SYM", "VARYING", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "XOR", "YEAR_MONTH_SYM", "ZEROFILL",
  "BODY_MARIADB_SYM", "ELSEIF_ORACLE_SYM", "ELSIF_MARIADB_SYM",
  "EXCEPTION_ORACLE_SYM", "GOTO_MARIADB_SYM", "OTHERS_MARIADB_SYM",
  "PACKAGE_MARIADB_SYM", "RAISE_MARIADB_SYM", "ROWTYPE_MARIADB_SYM",
  "ROWNUM_SYM", "ACCOUNT_SYM", "ACTION", "ADMIN_SYM", "ADDDATE_SYM",
  "ADD_MONTHS_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALWAYS_SYM", "ANY_SYM", "ASCII_SYM", "AT_SYM",
  "ATOMIC_SYM", "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC",
  "AUTO_SYM", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM",
  "BEGIN_MARIADB_SYM", "BEGIN_ORACLE_SYM", "BINLOG_SYM", "BIT_SYM",
  "BLOCK_SYM", "BOOL_SYM", "BOOLEAN_SYM", "BTREE_SYM", "BYTE_SYM",
  "CACHE_SYM", "CASCADED", "CATALOG_NAME_SYM", "CHAIN_SYM", "CHANGED",
  "CHARSET", "CHECKPOINT_SYM", "CHECKSUM_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOB_MARIADB_SYM", "CLOB_ORACLE_SYM",
  "CLOSE_SYM", "COALESCE", "CODE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONNECTION_SYM",
  "CONSISTENT_SYM", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM",
  "CONTRIBUTORS_SYM", "CPU_SYM", "CUBE_SYM", "CURRENT_SYM",
  "CURRENT_POS_SYM", "CURSOR_NAME_SYM", "CYCLE_SYM", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_FORMAT_SYM", "DATE_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECODE_MARIADB_SYM", "DECODE_ORACLE_SYM",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DES_KEY_FILE",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DO_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "ENABLE_SYM",
  "END", "ENDS_SYM", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "ERROR_SYM",
  "ERRORS", "ESCAPE_SYM", "EVENTS_SYM", "EVENT_SYM", "EVERY_SYM",
  "EXCHANGE_SYM", "EXAMINED_SYM", "EXCLUDE_SYM", "EXECUTE_SYM",
  "EXCEPTION_MARIADB_SYM", "EXIT_MARIADB_SYM", "EXIT_ORACLE_SYM",
  "EXPANSION_SYM", "EXPIRE_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "FAST_SYM", "FAULTS_SYM", "FEDERATED_SYM", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLUSH_SYM", "FOLLOWS_SYM", "FOLLOWING_SYM",
  "FORCE_SYM", "FORMAT_SYM", "FOUND_SYM", "FULL", "FUNCTION_SYM",
  "GENERAL", "GENERATED_SYM", "GET_FORMAT", "GET_SYM", "GLOBAL_SYM",
  "GRANTS", "HANDLER_SYM", "HARD_SYM", "HASH_SYM", "HELP_SYM",
  "HIGH_PRIORITY", "HISTORY_SYM", "HOST_SYM", "HOSTS_SYM", "HOUR_SYM",
  "ID_SYM", "IDENTIFIED_SYM", "IGNORE_SERVER_IDS_SYM", "IMMEDIATE_SYM",
  "IMPORT", "INCREMENT_SYM", "INDEXES", "INITIAL_SIZE_SYM",
  "INSERT_METHOD", "INSTALL_SYM", "INVOKER_SYM", "IO_SYM", "IPC_SYM",
  "ISOLATION", "ISOPEN_SYM", "ISSUER_SYM", "INVISIBLE_SYM", "JSON_SYM",
  "KEY_BLOCK_SIZE", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE",
  "LASTVAL_SYM", "LEAVES", "LESS_SYM", "LEVEL_SYM", "LIST_SYM",
  "LOCAL_SYM", "LOCKED_SYM", "LOCKS_SYM", "LOGFILE_SYM", "LOGS_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_DELAY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_UPDATES_PER_HOUR", "MAX_STATEMENT_TIME_SYM",
  "MAX_USER_CONNECTIONS_SYM", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_SYM",
  "MINVALUE_SYM", "MIN_ROWS", "MODE_SYM", "MODIFY_SYM", "MONITOR_SYM",
  "MONTH_SYM", "MUTEX_SYM", "MYSQL_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM",
  "NAME_SYM", "NATIONAL_SYM", "NCHAR_SYM", "NEVER_SYM", "NEW_SYM",
  "NEXT_SYM", "NEXTVAL_SYM", "NOCACHE_SYM", "NOCYCLE_SYM", "NODEGROUP_SYM",
  "NONE_SYM", "NOTFOUND_SYM", "NO_SYM", "NOMAXVALUE_SYM", "NOMINVALUE_SYM",
  "NO_WAIT_SYM", "NOWAIT_SYM", "NUMBER_MARIADB_SYM", "NUMBER_ORACLE_SYM",
  "NVARCHAR_SYM", "OF_SYM", "OFFSET_SYM", "OLD_PASSWORD_SYM", "ONE_SYM",
  "ONLY_SYM", "ONLINE_SYM", "OPEN_SYM", "OPTIONS_SYM", "OPTION",
  "OVERLAPS_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARSER_SYM",
  "PARTIAL", "PARTITIONS_SYM", "PARTITIONING_SYM", "PASSWORD_SYM",
  "PERIOD_SYM", "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM",
  "PORT_SYM", "PRECEDES_SYM", "PRECEDING_SYM", "PREPARE_SYM",
  "PRESERVE_SYM", "PREV_SYM", "PREVIOUS_SYM", "PRIVILEGES", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM",
  "QUARTER_SYM", "QUERY_SYM", "QUICK", "RAW_MARIADB_SYM", "RAW_ORACLE_SYM",
  "READ_ONLY_SYM", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "RELAY", "RELAYLOG_SYM",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELOAD",
  "REMOVE_SYM", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPLAY_SYM",
  "REPLICATION", "RESET_SYM", "RESTART_SYM", "RESOURCES", "RESTORE_SYM",
  "RESUME_SYM", "RETURNED_SQLSTATE_SYM", "RETURNS_SYM", "REUSE_SYM",
  "REVERSE_SYM", "ROLE_SYM", "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM",
  "ROWCOUNT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "ROW_FORMAT_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_SYM", "SECURITY_SYM", "SEQUENCE_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM", "SETVAL_SYM", "SHARE_SYM",
  "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SKIP_SYM", "SLAVE", "SLAVES",
  "SLAVE_POS_SYM", "SLOW", "SNAPSHOT_SYM", "SOCKET_SYM", "SOFT_SYM",
  "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_THREAD",
  "STAGE_SYM", "STARTS_SYM", "START_SYM", "STATEMENT_SYM", "STATUS_SYM",
  "STOP_SYM", "STORAGE_SYM", "STORED_SYM", "STRING_SYM",
  "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSTEM", "SYSTEM_TIME_SYM", "TABLES", "TABLESPACE",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TEXT_SYM", "THAN_SYM", "TIES_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TRANSACTION_SYM", "TRANSACTIONAL_SYM",
  "THREADS_SYM", "TRIGGERS_SYM", "TRIM_ORACLE", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UNBOUNDED_SYM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNICODE_SYM", "UNINSTALL_SYM", "UNKNOWN_SYM",
  "UNTIL_SYM", "UPGRADE_SYM", "USER_SYM", "USE_FRM", "VALUE_SYM",
  "VARCHAR2_MARIADB_SYM", "VARCHAR2_ORACLE_SYM", "VARIABLES",
  "VERSIONING_SYM", "VIA_SYM", "VIEW_SYM", "VISIBLE_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WINDOW_SYM",
  "WITHIN", "WITHOUT", "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM",
  "XA_SYM", "XML_SYM", "YEAR_SYM", "CONDITIONLESS_JOIN", "ON_SYM",
  "PREC_BELOW_NOT", "'='", "'>'", "'<'", "'|'", "'&'", "'-'", "'+'", "'*'",
  "'/'", "'%'", "'^'", "'~'", "SUBQUERY_AS_EXPR",
  "PREC_BELOW_IDENTIFIER_OPT_SPECIAL_CASE", "USER",
  "PREC_BELOW_CONTRACTION_TOKEN2", "'('", "')'", "EMPTY_FROM_CLAUSE",
  "','", "'!'", "'{'", "'}'", "';'", "'.'", "$accept", "query", "$@1",
  "opt_end_of_input", "directly_executable_statement", "verb_clause",
  "deallocate", "deallocate_or_drop", "prepare", "$@2", "execute", "$@3",
  "$@4", "execute_using", "$@5", "execute_params", "help", "$@6", "change",
  "$@7", "master_defs", "master_def", "ignore_server_id_list",
  "ignore_server_id", "do_domain_id_list", "do_domain_id",
  "ignore_domain_id_list", "ignore_domain_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@8", "$@9",
  "$@10", "$@11", "$@12", "$@13", "$@14", "$@15", "$@16", "$@17", "$@18",
  "$@19", "$@20", "$@21", "$@22", "$@23", "$@24", "opt_sequence",
  "sequence_defs", "sequence_def", "server_def", "$@25",
  "server_options_list", "server_option", "event_tail", "$@26",
  "ev_schedule_time", "$@27", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@28", "clear_privileges", "opt_aggregate", "sp_handler",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@29", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "$@30", "sp_fdparams",
  "sp_param_name", "sp_param_name_and_type", "sp_pdparam_list",
  "sp_pdparams", "sp_parameter_type", "sp_parenthesized_pdparam_list",
  "$@31", "sp_parenthesized_fdparam_list", "sp_proc_stmts",
  "sp_proc_stmts1", "optionally_qualified_column_ident",
  "row_field_definition", "row_field_definition_list", "row_type_body",
  "sp_decl_idents_init_vars", "sp_decl_variable_list", "$@32",
  "sp_decl_handler", "$@33", "opt_parenthesized_cursor_formal_parameters",
  "sp_cursor_stmt_lex", "sp_cursor_stmt", "$@34", "sp_handler_type",
  "sp_hcond_list", "sp_hcond_element", "sp_cond", "sqlstate", "opt_value",
  "sp_hcond", "raise_stmt_oracle", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_ident", "sp_decl_idents", "sp_proc_stmt_if", "$@35",
  "sp_proc_stmt_statement", "$@36", "RETURN_ALLMODES_SYM",
  "sp_proc_stmt_return", "sp_proc_stmt_exit_oracle",
  "sp_proc_stmt_continue_oracle", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_goto_oracle", "expr_lex", "@37",
  "assignment_source_lex", "assignment_source_expr", "$@38",
  "for_loop_bound_expr", "$@39", "cursor_actual_parameters",
  "opt_parenthesized_cursor_actual_parameters", "sp_proc_stmt_with_cursor",
  "sp_proc_stmt_open", "sp_proc_stmt_fetch_head", "sp_proc_stmt_fetch",
  "sp_proc_stmt_close", "sp_fetch_list", "sp_if", "$@40", "$@41",
  "sp_elseifs", "case_stmt_specification", "$@42", "case_stmt_body",
  "$@43", "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@44", "searched_when_clause", "$@45",
  "else_clause_opt", "sp_opt_label", "opt_sp_for_loop_direction",
  "sp_for_loop_index_and_bounds", "sp_for_loop_bounds", "loop_body",
  "repeat_body", "pop_sp_loop_label", "sp_labeled_control", "$@46", "$@47",
  "$@48", "$@49", "$@50", "$@51", "sp_unlabeled_control", "$@52", "$@53",
  "$@54", "$@55", "$@56", "trg_action_time", "trg_event",
  "change_tablespace_access", "change_tablespace_info", "tablespace_info",
  "opt_logfile_group_name", "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@57", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@58", "create_like", "opt_create_select",
  "create_select_query_expression", "opt_create_partitioning",
  "opt_partitioning", "partitioning", "$@59", "have_partitioning",
  "partition_entry", "$@60", "partition", "$@61", "part_type_def", "$@62",
  "$@63", "$@64", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@65",
  "$@66", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@67", "part_name", "opt_part_values", "$@68", "$@69", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@70", "$@71",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@72", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "opt_versioning_rotation", "opt_versioning_interval_start", "opt_as",
  "opt_create_database_options", "create_database_options",
  "create_database_option", "opt_if_not_exists_table_element",
  "opt_if_not_exists", "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@73", "opt_versioning_option",
  "versioning_option", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "udf_type", "create_field_list",
  "create_field_list_parens", "field_list", "field_list_item",
  "column_def", "key_def", "$@74", "$@75", "$@76", "$@77", "$@78", "$@79",
  "$@80", "constraint_def", "period_for_system_time",
  "period_for_application_time", "opt_check_constraint",
  "check_constraint", "opt_constraint_no_id", "opt_constraint",
  "constraint", "field_spec", "@81", "field_type_or_serial", "$@82",
  "$@83", "opt_serial_attribute", "opt_serial_attribute_list",
  "opt_asrow_attribute", "opt_asrow_attribute_list", "field_def", "$@84",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr", "$@85",
  "parenthesized_expr", "virtual_column_func", "expr_or_literal",
  "column_default_expr", "field_type", "qualified_field_type",
  "field_type_all", "field_type_numeric", "opt_binary_and_compression",
  "field_type_string", "field_type_temporal", "field_type_lob",
  "field_type_misc", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "srid_option", "float_options", "precision",
  "field_options", "last_field_options", "field_length",
  "opt_field_length", "opt_precision", "attribute_list", "attribute",
  "opt_compression_method", "opt_compressed", "opt_enable", "compressed",
  "compressed_deprecated_data_type_attribute",
  "compressed_deprecated_column_attribute", "asrow_attribute",
  "serial_attribute", "with_or_without_system", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "charset_or_alias", "collate", "opt_binary", "binary",
  "opt_bin_mod", "ws_nweights", "$@86", "ws_level_flag_desc",
  "ws_level_flag_reverse", "ws_level_flags", "ws_level_number",
  "ws_level_list_item", "ws_level_list", "ws_level_range",
  "ws_level_list_or_range", "opt_ws_levels", "opt_primary", "references",
  "opt_ref_list", "ref_list", "opt_match_clause", "opt_on_update_delete",
  "delete_option", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "fulltext", "spatial",
  "normal_key_options", "fulltext_key_options", "spatial_key_options",
  "normal_key_opts", "spatial_key_opts", "fulltext_key_opts",
  "opt_USING_key_algorithm", "opt_key_algorithm_clause", "key_using_alg",
  "all_key_opt", "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "ignorability", "key_list", "opt_without_overlaps",
  "key_part", "opt_ident", "string_list", "alter", "$@87", "$@88", "$@89",
  "$@90", "$@91", "$@92", "$@93", "$@94", "$@95", "$@96", "$@97", "$@98",
  "$@99", "account_locking_option", "opt_password_expire_option",
  "opt_account_locking_and_opt_password_expiration",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@100", "$@101", "$@102",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@103", "add_part_extra", "reorg_partition_rule", "$@104",
  "reorg_parts_rule", "$@105", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options",
  "$@106", "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@107", "$@108",
  "start", "opt_start_transaction_option_list",
  "start_transaction_option_list", "start_transaction_option",
  "slave_thread_opts", "$@109", "slave_thread_opt_list",
  "slave_thread_opt", "slave_until", "slave_until_opts", "checksum",
  "$@110", "opt_checksum_type", "repair_table_or_view", "$@111", "repair",
  "$@112", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "opt_view_repair_type", "analyze", "$@113", "analyze_table_list",
  "analyze_table_elem_spec", "opt_persistent_stat_clause",
  "persistent_stat_spec", "persistent_column_stat_spec", "$@114",
  "persistent_index_stat_spec", "$@115", "table_column_list",
  "table_index_list", "table_index_name", "binlog_base64_event",
  "check_view_or_table", "$@116", "check", "$@117", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "opt_view_check_type", "optimize",
  "$@118", "opt_no_write_to_binlog", "rename", "$@119", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@120",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@121",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@122", "cache_keys_spec",
  "$@123", "cache_key_list_or_empty", "opt_ignore_leaves", "select",
  "$@124", "$@125", "select_into", "$@126", "$@127", "simple_table",
  "table_value_constructor", "$@128", "query_specification_start", "$@129",
  "$@130", "query_specification", "select_into_query_specification",
  "query_expression", "query_expression_no_with_clause",
  "query_expression_body_ext", "$@131", "$@132",
  "query_expression_body_ext_parens", "query_expression_body", "$@133",
  "query_primary", "query_simple", "subselect", "subquery",
  "opt_from_clause", "from_clause", "table_reference_list",
  "select_options", "opt_history_unit", "history_point",
  "for_portion_of_time_clause", "opt_for_portion_of_time_clause",
  "opt_for_system_time_clause", "system_time_expr", "select_option_list",
  "select_option", "select_lock_type", "opt_select_lock_type",
  "opt_lock_wait_timeout_new", "select_item_list", "select_item",
  "remember_tok_start", "remember_name", "remember_end", "select_alias",
  "opt_default_time_precision", "opt_time_precision", "optional_braces",
  "expr", "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "opt_dyncol_type", "dyncol_type", "numeric_dyncol_type",
  "temporal_dyncol_type", "string_dyncol_type", "$@134",
  "dyncall_create_element", "dyncall_create_list", "plsql_cursor_attr",
  "explicit_cursor_attr", "trim_operands",
  "column_default_non_parenthesized_expr", "primary_expr",
  "string_factor_expr", "simple_expr", "mysql_concatenation_expr",
  "function_call_keyword_timestamp", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "function_call_generic", "@135", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@136", "$@137", "$@138",
  "$@139", "$@140", "window_func_expr", "window_func",
  "simple_window_func", "inverse_distribution_function",
  "percentile_function", "$@141", "inverse_distribution_function_def",
  "order_by_single_element_list", "window_name", "variable", "$@142",
  "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "gorder_list", "opt_glimit_clause", "glimit_clause",
  "glimit_options", "in_sum_expr", "$@143", "cast_type", "$@144", "$@145",
  "$@146", "cast_type_numeric", "cast_type_temporal", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "when_list",
  "when_list_opt_else", "decode_when_list_oracle", "table_ref",
  "json_text_literal", "join_table_list", "json_table_columns_clause",
  "json_table_columns_list", "json_table_column", "$@147", "$@148",
  "json_table_column_type", "json_table_field_type",
  "json_opt_on_empty_or_error", "json_on_response",
  "json_on_error_response", "json_on_empty_response", "table_function",
  "$@149", "$@150", "esc_table_ref", "derived_table_list", "join_table",
  "$@151", "$@152", "$@153", "$@154", "$@155", "$@156", "inner_join",
  "normal_join", "opt_use_partition", "use_partition", "table_factor",
  "table_primary_ident_opt_parens", "table_primary_derived_opt_parens",
  "table_reference_list_parens", "nested_table_reference_list",
  "join_table_parens", "table_primary_ident", "table_primary_derived",
  "opt_outer", "index_hint_clause", "index_hint_type",
  "index_hint_definition", "$@157", "$@158", "index_hints_list",
  "opt_index_hints_list", "$@159", "opt_key_definition", "$@160",
  "opt_key_usage_list", "key_usage_element", "key_usage_list",
  "using_list", "interval", "interval_time_stamp", "date_time_type",
  "table_alias", "opt_table_alias_clause", "table_alias_clause", "opt_all",
  "opt_where_clause", "$@161", "opt_having_clause", "$@162",
  "opt_group_clause", "group_list", "olap_opt", "opt_window_clause",
  "window_def_list", "window_def", "window_spec", "$@163",
  "opt_window_ref", "opt_window_partition_clause",
  "opt_window_order_clause", "opt_window_frame_clause",
  "window_frame_units", "window_frame_extent", "window_frame_start",
  "window_frame_bound", "opt_window_frame_exclusion", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@164", "order_list", "order_dir", "opt_limit_clause",
  "limit_clause", "fetch_first_clause", "first_or_next", "row_or_rows",
  "only_or_with_ties", "opt_global_limit_clause", "limit_options",
  "limit_option", "limit_rows_option", "delete_limit_clause",
  "order_limit_lock", "opt_order_limit_lock", "query_expression_tail",
  "opt_query_expression_tail", "opt_procedure_or_into", "order_or_limit",
  "opt_plus", "int_num", "ulong_num", "real_ulong_num", "longlong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "bool", "procedure_clause", "$@165", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@166",
  "select_var_list", "select_var_ident", "select_outvar", "into",
  "into_destination", "$@167", "$@168", "do", "$@169", "drop", "$@170",
  "$@171", "$@172", "$@173", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists_table_element", "opt_if_exists",
  "opt_temporary", "insert", "$@174", "$@175", "replace", "$@176", "$@177",
  "insert_start", "stmt_end", "insert_lock_option", "replace_lock_option",
  "insert_replace_option", "opt_into", "insert_table", "$@178",
  "insert_field_spec", "$@179", "insert_field_list", "opt_fields",
  "fields", "insert_values", "values_list", "ident_eq_list",
  "ident_eq_value", "equal", "opt_equal", "opt_with", "opt_by",
  "no_braces", "$@180", "no_braces_with_names", "$@181", "opt_values",
  "opt_values_with_names", "values", "values_with_names",
  "expr_or_default", "opt_insert_update", "$@182", "$@183",
  "update_table_list", "update", "$@184", "$@185", "$@186", "update_list",
  "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "$@187", "opt_delete_system_time",
  "delete_part2", "delete_single_table", "delete_single_table_for_period",
  "single_multi", "$@188", "$@189", "$@190", "$@191", "opt_returning",
  "@192", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "$@193", "$@194",
  "opt_table_sym", "opt_profile_defs", "profile_defs", "profile_def",
  "opt_profile_args", "show", "$@195", "show_param", "$@196", "$@197",
  "show_engine_param", "master_or_binary", "opt_storage", "opt_db",
  "opt_full", "from_or_in", "binlog_in", "binlog_from", "wild_and_where",
  "describe", "$@198", "$@199", "explainable_command", "describe_command",
  "analyze_stmt_command", "opt_extended_describe", "opt_format_json",
  "opt_describe_column", "flush", "$@200", "flush_options", "$@201",
  "opt_flush_lock", "flush_lock", "$@202", "flush_options_list",
  "flush_option", "opt_table_list", "backup", "backup_statements", "$@203",
  "opt_delete_gtid_domain", "delete_domain_id_list", "delete_domain_id",
  "optional_flush_tables_arguments", "reset", "$@204", "reset_options",
  "reset_option", "$@205", "$@206", "slave_reset_options",
  "master_reset_options", "purge", "$@207", "kill", "$@208", "kill_type",
  "kill_option", "opt_connection", "kill_expr", "shutdown", "$@209",
  "shutdown_option", "use", "load", "$@210", "$@211", "$@212", "$@213",
  "data_or_xml", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_xml_rows_identified_by",
  "opt_ignore_lines", "lines_or_rows", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "load_data_set_list", "load_data_set_elem", "text_literal",
  "text_string", "hex_or_bin_String", "param_marker", "signed_literal",
  "literal", "NUM_literal", "temporal_literal", "with_clause", "$@214",
  "opt_recursive", "with_list", "with_list_element", "opt_cycle", "$@215",
  "opt_with_column_list", "with_column_list", "ident_sys_alloc",
  "comma_separated_ident_list", "with_element_head", "insert_ident",
  "table_wild", "select_sublist_qualified_asterisk", "order_ident",
  "simple_ident", "simple_ident_nospvar", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_cli", "ident_cli",
  "IDENT_sys", "TEXT_STRING_sys", "TEXT_STRING_literal",
  "TEXT_STRING_filesystem", "ident_table_alias",
  "ident_cli_set_usual_case", "ident_sysvar_name", "ident", "label_ident",
  "ident_or_text", "user_maybe_role", "user_or_role", "user",
  "keyword_table_alias", "keyword_ident", "keyword_sysvar_name",
  "keyword_set_usual_case", "non_reserved_keyword_udt",
  "keyword_sp_var_not_label", "keyword_sp_head", "keyword_verb_clause",
  "keyword_set_special_case", "keyword_sysvar_type", "keyword_data_type",
  "keyword_cast_type", "keyword_sp_var_and_label",
  "reserved_keyword_udt_not_param_type", "set", "$@216", "set_param",
  "$@217", "$@218", "$@219", "set_stmt_option_list",
  "start_option_value_list_following_option_type", "$@220",
  "option_value_list", "option_value", "$@221", "option_type",
  "opt_var_type", "opt_var_ident_type", "set_stmt_option", "$@222",
  "$@223", "$@224", "option_value_following_option_type", "$@225", "$@226",
  "$@227", "option_value_no_option_type", "$@228", "$@229", "$@230",
  "$@231", "$@232", "$@233", "$@234", "$@235", "$@236", "$@237",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@238",
  "opt_lock_wait_timeout", "table_or_tables", "table_lock_list",
  "table_lock", "lock_option", "unlock", "$@239", "handler", "$@240",
  "handler_tail", "$@241", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "$@242", "handler_rkey_mode", "revoke",
  "revoke_command", "admin_option_for_role", "grant", "grant_command",
  "opt_with_admin", "opt_with_admin_option", "role_list", "current_role",
  "grant_role", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "column_list_privilege", "column_privilege",
  "object_privilege", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "user_and_role_list",
  "via_or_with", "using_or_as", "grant_user", "auth_expression",
  "auth_token", "opt_auth_str", "opt_require_clause", "resource_option",
  "resource_option_list", "opt_resource_options", "opt_grant_options",
  "opt_grant_option", "grant_option_list", "grant_option",
  "begin_stmt_mariadb", "$@243", "compound_statement", "opt_not",
  "opt_work", "opt_chain", "opt_release", "commit", "rollback",
  "savepoint", "release", "unit_type_decl", "union_option",
  "query_expression_option", "definer_opt", "no_definer", "definer",
  "view_algorithm", "opt_view_suid", "view_suid", "view_list_opt",
  "view_list", "view_select", "$@244", "view_check_option",
  "trigger_action_order", "trigger_follows_precedes_clause",
  "trigger_tail", "$@245", "$@246", "$@247", "$@248", "$@249",
  "sf_return_type", "$@250", "xa", "opt_format_xid", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@251", "opt_migrate", "install", "uninstall", "keep_gcc_happy",
  "_empty", "statement", "sp_statement", "$@252", "$@253",
  "sp_if_then_statements", "sp_case_then_statements",
  "reserved_keyword_udt", "keyword_sp_block_section", "keyword_label",
  "keyword_sp_decl", "opt_truncate_table_storage_clause",
  "ident_for_loop_index", "row_field_name", "while_body", "$@254",
  "for_loop_statements", "sp_control_label", "sp_block_label",
  "remember_end_opt", "sp_opt_default", "sp_opt_inout", "sp_pdparam",
  "sp_proc_stmts1_implicit_block", "$@255", "remember_lex",
  "keyword_directly_assignable", "ident_directly_assignable",
  "ident_cli_directly_assignable", "set_assign", "$@256", "$@257", "$@258",
  "labels_declaration_oracle", "label_declaration_oracle",
  "opt_exception_clause", "exception_handlers", "exception_handler",
  "$@259", "sp_no_param", "opt_sp_parenthesized_fdparam_list",
  "opt_sp_parenthesized_pdparam_list", "opt_sp_name",
  "opt_package_routine_end_name", "sp_tail_is", "sp_instr_addr", "sp_body",
  "$@260", "$@261", "$@262", "create_package_chistic",
  "create_package_chistics", "opt_create_package_chistics",
  "opt_create_package_chistics_init", "$@263",
  "package_implementation_executable_section",
  "package_implementation_declare_section",
  "package_implementation_declare_section_list1",
  "package_implementation_declare_section_list2", "package_routine_lex",
  "package_specification_function", "$@264",
  "package_specification_procedure", "$@265",
  "package_implementation_routine_definition",
  "package_implementation_function_body", "$@266",
  "package_implementation_procedure_body", "$@267",
  "package_implementation_item_declaration",
  "opt_package_specification_element_list",
  "package_specification_element_list", "package_specification_element",
  "sp_decl_variable_list_anchored", "sp_param_name_and_type_anchored",
  "sf_c_chistics_and_body_standalone", "$@268", "sp_tail_standalone",
  "$@269", "$@270", "drop_routine", "create_routine", "$@271", "$@272",
  "$@273", "$@274", "$@275", "$@276", "$@277", "opt_sp_decl_body_list",
  "sp_decl_body_list", "$@278", "sp_decl_non_handler_list",
  "sp_decl_handler_list", "opt_sp_decl_handler_list",
  "sp_decl_non_handler", "$@279", "sp_proc_stmt", "sp_labelable_stmt",
  "sp_proc_stmt_compound_ok", "sp_labeled_block", "$@280", "$@281",
  "$@282", "opt_not_atomic", "sp_unlabeled_block", "$@283", "$@284",
  "$@285", "sp_block_statements_and_exceptions", "$@286", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,    64,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,   446,   447,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   633,
     634,   635,   636,   637,   638,   639,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     654,   655,   656,   657,   658,   659,   660,   661,   662,   663,
     664,   665,   666,   667,   668,   669,   670,   671,   672,   673,
     674,   675,   676,   677,   678,   679,   680,   681,   682,   683,
     684,   685,   686,   687,   688,   689,   690,   691,   692,   693,
     694,   695,   696,   697,   698,   699,   700,   701,   702,   703,
     704,   705,   706,   707,   708,   709,   710,   711,   712,   713,
     714,   715,   716,   717,   718,   719,   720,   721,   722,   723,
     724,   725,   726,   727,   728,   729,   730,   731,   732,   733,
     734,   735,   736,   737,   738,   739,   740,   741,   742,   743,
     744,   745,   746,   747,   748,   749,   750,   751,   752,   753,
     754,   755,   756,   757,   758,   759,   760,   761,   762,   763,
     764,   765,   766,   767,   768,   769,   770,   771,   772,   773,
     774,   775,   776,   777,   778,   779,   780,   781,   782,   783,
     784,   785,   786,   787,   788,   789,   790,   791,   792,   793,
     794,   795,   796,   797,   798,   799,   800,   801,   802,   803,
     804,   805,   806,   807,   808,   809,   810,   811,   812,   813,
     814,   815,   816,   817,   818,   819,   820,   821,   822,   823,
     824,   825,   826,   827,   828,   829,   830,   831,   832,   833,
     834,   835,   836,   837,   838,   839,   840,   841,   842,   843,
     844,   845,   846,   847,   848,   849,   850,   851,   852,   853,
     854,   855,   856,   857,   858,   859,   860,   861,   862,   863,
     864,   865,   866,   867,   868,   869,   870,   871,   872,   873,
     874,   875,   876,   877,   878,   879,   880,   881,   882,   883,
     884,   885,   886,   887,   888,   889,   890,   891,   892,   893,
     894,   895,   896,   897,   898,   899,   900,   901,   902,   903,
     904,   905,   906,   907,   908,   909,   910,   911,   912,   913,
     914,   915,   916,   917,   918,   919,   920,   921,   922,   923,
     924,   925,   926,   927,   928,   929,   930,   931,   932,   933,
     934,   935,   936,   937,   938,   939,   940,   941,   942,   943,
     944,   945,   946,   947,   948,   949,   950,   951,   952,   953,
     954,   955,   956,   957,   958,   959,   960,   961,   962,   963,
     964,   965,   966,   967,   968,   969,   970,   971,   972,   973,
     974,   975,   976,   977,   978,   979,   980,   981,   982,   983,
     984,   985,   986,   987,   988,   989,   990,   991,   992,   993,
     994,   995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,
    1004,  1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,
    1014,  1015,  1016,  1017,  1018,  1019,    61,    62,    60,   124,
      38,    45,    43,    42,    47,    37,    94,   126,  1020,  1021,
    1022,  1023,    40,    41,  1024,    44,    33,   123,   125,    59,
      46
};
# endif

#define YYPACT_NINF -5642

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-5642)))

#define YYTABLE_NINF -3893

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   38261, -5642, -5642, 93531, -5642, -5642,  4131,  1298, 93531, -5642,
     931, -5642,  1043, -5642, -5642, -5642, -5642,  2983, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,   236,   185, -5642, -5642,   269,
   -5642, -5642, -5642, -5642,   349, 79376,   -54,   645, -5642, -5642,
   83101, -5642, -5642, -5642, -5642, 83101, -5642, -5642, 93531, -5642,
   -5642,  1268, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     636, -5642,  1372,   603, -5642, -5642, -5642, -5642, -5642, -5642,
    1897, -5642, -5642, -5642, -5642, -5642,   185, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  1455, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1542, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, 94276, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     293, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2137,
   -5642, -5642, -5642, -5642, -5642,   314, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1598,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, 93531, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,   269, -5642, -5642,
   -5642,   908, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,  1455, -5642, -5642, -5642, -5642, -5642, -5642, -5642, 93531,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,   501, -5642, -5642,   305, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1705, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642,  1631, -5642, -5642,   546,  2181,  2214, -5642, -5642,
    1632, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,  3881, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,   486, -5642, -5642, -5642, -5642,  3168,  1905,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   46482, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     546, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642,   334, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642,  1595, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, 95021, 93531,  1561,  1653, 93531,  2336,  2375,
   80121, 93531,  2375, -5642,    94, -5642, -5642,  2118, -5642,  1776,
   -5642,   185,   480, -5642,  1774,  2263,  2595,   584,  2390,  2446,
   93531, 80866,  1365,  2375, -5642,  2314,  2375,  2375,  2375,  2375,
    2503,  2375,  2375, 93531, -5642,  2375,  2375,  1147,102471, 68946,
   -5642, -5642,  1015,  2496, -5642, -5642, -5642, -5642, -5642, -5642,
   13288,   185, 22138,  2593, -5642, -5642,  2151,  4490,  1936, -5642,
    2428, -5642, -5642, 93531, -5642,  2375, 13288, -5642, -5642,  2428,
   69691,  1468, 50217, 10947,  2428,   185,  2512, -5642,  1921, -5642,
   -5642, -5642, -5642, -5642, 93531, -5642,  1455, -5642, -5642,  2376,
   -5642, -5642, 80121, -5642, -5642, -5642, -5642, -5642,  2687, 22138,
     231,  2457, -5642, -5642,  2349, 47227, 80121,  2632,  2595,  2648,
   -5642,  1604,   462, -5642,  2041,  2157,  2595,   341,  2179,  2595,
    2577,  2375,  2375, -5642, -5642,  2709,  2709,  2709,  2371,  2709,
   -5642,  2709,  2749,  2072,   554, -5642, -5642,  2090, 93531,  2632,
   -5642,  2632, -5642,  2738,  2632,  2632,  2257,  2773,  2780,   176,
    1839,   244,   244,  2118, 42012,  1178,  2613, -5642,  2749,  1759,
     416,   539,   539,   539,  1759,   546,  1759, -5642,   466,  1776,
    1492, 93531, -5642, -5642, -5642,  2169, -5642, -5642, -5642, 93531,
   93531,   234, -5642,  2203, -5642,  1400, 72671, -5642, 93531,  2844,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1516, -5642,
   -5642,  2668,  1166,  2316,  2541,  2236, -5642,  2722, 80121, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2211, 93531, -5642,
   -5642, 22138,  2881,  2263, -5642,  2715, -5642, -5642, -5642, -5642,
   47227, -5642, 93531, -5642,  2961, -5642, -5642,102471, -5642, -5642,
   -5642,  1364, 65221, -5642,  2218,  2538, -5642,  2229,  1444,  1462,
   -5642, -5642,  1495,  1528,  1622, -5642, -5642, -5642,  1623, -5642,
   -5642, -5642,101726,  1425,  2231, -5642, -5642,  2900, -5642, -5642,
   83846,   616, 93531,  2892,  2375, 93531, 93531, 93531, 93531, 93531,
   93531, -5642, 80121,  2353, -5642, -5642,  2375,  2375, -5642, -5642,
    2899, -5642,  2445,  2415,  1672,  2286,  2582, -5642,  2486, -5642,
    2295,  2373,  2509,  2303,  2328,  2382,   465, -5642,  2332, -5642,
     127,  2793,   159,   440,  2798,   451,   493,  2946,  2827,   506,
     104,   511,  2597,   514, -5642, -5642, -5642,  2875,  2974,  2386,
   -5642,  2399, -5642,  2904,  2763,  1315, -5642, -5642,  1284,  2845,
    1442, 47227,104514,103216, 81611,104514,104514,104514, -5642, -5642,
     284, 93531,103865, 93531, 12666, -5642, -5642, 39777, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, 93531, -5642, -5642,
   -5642, -5642, -5642, -5642,  1969,   389, 13383, -5642,  2421, -5642,
   -5642, -5642, -5642, -5642, 84591, -5642,   237,   247,  2741, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   28322,  2422,  2439,  2448, 18273,  2451,  2454,  2458,  2468,  2469,
    2286,  2286,  2286,  2472,  2488,  2501,  2510,  2520,  2523,  2524,
    2534, -5642,  2555,  2556,  2570,  2578,  2598,  2616, 22911,  2618,
    2619,  2623, 36001,  2625,  2626,  2628,  2629, 22138,  2472,  2635,
    2638, -5642,  2647,  2649,  2650,  2654,  2657,  2660,  2662,  2669,
    2673,  3211,  2674,  2676,  2677,  2678,  2681,  2684, -5642,  2286,
    2472,  2472,  2685,  2688,  2286,  2690,  2691,  2698,  2700,  2702,
    2703,  2706,  2716,  2718,  2719,  2720,  2721,  2723,  2729,   251,
    2730,  2731,  2734,  2735,  2745,  2746,  2747,  2751,  2752,  2755,
    2757,  2518,  2761,  2762,  2764,  2765,  2531,  2770,  2774,  2775,
    2776,  2777,  2779,  2781,   298,  2782,  2783,   324,  2794,  2795,
    2797,  2800,  2801,  2802,  2803,  2806, 29095, 29868, 28322, 15954,
   -5642, 93531, 95766, -5642, -5642,  9113,  1722,  2042, 28322, -5642,
   -5642, -5642,  3203, -5642,  3272, -5642, -5642, -5642, -5642,  3133,
    3147, -5642,  3156, -5642, -5642,  3163,  2631, -5642,  3400, -5642,
   -5642, -5642, -5642, -5642,  2733,  2813,  3496,  3517, -5642, -5642,
    1352, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  2724,  2789, -5642,  3400, -5642, -5642, 75651,
   -5642, 12062, -5642,  1388, -5642,  2445,  3010,  3397, -5642,  3470,
   -5642,  3399, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  1468, -5642, -5642, 51727,  3344,  1287,
   -5642, -5642,   248, -5642,   369,   402, 63731, -5642,   420, 64476,
     404, 85336,   267, -5642, 73416, -5642,   422, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2820, -5642,  2939,
    2836,  2636,  1841, -5642, -5642,   245,   965,  2923,   151, -5642,
     938, -5642,  1841, -5642, 76396,  1210,  2111, -5642,   966, -5642,
    3499, -5642, -5642,  2931,  2916,  2948, -5642,  1910, -5642,  2595,
   -5642,   297, -5642,  1210,  1841,  2111, -5642,  3115,  3197,  1341,
    3504, -5642,  1726, -5642, -5642, -5642,  3489, -5642,  2848, -5642,
    3459, -5642, 93531, 47227, -5642, -5642, -5642, -5642,  2852, 47227,
   47227,  1097,   216,  9113,  2853, 22138, -5642, -5642, 10917, 53992,
    3055,  1798,   -63, -5642, -5642,  1372, 93531, -5642, -5642,   610,
   -5642,  3280, -5642,  2857, -5642, 96511,   216,  3518, -5642, -5642,
   -5642,  1000,  3250, -5642,  2860, -5642, -5642, -5642, -5642, 47227,
   93531,  2595, -5642, -5642, -5642, -5642,  2861, -5642, -5642,  3067,
    2950, -5642,  2883, -5642, -5642,   628, -5642, -5642,  3647, -5642,
   93531, -5642,  2632, -5642, -5642,  2632, -5642, -5642, -5642,  2632,
    2632,  2338,  2632, -5642, -5642,  2910, -5642,  3192,  3193,  2722,
   -5642,  2878, 41267, 93531,  3654, -5642,  3304, -5642, -5642, -5642,
    2879, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3449,
    3638,  3638, -5642, 52482, -5642, -5642,  3536,  2613,   107,  3374,
   55503,  3524,  3611, 57771, -5642,  1210, -5642, -5642, -5642, -5642,
    2258, 93531, -5642,  2258,  2258, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,   546, -5642, -5642,
     480, 74161, 93531,  1759,   416, 17500,  3636,  3637, -5642, -5642,
   -5642,  2595,   387,  3273, -5642, -5642, -5642, -5642,  2286,  3678,
   -5642, -5642, -5642, -5642, -5642,  3640, -5642, -5642, 47227,  3101,
    3281,  3281,  3281,  3648, -5642, -5642, -5642, 72671,  2375, -5642,
   -5642, -5642,  1166, -5642,  2007, 93531, 47227,  2945, -5642, 47227,
   22138, -5642, -5642, -5642,  3383,  9113, -5642,  3268, -5642, -5642,
   47227,  1273, -5642, -5642, -5642,  3640,  3281, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    2920, -5642, -5642, -5642,  2920,    37, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2921, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    3482, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,  2921, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     260, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3316,  1560,
    1613, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3316, -5642,
    1613, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,  2921, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2925,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,  3316, -5642,  1613, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2920, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2920,
   -5642, -5642,  1613,  2920, -5642,  2927,  2921,  3316,  1322,  2299,
    2921, -5642, -5642,  2920,  2928,  2920,  2920,  2920,  2920, -5642,
    2920,  3697,  2930, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     101,  2920,  2920,  2920,  2920,  2937,   259,  2921,   272,   273,
     303,   308,   311,   312, -5642,  2921, -5642, -5642,  3587, 93531,
    3597, -5642,  3370,  1425,  2935,  2936, -5642, 47227,  3674, 47227,
    3602,  2613, -5642,  2947, -5642,  2941, -5642, -5642,  3616, 93531,
   93531, -5642, -5642, -5642, -5642,  2949,  2353, 77141, -5642,  1345,
    3306, 75651, 47227, -5642, -5642,  3560,  3096, -5642, -5642, -5642,
   -5642, -5642, -5642,  3037, -5642, -5642,  2963, -5642, -5642, -5642,
   -5642,  3416, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   75651, -5642, -5642,  3420,  3422, -5642, 72671,  1614, 12323, 95766,
   -5642,  3617, -5642, -5642, -5642,  3489, -5642, -5642, 23684, -5642,
   24457, -5642, -5642, -5642,  3251,   499,   -43, -5642, -5642, -5642,
   -5642, -5642, -5642,  3715, -5642, -5642, -5642, -5642, -5642, -5642,
    3450, 93531,  3201,  3643,  3621, -5642, -5642, -5642, -5642, -5642,
    3463,  2995,  3603,  2989, -5642, -5642,   351, -5642,  2996, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, 47227,
   53237, -5642, -5642, -5642,  2994, -5642, -5642, -5642,  3007, 28322,
   28322, -5642,  3745,  3745,  3745, 22138,  2489,  1627,  3363, 22138,
   22138, 22138,   549,  3011, -5642, -5642, -5642,   345, -5642,  3024,
   22138, 22138, 36752,  3031,   568, 11142, 22138,  3688,  3688, -5642,
   22138, 22138, 15954, 10697, 22138, 22138, 22138, 95766, 36752,  3479,
    3032, -5642,  3026,  2283, 22138,  2411, 22138,   507, -5642, 22138,
   22138, 22138, 22138,  3035, 30641,  3036, 22138, 22138, 22138,  3039,
    3175,  3745,  3745, 22138,  2412,   399, 16727, -5642, -5642, -5642,
    3745,  3745, -5642, 22138, 22138, 22138,  2430, 22138, 22138, 22138,
   22138, 22138, 22138, 22138, 22138, 22138, 22138, -5642, 22138, 22138,
   22138, 22138, 22138,  1584, 22138, 22138, 47227, 22138, 22138, 22138,
    3700, 47227, 22138, 22138, 22138,  3701, 22138, 22138, 22138,  3045,
   22138, 47227, 22138, -5642, 22138,  1717,  1717, -5642, 22138, 16727,
   22138,  3046, 37503, 22138, 22138, 22138, 22138, 22911, -5642, 22911,
   -5642, -5642,  3047,  2038,  3290,   546, 22138,  3041, -5642, 30641,
   -5642, -5642, -5642, -5642, -5642,   579, -5642, 22138, -5642, -5642,
   -5642, 22138, 22138, 25230, 30641,  3050, 30641, 30641,  3670,  1916,
   30641, 30641, 30641, 30641, 30641, 30641, 30641, 31414, 32187, 30641,
   30641, 30641, 30641, -5642, 80121, 28322, 49462,  3056,  3702, -5642,
   95766, -5642,  1786,  1095, -5642,  2595,  4490, 33730, -5642,  3054,
   -5642,  3552, 47227, -5642,  3689, -5642,  3061,  3717, 75651, 72671,
    1614,  3068, -5642,    66,   213, -5642, 77141, 93531, -5642, -5642,
   -5642,  3775, 22138, -5642, -5642, -5642, -5642, -5642,  3059,   447,
    3063, -5642,  1126, -5642, -5642, -5642, -5642, -5642, 93531, -5642,
   86081, 50972,  3160,  3078,  2632, 86826, 93531, 47227, 93531, 97256,
   93531, 93531, 47227, 75651, 47227, -5642, -5642, -5642,  1009,  1841,
   93531,  1841,  2111,  1023,  1841,  3704, -5642, -5642,  1662,  1662,
   -5642, -5642, -5642, -5642, -5642, -5642,  1841, 93531, 93531,  1841,
   72671, -5642,  2111,  1511, -5642,  3360,  3152, -5642, -5642, -5642,
    3405, -5642, -5642,  3734,  3076, -5642,  3425, -5642, -5642,  3173,
   -5642, -5642, 47227, -5642, -5642,  2111, -5642,  2111,  2111, 22138,
    1841,  1841,  1841, -5642, 42757,  3081,  3085, -5642,  3083, -5642,
    3088, -5642, -5642, -5642,  3445,  3869,  3725,  3091, -5642, -5642,
    3661,    57, -5642,  3515, -5642,  3641, -5642, 22138,  9113, 19046,
    3368, -5642, -5642,  3369,  3371,  3372, -5642, -5642, -5642, -5642,
    3525,  3376, -5642,  2595,  3377, -5642, -5642, -5642,  3105, -5642,
   -5642, -5642, 80121, 33730, -5642,  3106, -5642,  3120, -5642,   239,
   -5642, -5642,  3777,  3220, 22138, -5642, -5642, 47227,  3612, -5642,
    2595,  1604, 93531, -5642, -5642,  3856, -5642,   -27, -5642, -5642,
   -5642,  3230,   341, -5642, -5642,  1426, -5642, -5642,  2709,  3322,
   -5642, -5642, -5642, 80121, -5642, -5642, -5642, -5642, -5642, -5642,
   93531, -5642, 77141, 72671, 80121,  2632,  2632, -5642, 47227,  2632,
   93531, -5642, -5642, -5642,  2632,  2632,  2632,  3176, -5642,   518,
    3140,  3141,  3142,  3143,  1274,  3145, 43502,  2340,  6912,  3779,
    3780, -5642,  3723,  2150,  3723, -5642, -5642, 43502, 42757,  3157,
    3654, -5642, -5642, -5642, -5642, 80121,  3149, -5642, -5642,  3148,
   -5642, 22138,  3876,  3807,  3536, -5642, -5642, 56259,  1538, 84591,
   -5642, -5642, -5642,  3507,  3694,  1258, -5642,  3159,  3284, -5642,
    1053, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, 28322,  2520, -5642,  9113,
   -5642, -5642, -5642, -5642, -5642,   213,   226, -5642, -5642, -5642,
    1525,  3531,  2358, -5642, 80121,  2358,  1409,   970, -5642,  3170,
    2595,  2000, -5642,  2000, -5642,  3471, -5642,  3472,   445, -5642,
   47227, -5642, -5642, -5642, -5642, -5642, 47227,  3171, -5642,  3358,
    3174,  3177,  9113,  3677, -5642,  3383, -5642, -5642, -5642, 13288,
    3891, 10688,   166,  3226, -5642, -5642, -5642, -5642, -5642, 47227,
   -5642, -5642,  1840,  2969,  3666,  3194,  2760, -5642, -5642,  3316,
     213,  3316, -5642, -5642,  3092,  1089, -5642, -5642, -5642,  1089,
   -5642,   249,  3344, 77886,  3316, -5642, -5642, -5642, -5642,  3667,
    1613,   522, 78631,   544, -5642,  3588, -5642, -5642, -5642,  1089,
    2709, -5642, -5642,  3316, -5642, -5642, -5642,  2709,  1089, -5642,
    3669, -5642, -5642, -5642,  1089,  3316,102471,   538,  1613, -5642,
   -5642,  1613,  1089,   189, 93531,   538, -5642,   522,  3926,  1613,
    3316,  1089,  3954, -5642,  1089,  3749,  3749,  3749, -5642, -5642,
     263, -5642, -5642,  1425, -5642, -5642, -5642,  3449,  3288, -5642,
    3212, -5642, -5642,    95,  3778, -5642, -5642,  3793, 93531,  3873,
   58516, -5642, -5642,  3800, -5642, 93531,  1345,  3218, -5642, -5642,
   -5642, -5642, -5642,   213, -5642,  3219,   365, 47227, 47227, 13288,
   -5642, -5642,  3223, -5642, -5642, -5642,  3718, -5642, -5642,   134,
    3946, -5642, -5642, -5642, 44247, 44247,   127,  2793, -5642, -5642,
    2798, -5642, -5642,  2827, -5642,   104, -5642,  2597, -5642, -5642,
   -5642, -5642,  2020, -5642, -5642, -5642,  3689, 22138, 48717,  9113,
   -5642, -5642, 47227, -5642,  3865, -5642, -5642,100236,   491, -5642,
   -5642,   335, 47227, -5642, -5642, -5642, -5642,  3858,  3361, 93531,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, 93531,  2211, 93531,
  102471, 13288, 13288, -5642, 80866, -5642,  1235,    66, -5642,  3973,
   95766, 22138, -5642,  3232, -5642,  3234,  3235,  9761,  3590, 22138,
   22138, -5642,  2932,    85,  3443, -5642,  3237,  3249, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642,  3240, -5642, -5642, -5642,
    4637,  4669,  3241, -5642, -5642, -5642,  3243,   546, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3901, -5642,
    4272, -5642, -5642, -5642, 22138,  4676,  4773,  4921,  3257,  3455,
    3872,  4969,  2994,  2025,  3255, 36752, 95766,  3745,  3248,  4311,
    3745,  3256,  5258,  5521,  5102,  7480,  7906, -5642,   513, -5642,
    5548,  5643,  5876, -5642, -5642,  3258,  3261,  3126,  3745,  3262,
   -5642,  3263, 19819, 20592, 21365,  9797,  3265,  3266,  3269,  5931,
    6156,  7913,  3745,  3270,  7952,  2051,  7975,  6209,  8087,  6235,
   -5642,  2069,  6339,  6413,  3271,  2853,  6444,  8219,  8361,  7040,
    7111,  7237, -5642, -5642, -5642, -5642,  3277,  8373,  8407,  3278,
    3282,  8427,  8445,  8469, 47227,  3283,  8491,  3285,  8509, 47227,
    8539,  8567,  7272, -5642,  8621,  3279,  7312,  3895,  3286,  3287,
    8716,  3291,  7344, -5642, 95766, 93531,  3293,  3292,  3998,  3228,
    3294,  8735, 10697, 10697, -5642, 22138,  3297,  2288, 95766,  1787,
   -5642, -5642, -5642, -5642,   496,   719,   526,   507, -5642,  3299,
    1787,  3302,  2026, 15954, -5642,  1290,  4001, 30641, 30641,  3303,
   30641, 30641,  1215,   980,   980,  3275,  3275,  1263,  1329, 22911,
    1215, 22911,  1215,  3275,  3275,  3275, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  3839,  3307,  1521,  3308, -5642, -5642,
   -5642, -5642, -5642, -5642,    70,  3690, -5642,  3476,  1196, 22138,
   -5642,  3326,  4040,  4056,  4064, -5642, -5642, -5642, -5642, 75651,
   75651,  3310, -5642,  1426,  3671, -5642, -5642,  3966, 77141,  3971,
   -5642,  3314, 44247, 44247, -5642,  3318, -5642, 22138,  3311,  3315,
    3327, 98001, -5642,  3978,   213, 77886, -5642,  9113, 75651,   715,
   17500, 93531, 93531, -5642, 85336,  3980,  1420,  3606, -5642,  3331,
    3333, -5642,   213, 17500,  3329,  1200,   450, -5642,  3335,  3336,
   -5642, -5642, -5642, -5642,  3339, 93531, 93531, -5642, -5642, -5642,
   -5642, 93531, -5642, -5642, -5642, -5642, -5642, -5642,  2595, 22138,
   93531,  1841, -5642, -5642, -5642,  1841, 93531,  1841, -5642,  2595,
    3996, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,  1841, -5642, -5642, -5642, -5642, -5642,  3510,  1210,  1910,
    3704, -5642,  2111, 47227,  1841,  1841,  9113, -5642, -5642, -5642,
   -5642,  3868,  3449, 19046,  3345,  3342, -5642, -5642, 13288, 93531,
   95766,  4078, 11198, -5642, 80121, 87571, 47227, -5642, -5642, -5642,
    2409, -5642, -5642, -5642, -5642, -5642,  9113,  2457,  2520, -5642,
    3346,  9113, -5642,  4034, -5642, -5642, -5642, -5642,  2595, -5642,
   -5642, 10990, -5642, 47227, -5642, -5642, 54747, 54747,  1862, -5642,
   98746, -5642,  2595,  9113, 47227,   899,   335, -5642,  4088, -5642,
   -5642,  3467, -5642, -5642, -5642,  3350, -5642,  3404, -5642, -5642,
   -5642,  3359, -5642,  4019, -5642,   241,   105, 93531,   512,   445,
   -5642, 93531, 93531, 47227, -5642, 93531, -5642, 93531,  2632, -5642,
   -5642,  2632, 47227, 93531, 93531,  2632, 22138, 43502, -5642, -5642,
   -5642, -5642, -5642, 43502, -5642,   664, -5642,  3568,  2033,  2033,
   -5642, -5642, -5642, -5642, -5642,  3990,  3723,  3723, 43502,  3991,
    3596, -5642, 93531,  6388,   425, -5642, 52482, 93531,  9113, 22138,
   -5642,  3396,  3807, -5642,   157,  1223,  1053, -5642,  3642,   335,
   -5642, -5642, 57771,  3709, 57771, 57771, 95766,  3604, 22138, -5642,
    4030,  3373, 17500, 17500,   241,  2595, -5642,   213,   213,  3599,
    3890,  3893,  3505,  2595,  3897,  3898,  3900, -5642, -5642, -5642,
   -5642, -5642,  2595,  2595, -5642, -5642,   213, -5642,  2392, -5642,
   -5642, -5642, -5642,  2113,   875, -5642,   213,   213, -5642,  1989,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1537, -5642,   238,
    1162, 72671,  3853,  1426,  3968,  3390, -5642, 47227,  4047, -5642,
   -5642, 22138, -5642, -5642, -5642, 12199, -5642,  3409,  3411,  3412,
    3413,  3414,  3417,  3418,  3419,  3421,  3426,  3427,  3429,  3430,
    3431,  3433,  3434,  3435,  3436,  3437,  3438,  3441,  3442,  3447,
    3451,  3401, -5642, -5642,  3454, -5642, -5642, -5642, -5642,   213,
     213,   213,   213, -5642,  2424, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  3705,  2551, 93531,  4027,  3432,  3444,  3446,
    3453, -5642, -5642, 93531, -5642,  2079,  3905,  3923, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,   213, -5642, -5642,  2092, -5642, -5642,
    2102, -5642, -5642, -5642, -5642, -5642,  2112, 68201, -5642, 22138,
   22138, -5642, -5642, -5642, -5642, -5642,   538,   538,  3398, -5642,
   -5642, -5642, -5642,  3926, -5642,  3440, -5642,  3460, -5642, -5642,
   -5642, 62986, -5642, -5642, -5642, -5642,  3320, -5642,  3803, -5642,
    2033, 93531,  3940, 58516, -5642,  3675,  4077, -5642, -5642, 42757,
   -5642,  3462, 47227, -5642, -5642, 77141, 80121, 75651, -5642, -5642,
   -5642,  3473,  1235, 12770, -5642, -5642,  4222, 72671,  3925, -5642,
   -5642,  3474, -5642,  3475,  3974,  3975, -5642, 95766, -5642, -5642,
   -5642,  9113, -5642, -5642,  3481, -5642, -5642,  3661,  3638, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  3503,  3759,  3879, -5642, -5642, -5642,
   -5642, -5642, -5642,  4118, -5642, -5642, -5642,  2123,  3636, -5642,
   -5642, -5642,104514,104514,104514, -5642,  3843, -5642,100981, 22138,
   -5642,  7381, -5642, 22138, -5642, -5642, 22138, -5642,  9113,  9975,
  105249, 78631, -5642, 78631,105249, 22138, -5642,  3490, -5642,  4123,
    4125, -5642, -5642, -5642, 22138, -5642, 22138, 22138,  7436, 22138,
   22138, 22138, 22138, -5642, 22138, -5642, 22138, 22138, -5642, 30641,
   -5642,  3488,  3498, -5642, -5642,  3500, -5642, 22138, 22138, -5642,
   -5642, -5642, 22138, 22138, 22138, 22138, -5642, -5642, 22138, 22138,
    3501, -5642, -5642, 22138, 10026, 22138, 10102, 22138, 10123, 22138,
   -5642, -5642, -5642, 26003, 22138, -5642,  3502, -5642, -5642, -5642,
   -5642, 22138, -5642, 22138, -5642, 22138, 22138, 22138, -5642, 22138,
   -5642, -5642, 22138, 22138, 22138, 22138, -5642,  4067, 22138, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, 22138, -5642,   372, 26776, -5642, 22138, 22138, 22138, -5642,
   -5642, 22138,  3497,  3509, -5642, 93531, -5642, 22138,  2176,  3042,
     335,  3511, -5642, -5642,  3514,  3516,  2853, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,   568, 30641,  4075, 30641,  4001,  2294,
   15954, -5642,  1307,  4001, 10697, 10697, 93531,  4226,  3512, -5642,
   22138, 95766, 22138,  3519,  3508, -5642,  3529, 30641, -5642, -5642,
    3535, -5642,  2419,  3042,  3593,  3959, -5642,  9113, 33730,  4012,
   -5642, 47227,  4013,  4082, -5642, 47227,  3737, -5642, 75651, 72671,
    4197,  4198, -5642,  9113, -5642,  3537, -5642, -5642, -5642,  3539,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,   452, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, 22138, 75651, -5642,
   -5642,   213, -5642,  3544,  3548, -5642, -5642,   213,   213, 17500,
   -5642, 39019, -5642, -5642,   221,  3837,  4103, -5642, -5642, 93531,
    1126, 93531, -5642, 50972, 50972, 88316,  1012, -5642, -5642, -5642,
   -5642,  9113, -5642, -5642, -5642, -5642, -5642, -5642,  3566, -5642,
   -5642, -5642,  4313, -5642, -5642,  3996,  2613,  2111, -5642, -5642,
   37503,   548, -5642, -5642, -5642, 19046, 12984, -5642,  3557,  3559,
    3570,  3569,  4032, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  3575, -5642, -5642, 19046,  3595, -5642, -5642,
   -5642,  3473,   407,  3598,  3574, -5642, -5642, -5642, -5642, -5642,
   -5642,   220,   223,  1359,  2613, -5642, -5642,   438, -5642, -5642,
   -5642, -5642, -5642,  1277, -5642, -5642, -5642, -5642,   -27,  2244,
   -5642,   294,   335,  3816, -5642, -5642,   300,  1081,  1081,  4161,
     105,  4033, -5642,  3853,  4242,  4167,  4168, -5642,  2113, -5642,
    1967,  1139, -5642, -5642, -5642, 93531, -5642, -5642,   -91, -5642,
   47227,  7683,  3304,  3304, -5642,  2033,   326, -5642, 30641,  4322,
   -5642,  4086, 43502,  4221,  4223, -5642, 43502, -5642, -5642,  2130,
   -5642, -5642, 74906, -5642, -5642, -5642,  9113,   342,  2028, 22138,
   93531, -5642,  3396,  3665, -5642, -5642,  1223, -5642, -5642, -5642,
   -5642, 57771, -5642, -5642, -5642,  1538,  3600,  2028,   107,  3601,
   -5642, -5642, -5642, -5642, 77886, 74906, -5642,  3976,  3979,  2013,
   -5642, -5642, -5642, -5642, -5642, -5642,  2929,   970, -5642,   213,
     213, -5642,   350,   213, -5642, -5642,   285, -5642, -5642,   481,
     203,  2113, -5642,  2595,  2595,  2595,  2595,   335,  2595,  2595,
    2160, -5642,  2929,  2929,  2000, -5642,  1173, -5642, -5642, -5642,
   -5642,   386, -5642, -5642, 80121, -5642,  4351,  4352, -5642,  4359,
   -5642, -5642,   840, -5642,  2135,   282, -5642,   110, -5642,  4151,
   93531,  4341,  3390, -5642,  1313,  9113, -5642,  4110,  3613,  3614,
     335,  3615,   335,   335,  2595,  2595,  3566,  2595,   335,  2595,
    2595,  2595,  2595,  2595,  2595,  2595,   335,  2595,  1247,  3395,
    2595,   335, 10688, -5642,  2595,  3042,  2929,  2929,  2969, -5642,
    4263,   213, -5642,  2337, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  2161, 65966, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  4371, -5642, -5642, -5642,   522,  2709,
     522, -5642,102471, -5642, -5642,  2921, -5642, -5642, -5642, -5642,
   -5642, -5642,  9113,  9113, -5642, -5642, 93531, -5642,  4372, -5642,
   -5642, -5642,  9879, -5642, -5642, -5642,  3939, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642,  3618, 42757,   517, -5642,
   57015,  4158,  2613,  3631, -5642,  1426, -5642, -5642, -5642, -5642,
     473,  4229, -5642,  3624, 22138, -5642,   528,  3823,  3639, 59261,
   72671, 72671, -5642,  2588, -5642, 47227, -5642,  4268, -5642, -5642,
   -5642, -5642, -5642, 22138, -5642, -5642,  2211,  3560, -5642, -5642,
   -5642, -5642, -5642,  4062,104514,  3629,  9113, 22138,  9113,  9113,
   22138,  2920,  2920,  2921,  2937, -5642,  4326, -5642,  4267,  2920,
    2920, -5642,  2920,  4269,  2920,  2920,  3645, -5642, -5642, -5642,
   -5642, -5642,  3646,  3650,  3651,  2853, -5642, 22138, 22138,  8745,
     168,   168, 22138,  7703,  7730,  4199, -5642,  8766,  8784,  8809,
    1592, -5642, -5642,  8829,  8925,  8963,  9011,  7754,  9023,  1574,
    4211, -5642,  9113, 22138,  9113, 22138,  9113, 22138,  9113, 22911,
    9059,  9123, -5642,  2186, 10153, -5642,  2195, 10228,  4301,  9147,
    7799,  2200,  4457,  9168,  9191,  2253, -5642,  2903,  4393,  2261,
   22911,  9213,  9261,  7827,  7859,  9317, 95766, 93531,  3635,  9324,
    3644,  3644,   500, -5642,  3652, -5642, -5642, -5642,  3653, -5642,
   22138, 22138,  3656,  1787, -5642, 22138,  4001, 30641,  4538, 30641,
   -5642, -5642,  3839, -5642, 22138, -5642,  4225,  3657, -5642,  9113,
   -5642, -5642, 93531,  3658,  2042, -5642, 22138,  3566, -5642, -5642,
    4378,  3662,  3679,  3664,  3535, -5642, 75651, -5642, 47227, -5642,
     266, -5642,  3449,  4308,  3219, -5642, 72671, 72671, -5642, 82356,
   -5642, 60006, 93531, 93531, -5642,  9113, -5642, 17500,   715,  4406,
    4413, -5642, -5642, -5642, -5642,    63,  4218, -5642, -5642, -5642,
   -5642, 17500,   213, -5642,   213, 17500,  3336, -5642, -5642, -5642,
   -5642,  3495, -5642,  1210, -5642, -5642, -5642,  1841,  3668, -5642,
     213,   435, -5642, 19046,  3672,  3673, -5642,  4275, -5642,   568,
   -5642,  4139, -5642, -5642,  3680, 89061, -5642,  3681, -5642,  4228,
   -5642, -5642,  4432, 54747, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,  1210,  3902, -5642, -5642, -5642,
    3695, -5642,  3682,  3768,  3773, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, 47227,  4270, 72671,   282,  4066, 47227,
   47227, 10750,  7022,  2113,  1967, -5642, -5642, -5642,  2595, -5642,
   -5642, -5642,  1139, -5642,  3692, 93531, -5642,  3390,  3693,   530,
    3693, -5642, -5642, -5642, -5642,  2042,  2033,  2033,  2727,  4170,
   43502, 43502,  2831,  4175, 22138,  3698, -5642, 93531, -5642,  1232,
   -5642,  4104, -5642, -5642, 22138, -5642, -5642, -5642, -5642,  9113,
    4430,  3699, -5642, -5642, -5642, -5642, -5642, -5642, 22138, -5642,
   56259, 22138,  3703,  3711, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     372,   372, -5642, -5642,   372,   372, -5642, -5642, -5642, -5642,
     372,   372, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642,   875, -5642, -5642, -5642,  1537, -5642, -5642,  4453,
    1479, -5642,  4278, -5642, -5642, -5642, -5642,   994,   335,   335,
     335,  3395,  1958, -5642,  2135,  1225,  4039, -5642,  6913,  1372,
    1870,  4200,  2080, -5642,  2267, -5642,  4438, -5642,   207, -5642,
   -5642,   205,   338, -5642,   375, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, 93531,  2929,  2551, -5642, -5642, 93531,  2928,
     327, -5642, -5642,  3716, -5642, -5642, -5642, -5642, -5642, -5642,
   62986, -5642, -5642, 58516,  2613, -5642, 93531,  4053,  4247, -5642,
   -5642, -5642, -5642, -5642, -5642,   568, -5642,  9113, -5642,  4370,
   -5642, -5642, -5642, -5642,   445,   445, -5642, -5642, -5642, -5642,
     266, -5642, -5642,  4268,  3999, -5642,   426,  9113, -5642, -5642,
   -5642, -5642, -5642, 93531,  4199,  9113, -5642, -5642, -5642, -5642,
    2920, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642,  3719, 10697, 10697, -5642,  4440,  4249,  4340,  9361,
   22138, 22138, -5642, 22138, -5642, -5642, -5642,   346,  3726,  4194,
   -5642, -5642, -5642, -5642, 22138, -5642, 22138, -5642, -5642, 22138,
    9113,  9113,  9113, 10697, -5642, -5642, -5642,  2307, -5642, -5642,
  105249, -5642, 22138, -5642, 22138, -5642, 22138, -5642, 22138, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642,   339, 10697, -5642, -5642,
   22138, 22138, -5642, -5642, -5642, 93531, -5642,  3042,  3728,  4006,
   -5642, -5642, -5642,  3042,  3870, -5642, -5642,  3042,   335, -5642,
   -5642, -5642,  2277,  1787, -5642, 22138,  4001,  4309,  3732,  4449,
    3738, -5642, 82356, -5642,  3739,  3735, -5642, -5642, -5642, 10697,
   -5642,  4355,  4310, -5642,  3042, 93531, -5642, -5642, -5642, 37503,
    4208, -5642, -5642, -5642,  4158,   228, -5642, -5642, 72671,  3314,
    3314, 89806, -5642, -5642, -5642, -5642,  1788,   213,   213, 17500,
   -5642, -5642,  3742,  3747, 17500, 17500, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1210,
   -5642, 37503,  2613, 19046, -5642, -5642, -5642, 19046, -5642,  3748,
   -5642,  4139, -5642, 90551, -5642,  3750, -5642,  3751, -5642,  1873,
    4083,  4362, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3753, -5642, -5642,
    2595,  1917, -5642, -5642, -5642, 47227, -5642, -5642,  3785, -5642,
   -5642, 40522,  4381,  3805,  4130, 47227,   213,   213,   213,   213,
     213,   213,   213,   213,   213,   213,  4132,   213,   213,   213,
     213,   213,   213,   213,   213,   213,   213,  1698, 93531,   213,
     213, -5642, -5642,  4337, -5642,  7434, -5642, -5642, -5642, -5642,
     213, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,   456,  4353,  4504,  3776, -5642, -5642,  4316, -5642, -5642,
   -5642, -5642,  3880,  4317,  3390,  2697, -5642, -5642, -5642,  4259,
   -5642, -5642, -5642,  4264,  9113, 93531, -5642, -5642, -5642,  1283,
    2002,  4397,  2028,  3789, 93531,  2028,  1223,  1053,  9113, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,   409, -5642, 80121, -5642, -5642, -5642, -5642,
   -5642,  4546,  4550, -5642, -5642, -5642, -5642,  3972,  1227,  6311,
    1430,  4364,  4201,  4365,  4295,  2304,   213,  4369,  4522, -5642,
     449,   213,  4376,  4435,  3887,  4439,  4382, -5642,  3892,  4201,
    4384,  4007,  4386,  4388,  4389, -5642, -5642, 11120, -5642, -5642,
   -5642, -5642,   173, 44992, -5642, -5642, -5642, -5642, -5642,  4003,
   22138, 22138,  4404, 93531,  4407, -5642,  4230, -5642, 93531, -5642,
     568, -5642, -5642, -5642,  4124, -5642,  2311, -5642, -5642,  2312,
   -5642, -5642,  2322, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    4373, 93531, -5642, -5642,  3462, -5642,  4487, -5642,  4176,  3068,
   -5642, -5642,   546,  4035,  4300,  4300, -5642, -5642, -5642,  4420,
   -5642, -5642, -5642, -5642,  4471,104514,  4202, -5642,   522, -5642,
     522,   522, -5642,  3844,  3847, 22138,  2709,  4340, 57771,  3849,
   -5642, -5642,  9431,  7881,  2343,  4126,  4084, -5642,  4020, -5642,
    9455,  9487,  9505,  1771,  2921, -5642, -5642, -5642, -5642,  4482,
    2920, -5642,  4567, -5642,  2920, -5642, -5642, -5642, -5642, -5642,
   -5642,  3860,  9568,  9113,  9113,  9595, -5642, -5642, -5642,  2359,
    1831,  9632,  9650, -5642, -5642, -5642,  3862, -5642, -5642,   609,
   -5642,  3861, -5642,  2360,  4577,  2254, 22138, -5642, -5642, -5642,
   93531,  3960,  1300, -5642,  2369, -5642, -5642,  3866,  3877,  3867,
   -5642, -5642, -5642,  3875,   546, 37503, -5642, -5642,  3314, -5642,
   -5642, 60751, -5642, -5642, -5642, -5642, -5642, -5642, -5642, 17500,
   17500, -5642, -5642,  3793, -5642, -5642, -5642, -5642,  4246, 62986,
   -5642, -5642,  3883,  3871, -5642, -5642, -5642, 89061, -5642,  2370,
   -5642, -5642,  4610, 19046, -5642, -5642,  3886, -5642, 80121,  3888,
    3894, 47972,  1440, 93531,  2384, -5642, -5642, -5642, -5642, -5642,
    1892, -5642,  1766,  2632,  2409,  2409, -5642,  3884, 47227, -5642,
     213, -5642,   283,   370,   377,   382, -5642,  3566,   335,   335,
    2595,  2595,   213,   335, 80121,  1904,   335,  3566,  3566,   383,
    2595,  1548,   283, -5642, -5642, -5642,   335,   283,   262, -5642,
   -5642, 12783, -5642, 11120, 70436, -5642,  1135, 93531,  2821, -5642,
   -5642,  1860,  4023, -5642,  3899, 93531, -5642,  2595, -5642,  4629,
    4653, -5642, -5642,  4307, 22138,  3903, 22138,  3906,  2385, -5642,
    2409, -5642,  2409, -5642,  1283,  4623,  4625,  4574,  4627,  2002,
   -5642,  2143, -5642, -5642, -5642, -5642, -5642, -5642,  1223, -5642,
   -5642,  3910, -5642, -5642, -5642, -5642,  4251, -5642,  4666, -5642,
    4367, 45737,  2632, -5642,   531,  3956, -5642, -5642, -5642,  4566,
    2892,  2892,   269,  2892, 90551,   425,  2101,  4554,  2375,  1783,
    3977,  4491,  2892,  2892, 91296,   269, 37503, -5642, -5642, -5642,
    2892, -5642,  2892, 47227, 92041,   269, -5642, -5642, -5642, 93531,
   -5642,  2892,   269, -5642,   269,   269, 90551, -5642, 12412, -5642,
   -5642, 40522,  1120, -5642,  9113, 10697,  4328, -5642, -5642,  4048,
    2595,  4296, -5642, -5642,  4408, -5642, 93531,   210, -5642,   335,
   -5642,   335, -5642,   335, -5642,   330, -5642, 30641, -5642,  3318,
   -5642, -5642,  1946, -5642, -5642,  4297,  4158,  4444, -5642,104514,
   -5642, -5642, -5642, -5642, -5642,  3937,  2028, -5642,  3944, -5642,
   -5642, -5642, -5642, 22138, -5642,  4178, -5642,  4282, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,   522, -5642, -5642,
   -5642, -5642,  3566, -5642, -5642, -5642,  3947, -5642,   335, -5642,
   22138, -5642, -5642,  3950,  9790,  2028, -5642,  2817, -5642,  3959,
    3952, 93531, -5642,  4310, -5642, -5642, 37503, 61496,  3955,  3957,
   -5642,   213, -5642, -5642, 17500, 17500, -5642, -5642,  4077, -5642,
   -5642,   527, -5642, 93531, -5642, -5642,  3566,  4314, -5642,  2402,
   93531,  3958,  4152, 93531, 93531, -5642, -5642,  3961, 93531, -5642,
   -5642, -5642, 40522,  3962,  4580,  4582,  2409, -5642,  2632,  4511,
   47972, -5642,  2632,  2632, 66711, 93531,  3964,  2595, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3967, -5642, -5642,
   -5642, -5642, -5642,  2595, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  4696, -5642,
    4337, -5642, -5642, -5642, -5642,105993, -5642, -5642, -5642,  4321,
    1135, -5642,  2292,  3969,  3970, -5642, -5642, -5642,  4647,  1967,
   -5642, -5642, -5642,  4552,  1870, -5642, -5642,  3982, -5642, 68201,
   -5642, -5642, -5642, -5642,  3981,  3985,  9113, 93531,  9113, 93531,
   -5642,  4632,  4632, -5642,  2709,  2709,  4697,  2709, -5642,  4705,
    4706,  2143, -5642, -5642,  4730,  1227,  4360,  1225,  1372,   269,
    1372,  4649, -5642, -5642, 93531, 47972, 90551, 47972, -5642, 74906,
   47972,  2892, 93531, -5642,  4651, -5642,  4614, 47972, 47972, -5642,
   -5642, 90551,  3993, -5642,  2028,  2593, 93531, 47972, -5642, -5642,
   -5642,  3042,  4463, 47972, 90551, -5642, 90551, -5642,  3058,  1419,
   -5642,  3997,  4002, 93531, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,  1260, -5642, -5642,  2416, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642,   436, 93531, -5642,  1822,  4196, -5642,  1946, -5642,
   -5642, -5642, 47227, -5642, 22138, -5642, -5642,  9686, -5642, -5642,
   -5642,  4014, -5642,  4015,  3600, -5642, 10786,  4135,  4040,  4056,
    4064,  4186,  4348, -5642,  4193, -5642, -5642,  4017, 30641, -5642,
    1375, -5642, -5642, -5642, -5642,  4016, -5642, 37503, 19046, -5642,
   -5642, -5642, 95766, -5642, -5642, -5642,  4437, -5642,  2443,  2028,
    4022, 93531,  4028,  2456,  2462, 93531,  4037, -5642, 22138,  2632,
   -5642, -5642, 47972, 47227, -5642,  4513,  -139, 47972, 47972, -5642,
    4025,  4741, -5642, -5642,  4031, -5642, -5642, 47227, -5642, -5642,
     228,   262, -5642, -5642,  4036, -5642, -5642, -5642, -5642, -5642,
   -5642,105993,  1390, -5642, -5642, -5642, -5642,  4043, -5642,  4044,
   -5642, -5642, -5642,  4606, -5642, -5642, -5642, 67456, -5642, 93531,
   -5642, -5642, -5642,  4404,  2821, 93531, -5642, 93531, -5642, 99491,
    7117,  2463,  2476,  2362, -5642, -5642, -5642, -5642,  2709, -5642,
    2709,  2709, -5642,  4046, -5642, -5642, -5642,  4701, -5642,  4704,
   -5642,   428,  1901, -5642, 47972,  1840,  3775, -5642, 47972,  3871,
   93531, -5642, -5642,   473, -5642, 37503, -5642, -5642,  4547,  4551,
   -5642,  4558,  1120, -5642, 93531, -5642, -5642, -5642,  4159, -5642,
   13288,  4261,  4774,  4777, -5642, 93531, 92786, -5642, -5642,  4836,
   30641, -5642, -5642,  4692, -5642,  3449,  2028, -5642, -5642, -5642,
      89, -5642,  4804,   123, -5642, -5642,  1109, -5642, -5642, 93531,
    4071,  4163, -5642, -5642,  4143, -5642, -5642,  2321, 62241, -5642,
   -5642, -5642,   188, -5642, -5642,  1426, 93531, -5642,  4828,  4079,
     875,  1426,  1426,  4080, 93531,  9731, 47972,  4513,  1720,  4081,
    1081, -5642,  1081, -5642, -5642,  1241, 68201, -5642, -5642,  1427,
   93531,  4087,  4849, -5642,   197,   242, -5642,  1146,  1390, -5642,
   -5642, 93531, -5642, 93531, -5642, 93531, -5642,  2928,   332, -5642,
   -5642, 93531, 80866, -5642,  2080, -5642,  1967, -5642, -5642, -5642,
   -5642,  4650,  2482, -5642, -5642, -5642, -5642, -5642,  4807, -5642,
    4809,  4093,  4096, -5642, -5642, -5642, -5642, 47972,   957, -5642,
   -5642,  4736, -5642,  4782,  4783,  1120, -5642, -5642, -5642, -5642,
   -5642,   269, -5642, 93531, 47972, 47227, -5642, -5642,  3871,  1277,
   22138,  4452, -5642, -5642,  4302,  4303, -5642, -5642,  2493, -5642,
   -5642,  4164,  2042,  4593, -5642, -5642, -5642, 10786, -5642, -5642,
    4241,  1931, -5642,  2516, -5642, -5642, -5642,  3042, -5642,  4111,
   -5642,  4478,   213,   213,  4480,   213,   213,   213,   213,  4119,
    2321, -5642,  4470, -5642, -5642, -5642,  1248,  2028,  4142, 93531,
    4146,  2527,  1453,   706, 93531,  4145, -5642, -5642, -5642,  1081,
   93531,  4752, -5642,  4150, -5642,  4153,  4154, -5642, -5642,  4775,
    2595, -5642,  4235, -5642,  1241, -5642, -5642, -5642,  4205,  4781,
    4744,   213, -5642, 80121, 32960, -5642,  4643, -5642,  4607,  4847,
   -5642,  4900,  1747, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    4169, -5642,  4171, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    4712, 93531, -5642, -5642, 47227,  4230, -5642,  2697, -5642, 99491,
   12175, -5642, -5642, 89061, 89061,  4741,  3042,  4310, -5642, -5642,
   -5642, 32960, -5642, -5642, -5642, -5642, -5642,  4815, -5642,  9113,
   22138, -5642, -5642, -5642, -5642, 92786, -5642, -5642,   425, -5642,
   -5642, -5642, -5642, -5642, 93531, -5642,  4187, -5642, -5642,   178,
     213,  2595,  2595,   213,  3264,  3264,  3042, 80121,  4274, -5642,
   -5642,   213,  1081,  2595,   213,  1081, -5642,  1842,  1248, -5642,
   -5642, -5642, -5642,   213, -5642, -5642,  1285,  1426, -5642,  4380,
    1842,  1453, -5642, -5642,  1842,   706, -5642, -5642,  4191, 93531,
    4207,  4209, -5642,  2544, -5642,  1544,  4779, 93531,  4210, 93531,
   93531, -5642, -5642, -5642, -5642, -5642, -5642,  4555, 71181, -5642,
    3395,  3395, 15954, -5642, -5642, -5642, -5642, -5642, -5642,  2813,
    4778, -5642,  4250,  1361,   213, -5642,  5900, -5642, -5642, -5642,
   -5642,  4568, -5642,  3692,  3693, -5642,   336,  4635,  4869,  4575,
   -5642, -5642, -5642,  4792, -5642,  3775, -5642,  3775, -5642,   448,
    4217,  2549, -5642, -5642,  2563, -5642, -5642,  4220,  9113, -5642,
   37503, -5642,  4163, -5642, -5642,  2572, -5642, 27549, -5642, -5642,
   -5642,  2595, -5642, -5642,  2595, -5642, -5642, -5642, -5642, -5642,
    2573, -5642, 80121, -5642, -5642,   335, -5642, -5642,  4834,  4670,
   -5642, 71926,  4423,  1248,  2728, -5642, -5642, -5642, -5642, -5642,
    4231, 93531, 93531,  4233, -5642, 93531, -5642, -5642, -5642,  1675,
   -5642,  2580, 93531,  2581,  2586, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  4234,  4237, -5642,    71, -5642, -5642,  5900,
   -5642, -5642, -5642, 93531, -5642,  4764,   553, 93531, -5642, -5642,
   -5642,  4307, -5642, -5642, -5642,  4795,  2697, -5642, -5642, -5642,
    4310,  4236, -5642,   213,  4762, -5642, -5642,  4187, -5642,  4239,
   -5642,  2042, -5642, -5642, 80121, -5642,  4274, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642,  1842, -5642, -5642,  2603,
    4079, 93531, -5642,  1252,  1252,  1248,  2607,  1453,   706, -5642,
     413, -5642,  1412,  1412,  1621, 93531, 93531, -5642,  2821, -5642,
   -5642, -5642,  5002, -5642, -5642, -5642, -5642,  2697,   396,  2610,
   37503, 19046,  4540,  4104, -5642, 27549,  4243,  2321, -5642, -5642,
   -5642,  4511,  4244,  4079, -5642, -5642,  2147,  4694,  4827,  4829,
   -5642,  1248, -5642, -5642, -5642,  4254, -5642,  1412, -5642, -5642,
   -5642, -5642, -5642,  1549, -5642, -5642, -5642, -5642, -5642,  4306,
    4604,  4930, -5642,  2697, -5642, -5642, -5642,  4840,   396,   396,
   -5642, -5642, -5642,  4979,  4397, -5642, -5642, -5642, -5642,  1248,
    4262, -5642, -5642, -5642,  4746,  4947, -5642, -5642, -5642, -5642,
    1549, -5642,  2821, -5642, -5642,  4398, -5642,   400,  4848, -5642,
    4850, -5642,  2709,  4909, -5642,  1248,  1252,  1252, -5642, -5642,
   -5642, -5642,  4938,  4620, -5642,  5027,  4277, -5642, -5642, -5642,
    1022,  1246, 34490,  4803, -5642, -5642, 80121, -5642, -5642, -5642,
   -5642, 80121, -5642,  2614, -5642, -5642, 37503, -5642, -5642, 13288,
   -5642, -5642, 35250,  4279, -5642,   213, -5642, -5642, -5642, 37503,
   -5642, -5642, 19046, -5642, -5642
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  3679,     2,     0,  2567,  2568,  1073,  2361,     0,   417,
       0,  1299,   669,  3889,  2206,  2355,  2354,  2129,  2828,   457,
     215,  2879,   368,  2131,  2427,     0,     0,   453,  2936,  1315,
    2955,   810,   564,  2963,     0,   314,     0,     0,   460,  2134,
     312,   215,  1364,  3324,  2255,     0,  3429,  2194,     0,  1362,
     455,  2525,  2778,  2826,  2827,  2857,  2682,  2957,  2980,  3007,
    2759,  2758,  2762,  2760,  2761,  2763,  2764,  2765,  2766,  2767,
    2768,  2655,  2769,  2770,  2771,  2773,  2772,  2774,  2775,  2776,
    2656,  3584,  3680,  2657,  2731,  2777,  2733,  2732,  2779,  2658,
    2659,  2780,  2781,  2782,  2783,  2661,  2660,  2784,  2786,  2785,
    2734,  2735,  2787,  2788,  2789,  2791,  2662,  2663,  2664,  2665,
    2666,  2790,  2667,  2792,  3589,  2793,  2794,  2668,  2795,  2796,
    2797,  2798,  2800,  2799,  2801,  2802,  2804,  2805,  2806,  2803,
    2807,  2808,  2810,  2809,  2737,  2811,  2736,  2812,  2669,  2813,
    2814,  2815,  2816,  2817,  2818,  2819,  2820,  2821,  2822,  2099,
    2823,  2824,  2825,  2848,  2829,  2831,  2830,  2738,  2832,  2833,
    2834,  2836,  2835,  2837,  2839,  2670,  2671,  2672,  2838,  2840,
    2841,  2842,  2843,  2844,  2846,  2845,  2849,  2851,  2852,  2739,
    1315,  2674,  2675,  2847,  2850,  3741,  2853,  2854,  2855,  2676,
    2728,  2856,  3431,  2859,  2858,    84,  2860,  2678,  2861,  2862,
    2863,  2864,  2865,  2867,  2869,  2866,  2870,  2871,  2877,  2679,
    2868,  2872,  2873,  2874,  2875,  2876,  2878,  2740,  2880,  2882,
    2881,  2883,  2884,  2885,  2886,  2887,  2729,  2888,  2889,  2890,
    2891,  2904,  2905,  2895,  2896,  2898,  2899,  2902,  2897,  2903,
    2908,  2907,  2909,  2910,  2911,  2912,  2913,  2906,  2893,  2900,
    2901,  2894,  2914,  2915,  2892,  2916,  2918,  2917,  2919,  2741,
    2920,  2921,  2922,  2923,  2924,  2925,  2926,  2927,  2929,  2928,
    2930,  2931,  2932,  2933,  2934,  2725,  2935,  2742,  2743,  2937,
    2940,  2938,  2939,  2941,  2942,  2947,  2948,  2949,  2944,  2943,
    2945,  2946,  2744,  2745,  2746,  2950,  2951,  2952,  2954,  2953,
    2681,  2680,  2956,  2683,  2958,  2959,  2684,  2960,  2962,  2961,
    2727,  2685,  2964,  2965,  2967,  2966,  2686,  2687,  2688,  2968,
    2969,  2970,  2971,  2972,  2973,  2974,  2975,  2976,  2977,  2978,
    2979,  2747,  2748,  2981,  2982,  2983,  2985,  2984,  2986,  2987,
    2988,  2989,  2990,  2991,  2992,  2689,  2993,  1315,  2994,  2995,
    2996,  2690,  2998,  2997,  2691,  2999,  3000,  3001,  3002,  3003,
    2726,  3589,  3004,  3005,  3006,  2749,  3008,  3009,  3010,     0,
    3011,  3012,  3013,  2692,  3014,  3015,  2750,  2730,  2693,  3016,
    3018,  2439,  2757,  3017,  3019,  2695,  2696,  3020,  3021,  3022,
    2694,  3023,  2697,  3024,  3025,  3027,  3026,  3028,  3029,  3030,
    3031,  2698,  3032,  3033,  2699,  3034,  2700,  3035,  3036,  3037,
    3038,  3040,  3039,  3041,  3042,  3043,  3044,  3045,  3046,  3048,
    3050,  3049,  3047,  3051,  3052,  2751,  3053,  2701,  2752,  3059,
    3060,  2753,  3054,  3055,  3056,  3057,  3058,  2235,  3061,  3062,
    3063,  2704,  3064,  3065,  3067,  3066,  2702,  2703,  3068,  3069,
    2708,  3070,  3071,  3077,  2754,  2755,  3072,  3073,  3086,  3074,
    3076,  3075,  3079,  3078,  3080,  3081,  3742,  2705,  3082,  3083,
    2706,  3084,  2707,  3085,  2756,     0,     0,     3,  3681,    22,
       0,    44,    27,    32,    17,    21,    16,    46,    59,    52,
      29,  3876,  3877,  3879,    42,  3620,    41,    11,    62,    63,
      19,    49,    12,    15,    18,    40,    48,    36,    43,    56,
      57,  1385,  1361,  1389,  1360,  1356,  1352,  1371,  1372,  1373,
    1379,    25,    26,    33,    50,    67,    23,    64,    60,    24,
    2361,    13,    28,    14,    51,    45,    37,    61,    68,    38,
       0,  3745,  3739,  3737,  3740,  3735,  3736,  3738,    58,    39,
      66,    31,    53,    30,     9,    10,    20,    54,    55,    47,
      69,    34,    65,    35,     8,  3746,     0,  3682,  2117,   165,
    3586,  3878,  2620,  2619,  2656,  3691,  2657,  2659,  2712,  2660,
    2715,  2716,  2709,  2669,  2717,  3692,  2672,  2673,  2713,  2617,
    2676,  2718,  2677,  2679,  2710,  2711,  2719,  2714,  2688,  2720,
    2690,  2721,  2722,  2723,  2698,  2699,  2724,  2703,  2618,  2707,
    2572,  2583,     0,  2584,  2614,  2612,  2616,  2610,  2615,  2608,
    2609,  2613,  2611,  1121,     0,     0,     0,     0,     0,  2127,
       0,     0,  2127,  1208,  1430,  3618,  3619,  3620,  1316,     0,
    1317,     0,     0,   239,   223,   387,   129,     0,     0,     0,
       0,  3680,  2230,  2127,  2103,  2127,  2127,  2127,  2127,  2127,
       0,  2127,  2127,     0,  2130,  2127,  2127,     0,     0,     0,
     387,  2137,  2429,     0,  2449,  2450,  2444,  3419,  3420,  3414,
     370,     0,     0,     0,  2328,  2327,     0,     0,   299,   311,
     314,   307,   310,     0,   215,  2127,   370,  2137,   313,   314,
       0,  1394,     0,  2333,   314,     0,  2204,  2443,     0,   387,
    2526,  2523,  2400,  2402,     0,  2398,  3589,  1501,  1500,     0,
    3885,  3887,     0,  2573,  1294,  1326,  1252,  3590,  3591,     0,
      76,    79,  2366,   336,     0,     0,     0,   667,     0,     0,
    1260,     0,  3591,  3601,  2441,     0,   129,  1233,     0,   129,
    2238,  2127,  2127,  3662,  3663,     0,     0,     0,  3657,     0,
    3664,     0,  1389,     0,  1375,     1,     5,     0,     0,   667,
    1024,   667,  1025,     0,   667,   667,     0,     0,     0,     0,
    3625,  3618,  3619,  3620,     0,  2085,  1940,  1390,  1389,  2032,
    2036,  3606,  3606,  3606,     0,     0,  2032,  1380,  2843,  2675,
    2962,     0,  2346,  2360,  2344,  2561,  1358,  1354,  3747,     0,
       0,  2667,  1076,  1122,  1081,     0,     0,  1083,     0,     0,
    1098,  2589,  2588,  2587,  1095,  1094,  1093,  1091,     0,   528,
     215,     0,  1210,     0,     0,     0,  3626,  3625,     0,  1271,
    2348,  2349,  2350,  2351,  2352,  2353,  2356,   241,     0,   387,
     419,     0,   430,   421,   424,     0,   130,   131,  1297,  1300,
       0,   670,     0,   162,     0,   290,   292,     0,  3708,   289,
     291,  3707,     0,  3854,     0,     0,   366,   277,   364,  3704,
    3701,  3706,  3702,  3705,  3703,  3843,   365,  3744,     0,   281,
    3890,  3844,  3845,  3847,     0,  2234,  2233,     0,  2232,  2207,
       0,  2230,     0,  2125,  2127,     0,     0,     0,     0,     0,
       0,   215,     0,  2329,   215,  2108,  2127,  2127,   458,  3743,
       0,  3712,  3478,  3496,  3497,  1443,  3493,  3498,     0,  3495,
    3490,     0,     0,  3492,  3489,     0,     0,  3517,  3491,  3494,
    2657,  2796,  2835,  2672,  2849,  2851,  2972,  2976,  2981,  2992,
    2996,  2723,  2695,  3041,  3472,  3460,  3473,     0,     0,  3476,
    3481,     0,  3480,     0,     0,  2139,  2430,  2431,  2435,     0,
    2453,     0,     0,   380,     0,     0,     0,     0,  3875,   372,
     373,     0,   376,     0,   370,  3873,  3865,     0,   387,  3872,
    3867,  3866,  3868,  3869,  3870,  3871,   398,     0,   399,   400,
    3874,   454,  3861,  3862,     0,     0,   370,  3753,     0,  3863,
    3859,  3860,  1313,  1742,     0,  2500,  2569,  2570,     0,  2513,
    2518,  2519,  2511,  2512,  2516,  2492,  2515,  2491,  2517,  1503,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1443,  1443,  1443,  1440,     0,     0,     0,     0,     0,     0,
       0,  2509,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1440,     0,
       0,  2508,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,  2510,  1443,
    1440,  1440,     0,     0,  1443,  2760,  2761,  2655,  2776,  2712,
    2787,  2789,  2662,  2663,  2664,  2665,  2666,  2709,  2811,  2736,
    2812,  2813,  2814,  2675,  2855,  2862,  2881,  2883,  2923,  2925,
    2931,  2938,  2939,  2951,  2956,  2727,  2970,  2977,  3003,  2749,
    3008,  3013,  3016,  3037,  2752,  3059,  3060,  2753,  3058,  2724,
    3070,  3077,  3080,  3081,  2705,  2756,     0,     0,     0,     0,
    1502,     0,     0,  1387,  1577,   811,  1460,  1476,     0,  1575,
    1574,  1578,  1580,  1586,  1495,  1607,  1546,  1547,  1549,  1548,
    1553,  1554,     0,  1718,  1555,     0,     0,  1552,  2505,  1551,
    1550,  2506,  2507,  1545,  2547,  2583,     0,  2571,   566,   565,
       0,   326,   321,   329,   323,   325,   324,   330,   331,   332,
     327,   322,   328,   315,     0,   300,     0,   308,  3602,     0,
    1318,   370,   461,  2142,   333,  3478,  2762,  2976,  3452,     0,
    3459,     0,  3617,  3611,  3614,  3613,  3609,  3612,  3610,  3615,
    1415,  3616,  1414,  1365,  1395,  1412,  1413,     0,     0,     0,
    2645,  2644,   944,  2642,  3345,  3346,     0,  2646,     0,     0,
    3347,  3032,  3054,  2643,     0,  2578,     0,  2579,  2639,  2637,
    2641,  2640,  2634,  2635,  2638,  3325,  3330,  3326,  2636,     0,
       0,     0,  2341,  1022,  1021,     0,     0,     0,     0,  2277,
       0,   944,  2341,  2278,     0,  1997,  2331,  2334,     0,  3349,
    2291,  1023,  3350,  2327,     0,  2263,  2279,  2240,  2284,   129,
    3351,     0,  2330,  1997,  2341,     0,  2256,     0,     0,     0,
       0,  1429,     0,   309,  3430,  2205,  1206,  2175,  1363,  2161,
       0,   456,     0,     0,  2399,  3585,  3886,  3773,     0,     0,
       0,     0,  3594,  1789,  2100,     0,    80,    75,     0,     0,
       0,     0,  2566,  3432,    85,     0,     0,  3676,    73,     0,
    2417,     0,  2415,  2412,  2414,     0,  3594,     0,  2440,  1240,
    1240,     0,     0,  1232,  1234,  1235,  1240,  1240,  2239,     0,
       0,     0,  2499,  2497,  2498,  2574,  3659,  2496,  2495,  3668,
    3670,  3653,     0,  3656,  3655,  3665,  1378,  1377,     6,    70,
       0,   137,   667,   215,   215,   667,   164,   143,   146,   667,
     667,   667,   667,   155,   157,     0,   217,     0,     0,  3625,
    1393,  2879,     0,     0,  1405,  1391,  1834,  1392,  1866,  1836,
    1806,  1802,  1801,  1862,  1863,  1865,  1864,  1867,  1869,  1859,
       0,     0,  2098,     0,  2093,  1941,  1946,  1940,     0,     0,
       0,     0,     0,     0,  2031,  1997,  2040,  2002,  2033,  1357,
    2029,     0,  1353,  1418,  1418,  3608,  3607,  3605,  3604,  3603,
    2034,  1376,  1384,  1382,  1383,  2035,  1374,     0,  2358,  2563,
       0,  2363,     0,  2032,  2036,     0,     0,     0,  2166,  2165,
    2168,     0,   960,     0,   224,  3623,  3624,  3622,  1443,  2590,
    2593,  3621,  2594,   224,  1092,     0,   529,  2128,     0,     0,
       0,     0,     0,     0,   531,   530,   467,     0,  2127,  1214,
    1215,  1209,  1211,  1213,     0,     0,     0,     0,  2362,     0,
     243,   240,   222,   428,     0,   388,  3732,     0,   425,    86,
       0,  1301,  2118,  2120,   161,     0,     0,  3857,  3087,  3088,
    3089,  3090,  3091,  3092,  3094,  3095,  3093,  3096,  3097,   889,
     910,  3098,  3099,  3100,   910,   925,  3101,  3102,  3103,  3104,
    3105,  3106,  3107,  3108,   875,  3109,  3110,  3111,  3112,  3113,
    3114,  3115,  3116,  3117,  3118,  3119,  3121,  3120,  3122,  3123,
    3124,  3125,  3126,  3127,  3128,  3129,  3130,   895,  3131,  3132,
    3133,  3134,  3135,  3136,  3138,  3137,  3139,  3140,  3141,  3142,
     891,  3143,  3144,  3145,  3147,  3146,  3148,  3149,  3150,  3151,
    3152,  3153,  3154,  3155,  3156,   895,  3157,  3158,  3159,  3160,
    3161,  3163,  3162,  3166,  3167,  3168,  3169,  3170,  3171,  3172,
    3173,  3174,  3175,  3176,  3177,  3178,  3179,  3180,  3181,   885,
    3182,  3183,  3184,  3185,  3186,  3187,  3164,  3188,  3165,  3189,
    3190,  3191,  3192,  3193,  3194,  3195,  3196,  3197,   925,   841,
     841,  3198,  3199,  3200,  3201,  3202,  3203,  3204,   925,   888,
     841,  3207,  3208,  3205,  3206,  3209,  3210,  3211,  3212,  3213,
    3215,  3214,  3218,  3216,  3217,   895,  3219,  3220,  3221,  3222,
    3223,  3224,  3225,  3226,  3227,  3228,  3229,  3230,  3231,  3233,
    3234,  3232,  3235,  3236,  3237,  3238,  3239,  3240,  3241,  3242,
    3243,  3244,  3245,  3246,   890,  3247,  3249,  3248,  3250,  3251,
    3252,  3253,  3254,  3255,  3256,  3257,  3258,  3259,  3260,  3261,
    3262,  3265,  3263,  3264,  3266,  3267,  3268,  3269,  3270,     0,
    3271,  3272,   887,  3273,  3274,  3278,  3275,  3279,  3276,  3280,
    3277,  3281,  3282,  3283,  3284,  3285,  3286,  3287,  3288,  3289,
    3290,  3291,  3292,  3293,  3294,   925,   886,   841,  3295,  3296,
    3297,  3298,  3299,  3300,  3301,  3302,  3303,  3304,  3305,  3306,
    3307,  3308,  3309,  3310,  3312,  3313,  3311,   910,   879,  3314,
    3316,  3315,  3317,  3318,  3319,  3320,  3321,  3322,  3323,   910,
     835,   836,   841,   910,   854,     0,   895,   925,     0,   876,
     895,   881,  2654,   910,     0,   910,   910,   910,   910,  3707,
     910,     0,   270,   278,   820,   823,   825,   824,   826,   827,
     910,   910,   910,   910,   910,   912,   895,   895,  2647,  2648,
    2649,  2650,  2652,  2653,  3690,   895,  2651,  3850,     0,     0,
       0,  3856,     0,  3680,     0,     0,  3848,     0,  2208,     0,
    1403,  1940,  2210,  2215,  2224,  2228,  2231,  2105,     0,     0,
       0,  3828,  3827,  2111,  2110,  3826,  2329,     0,  2114,   542,
       0,     0,     0,  2115,  2101,     0,   434,   436,  3479,  3477,
    3514,  3513,  3518,     0,  3515,  3511,     0,  3471,  3519,  3504,
    3508,     0,  3520,  3505,  3512,  3526,  3525,  3527,  3522,  3521,
       0,  3524,  3510,     0,  3509,  3530,     0,  3474,     0,     0,
     410,     0,  2144,  2145,  2141,  1206,  2140,  2436,     0,  2428,
       0,  1336,  2455,  2454,  2451,  1932,  3416,  3421,  3700,  3699,
    3698,  3697,  2585,     0,  3694,  3696,  3693,  3695,  2586,   387,
     381,     0,     0,  2938,     0,   386,   385,   384,   407,   387,
     377,   396,     0,     0,  3683,   371,  3684,   374,   405,   408,
     447,   443,   451,   445,  3882,  3880,  3754,  3864,   268,     0,
       0,  2569,  2570,  2502,  2501,  2571,  2493,  2514,     0,     0,
       0,  1581,  1938,  1938,  1938,     0,     0,  1797,     0,     0,
       0,     0,  1938,     0,  1614,  1593,  1592,     0,  1615,     0,
       0,     0,     0,     0,     0,     0,     0,  1748,  1748,  1714,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1791,  1793,  2547,  1938,     0,  1938,     0,  1448,  1624,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1938,  1938,     0,  1938,     0,     0,  1639,  1641,  1640,
    1938,  1938,  1626,     0,     0,     0,  1938,     0,     0,     0,
       0,     0,     0,     0,     0,  1787,     0,  2520,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1787,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2522,     0,     0,     0,  2521,     0,     0,
       0,     0,     0,     0,     0,  1787,     0,     0,  1583,     0,
    1582,  1584,     0,  1387,   812,     0,     0,     0,  1499,     0,
    1505,  1507,  1509,  1497,  1498,     0,  1496,     0,  1504,  1506,
    1508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1585,     0,     0,     0,     0,     0,  2494,
       0,  1673,     0,   578,  2425,     0,     0,     0,   298,  1320,
    2595,     0,     0,   387,  2146,  2143,  3477,     0,     0,     0,
    3474,  1430,  1411,  3352,     0,   943,     0,     0,   946,   948,
     947,   956,     0,   945,  3392,  3390,  3388,  3387,     0,     0,
    3332,  3334,     0,   952,   954,   953,  3382,   951,     0,  3368,
       0,     0,     0,     0,   667,     0,     0,     0,     0,     0,
       0,     0,     0,  2309,     0,  1429,  1429,  2257,     0,  2341,
       0,  2341,  2331,     0,  2341,  2337,  2297,  2290,     0,     0,
     723,  2014,  1998,  2283,  2335,  2336,  2341,     0,     0,  2341,
       0,  2298,  2331,  2341,  2252,     0,     0,  2244,  2249,  2245,
       0,  2251,  2250,  2253,  2241,  2242,     0,  2270,  2300,     0,
    2282,  2289,     0,  2269,  2276,     0,  2287,  2331,  2331,     0,
    2341,  2341,  2341,  1207,     0,  1430,     0,  3714,  2524,  2527,
    2533,  2539,  2401,   266,     0,     0,     0,  1328,  1330,  1329,
    1346,  1254,  3593,     0,  3595,     0,  3597,     0,    77,     0,
       0,  2393,  2391,     0,     0,     0,  2385,  2387,  2390,  2386,
       0,     0,  2392,   129,     0,  2388,  2394,  2367,  2370,  2377,
    1429,  2368,     0,     0,   334,   337,   339,     0,   342,  1932,
    3435,  3434,     0,     0,     0,  1258,  1261,     0,  2422,  2419,
     129,     0,  2722,  3600,  3598,     0,  1228,  1244,  1226,  1238,
    1239,     0,     0,  1231,  1230,  3416,  3677,  3678,     0,     0,
    3654,  3671,  3652,     0,  3666,  3667,  3651,     7,     4,   149,
       0,   140,     0,     0,     0,   667,   667,   132,     0,   667,
       0,  3830,  1430,  1430,   667,   667,   667,     0,  1831,     0,
    1802,  1862,  1863,  1865,     0,  1864,     0,     0,  1932,     0,
       0,  1854,  1880,     0,  1880,  1856,  1857,     0,     0,     0,
    1405,  1860,  2575,  2094,  2097,     0,  2086,  2088,  2089,  2587,
    2091,     0,     0,  1943,  1946,  2008,  2009,     0,  1420,     0,
    2022,  2023,  2021,     0,  1999,  2015,  2020,  2018,     0,  1990,
       0,  2039,  2030,  2078,  1419,  2037,  2038,  1381,  2347,  2345,
    2364,  2365,  2562,  1359,  1355,  3412,  3413,  3410,  3411,  3409,
    3748,  3749,  3751,  1078,   961,  2167,   960,   660,   663,   662,
       0,     0,  2138,  2592,     0,  2138,     0,  2329,  1099,     0,
       0,  2329,   478,  2329,   532,  2593,  3555,     0,  3562,  3544,
       0,  1212,  3627,  3628,  1089,  1087,     0,  1272,  1273,  1276,
       0,   244,   246,     0,   387,   420,   422,   431,  3689,   370,
       0,     0,  1311,     0,  1309,  1308,  1306,  1307,  1305,     0,
    1296,  1302,  1303,  2329,   470,   284,     0,   911,   847,   925,
     923,   925,   861,   926,     0,   899,   897,   896,   892,   899,
     863,   970,   875,     0,   925,   963,   968,   964,   871,     0,
     841,   966,     0,   974,   973,   842,   869,   862,   868,   899,
       0,   858,   866,   925,   834,   870,   857,     0,   899,   872,
     877,   880,   882,   884,   899,   925,     0,  3680,   841,   856,
     855,   841,   899,     0,     0,  3680,   878,   966,   974,   841,
     925,   899,     0,   913,   899,   893,   893,   893,   282,   367,
    2041,  3773,  3852,  3853,  3846,  3849,  3851,  1859,     0,  2211,
    2218,  2122,  2124,  2561,     0,  1404,  2213,  1988,     0,     0,
       0,  2226,  2126,     0,  3829,     0,   542,  2107,  3469,   545,
     544,  2112,   543,  2167,  3542,  2106,  1216,     0,     0,   370,
     459,   435,   389,  3507,  1444,  3523,     0,  3528,  3529,  3467,
     220,   219,  3475,   218,     0,     0,     0,     0,  3516,  3499,
       0,  3503,  3502,     0,  3500,     0,  3501,     0,  3506,  3483,
    3482,  2537,     0,  2536,  3732,   369,  2146,  2863,  3070,  2437,
    2433,  2432,     0,  2452,     0,  1933,  1934,     0,     0,  1936,
    3418,  2041,     0,  3415,  3755,   382,   387,     0,     0,     0,
     402,   378,   387,   389,   401,   440,   269,     0,   241,     0,
       0,   370,   370,   387,  3680,  3773,  3416,  3352,  1743,  1745,
       0,     0,  1939,     0,  1760,     0,     0,     0,     0,     0,
       0,  1561,     0,     0,     0,  1697,     0,  1760,  1725,  2071,
    2072,  2052,  2053,  2051,  2054,  1441,     0,  2055,  2070,  1651,
       0,     0,     0,  1723,  1386,  1369,     0,     0,  1908,  1909,
    1910,  1911,  1912,  1913,  1914,  1915,  1916,  1917,  1918,  1919,
    1921,  1926,  1922,  1923,  1924,  1925,  1920,  1927,     0,  1907,
       0,  1749,  1710,  1712,     0,     0,     0,   812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1938,     0,     0,
    1938,     0,     0,     0,     0,     0,     0,  1724,     0,  1722,
       0,     0,     0,  1721,  1605,     0,     0,     0,  1938,     0,
    1634,     0,     0,     0,     0,  1537,     0,     0,     0,     0,
       0,     0,  1938,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,     0,  1788,     0,     0,     0,     0,
       0,     0,  1930,  1928,  1931,  1929,     0,     0,  1789,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1665,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1609,     0,     0,     0,  2552,     0,   992,
       0,     0,     0,     0,  1576,     0,     0,     0,     0,  1457,
    1451,  1455,  1449,  1453,     0,  1446,  1445,  1447,  1510,  2768,
    1458,     0,     0,     0,  1461,  1470,  1474,     0,     0,     0,
       0,     0,  1481,  1479,  1480,  1492,  1493,  1477,  1478,     0,
    1483,     0,  1482,  1489,  1490,  1491,  1494,  1579,   955,  1587,
    1958,  1716,  1717,  1741,  1962,     0,  2548,  1430,  1533,  1532,
    1534,  1535,  1536,   579,     0,   573,   576,   590,     0,     0,
    2424,     0,  2736,  2752,  2753,   316,   319,   318,   320,     0,
       0,  1319,  1323,  3416,     0,  2147,  2148,     0,     0,     0,
    3546,  3457,     0,     0,  1426,  1366,  1425,     0,     0,     0,
       0,     0,  3374,  3385,     0,     0,  3384,  3383,     0,     0,
       0,     0,     0,  3356,     0,     0,     0,     0,  3329,  3394,
    3395,  3398,     0,     0,     0,  3054,     0,  3331,  3336,  3327,
    3340,  3342,  3344,  2299,     0,     0,     0,  2305,  2302,  2294,
    2308,  2778,  2304,  2321,  2303,  2296,  2310,  2295,     0,     0,
       0,  2341,  2314,  2317,  2311,  2341,     0,  2341,  2313,     0,
    2339,  2326,  2325,  2324,  2267,  2266,  2260,  2332,  2318,  2312,
     215,  2341,  2265,  2264,  2246,  2247,  2248,     0,  1997,     0,
    2337,  2301,  2331,     0,  2341,  2341,  2322,  2323,  2286,  2288,
    2193,     0,  1859,     0,     0,  2180,  2173,  2160,   370,     0,
       0,     0,   370,  3888,     0,     0,     0,   563,  1346,  1332,
    1348,  1256,  1255,  1253,  3592,  3596,  1790,    79,  2186,  2187,
      81,  2185,    82,  2403,  2379,  2378,  2380,  2384,   129,  2389,
    2381,     0,  2395,  2396,   343,   347,     0,     0,     0,  3433,
       0,   668,     0,    74,     0,  1262,  2041,  2418,  2420,  2413,
    3599,     0,  1229,  1246,  1245,  1241,  1242,  1247,  1237,  1236,
    2236,  3660,  3669,  3673,  3658,   960,  1040,     0,  3465,  3562,
     184,     0,     0,     0,   135,     0,  3784,     0,   667,   156,
     158,   667,     0,     0,     0,   667,     0,     0,  1876,  1868,
    1870,  1871,  1872,     0,  1875,     0,  1408,     0,  1396,  1396,
    1406,  1878,  1858,  1855,  1881,     0,  1880,  1880,     0,     0,
    1838,  1837,     0,  1932,   949,  2090,     0,     0,  1942,     0,
    1944,  1953,  1943,  2011,  2749,     0,     0,  1422,     0,  2041,
    1416,  2501,     0,     0,     0,     0,     0,     0,     0,  2010,
    2007,     0,     0,     0,   960,     0,   661,  2167,  2167,     0,
       0,     0,     0,     0,     0,     0,     0,   225,   234,  1082,
    2591,  1084,     0,     0,   476,   477,  2167,   475,   518,   519,
     522,   523,   524,     0,     0,   525,  2167,  2167,   472,   498,
     499,   502,   503,   504,   505,   506,   468,     0,   473,     0,
       0,     0,  3574,  3416,  1113,  3629,  1085,     0,     0,  1275,
     242,     0,  3732,   426,   423,   370,   418,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    87,    88,   109,     0,  1298,  1310,  2119,  1304,  2167,
    2167,  2167,  2167,   474,   507,   508,   511,   512,   513,   514,
     517,   515,   516,     0,  2329,     0,     0,     0,     0,     0,
       0,   859,   929,     0,   860,     0,   901,   902,   900,   905,
     837,   833,   971,   959,   958,   965,   864,   865,   844,   967,
     962,   975,   972,   969,   923,   843,   839,     0,  1071,   851,
       0,   840,   883,   838,   852,   274,     0,     0,  3713,     0,
       0,  3720,   280,   867,   849,   853,  3680,  3680,   271,   279,
     845,   846,   848,   974,   831,     0,   832,     0,   828,   830,
     829,  2041,  2046,  2042,  3855,   297,     0,   296,     0,  2212,
    1396,     0,     0,     0,  2564,     0,  2025,  1989,  2225,     0,
    2229,  2228,     0,  3825,  2113,     0,     0,     0,  1218,  1217,
    2109,  2116,  3416,   370,   286,   392,   438,     0,     0,  3464,
     221,  3538,  3541,  2561,     0,     0,  3484,     0,   411,  3688,
    2148,  2434,  2438,  1337,  1339,  1340,  1338,  1346,     0,  2607,
    2606,  2605,  2576,  1937,  2577,  2602,  2600,  2604,  2598,  2603,
    2596,  2597,  2601,  2599,     0,  3424,  3425,  3423,  3417,  3422,
     383,   403,   406,     0,   379,   390,   394,     0,  3686,  3685,
     409,   448,   432,   432,   432,  3883,     0,  1314,     0,     0,
    2551,     0,  1692,     0,  1693,  1694,     0,  1562,  1798,     0,
       0,     0,  1590,     0,     0,     0,  1696,     0,  1442,     0,
       0,  1565,  1557,  1370,     0,  1727,     0,     0,     0,     0,
       0,     0,     0,  1732,     0,  1730,     0,     0,  1792,     0,
    1794,  2548,     0,  1702,  1737,     0,  1700,     0,     0,  1726,
    1738,  1739,     0,     0,     0,     0,  1706,  1704,     0,     0,
       0,  1708,  1635,     0,     0,     0,     0,     0,     0,     0,
    1608,  1705,  1707,     0,     0,  1647,     0,  1690,  1648,  1649,
    1650,     0,  1644,     0,  1645,     0,     0,     0,  1675,     0,
    1594,  1595,     0,     0,     0,     0,  1596,  1655,     0,  1570,
    1657,  1601,  1602,  1567,  1568,  1659,  1676,  1660,  1569,  1661,
    1664,     0,  1604,  2041,     0,  1588,     0,     0,     0,  1606,
    1638,     0,     0,     0,  1566,     0,  1667,     0,     0,     0,
    2041,     0,  1677,  1610,     0,     0,   813,  1388,  1558,  2549,
    1452,  1456,  1450,  1454,     0,     0,     0,     0,  1469,     0,
       0,  1462,  1472,  1475,     0,     0,  1960,     0,     0,  1735,
    1787,     0,     0,     0,  1686,  1687,     0,     0,   572,   571,
       0,   575,   651,     0,   592,   580,   569,  2426,     0,     0,
    1321,     0,     0,     0,  2135,     0,     0,  3458,     0,     0,
       0,     0,  1430,  1431,  1431,  2547,  3353,  3354,  3355,     0,
    2632,  2631,  2629,  2633,  2630,  2580,  2582,     0,  2581,  2627,
    2625,  2628,  2623,  2621,  2622,  2626,  2624,     0,     0,  3372,
     957,     0,  3406,     0,     0,  3391,  3389,     0,     0,     0,
    3335,     0,  3400,  3401,     0,     0,     0,  3370,  3369,     0,
       0,     0,  3362,     0,     0,     0,     0,  2293,  2307,  2306,
    2342,  2343,  2320,  2316,  2261,  2319,  2315,  2338,  2041,  2271,
    2292,  2262,     0,  2285,  2243,  2339,  1940,  2331,  2258,  2259,
       0,  1405,  1431,  2176,  1430,  2177,   370,  2528,     0,  2535,
       0,     0,  3680,  1295,  1335,  1327,  1334,  1331,  1346,  1344,
    1333,  1018,  1017,     0,  1347,    78,     0,     0,  2382,  2383,
    2376,  2397,  2371,     0,   338,   348,   340,   344,   345,   346,
     341,  2852,  2938,     0,  1940,  3437,  3675,  1269,  1267,  1266,
    1268,  1257,  1263,  1264,  2423,  2421,  2416,  2442,  1244,     0,
    1227,  3680,  2041,     0,  3672,   150,   960,     0,     0,     0,
    1040,     0,   160,  3574,     0,     0,     0,   133,   166,  3784,
       0,  3680,  3822,  3831,  3643,     0,   151,  3834,   223,  3832,
       0,     0,  1873,  1874,  1835,  1396,  1398,  1397,     0,     0,
    1400,     0,     0,     0,     0,  1843,     0,  1839,  1841,     0,
    1905,  1897,     0,  2095,  2087,  2092,  2546,  1950,  1994,     0,
       0,  1367,  1953,     0,  2012,  2003,     0,  1423,  1421,  2024,
    2001,     0,  2017,  2016,  2019,  1420,  1991,  1994,     0,  1430,
    3750,  3752,  1079,   664,     0,     0,  1080,     0,     0,     0,
     228,   231,   229,   230,   527,   526,     0,  2329,   520,  2167,
    2167,   180,  2167,  2167,   179,   181,     0,   175,   172,   182,
    2167,  1100,   168,     0,     0,     0,     0,  2041,     0,     0,
       0,   186,     0,     0,  2329,   500,   479,   480,   483,   484,
     485,     0,  3549,  3548,     0,  3564,     0,     0,  3566,     0,
    3565,  3563,  3534,  3545,     0,  1108,  1074,     0,  1115,  1117,
       0,     0,  3629,  1274,     0,   245,   429,     0,     0,     0,
    2041,     0,  2041,  2041,     0,     0,  2041,     0,  2041,     0,
       0,     0,     0,     0,     0,     0,  2041,     0,     0,     0,
       0,  2041,     0,  1312,     0,     0,     0,     0,  2329,   509,
       0,  2167,   469,   486,   487,   490,   491,   492,   493,   494,
     497,   495,   496,     0,     0,   251,   252,   255,   286,   908,
     906,   909,   907,   924,     0,   903,   904,   930,   966,     0,
     966,   276,     0,  3173,   273,   895,  2647,  2648,  2649,  2650,
    2652,  2653,  3722,  3721,  3815,  3814,     0,   850,     0,   306,
     305,   303,   370,   293,   301,   295,     0,   302,  2049,  2050,
    2047,  2045,  2048,  3891,  2209,  2123,  2228,     0,  2562,  1429,
       0,  2221,  1940,     0,  2227,  3416,  3470,   541,   722,  3543,
    1216,     0,   287,     0,     0,   389,  3578,     0,     0,     0,
       0,     0,  2538,   413,  2132,     0,  1346,  1350,  2445,  3427,
    3428,  3426,   404,     0,   397,   389,   241,     0,   442,   444,
     433,   452,   446,     0,   432,  1746,  1744,     0,  1761,  1795,
       0,   910,   910,   895,   912,  1781,  3180,  1775,  1778,     0,
     910,  1783,   910,  1776,   910,     0,     0,  1770,  1771,  1772,
    1774,  1773,     0,     0,     0,  1698,  1695,     0,     0,     0,
    1752,  1752,     0,     0,     0,     0,  1486,     0,     0,     0,
    1681,  1703,  1701,     0,     0,     0,     0,     0,     0,     0,
       0,  1709,  1543,     0,  1541,     0,  1542,     0,  1544,     0,
       0,     0,  1691,     0,  1512,  1531,     0,     0,     0,     0,
       0,     0,     0,     0,  1790,     0,  2057,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2553,     0,
       0,     0,   981,   987,   990,   991,   993,   985,     0,  1669,
       0,     0,     0,  1467,  1463,     0,  1471,     0,     0,     0,
    1485,  1484,  1962,  1961,     0,  1734,     0,     0,  2550,  1431,
    1674,  1430,   582,     0,   600,   574,     0,  2041,   577,   591,
       0,   603,     0,     0,     0,   317,     0,  1324,     0,   441,
       0,  2149,  1859,     0,  3456,  3547,     0,     0,  1424,  1432,
    1427,     0,     0,     0,  3376,  3375,  3386,     0,     0,     0,
       0,  3360,  3358,  3357,  3333,     0,     0,  3405,  3399,  3396,
    3397,     0,     0,  3339,     0,     0,  3337,  3341,  3343,  2281,
    2280,     0,  2340,  1997,  2254,  2273,  2275,  2341,  2195,  2199,
       0,  1932,  2184,     0,     0,  2178,  2182,     0,  2534,     0,
     267,     0,  3756,  3893,     0,  1899,    83,     0,  2374,     0,
    2369,  2372,     0,     0,  3448,  3449,  3441,  3444,  3442,  3443,
    3447,  3450,  3451,  3438,  3445,  1997,     0,  1259,  1265,  1243,
       0,  1250,  1248,     0,     0,  3709,  2237,  3661,  3674,  1058,
    1060,  1059,  1041,  1042,     0,     0,     0,  1108,     0,     0,
       0,   671,   960,   167,     0,  3772,  3771,  1430,     0,  3779,
    3782,  3780,  3783,  3785,  3680,     0,   195,  3629,  3680,     0,
    3680,   153,  1832,  1407,  1399,  1401,  1396,  1396,     0,  1801,
       0,     0,     0,  1801,     0,     0,   563,     0,  1877,  1894,
     950,  2459,  1951,  1952,     0,  1947,  1995,  1996,  1949,  1945,
       0,  1954,  1956,  1368,  2013,  2005,  2000,  1417,     0,  1993,
       0,     0,     0,  2081,  2083,   721,   720,   233,   232,   237,
     238,  2067,  2068,  2065,  2066,   533,   546,  2069,   547,   521,
    2041,  2041,  2172,  2171,  2041,  2041,   174,   171,  2170,  2169,
    2041,  2041,   169,  2138,   190,   189,   191,   192,   194,   193,
     188,  1096,     0,   534,   535,   501,     0,   481,  3552,     0,
    3559,  3554,  3557,  3537,  3536,  3535,  3532,     0,  2041,  2041,
    2041,     0,  2041,  3573,  3575,     0,     0,  1097,   960,  3587,
       0,     0,   200,  3631,     0,  3633,     0,  1278,     0,  1277,
    3732,  2041,  2041,   102,  2041,    94,    95,    90,   122,   123,
      92,    93,    98,    97,    99,   100,   103,   104,   101,    96,
      91,   126,   128,   127,   105,   124,   125,    89,   540,   539,
     538,   537,   510,     0,     0,  2329,   488,   285,     0,     0,
       0,   253,  3858,     0,   874,  1072,   873,   275,   272,   894,
    2041,   283,   304,     0,  1940,  2565,     0,     0,  2026,  2222,
    2214,  2216,  2104,  2102,  3716,     0,   439,   393,   437,     0,
    3463,  3468,  3540,  3539,  3562,  3562,   387,  3732,   387,   412,
       0,  1341,  1346,  1350,     0,  1342,  2456,   391,   395,  3687,
     449,  3773,  3881,     0,     0,  1796,  1762,  1763,  1780,  1782,
       0,  1779,  1765,  1785,  1769,  1777,  1784,  1767,  1560,  1591,
    1564,  1563,     0,     0,     0,  1622,     0,  1750,  1756,     0,
       0,     0,  1598,     0,  1733,  1731,  1600,     0,     0,  1683,
    1658,  1729,  1625,  1662,     0,  1603,     0,  1632,  1630,     0,
    1540,  1538,  1539,     0,  1612,  1611,  1642,     0,  1529,  1643,
       0,  1618,     0,  1620,     0,  1621,     0,  1653,     0,  1623,
    1656,  1556,  2059,  2058,  2056,  1571,  2041,     0,  1627,  1589,
       0,     0,  1666,  2554,  2555,     0,  1668,     0,     0,   992,
     978,   979,   980,     0,   982,   984,   986,     0,  2041,  1488,
    1487,  1459,     0,  1468,  1465,     0,  1473,  1964,  1963,     0,
       0,  1678,  1432,  1688,     0,   583,   584,   586,   588,     0,
     653,   578,     0,   567,     0,   582,   570,  1322,  1325,  2155,
       0,  2152,  2159,   556,  2221,     0,  2150,  2121,     0,  3454,
    3453,     0,  1428,  1436,  1435,  2544,  2548,     0,     0,     0,
    3373,  3393,     0,     0,     0,     0,  3403,  3402,  3404,  3371,
    3366,  3364,  3363,  2063,  2064,  2062,  2060,  2061,  2272,  1997,
    2268,     0,  1940,     0,  1897,  1431,  2174,     0,  3715,     0,
    3760,  3757,  3758,     0,  1902,     0,  1903,  1900,  1901,  2041,
       0,     0,   356,   351,   359,   353,   355,   354,   360,   361,
     362,   363,   357,   352,   358,   350,   349,     0,  3436,  1270,
       0,     0,  3710,  3711,   138,     0,  3466,   159,     0,   144,
     147,   771,     0,     0,     0,     0,  2167,  2167,  2167,  2167,
    2167,  2167,  2167,  2167,  2167,  2167,     0,  2167,  2167,  2167,
    2167,  2167,  2167,  2167,  2167,  2167,  2167,     0,     0,  2167,
    2167,   134,   551,   559,   672,   675,   716,   700,   701,   548,
       0,   136,  1430,  3837,  3778,  3781,   263,  3766,  3762,  3765,
     226,     0,     0,     0,   248,  3764,  3763,     0,   736,   737,
     735,   734,     0,     0,  3629,     0,  1410,  1409,  1844,     0,
    1848,  1853,  1849,     0,  1840,     0,  1861,  1906,  1898,     0,
       0,  2467,  1994,     0,     0,  1994,     0,     0,  1431,  2079,
    1430,   173,   178,   177,   170,   183,   176,  1101,   187,   482,
    3553,  3551,  3550,     0,  3558,     0,  3533,  3569,  3567,  3568,
    3571,     0,     0,  3570,  3572,  1102,  1103,  1109,  1104,  1204,
    1204,     0,  1204,     0,     0,  1204,  2167,     0,     0,   563,
    1222,  2167,     0,     0,     0,     0,     0,  1187,     0,  1204,
       0,     0,     0,     0,     0,  1129,  1186,   673,  1075,  1128,
    1130,  1142,   559,     0,  1160,  1189,  1190,  1188,  3588,     0,
       0,     0,  1114,     0,   203,   201,   211,  3630,     0,  2138,
       0,  3633,  1280,  1281,     0,   427,     0,   115,   117,     0,
     119,   121,     0,   111,   113,   471,   536,   489,   250,   254,
       0,     0,   898,   294,  2228,  2219,     0,  2027,     0,  1430,
    2138,   288,     0,     0,  3576,  3576,   414,   416,   415,  2188,
    1343,  1351,  2458,  2457,     0,   432,     0,  1747,   966,  1786,
     966,   966,  1699,     0,     0,     0,     0,  1756,     0,     0,
    1757,  1715,     0,     0,     0,     0,     0,  1559,     0,  1679,
       0,     0,     0,     0,   895,  1519,  1521,  1517,  1520,     0,
     910,  1523,     0,   876,   910,  1526,  1528,  1513,  1514,  1515,
    1516,     0,     0,  1799,  1800,     0,  2077,  2076,  2075,     0,
       0,     0,     0,  2556,   976,  1671,     0,   989,   983,   981,
     988,     0,  1464,     0,     0,  1966,     0,  1736,  1689,   587,
       0,   654,     0,   607,     0,   605,   581,     0,     0,  2156,
    2158,  2541,  2540,  2552,     0,     0,  2138,  2151,  3455,  1434,
    1433,     0,  3380,  3378,  3377,  3408,  3407,  3361,  3359,     0,
       0,  2274,  2198,  1988,  2200,  2192,  2183,  2181,  2530,  2041,
    3759,  1145,     0,  1146,  1157,  1159,  1349,     0,  2408,     0,
    2406,  2375,  2409,     0,  1249,  1251,     0,   141,     0,     0,
       0,  1069,  2685,     0,     0,   740,   742,   743,   744,   745,
       0,   772,   747,   667,  1019,  1019,   774,  2557,     0,   719,
    2167,   552,  2041,  2041,  2041,  2041,   698,  2041,  2041,  2041,
       0,     0,  2167,  2041,     0,     0,  2041,  2041,  2041,  2041,
       0,     0,  2041,   706,   707,   705,  2041,  2041,  2456,   558,
     560,   960,   676,   671,     0,  3839,  3680,   256,  3823,   462,
     463,     0,     0,  3633,     0,     0,  3649,     0,  3649,     0,
       0,  1804,  1803,     0,     0,     0,     0,     0,     0,  1887,
       0,  1886,     0,  1892,  1896,     0,     0,     0,     0,  2460,
    2462,     0,  2096,  1948,  1957,  1955,  1992,  2004,     0,  2084,
    2082,     0,  3560,  3556,  2044,  2043,     0,  1106,     0,  1105,
    1110,  1069,   667,  1205,   665,     0,  1164,  1168,  1165,   665,
    2125,  2125,  1315,  2125,     0,     0,  2125,     0,  2127,  2125,
       0,     0,  2125,  2125,     0,  1315,     0,   561,  1225,  1223,
    2125,  1224,  2125,     0,     0,  1315,  1177,  1124,  1178,     0,
    1125,  2125,  1315,  1144,  1315,  1315,     0,   674,   960,  1126,
    1127,   771,  1219,   210,   199,     0,     0,  1116,  1118,     0,
       0,  1119,  3632,  1088,  3635,  2138,  1286,     0,   107,  2041,
     108,  2041,   106,  2041,  3818,     0,  2138,     0,  2028,  2223,
    2217,  3579,     0,  3462,  3461,     0,  2221,     0,   450,   432,
    1764,  1766,  1768,  1616,  1617,  1753,  1994,  1751,     0,  1758,
    1759,  1713,  1652,     0,  1599,     0,  1680,     0,  1663,  1631,
    1629,  1613,  1522,  1518,  1525,   877,  1524,   966,  1646,  1619,
    1654,  1572,  2041,  1628,  1636,  1637,     0,  1670,  2041,  1466,
       0,  1969,  1968,     0,     0,  1994,   585,     0,   652,   580,
       0,     0,   604,     0,   568,  2154,     0,     0,     0,  2153,
    2163,     0,  2136,  2545,     0,     0,  3367,  3365,  2025,  2531,
    2529,     0,  1345,     0,  1904,  2404,  2041,     0,  2373,     0,
       0,     0,     0,     0,     0,   773,  1070,     0,     0,   746,
    2560,   739,   771,     0,     0,     0,  1019,   763,   667,     0,
    1069,  1020,   667,   667,     0,     0,     0,     0,  2074,  2073,
     695,   688,   687,   690,   689,   692,   691,     0,   684,   681,
     693,   683,   708,     0,   696,   678,   732,   733,   731,   702,
     709,   679,   680,   686,   685,   682,   724,   729,   727,   726,
     725,   730,   728,   697,   715,   694,   710,   550,   656,   677,
     559,   714,   713,   711,   712,     0,  3734,  3734,  3808,     0,
    3809,  3810,  3680,     0,   257,   259,   235,   227,     0,     0,
     466,   464,   465,     0,     0,   152,   265,   249,   226,     0,
    3836,   226,  3633,  1805,     0,     0,  1845,     0,  1850,     0,
    1842,  1882,  1882,  1893,     0,     0,     0,     0,  2461,     0,
       0,  2468,  2470,  2006,     0,  1104,     0,     0,     0,  1315,
       0,     0,  1191,  1162,     0,     0,     0,     0,  1136,     0,
       0,  2125,     0,  1193,     0,  1192,     0,     0,     0,  1202,
    1203,     0,  1984,  1986,  1994,     0,     0,     0,  1182,  1200,
    1201,     0,     0,     0,     0,  1152,     0,  1141,  1204,  1204,
    1161,     0,   738,     0,  1221,  1163,   197,   202,   212,   213,
    1090,     0,  3634,  1086,     0,  1287,  1283,  1284,  1279,   116,
     120,   112,     0,     0,  2220,     0,     0,  3583,  3577,  3581,
    2189,  2138,     0,  3884,     0,  1755,  1711,     0,  1682,  1684,
    1527,     0,   977,     0,  1965,  1959,     0,     0,     0,     0,
       0,     0,  1978,  1970,     0,  1740,   655,     0,     0,   593,
     610,   609,   606,  2157,  2542,  2553,   557,     0,     0,  3381,
    3379,  2196,     0,  3732,  1158,  2407,     0,  3446,     0,  1994,
    1067,     0,     0,     0,     0,     0,     0,   741,     0,   667,
    1015,  1016,  1069,     0,   748,  1038,  2557,  1069,  1069,   778,
       0,   766,   776,   821,  2559,   553,   704,  2396,   703,   657,
       0,  2456,  3734,  3734,     0,   364,  3704,  3702,  3705,  3703,
    3840,  3788,  3789,  3793,  3791,  3802,  3795,     0,  3795,     0,
    3719,  3811,   262,   260,   261,  3724,  3723,     0,   264,     0,
     236,  3774,  1430,   208,  3820,  3680,  3650,  3680,   154,     0,
    1932,     0,     0,     0,  1890,  1888,  2465,  2466,     0,  2463,
       0,     0,  2469,     0,  1111,  1107,  1112,     0,  1147,     0,
    1166,     0,     0,  1135,     0,  1301,   956,  1173,     0,  1131,
       0,  1175,  1176,  1216,  1133,     0,  1987,   562,     0,     0,
    1140,     0,  1219,  1132,  1154,  1138,  1167,  1220,   204,  1120,
     370,     0,     0,     0,  1282,     0,  1289,  3819,  3816,     0,
       0,  3582,  3580,     0,  2133,  1859,  1994,  1597,  1573,  1672,
       0,  1975,     0,     0,  1973,  1972,     0,  1967,  1974,     0,
       0,   601,   617,   613,     0,   615,   616,   638,     0,  2162,
    2164,  2138,     0,  3761,  2410,  3416,     0,  1064,     0,  1065,
       0,  3416,  3416,     0,     0,     0,  1069,  1038,  2557,   997,
       0,   749,     0,   753,   755,   780,     0,   775,   767,   788,
       0,     0,   717,   549,     0,     0,  3807,     0,  3790,  3792,
    3794,     0,  3813,     0,  3812,  3680,  3725,     0,     0,  3726,
     258,  3680,  3680,  3644,   200,   209,     0,  3768,  3767,  3835,
    3833,  2936,     0,  1808,  1810,  1833,  1847,  1852,     0,  1883,
       0,     0,     0,  2464,  2472,  2471,  3561,     0,  1149,   666,
    1061,     0,  1180,     0,     0,  1219,  1137,  1185,  1174,  1194,
    1172,  1315,  1985,     0,     0,     0,  1171,  1153,  1155,  1262,
       0,   206,   214,  3636,     0,     0,  1288,  1293,     0,  1290,
    1292,     0,  1402,     0,  2446,  1754,  1976,     0,  1977,  1980,
       0,     0,  1981,     0,   597,   599,   589,     0,   594,     0,
     611,     0,  2167,  2167,     0,  2167,  2167,  2167,  2167,   631,
     639,   641,     0,  2543,  2197,  2532,  1026,  1994,     0,     0,
       0,     0,  1028,  1030,     0,     0,   768,   761,   757,     0,
       0,  1001,  1039,     0,   751,     0,     0,   941,   995,   806,
       0,   809,     0,   779,   781,   934,   935,   783,     0,     0,
       0,     0,   822,     0,     0,   916,     0,   919,     0,     0,
     777,     0,   789,   915,   922,  2558,   699,   555,   718,  3734,
       0,  3734,     0,  3773,  3786,  3841,  3798,  3796,  3838,  3731,
       0,     0,  3824,  3775,     0,   211,  3774,     0,  1807,     0,
       0,  1885,  1884,  1899,     0,     0,     0,     0,  1148,  1062,
    1181,     0,  1170,  1134,  1183,  1184,   563,     0,  1139,   205,
       0,   198,  3637,  3638,  1285,     0,  3817,  2190,   949,  1971,
    1979,  1983,  1982,   595,     0,   602,   624,   614,   620,     0,
    2167,     0,     0,  2167,     0,     0,     0,     0,     0,   608,
     640,  2167,     0,     0,  2167,     0,  1047,  1195,  1027,  1054,
    1053,  1032,  1048,     0,  1063,  1068,  1067,  3416,   185,     0,
    1195,  1029,  1056,  1036,  1195,  1031,  1055,  1034,     0,     0,
       0,     0,   759,     0,  1000,     0,  1005,     0,     0,     0,
       0,   807,   808,   942,   782,   940,   933,   927,     0,   921,
       0,     0,     0,   818,   819,   917,   815,   816,   817,     0,
       0,   797,     0,     0,   923,   914,   790,  3805,  3801,  3803,
    3800,     0,  3719,  3680,  3680,  3729,     0,     0,     0,     0,
    3821,  1812,  1809,     0,  1817,   956,  1818,   956,  1811,     0,
       0,     0,  1169,  1151,     0,  1179,  1143,     0,   207,  1291,
       0,  2447,   601,   598,   624,     0,   622,     0,   618,   612,
     619,     0,   650,   644,     0,   646,   647,   645,   642,   635,
       0,   633,     0,  1043,  1046,  2041,  1044,   139,  1197,  1196,
    1033,     0,     0,  1026,     0,   145,  1037,   148,  1035,   764,
       0,     0,     0,     0,   998,     0,  1002,  1003,  1004,     0,
     996,     0,     0,     0,     0,   928,   932,   939,   938,   936,
     937,  2504,  2503,     0,  1437,   920,     0,   792,   931,   791,
    3774,  3774,  3787,  3680,   226,     0,     0,     0,  3773,  1430,
     213,     0,  1814,  1819,  1820,     0,     0,  1891,  1889,  1150,
       0,  2191,  2202,     0,  2473,   596,   621,     0,   629,   625,
     627,   630,   649,   648,     0,   632,     0,   643,  1045,  1199,
    1198,  1052,  1051,  1049,  1050,  1066,  1195,  1057,   765,     0,
    1065,     0,   999,     0,     0,  1026,     0,  1028,  1030,   814,
       0,   918,   784,   784,   798,  3680,  3680,  3842,  3799,  3649,
    3730,  3727,     0,  3776,  3645,   196,  1813,     0,  1821,     0,
       0,     0,     0,  2459,   623,     0,     0,   638,   637,   634,
     142,     0,     0,  1065,  1011,  1010,     0,     0,  1007,  1006,
     750,  1026,   754,   756,  1438,     0,   795,   785,   787,   794,
     800,   801,   799,   802,  3770,  3769,  3806,  3804,   226,     0,
       0,     0,  1816,     0,  1827,  1826,  1815,     0,  1822,  1824,
    1156,  2201,  2203,     0,  2467,   628,   626,   636,   762,  1026,
       0,  1014,  1012,  1013,     0,     0,   752,  1439,   786,   793,
     803,   805,  3797,  3728,  3777,     0,  1828,     0,     0,  1823,
       0,  1825,     0,  2475,   758,  1026,     0,     0,   804,  3646,
    1830,  1829,     0,     0,  2474,     0,  2479,   760,  1009,  1008,
    3641,     0,     0,  2486,  3639,  3640,     0,  3647,  2477,  2478,
    2476,     0,  2481,     0,  2483,  2484,     0,  2138,  3642,   370,
    2485,  2480,     0,  2487,  2489,     0,  2448,  3648,  2482,     0,
    1430,  2488,     0,  1431,  2490
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -5642, -5642, -5642, -5642,  1301, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  1939, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,  1021, -5642,  -333, -5642,  -328, -5642,  -329, -3651,  -644,
    3772, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    1197, -3155, -5642, -5642,  -839,   560, -5642, -5642,  -509, -5642,
    -881, -5642, -5642, -5642, -4817, -1038, -1272, -5642,    20,  4315,
    2902,   321,  3605, -4790,   155, -5642, -3565, -5642, -5642, -2566,
   -5642, -5642, -5642, -5642,  -190, -4889,   495, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  -615, -5642,  1019, -5642, -4429, -5642,
   -4173, -5642,  -776, -5642, -5642, -5642,  1034, -5642, -5642,   -96,
     494,  2485,  2410, -5642, -5642, -5642, -5642,  2313, -5642,  1949,
   -5642, -2174,  2933, -5642, -5642, -5642, -5642, -5642,  1959, -2964,
   -5642, -5642, -5642,   724, -5642,  -857, -5642,    35, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  -526, -5642,
   -2568,   953, -5642,   975, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -1703, -5642, -5642, -5642,    43, -5642, -5642,
   -5642, -5642, -5642,  2587, -5642,  4260, -5642, -5642, -3993, -5642,
    2387, -5642,  2383,  2388, -3388, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642,    44, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3580, -5642, -5642,
   -5642, -3615, -5642, -5642, -3671,  2620, -5642, -3029, -5642, -5642,
   -3083, -5642, -5642, -2869,  1131, -5642, -5642,   -53,  1439, -5642,
   -2312, -3092, -3086, -5642, -5642, -5642, -3192, -3191,  -855,  2473,
   -1795, -3110, -5642, -5642, -5642,  -660,  -658,  -445,   108,   578,
   -5642, -4330, -5642, -5642,  -524, -5642, -5642, -5642, -5642, -5642,
     358,  -336,   364, -5642,   -17,  2170, -3418, -5642, -5642, -5642,
   -5642, -5642, -5642, -1020,  -582, -1134, -5642, -5624,  -324, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5641, -5642, -5642,
   -5642, -1285, -5642, -5642, -1234, -5642, -5642, -1284, -5642,  -895,
   -5642, -5642, -5642,  1902,  3676, -2326,  -180,  -575, -5642, -4201,
     143, -4457, -4335, -5642, -5642,  -781, -1396, -1391, -1140, -5642,
   -5642, -5642, -5642, -5642, -5642,  -218,  -348,   144, -4571, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -4493, -4471,  -466, -5642,
   -5266, -5642,   -66, -5642, -3702, -5642, -5642, -5642, -5642, -5642,
   -5642, -1245, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -4394,
   -5642, -5642, -1063, -1072, -5642,  -968, -3317, -5642, -5078,  -956,
   -1424,  -955,  -952,  -951, -5642, -1603,   474,  3527, -5642, -5642,
   -5642,   148, -1505, -1741, -5642,   992, -1381, -1520,  1013, -1058,
   -4554, -3335, -1388, -5642, -1418, -5642, -5642, -3847, -3845, -5642,
    -692, -2374, -3778,  -975, -5642, -5642, -2147, -4464, -2805, -5642,
    2633,  2622, -2533, -2508, -2399,   928, -5642, -5642,   454, -5642,
   -2002,   455, -5642, -5642, -5642,   464, -5642, -1236, -5642, -5642,
   -5642, -5642, -4257, -5642, -3033, -4745, -5642,  4711,  4714, -4217,
   -1197, -1196, -5642, -5642, -5642,  -716,  1346, -5642, -4035,  -969,
    -988,  -980, -3765,  -619, -5245, -3947, -3905, -4053,  2639, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  -398,  -397,   813, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,   209, -3064, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5126, -3316, -5642, -5642,  -146, -4324, -4426,
   -4424, -4360,  3309, -5642, -5642, -5642, -5642,  3721, -4003, -3811,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  2864,  1261, -5642,
   -5642,  1379, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,  -770,  1391, -5642, -5642, -5642, -5642, -5642,  1934, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  -912, -5642, -5642,
   -5642, -5642, -5642,  -599,  2705, -5642, -5642, -5642, -5642,   -26,
   -5642, -5642, -5642, -5642,  1539, -5642, -5642, -5642, -5642,  2132,
   -5642, -5642, -5642, -5642, -5642, -5642,  1104, -5642,  1767, -5642,
   -2995, -5642, -5642,   612,  -624, -5642, -5642,  -426, -5642, -5642,
   -5642, -5642, -5642,    49, -5642, -5642, -5642,  4713, -1957,    19,
    -469, -5642, -5642,     8, -5642, -5642,  3791,  -511,  1582,  -756,
    4472, -5642, -5642, -5642, -5642, -3005,  1458, -5642,  3848, -5642,
   -5642,  4029,  1257,  3810,  1330,   200,  1551, -2120,  -632, -3641,
     504, -5642,  1550,   323,  9838, -1881, -2011, -5642, -5642,   -81,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1655,
    1661, -5642, -5642,  3167, -5489, -5642, -5642,  -811, -5642, -3019,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     986, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642,  3112, -2040, -5642, -5642,  3267,
   -5642,  1079, -5642,   184, -5642, -5642, -1582, -5642, -3363, -5642,
   -5642, -5642, -5642, -5642, -1962,  -667, -5642,  3260, -5642,  3301,
   -5642, -1287, -4645, -2188, -1078, -5642,  -845, -5642, -5642, -5642,
   -5642, -5642, -3684, -1190, -1183, -5642, -5642, -5642,  2872, -5642,
    3889, -5642, -5642, -5642, -5642, -5642, -5642,  2880, -5642, -2588,
   -5642, -2994,  3896,  3907,  3908, -5642,  3912, -5642, -5642, -2199,
    -310, -5642,     6, -5642, -5642, -5642, -5642, -5642,   487, -5642,
    -820,   115,  -819, -4660, -1983,   714, -5642, -5642, -2313,  2896,
    3324, -1385, -5642,  2085, -5642,  2887,  1048, -5642,  1405, -5642,
     379,   381, -5642, -5642,  1054, -5642, -5642, -5642, -5642,  -129,
    -690, -5642, -5642, -5642,  -515,   149, -2559, -5642,  -117, -3762,
    3913,  -292, -5642,  1406, -2372, -3758, -1278,   254, -1347,  1414,
    -141,  4561,  -527, -5642, -5642,  3885, -5642, -3166, -5642,  -705,
   -1995, -1470, -3659, -5090, -3824, -5642, -2756, -5642, -5642, -5642,
   -5642, -5642,   403, -5642, -5642, -5642,  2136, -5642,  4851, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  -746,
   -1262, -5642, -5642,  1924, -1937,  -586,  4872,  -425, -5642, -5642,
    -424, -5642, -5642,  4671, -2464, -5642, -5642,  4156,  2675,  1890,
   -5642,   732, -5642, -5642, -5642, -5642,   589, -5642, -5642,  -362,
   -1128,    27,  1407, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     163, -5642, -2264, -5642, -5642, -5642, -5642,  -409, -5642, -5642,
   -5642, -5642,   558, -5642, -1050, -5642,  -399, -5642, -5642, -5642,
    4481, -5642, -5642, -5642, -5642, -5642, -5642, -4446, -5642, -5642,
    2744, -1812,  4483, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
    2297, -5642, -5642, -5642, -5642, -5642, -5642,  3134,  4684,  -694,
   -2085, -5642, -1098,  2298,  1594, -1126, -5642, -5642, -5642,  3920,
    4688, -5642, -5642,  4862, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642,  2255,  -382, -5642, -5642, -5642, -5642, -5642,
     -98, -5642, -5642, -5642, -5642,  3038, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642,  3477, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
     755, -1031, -5642,    97, -1076, -5642,  -212, -5642, -5642, -5642,
   -5642, -5642, -1142, -5642, -5642, -1147, -5642, -1455,  4396, -1342,
   -5642, -2156, -3942, -5642,     4, -5642, -5642, -5642,  2306, -5642,
   -5642, -5642, -5642,  1940, -3044, -5642,   -58, -5642, -5642, -3163,
    -958, -2082, -4267,  1385, -5642, -5642,    29,  3180,  4743,   -60,
     299, -1331, -5642, -5642,  1888,    -3,  1855,  -321,  -727,  -796,
   -1141, -5642,  8557, -5642, -5642, -3352,   186,  -637,  -539,   227,
      92,    50,    47,    26, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642,  1647,  1650, -5642,  4719, -5642,  2689,
    2404, -5642, -5642, -5642,  1654, -5642, -5642, -5642,  4728, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,  1663,
    1665,  1667, -5642, -5642,  1106, -2819, -5642, -5642, -2353,   142,
   -5642,  2726, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,
   -5642,  3048,  -605,  -592,  3259,  4739,  4232, -5642,  3523, -5642,
    3530, -5642,   913, -5642, -1297,  1733, -1823, -3923, -5642, -5642,
    2152,   477, -5642, -5642, -3041, -3587, -5642,  1583,   380, -5642,
   -5642,  -241, -5642, -5642, -5642,   909,    96,  4717,  4106, -5642,
   -5642, -5642, -5642,  4941,  2106, -5642,  1122,  4968,  4975,  4976,
    -192, -5642, -3800, -5642, -4676, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5095, -5642, -5642, -5642,  2265,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642,   -75,
    4477, -5642, -5642, -5642,   838, -3136, -3349,  -675, -5642, -5642,
   -5642, -5642, -5642,  2743, -5642,  1320, -5642, -5642,  -774, -2377,
   -5642,  -330, -2640, -5642, -4277,    24,  -617,  4493, -5642, -5642,
   -5642, -5642, -5642,  4475, -5642, -5642,   651, -5642, -4323, -4327,
    -769, -5432,  -931, -4291, -5642, -4264, -5642, -5642, -5642,  1056,
   -5642, -5642,  1607, -5642, -5642, -5642, -5642,  -302,  -307,  -291,
   -5642,  -289, -5642, -3731, -5642, -5642, -5642, -5642,  -297, -5642,
   -5642, -3928, -5642, -5642,  -106, -5642, -5642, -5642, -5642, -5642,
   -5642, -5642, -5642, -5642, -5642, -5642, -5642, -5642, -2693, -5642,
   -5642, -5642,  3655, -5642,  4611, -5642,  -971,  4492, -5642, -5642,
   -5642, -5642, -5642, -5642,    48, -5642, -5642, -5642, -2583, -5642
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,   476,   767,  2388,   477,   478,   479,   480,   481,  2354,
     482,  1335,  3127,  1337,  2319,  3130,   483,   736,   484,  2531,
    3341,  3342,  5052,  5053,  5046,  5047,  5049,  5050,  3343,   855,
     856,   485,  3183,  4421,  3878,  2390,  5216,  3177,  5501,  2395,
    5219,  2396,  5220,  3175,  4437,  4934,  2402,  2403,   776,  4422,
    3971,  3972,  1396,  3874,  3980,  3981,  3190,  4922,  5032,  5868,
    5036,  6011,  6151,  5964,  4008,  5391,  5869,  5870,   669,  1407,
    2674,  5967,  2492,  5814,  5586,  5587,  3268,   486,   847,  1521,
    2520,  2521,  5284,  5285,  4063,  4064,  4065,  5583,  5584,  5805,
    4917,  5277,  4925,  3112,   984,  1821,  3405,  3406,  2597,   872,
     873,  2605,   874,  3431,  3366,  4132,  4133,  4625,   875,  4102,
    4103,  4104,  3435,  1206,  4105,   487,   488,   690,   699,   691,
    1203,  2985,  1204,   489,   490,   734,  2344,  2345,  2346,  2347,
    3840,  3146,  3834,  3835,  4855,   876,   877,   985,   670,   986,
     987,   988,   989,   990,   991,   992,   993,   994,   963,   851,
    3465,  3516,  4153,  3466,  4134,  3517,  2724,   995,   996,   997,
     998,   999,  1968,   964,  2694,  4143,  4639,  1000,   645,   852,
    1524,  2525,   853,  2526,  4017,   854,  2523,  1527,  4158,  2662,
     918,  1887,  1001,  1212,  4159,  1002,  2731,  2733,  2730,  4157,
    5085,  2732,  1003,   680,   709,   668,  1885,   696,  5281,  5593,
     825,   826,   863,  3364,   827,  1534,  1494,  2497,  3296,  3297,
    3986,  3987,  4052,  4053,  4054,  3288,  3289,  3290,  3353,  3354,
    3355,  3277,  3278,  3279,  2501,  3274,  3275,   828,  1495,  1506,
    3291,  3292,  3293,  4058,  3357,  3358,  3359,  3360,  3294,  2651,
    3295,  4495,  4901,  5273,  4902,  5567,  4782,  5268,  5269,  5270,
    5655,  3819,   494,   683,  1189,  2173,  2977,  4304,  3700,  3702,
    2978,  4303,  4764,  4765,  4766,  3698,  3699,  5729,  3704,  4301,
    5901,  6282,  6033,  6034,  4293,  6038,  4773,  5164,  5165,  5471,
    5730,  5907,  6169,  6039,  6289,  6167,  6285,  6168,  6287,  6436,
    6379,  6380,  6179,  6300,  6301,  6384,  6437,  6049,  6050,  6051,
    4298,  5468,  5780,  3865,  3866,  2487,  5631,  1346,   495,  4903,
    5016,  4904,  4905,  5537,  6107,  4906,  4907,  4908,  4127,  2249,
    5563,  5549,  4932,  5671,  4909,  5224,  5225,  5226,  5227,  6073,
    6218,  6075,  6076,  6211,  6323,  6210,  5228,  5229,  5509,  5937,
    5517,  5351,  5230,  5231,  5232,  5524,  5771,  5939,  5935,  6083,
    6084,  6456,  6457,  6100,  6414,  6101,  6463,  6499,  6500,  6085,
     496,   682,  2122,  6233,  6234,  6235,  1823,  5772,  1824,  1825,
    2568,  1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,
    1835,  3428,  2615,  2556,  3379,  3380,  2547,  2548,  2614,  6102,
    6103,  3372,  2552,  6336,  2553,  3395,  6246,  6086,  6104,  6088,
    2572,  2200,  2201,  3913,  2215,  2216,  3384,  3016,  3385,  2490,
    2573,  2574,  3388,  2575,  3393,  4738,  5456,  4744,  4745,  4746,
    4262,  4263,  4264,  4265,  4266,  3661,  6089,  5764,  6071,  6213,
    6216,  6330,  6448,  5518,  5233,  5522,  1305,  5234,  5235,  6187,
    6200,  6204,  6188,  6205,  6201,  5931,  3869,  6189,  6190,  6191,
    6207,  6203,  4412,  6192,  5748,  6060,  5749,  5505,  3397,   497,
     633,  4548,  1482,  3254,  1484,  1493,  4012,  3305,  3304,  1499,
    1498,  3283,  4513,  4987,  5330,  4547,  4009,  4552,  5680,   812,
    5018,  6001,  5845,  6009,  5019,  5202,  5020,  5988,  6138,  5021,
    5864,  6007,  6147,  5203,  5204,  5022,  5023,  5024,  6307,  6308,
    6309,  5339,  2294,   831,   832,  1511,  1512,  1513,  3460,  5675,
    5363,   498,  3167,  3162,   499,  1363,  1364,  1365,  2366,  2367,
    3165,  3166,  3860,  4402,   500,  1330,  3123,  2356,  3154,   501,
    1349,  3851,  3852,  3853,  4397,   502,  1519,  2517,  2518,  3309,
    4559,  5044,  5396,  5688,  5876,  5684,  6018,  6019,   503,   859,
    1530,   504,   647,  2540,  2541,  2542,  3345,   505,  1979,   641,
     506,  2182,  2179,  2991,  2992,   507,  1329,  2306,  2307,  2308,
    2309,  3815,   508,  2702,  3483,  3484,  3485,  3486,  3118,  4374,
    3119,  3120,  3824,  4645,   509,   790,  1474,   510,   789,  1473,
     511,   512,   708,   762,   701,  2191,   514,   515,  4783,  2775,
     517,   796,   794,  1153,   519,  1467,  1463,   520,  2776,  1154,
     786,   787,  1415,  1233,  3898,  3899,  2635,  2636,  3223,  3210,
    1234,  1235,  1444,  2465,  3240,  3005,  3006,  2290,  3007,  4319,
    4792,  6411,  2008,  1897,  1333,  1156,  1157,  2141,  2142,  2149,
    1158,  2143,  2931,  4708,  5127,  5128,  5129,  5130,  5447,  2860,
    2861,  2972,  1159,  2846,  1160,  1161,  1162,  1163,  1164,  1165,
    1166,  1167,  1168,  1169,  2967,  4688,  4689,  5109,  3693,  3694,
    3695,  1170,  3545,  4672,  3556,  3557,  2804,  1171,  1172,  1173,
    1174,  1175,  4286,  1176,  4760,  4470,  1177,  1980,  2738,  2802,
    5097,  4677,  5425,  5099,  5100,  5429,  2743,  3533,  4186,  5088,
    5090,  5091,  4187,  4188,  2864,  2865,  2029,  2030,  1997,  1998,
    4241,  1416,  5293,  1417,  5605,  5972,  5973,  6130,  6361,  6268,
    6269,  6476,  6477,  6478,  6479,  1418,  3196,  4935,  1419,  1420,
    1421,  4454,  4455,  5294,  4939,  5296,  4943,  2426,  2427,  2430,
    2431,  1422,  1423,  1424,  1425,  2414,  1426,  1427,  1428,  3215,
    5824,  5302,  5303,  5982,  5981,  5304,  4948,  4949,  4458,  4459,
    4835,  4836,  4837,  3909,  2798,  2799,  2876,  2707,  2708,  2709,
    2744,  1436,  2441,  3231,  3919,  2443,  3917,  4465,  3921,  4471,
    4472,  2962,  3686,  4282,  3688,  5155,  5463,  5464,  5722,  5891,
    5892,  5897,  5027,  5652,  5653,  3446,  1445,  3248,  3936,  4468,
    2251,  2252,  1447,  2447,  3235,  3925,  2253,  2454,  2455,  3930,
    4121,  1448,  1449,  1461,  1466,  1452,  1450,  3436,  4983,  3437,
    4267,  4249,  5208,  4496,  2767,  2768,  5530,  5139,  1453,  3251,
    4482,  4483,  4484,  1432,  1433,  2436,  2437,  2438,  1454,  1434,
    3224,  4461,   521,   729,   522,  2658,   903,  1882,  2657,  3831,
    1532,  4311,  2630,  2631,  1869,   820,   667,   523,   671,  4640,
     524,   697,  4310,   965,  3269,  1925,  2184,  1926,  2996,  3714,
    3715,  4784,  5175,  4785,  5168,  5169,  4786,  1318,  5479,  5480,
    1480,  4509,  4510,  4504,  3107,  3805,  1319,  2295,  4364,  3104,
    4365,  3105,  4366,  5416,  5883,  6280,  3101,   525,   706,  4822,
    5911,  4358,  4359,  6371,  6372,  1316,   526,   652,  2629,   899,
    1858,  1861,  1862,  2639,  5070,  3442,  5406,  4620,  5069,  1863,
    1864,  3444,   900,   901,   527,   750,  3861,  1369,  2273,  2274,
    2275,  3088,   528,   703,  1306,  4353,  4819,  3074,   686,  1880,
    2256,  1309,  2257,  3070,  3789,  2237,   529,  1471,  1470,   846,
     530,   531,   802,   642,  2469,   532,  1338,  2337,  3143,  4380,
    4381,  4840,  2338,  2339,  3832,   533,   715,  1323,  3828,  5209,
    5210,  5498,   534,   741,  1353,  1354,  2360,  2358,  3856,  3157,
     535,  2979,   536,   672,   968,  1929,  1930,  2700,   537,   744,
    1358,   538,   539,   970,  4646,  6158,  6374,   676,  2704,  1934,
    5568,  4951,  5309,  5310,  5312,  5621,  5622,  6433,  6526,  6540,
    6533,  6543,  6544,  6547,  6553,  6554,  1178,  1376,  1377,  1179,
    6238,  1180,  1181,  1182,  2777,  1322,   711,  2298,  2299,  5490,
    5742,  3111,  3808,  2691,  2692,  2300,  5170,  5171,  3724,  3918,
    1183,  4360,  5506,  1533,  2632,  1341,   610,  1184,   611,   822,
    1378,  2433,  3493,  1256,  3737,  1186,  4160,  1489,  2180,  2506,
    2507,  3494,   613,  3738,  1257,  1837,   614,   615,   616,   617,
     618,   619,   620,   621,  1844,   548,   702,  1265,  2212,  2220,
    3025,  2210,  3037,  3770,  3039,  3040,  3775,  3041,  1312,  3011,
    2211,  3759,  4805,  4804,  3038,  4345,  5190,  5189,  3042,  3033,
    4341,  4327,  3747,  4799,  5485,  5484,  3020,  3019,  3018,  3028,
    3029,  3030,  3031,  4338,  3755,  2480,   549,   971,  2713,   679,
    1936,  1937,  3507,   550,   705,   551,   735,  1343,  3150,  3844,
    3845,  4393,  4857,  4394,   552,  1218,  1219,   553,   955,  3872,
    3469,  2647,  1492,  2648,  2675,   958,  1889,   959,   960,   961,
     962,  4537,  4001,  4002,  3474,  2655,  2508,  3001,  3994,  4973,
    2509,  4531,  4532,  4974,  3302,  5697,  4544,  4005,  5413,  4630,
    5698,  5699,   554,   716,   555,  5588,   728,  1332,  2316,   556,
     557,   558,   559,   795,  1457,  1236,   634,   635,   636,   637,
     835,   836,  4011,  4554,  5039,  5040,  5682,  6536,  6537,  3189,
    4435,  6124,  6471,  6530,  6549,  5598,  5599,   560,  1383,  1379,
     761,  2386,  2380,  2382,  3173,  3864,   561,   562,   563,  4918,
     564,  1965,  2728,  4156,  3478,  2527,  1845,   622,  1948,   886,
    4406,   920,  3407,  1321,  3108,  2660,  1004,  1005,  5955,  3412,
    5807,  5585,  2528,  2529,  5796,   887,   888,   566,   567,  1475,
    3252,  3253,  1006,  1007,  4373,  4831,  4832,  5199,  4926,  4927,
    4920,  5969,  6466,  4427,  2303,  5961,  5962,  6257,  6470,  4431,
    4432,  4433,  3880,  3881,  6115,  5790,  5791,  5792,  5951,  5799,
    6254,  5797,  6253,  5793,  6112,  6351,  6110,  6350,  5794,  5579,
    5580,  5795,   889,  4067,  5815,  5966,  3883,  4434,  5589,   568,
     569,  3187,  4440,  4438,  5276,  5575,  5947,  6252,   890,   891,
    1853,   892,   893,  2624,   894,  2545,  1008,  1009,   570,  1010,
    2735,  2734,  4163,   721,  1011,  1327,   651,  1852,  2304,  3812
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     612,   719,   834,   681,   540,   644,   763,   720,   518,  1308,
    1254,  1304,  2766,  1963,   880,  1822,  2470,  2957,   840,   516,
    1491,  2987,  3170,   724,   565,  2280,   547,  1268,  1414,   541,
    2906,  3271,   692,  2828,  2549,   491,  3149,   692,  3438,  3439,
    2808,  3525,   692,   492,   493,   707,   830,   546,   571,   513,
     545,   921,  2444,  2641,  3479,  3132,  2569,  2774,  1879,  4077,
    2841,   700,  1334,  3389,   956,  1259,  3809,   902,  2181,   905,
     906,   907,   908,   909,  3420,   911,   912,   957,  3447,   914,
     915,  1211,  2555,  4320,  2652,  3937,  2488,  3823,  3250,  1490,
    4084,  2489,   544,  2669,  2613,   956,  2460,  4584,  2456,  3389,
    2434,  2456,  1360,  4413,  2031,  1367,  3100,  2375,  1220,  1210,
    2559,  4919,   881,  4933,  1531,  3058,  3059,  1855,  2202,   850,
    2205,  2206,  5025,  3820,  5026,  2409,  4946,  4623,  2219,  4352,
    5278,  2887,  4497,  4912,  4460,  4161,  4162,  2986,  3873,  2942,
    2943,  2944,  2945,  2946,  2947,  2948,  2950,  2952,  2953,  2954,
    2955,  2956,  3526,  2910,   732,  3515,  2247,  3065,  4497,  4497,
    3256,  4362,  3519,  1260,   731,  1370,  1371,  4486,  4475,  3145,
    5059,  4652,  4059,  4060,  2551,  4479,  4016,  3081,  2281,   695,
    2579,  4194,  3833,  1320,  5572,  3280,   542,  2987,  4190,  3900,
    3900,  4191,  4190,  5601,  1390,  4191,  1391,  1846,  3390,  1393,
    1394,  3756,  3094,  3095,  3901,  3989,  2557,  2282,  4401,  3421,
    3750,  3990,  4556,  5017,  3768,  5387,   841,   842,   843,  1991,
    3142,  4911,  4497,  4497,  3905,  3219, -3439,   543,  3419, -3440,
    3432,  3356, -1077,   844,  2557,  1839,  2576, -2867,   726,  4780,
    1963,  2571,  2571,   845,  1478, -1935,  2578,  -658,  2919,  4425,
    1537, -2567,  2571,  5042,  1478,   880,  5686,  2519,  5753,  5754,
    3985, -2568,  2930,  2932, -2167,  2935,  2936,  2583,  -554,  1465,
    2560,  4049,  4056,  -364, -3708,  1478,  4779,  4780,  4057,  2584,
    2577,  2077,  4295,  2586,  1464,  5298, -3704, -3701,  3432, -2712,
    -375,  2705,  3344,  2595,  4425,  2598,  2599,  2600,  2601, -2673,
    2602,  2588,  3991,  2986,  2557,  2594,  -659,  2238,  3432,   824,
    2607,  2608,  2609,  2610,  2611,   739,  4429, -3706,  1870,  1238,
   -2677,   740, -3702,  1523,  2484, -3705, -3703,   723,  2103,   643,
    1883,  1884,  2616,  1840, -2673,  2118,  2120,  2121,  5176,  2484,
    2617,  5060, -3439,  2582,  5692, -3440,  6120,  2163,   954,  2571,
    6356,   748,  4426,   881,  2107, -2677,  4444,  4462,  4463,  6288,
    3432, -3516,   833,  3432,  3432,  5395,   743,  4569,  2759,  2760,
    2761,  4527,  2762,  4676,  2763,   808,  2764,  2581,  2585,   954,
     673,  5528,  4596,  3527,  2571,  5970,  3541, -3439,  5582,  4999,
   -3440,  1478,   808,  4789,  4790,  3432, -2228,  4426,  2484,  4246,
    3432,  1328,  3432,  4403,  5082,   684,  3867,  3432,  3432,  3958,
   -2728,  2745,  2746,  2606,  4502,  1344,  4528,  4543,  5336,  2589,
    2756,  3900,  2759,  2760,  2761,  2557,  2762,  2550,  2763,  2557,
    2764,  3458,  6055,  3940,  3941,  4114,  2759,  2760,  2761,   723,
    2762,  3416,  2763, -2729,  2764, -2730,  5773,  3696,  5272,  4806,
    3468,  2818,  4335,  2821,  2314,  2557,  2557,   742,  1399,  1905,
    5136,  1478,  1967,  1478,  2557,   638,  4506,   677,  5531,  2835,
    2836,  2243,  2839, -2010,  1912,  5533,  2637,  4248,  2847,  2848,
    5535,  5553,    42,   764,  2853,  2484,  1974,  2705,  1478,   638,
    5523,  1478,  4147,  1478,  6473,  1238,  5337,  1446, -3328,  4549,
    6412,  5358,  1446,  5083,  1446,  5938,  5919,  3121, -2167,  5279,
   -2167,  1331,  1468,  6274,  3801,  6520,  5849,  1518,  5338,  4508,
      42, -2561,  1478,  6118,  4781,  6286,  2150,   805,  6290,  6122,
     688,  2710, -2867,  4378, -3439,    49,  3008, -3440,  5105,  3458,
    5507,  2129,  2130,  2131,    51,  2132,  2204,   745,   518,  6026,
    4740,  2705,  4439,  1903,  3992,  2151,  2152,  2417,  2128,   807,
    2129,  2130,  2131,  2445,  2132,  4396, -2357,  6365,  5082,   785,
    3179,  5990,  1361,    49,  3009,  2134,   885, -1935,  2561,  3409,
      14,  1406,    51,  6028,  2311,  1455,   857,  5932,  1405,   513,
    2565,  1878,  1238,  3821,  2563,  2742,  6474,   864,  2419,  4980,
    3391,   693,  3163,  4741,  5236,  6237,   722,  5595,  3822,  3459,
     913,  2485,  4545,   784,  1281, -2357,  2563,  3670,   717,  2153,
     813,   644,  4351,  5991,   644,  4928,  2485,   823,   829,    23,
    5341,  5137,  5343,   723,  1913,  5353,  3410,  4923,  4770,   785,
    3712,  1451, -3499,   674,  1456,  1517,   540,   829,  4762,  5371,
     518,  5525,  6237, -3503,  2755,  2276,  1414,  1362,  3164,  4740,
     829,   516,  2135,  3582,  2420,  6366,   823,  5083,  3504,  5357,
    2446,  5630,   791,  3122,  2634,  2421, -1935,   884,  1347,  1906,
     763,  2135,  5017,  2422,  4929,  2485,   857,  3300,  5877,   857,
    1208,   513,  5895, -1935,   547, -3502,  3671,   823,   546,   848,
    2920,   545,  3282,  5106,  2154,   792,  2711, -2357, -3500,  -216,
    2423,  1324,  4741, -3501,  1209,   546, -3506,  3459,   545,   823,
   -2357,    39,  3505,  4379,     4,     5,  5898,  1472,  1264,  3010,
   -1935,  1255,  1342,   823,    42, -1935,  6434,  5359,  6008, -2010,
    2654,  1975,  2712,   883,  2419,  3752,  6429,  4601,  3362,  1263,
    1355,  2128,  1262,  2129,  2130,  2131,  5236,  2132,   895,  6413,
     544, -3328,  1907,  4930, -2357,  1389,  4550,  2424,  2134,  2666,
    4497,  5761,  2485, -2357,   718,  1914,  2277,   640,    47,  2921,
    2505,   805, -2357,   839,  2532,  2384,  2315,    49,  3672,   860,
    1281,  5280,  4807,   896,  1261,  2425,    51,  4508,  1469, -3439,
      42,   640, -3440,  1462,  5011,  6420,  1476,  1477,   712,   917,
    2420,  5743,  1325,   823,  5569,  1496,  4512,  2391, -2228,  2546,
    2394,  2421,    42,  1012,  2397,  2398,  2400,  2401,  3871,  2422,
    6475,  3868,  5360,  4507,  6521,   823,  1400,   879,  1481,  3802,
   -3625,  2244,  2539,  2137,  4629,  1522,   840,  1314,   793,  5990,
    1507,  2652,  3697,    49,   542,  4336,  2423,   805,  6092,  1496,
    4351,  4059,  4060,  2565,  3926,  5178,   677,  4429,  3542,  6272,
    2317,  2922,  4523,  4524,  2135,    49,  3900,  4546,   882,   685,
   -2228,  2566,  4337,  2546,    51,  3443,  4776,  1281,  1258,  4536,
    4443,   678,   677,   547,  3989,   543, -1935,  1865,  1843,  1867,
    3990,  5991,   644,   644,   644,   644,  1875,  1496,  4449,   823,
    3911,  4969,  4453,  2424,   546,  3417,  2194,   545,   884,  3301,
    5582,  6417,  2510,  3171,  5057,  2203,  5818,   677,  2207,  3664,
    3665,  1877,   713,  2217,  1881,  2239,  4590,  4591,  4404,   546,
    4333,  2425,   545,   763, -3516,   814,  2473,  5821,   817,  5822,
    4006,  2539,  5025,  2317,  5026,  4525,  1464,  4984,  5378,   544,
    6284,  4056,  3973,  2250,  1842,  4592,  3280,  4057,   805,  1479,
    5701,  1954,  6331,  3477,  6333,  6334,   749,  3433,  1958,  1479,
    1961,  4529,  2567,  3993,   883,  3988,  5952,  2278,  -114,  5043,
    -114,   540,  5687,  2150,  1969,   518,  5965,   675,  1947,  1947,
    1479,  1947,  1947,  1947,  5321,  2706,   516,  3796,  1947, -3439,
     475,   565, -3440,   547, -2712, -1077,   541,  3903,  3904, -2567,
   -2867,  2646,  1946,  1946,  4097,  1946,  1946,  1946, -1935, -2568,
    -658,  5954,  1946,  2078,   546,  3433,   513,   545, -2712,  4094,
    4095,  2554,  3356,  5017,   841,   842,   843,  2999,   475,  -364,
   -3708,  -554,  4055,   542,  2772,  3433,  3678,  3679,  1838,  3682,
    3683,   844, -3704, -3701,  1945,  1945,  3012,  1945,  1945,  1945,
    2031,   845,  5570,  -375,  1945, -2673,  6399,  6400,   879,   544,
    2104,  3023, -2673, -2673,  6295,  6296,  2153,  6406,  4499,  -659,
    2488,  6183,  3056, -3706,   543,  2489, -2677,  5336, -3702,  1841,
    3236, -3705, -3703, -2677, -2677,  2456,  2108,  3433,  2104,  4130,
    3433,  3433,  2440,  3062,  5236,  3064,  1479,  5061,  3068,   882,
    5693,  -118,  6121,  -118,   809,  3398,  6357,  4464,  2765,  3205,
    3076,  4351,  3398,  3079,  5289, -2728,  2656,  3082,  6338,  4485,
    3220,  2727,  3433,  4247,  3433,  4742,  3387,  3433,  2126,  3433,
    2539,  4643,  2571,  2125,  3433,  3433,  6443,  2123,  -110, -2728,
    -110,  3371,  5878,  3374,  3097,  3098,  3099,  4192, -2729,  4193,
   -2730,  2154,   746,   542,  3413,  5337,  3386,  3414,  2118,  2120,
    2571,  1446,  2840,  2571,  5196,  3422,  1479,  3093,  1479,  2505,
    5313,  2571, -2729,  5316, -2730,  3399,  6454,  5338,  5317,  1944,
    1944,  2706,  1944,  1944,  1944,  6184,   823,  3404, -3531,  1944,
    5215,  1904,  2218,  1479,   543,  5361,  1479,  2407,  1479,  2988,
     747,  6392,  3423,  2539,  4931, -3499,  1871,  1872,  1873,  1874,
    3301,  3673,   898,  2736,   823,  3572, -3503,  3022,  3575,   857,
    3771,   857,  4323,   823,  6029,  5236,   823,  1479, -2357,  3506,
     648,   823, -2167, -2167,  4742,  2567,  3590, -1935,  6077,     4,
       5,  4122,   475,  2973,  2352,  2706,     4,     5,  4512,  2385,
    3606,  4743,   956,  2138,  2139,  2140,  2150,  3347, -3502,  6421,
     717,   823,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,
     678, -3500,  2138,  2139,  2140,  3753, -3501,  3455,  5811, -3506,
    5798,  4952, -2228,  3197,  3233,  2151,  2152,  4123,  1509,  5353,
    3754,  2377,  4610,  3301,  2923,  4955,   678,  5319,  6444,  2301,
     805,  2153,   714,  2974,  6468,  5327,   805,   805,   475,   717,
     858,  5871,  1438,  2753,  4248,  4248, -3531,  1387,  4248,  4248,
    2240,  2258,  2150,  2353,  4248,  4248,   717,  5131,  5581,  3848,
     475,   678,  2363,  3974,  2959,  3705,  2355,  3026,  4190,  4557,
    5576,  4191,  3996,  2004,  2005,  2006,   805,  2376,  5842,  2153,
    5844,  2151,  2152,  5847, -1895,  2245,  4982,  1440,  3475,  5328,
    5852,  5853,  5997,   694,  3060,  2988,  3376,  2389,  1430,  2934,
    5859,  5990,  2590,  3000,  4384,  4385,  5236,  4985,  3066,  2533,
    -994,  2855,  5784,  4059,  4060,  2174,  2154,  3262,  3377,   805,
    2416,   717,  2057,  2392,  2393,  6538,  2125,  2062,  2879,  3833,
    2123,  2483,  3373,  2715,  5045,  5299,  5703,  3900,  3900,   677,
    2439, -3338,  3995,  2721,  3989,  2153,   718, -3742, -2411,  4409,
    3990,  4936,  4937,  5991,  6077,     4,     5,  4349,  2463,  5507,
    4497,   717,  3894,  6186,  2154,  5673,  4940,  4941,  3276,  5469,
    2312,   646,  1490,  3975,  3080,  6078,   717,  5765,  2471,  2472,
    3976,     4,     5,  5902,   540,  1462,  3977,  2169,   518,  -796,
    2341,  6534,  6261,  3282,  5056,  2138,  2139,  2140,   966,   516,
    3997,  2357,  1922,  5346,   638,   805,  6445,  6539,  6113,  6093,
     865,   866,   710,  4056,   823,  2178,  5798,   895,  4800,  4057,
    6446,  6030,   644,   805,  1222,  3849,   805, -3743,  3286,   513,
    2154,  4986,  4809, -2411,  4428,  6094,  4812,   805,  6119,  1254,
    3996,  4971, -1895,  1490,  4305, -3739,  6079, -3531,  1414,  3923,
    3256,   723,   896,  2649,  5347,  4604,  1268,  4606,  6245,  6182,
    6136,  3978,  2987,   763,   649,  4410,   954,  3482,  4210,  3362,
    5623,  1500,  4376,  3821,  6418,  1922,  5508,   718, -3737,  4062,
    3389,  -994,  3389,  1223,  3821,  6114,  5674,  5236,  3822, -2411,
   -1315,  5998,  2369,  5300,  1259,  1501,  -994,  3515,  5538,  3822,
    4649,   956, -2359,  5074,  5075,  1238,  5990,  3257,  5551,  5552,
    5577, -3740,  2975,  1431,  3013,  2150,  2128,   718,  2129,  2130,
    2131,  3155,  2132,  3979,  2133,  5782,  2561,   780,  5784,  1932,
    3027,  5872,   718,  2134,  6535,  1502,  6080,  6095,  2246,  6096,
    2562,  2591,  2563,  6183,  2151,  2152,  6078,  2534,  3850,  4124,
    2175, -2359,  3281,  -769,  4136,  3280,  5556,  4147,  5991,  3045,
    4581,  6078,  5801,  6109,  6111,  2241,  2259,  2994,  3997,  2739,
    1414,  3276,  1302,  3103,  5705,  1991,  2505,  2313,  2986,  2561,
    3706,  1414,  1414,  4351,  3988,  6126,  1927,  2235,  6502,  6031,
    5903,  5904,  1260,  1238,  2539,  2563,  4294, -3742,  3361,  3139,
    4558,  3999,   967, -1895, -3338, -3738,  1850,  5418,  2153,  3061,
    4696,  4280,  4281,  5725,  3249,  3720,  3721,  6079,  4299,  5927,
    3287,  1503,  4357,  3067,  5933,  5934,  3158,  2774,  2285,  2650,
    6135,  6428,  6079,  2535,  4787,  2536,  3677,  3848,  4287,  2135,
    3998,  1923,  1224, -2359,  1225,  4411,  3356,  6145,  6081,  6137,
    2749,  4055,  4687,  4279,  5301,  1226, -2359,  6184,  1504,  1510,
     650,  2157,  2158,  2159,  2160,  2161,  2162,  3378,  2370,   837,
     639,   717,  4350,  1227,  6077,     4,     5, -3743,  5873,  6199,
    3188,  3191,  4622,  6097,  5470,  6403,  2144,  5905,  2622,  2488,
    4972,  2136,  6472,  2154,  2489, -3739,   717,   956,  5329,  1443,
   -2359,  1924,  5643,  5711,  4273,  6245,  4276,  6080,  3258, -2359,
    2976,  6363,  5333,  6364,  1923,  3924,   640,   916, -2359,  2710,
    3793,  2493,  6080,  5333,  2537,  4386,  6276,  4582, -3737,  6093,
    3181,  3182,  6447,  6032,  3185,  2236,   717,  2670,  6506,  3192,
    3193,  3194,  6247,  1933,  6249,  2150,  2514,  3244,  6183,  2671,
    5221,  2144,   897,  2958,  6079,  6094,  2619,  1855,  3709,  3710,
    6000, -3740,  5906,   678,   805,  5783,  2633,  3570,  2488,  3999,
    4387,  5846,  6260,  2489,  2151,  2152,  2643,   644,  2564,  1788,
     869,   870,  2145,  6067,   823,   954,  6315,  3751,   823,   805,
    6317,  1438,  3286,  6390,  6389,  1439,  3749,  4445,  2146,  2538,
    1281,  2137,  5856,  3849,  6098,  3929,  2672,  3932,  3933,  1928,
    2456,  2565,  2456,  2456,  3767,  1409,  -994,   823,  3772,  6081,
    3892,  3461,  3462,   823,  3315,   804,  3893,   718,  2649,  2566,
    4583,  4000,  4388,  1868,  6081,  1281,  1440,  6355,  2153,  4614,
    4919,  1441,  5426,  2196,  6080,  3783,  5557,  2145,  5558,  3784,
    2750,  3786,   718,  1485,  1228, -3738,  1851,  6095,  2717,  6096,
    2550,  2286,  6184,  2146,  2565,  3791,  2264,  5340,  4526,  2147,
    5590,  5862,  5352,  5513,  1442,  4389,  2533,  5362,  3798,  3799,
    2938,  6078,  2566,  6404,  6185,  5559,   805,   823,  1281,  3408,
    5184,   898,   753,   754,  2711,  5187,  5188,  5917,  2159,  2160,
    2161,  2162,  2872,  5465,  2873,  6186,  6082,  3479,  3313,  4616,
    2710,  -771,  3762,  2550, -1315,  5560,  3508,  2235,  6326,  5591,
    5993,  6057,  6346,  2154,  4996,  5349,  3850,  5514,   755,  4425,
    2539,  3144,   518,   791,  2147,  3276,  2125,  6202,  6206,  2350,
    2123,  3272,  3503,  2156,  2157,  2158,  2159,  2160,  2161,  2162,
    6312,   725,  6079,  3245,  3463,  2519,  6081,  2287,  4824,  4967,
    4589,  6006,  1401,  5662,  2924,  2150,   792,  3202,  2539,  3203,
     756,  5950,  3174,  2288,  1402,   717,  2939,  5918,  5086,  6501,
    3496,   954,  6440,  3180,  3287,  3675,  5696,  2197,  4466,  2673,
    2144,  4351,  2940,   805,  2151,  2152,  6415,  6416,   805,  6099,
    6087,  4351,  4351,  6097,  2650,  1970,  6396,   880,   805,  4825,
    2157,  2158,  2159,  2160,  2161,  2162,  6518,   833,  4956,  2907,
    5880,  1486,  3237,   921,  3225,  2980,  5515,  1211,  5305,  5306,
    1340,  5263,  4426,  5350,  6025,  4390,  4391,  4392,  2789,  1403,
    1487,  4467,  6080,   518,  1350,  1505,  6327,  6244,  5561,  6161,
    3273,  3811,  5995,  6232,  2916,  1971,   -71,  6449,  2153,  1229,
    1230,  1231,  1232,  2941,  6057,  2236,   791,  4148,  5592,  5994,
   -1375,   823,  3282,  2963, -1375,  6072,  6202,  6074,  3497,  1429,
    6206,  2351,  5562,  3270,  3071,  2711,  2145,  5744,  3763,   805,
    5001,   765,  6082,  3681,  6142,   823,   823,  5516,  6450,   792,
    3510,  2644,  2146,   823,  3014,   881,  3514,  2790,   737,   793,
    6186,  5521,  5521,  3083,  2534, -1375,  5307,  1320,  3238,  1972,
   -1375,   727,  5030,  6328,  3988,  3032,  3072,  5950,  6460,  1351,
     766,   718,   644,   644,   805,   644,   644,   644,   644,   805,
     823,   805,  4260,  2154,  6496,   757,   768,   644,  2254,  6224,
    5264,  1868,  2958, -1375,  6081,  6491,  4261,  1264,  3666,  2968,
    1255,  2203,   758,  3362,  3077,   644,  6162,   823,  4062,  6528,
    6529,  2255,  2791,  2147,  2792,  2265,  3373,  5611,  1263,  5612,
    2793,  1262,  6514,   857, -2359,  1352,   738,  1404,   759,   805,
    5638,  2969,  5816,  4055,  1973,  5308,  4351,  3239,  6341,  6342,
    2535,   805,  2536,  2567,  3959,  6194,  2420,  3937,  6527,  2874,
     857,  1535,  2875,  3690,  6212,   751,  4615,  2421,  2266,  5031,
    2267,  3691,  5667,  1261,  6461,  3216,  4129,  4634,  4635,   760,
    2128,  1891,  2129,  2130,  2131,  -770,  2132,   815,  2133,  2742,
    4351,  2794,   793,   717,  3286,  3692,  3746,  2134,  1443,   823,
    2138,  2139,  2140,  4277,  1963,  3286,  2567,  6492,  2144,  1876,
    4497,  4497,  3073,   698,   805,  2970,  1935,  4697,   704,  3160,
    5546,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  6462,
    5486,  5487,  6202,  6206,  3740,  2795,   904,  1564,  5346,  1892,
     823,  2537,  1893,   752,  1439,   810,  3206,  3176,  2817,   823,
     823,   823,  3207,   956,  3208,   805,  4753,   644,  4756,  3217,
    2399,  2148,  5114,  2268,  4497,  5547,  3717,  1258,  3847,  6099,
    1894,  4356,  4829,   805,  5619,  5115,  2291,  6303,  1895,   816,
    6306, -2329,  2512,  3281,   805,   805,  5620,  2425,  4489,  5347,
    1441,  5116,   823,  2613,  3324,  3325,  2971,  3837,  3838,  5802,
    3285,  1414,  5803,  2135,  2145,   689,  6069,  1414,  3821,  3337,
     689,  3854,  2269,  6442,   819,   689,  2538,  2742,  2742,  4395,
    2146,  5117,  1414,  3822,   763,  6041,  2148,  3209,  2796,  2292,
    2488,   818,  3741,  3960,  5548,  2489,  2742,  3276,  1345,  2797,
    4538,  4539,  5461,  5521,  4540,  4541,  4542,  4497,  3276,   718,
    5959,   823,  1963,  3806,  3829,  2136,  6490,  5978,  2513,  3361,
    2270,  5034,  6082,  5804,  4490,  5462,  5564,   805,  5035,  4061,
    5525,  5566,  3255,   805,  3839,   819,  2820,  2838,  3961,  5979,
    5348,  2128,  3411,  2129,  2130,  2131,  3287,  2132,  -769,  2133,
    3411,  2147,  3912,   626,  3928,  2852,   805,  3287,  2134,   733,
    5118,  5886,   838,  3562,  3339,  3340,  3047,  3048,  3260,  3050,
    3052,  3053,  3054,  3821,  5441,  5420,  -335,  5421,  5422,  5194,
     823,  3063,  2649,  5197,   848,  6458,  6458,  5980,  3822,   823,
    3690,  4296,  5843,  2649,  2505,  5393,   849,  2654,  5181,  3078,
    3389,   862,  3389,  3389,  3929,  5318,  4297,  5854,  3261,  2456,
    2271,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  3962,
    5863,  3418,  5865,  3562,  5119,  2137,  5410,  4326,  2592,  4324,
    6498,  2593,  2272,  3884,  5453,  4448,  3885, -1375,  2038,  4452,
    3890,  2368,   547,  4328,  4605,   723,  3262,  2373,  2374,  4331,
    4332,   861,  2502,  2503,  3447,  1865,  5352,  3451,   910,  1207,
    2058,  2059,  3453,   546,  2135,  3433,   545,  3267,  1214,   969,
    3267,  4656,  4657,  1313,   805,   805, -2405,  1188, -2405,   885,
    4663,  3963,  4664,  1190,  4666,  5739,  5740,  2544,  4658,  4538,
    4539,  3473,  3473,  4540,  4541,  4542,  1205,   954,  3964,  3965,
    3456,  1302,  3286,  3966,  3967,  3968,   687,  5333,   544,  1315,
    5093,  5094,  1302,  1414,  2958,   823,  2136,  5172,  5912,   805,
    4636,  4637,  4638,  1317,  2557,  2148,  6042,  2462,  2302,   805,
    2464,  2464,  5482,  6043,  2310,  5120,  3513,  5121,  5290,  1326,
    5113,  3186,  3349,  2224,  3518,  5291,  3520,  5292,  6044,  4981,
    3433,  1372,  1846,  3502,  1373,  1374,  1331,  4621,  2650,  1375,
    2505,  5147,  5144,  3263,  5140,  5149,     4,     5,  3896,  2650,
    2988,  3969,  3897, -2329,  3501,  3264,   547,  3500,  1336,  4400,
     884,  3324,  3325,  1372,  3429,  3430,  1373,  1374,  1339, -2329,
    4087,  1986,  1345,  4618,  3984,  1348,  3337,   546,  2456,  5166,
     545,   546,   542,  3367,   545,   518,  5161,  3368,  4051,  3369,
    1357,  3370,  2557,  3813,  6508,  6510,  3553,  1429,  4662,  3499,
    4062,  3970,  1995,  3476,  4667,  3477,  2137,  2419,  3568,  3349,
    2815,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  2898,
    2899,  1387,   544,   543, -2329,  3276,   883,  1943,  1950,  1359,
    1955,  1956,  1957,  1382,  3609,  1963,  2317,  1960,  1018,  1019,
    1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,  2225,
     956,  1366,  3614,  3746,  3615,  1386, -2329,  6045,  3265,  1368,
     717,  2226,  4071,  4126,  4074,  1846,  5122,  5123,  4088,  1846,
    6046,  3339,  3340,  2420,  3287,  4078,   784,  4079,  4195,  1388,
    3276,   805,  1392,  2498,  2421,  4080,   805,  4079,  6047,  4200,
    4201,  3740,  2422,  3495,  3666,  4081,  3286,  4082,  1458,  1459,
    5349,  2515,  3653,  4087,  3350,  2440,  4154,  4087,  4155,  6348,
    2649,  2419,  3276,  4456,  5710,  4457,   542,  1397,  2227,  2423,
     879,  1395,  6564,  4315,  1398, -3587,  2228,  1435,  3266,  4938,
    4722,  5683,  4723,  5076,  3498,  5078,  3349,  2125,  1051,  3389,
    1483,  2123,  5694,  4521,  4597,  4522,  4598,     4,     5,  4236,
    1508,  3736,  2759,  2760,  4491,  4268,  4492,   543,  4493,  1472,
    4494,   882,  2229,  1497,  2128,  2649,  2129,  2130,  2131,  4706,
    2132,  3615,  2133,  2148,  4245,  1514,  2424,  2420,  4709,  1515,
    2317,  2134,  1516,  4715,  3540,  4716,   823,   823,  2421,  3741,
     833,  3350,  1490,  1520,  1526,   823,  2422,  2649,  3780,  3473,
    3473,  4088,  4051,  1529,  2425,  4088,  1536,  1847,  5350,  3787,
    1848,  3260,   823,  1302,  1849,   823,   718,  1071,  3757,  3758,
    1856,  1380,  1381,  2423,  1384,  5124,  1385,  1857,  6048,  1302,
    4961,  4962,  1868,  4942,  4963,  4964,  4721,  3745,  2317,  3276,
    4965,  4966,  3777,   644,  4725,  1302,  4726,  3351,   644,  1886,
    5037,  3261,  5038,  1888,  2138,  2139,  2140,   644,  3744,  1898,
    5152,  3743,  2317,   644,  1890,  2759,  2760,  2761,  1896,  2762,
     653,  2763,  1899,  2764,  2230,  4818,  3668, -3486,   857,  1900,
    2424,  1254,  1254,  5394,  1302, -3488,  2650,  2135,  3287,  3262,
     805,  1901,  3846,  5481,  5398,  5400,  5399,  5401,  1268,  1268,
    3790,  2231,  3281,  5913,  5125,  5402,  2301,  5403,  2425,  1088,
   -3485,   823,  3816,   805, -3487,  3367,  1302,  4858,  3350,  3368,
    1902,  3375,  4595,  3370,  2649,  1908,  5434,   654,  2317,  -771,
    1909,  4611,  5331,  4957,   954,  4128,  1259,  1259,  2456,  2136,
     805,  2650,  5451,  5459,  5452,  2317,  1414,  3843,  1910,  1915,
    1414,   805,  5472,  5495,  5473,  5496,  3352,  4407,  2128,  1911,
    2129,  2130,  2131,  1916,  2132,  4777,  2133,  5511,  5610,  5512,
    4457,  1918,  4363,  2650,  3870,  2134,  1917,  3957,  3875,  3876,
     805,  1919,   644,  -771,   644,  5747,   770,  4827,  1920,   805,
    3888,   644,  1921,  3361,   805,  3943,   655,  3739,  4061,  5874,
     805,  5875,  3821,  3950,  1992,  1931,  3263,  4600,   656,  4048,
    1978,   763,  3954,  3955,  4810,   805,  4811,  3822,  3264,  3910,
    2203,  1993,  2203,  2439,  3915,  2050,  5915,  5718,  5916,  5065,
    1994,  4820,  4823,  1999,  1260,  1260,  2000,  5884,  3742,  5921,
    2001,  5916,  2627,  1302,  2627,  5922,  5976,  5916,  4457,  2137,
    2002,  2003,  4615,  3588,  2007,  2138,  2139,  2140,  2090,  5977,
    2128,  4457,  2129,  2130,  2131,  6128,  2132,  6129,  2133,  6123,
    2009,  2095,  4518,   657,  5654,  2164,  6154,  2134,  6155,  5089,
    3658,  2135,  -771,  2010,  3944,  3945,   791,  2759,  2760,  4491,
   -1375,  4492,  2011,  4493, -1375,  4494,  2232,  6024,   823,  6163,
    2650,  6164,  2012,  3956,   805,  2013,  2014,  4481,  5724,  2165,
    6198,  5726,  4522,  3982,  3983,  4563,  2015,  4565,  4566,   792,
     772,  3265,  2128,  4571,  2129,  2130,  2131,  6324,  2132,  6325,
    2133,  4579,  6368,  2136,  5207, -1375,  4586,  2016,  2017,  2134,
   -1375,  3411,  3411,  4108,  4109, -1720,  6369,  4110,  5473,  4111,
    4106,  4112,  2018,  -771,  3349,  6376,  6385,  6377,  6386, -1719,
    2019,  1414,  4066,  6405,  6407,  5916,  5916,  3778,  2166,  6408,
    4073,  5916,  3779, -1375,  2233,  2167,  4044,  4045,  4046,  4047,
    2020,  3782,  2234,  2135,  2419,  2168,  6441,  3785,  5916,  1846,
    6451,  3266,  5916,  6480,  5172,  5473,  5695,  6551,  2021,  6552,
    2024,  2025,  5676,  5634,  5635,  2026,  5637,  2033,  2034,  5640,
    2035,  2036,  5644,  2505,  2505,  5647,  5648,  2039,  1020,  1021,
    2040,   658,  1024,  5656,  1026,  5657,  1028,  1839,  4107,  2041,
    1375,  2042,  2043,  4091,  5663,  2136,  2044,  5193,  4116,  2045,
    4118,  5333,  2046,  2137,  2047,  2135,   805,  6054,   659,   805,
    2420,  2048,   823,   823,   823,  2049,  2051,  3276,  2052,  2053,
    2054,  2421,   793,  2055,   823,  3408,  2056,  2060,  3736,  2422,
    2061,  2880,  2063,  2064,  5910,  2128,  2885,  2129,  2130,  2131,
    2065,  2132,  2066,  2133,  2067,  2068,  2895,  2128,  2069,  2129,
    2130,  2131,  2134,  2132,   660,  2133,  2423,  2136,  2070,  4090,
    2071,  2072,  2073,  2074,  2134,  2075,  3879,  5975,  3882,  2176,
    2172,  2076,  2079,  2080,  3887,  3889,  2081,  2082,  4813,  4814,
    3000,  3000,  4815,  2170,  4816,  1840,  4817,  2083,  2084,  2085,
    6251, -2584,  5719,  2086,  2087,  5720,  3350,  2088,   823,  2089,
     823,  5191,  2649,  2091,  2092,  2137,  2093,  2094,  1947,  1947,
    1947,  3381,  2096,  2424,  3745,  2177,  2097,  2098,  2099,  2100,
    5893,  2101,  6056,  2102,  2105,  2106,  4091,  2993,  6062,  6063,
    4091,  3396,  1946,  1946,  1946,  3744,  2109,  2110,  3743,  2111,
    3401,  2425,  2112,  2113,  2114,  2115,  3403,   -72,  2116,  1490,
    1490,  2203,  3351,  4086,  3415,  2171,  2187,  2189,  2135,  2188,
    5444,  2190,  2195,  3424,  5446,  2221,  3426,  2137,  4752,  5442,
    2135,  2222,  3049,  2242,  1945,  1945,  1945,  3055,  2223,  3057,
    4866,  2261,  2262,  2958,  2203,  2260,  2263,  2283,  2284,   661,
    2289,  2293,  4090,  2296,  4089,  2297,  4090,  2305,  2317,  2349,
    2359,  5427,  2361,  2371,  2365,  2372,  2378,   662,  2379,  2383,
    2136,  2381,  4258,  2387,  5334,  5481,  2404,  2405,  2406,  3692,
    2408,  1302,  2136,  2417,  2428,  2429,  5860,  3092,  2432,  5182,
    5183,  2442,  2448,  4530,  2458,  2459,  2419,  2481,  2482,  3102,
    2491,  2494,   518,  4283,  2125,  2496,  2499,  2500,  2123,  1490,
     663,  2516,  2504,   664,  1414,  1414,  2524,  2530,  2138,  2139,
    2140,  3352,  2546,  2554,  5848,  2558,  2550,  2580,   805,  2587,
    2596,  2603,   805,  2618,  3739,   823,   823,  4294,  2650,  2612,
    2604,   665,  2621,  2620,  2625,  2626,  4086,  2628,  2634,   666,
    4086,  2640,  2638,  2557,  3659,  2642,  2659,  4372,  2653,  2645,
    4061,  2661,  2420,  2663,  3543,   823,  2664, -1375,  2665,  1944,
    1944,  1944,  2667,  2421,  2668,  3742,  2456,  2695,  2714,  2703,
    2137,  2422,  5335,  2716,  2718,   540,  4342,  4089,  4344,   518,
    2719,  4089,  2137,  5654,  2720,  6423,  2722,  2723,  2726,  2725,
     516,  2729,  5274,  3184,  2740,   565,  4405,   547,  2423,  2741,
     541,  2742,  2751,  2801,  2758,  4913,   491,  2907,  3907,  1264,
    1264,  1429,  1255,  1255,   492,   493,  4430,  2769,   546,   571,
     513,   545,  1429,  1429,  2773,  2814,  2816,  2815,  2827,  2829,
    1263,  1263,  2833,  1262,  1262,  2834,  2884,  2889,  2893,  2903,
    2914,  2918,  2933,  4977,  4978,  4979,  2937,  2965,  2964,  2989,
    2990,  3004,  2995,  2998,  6313,  2424,  2997,  3015,  3024,  3021,
    3043,  3044,  3084,   544,  3069,  3085,  5048,  5051,  3086,  5054,
    3087,  3089,  3090,  3091, -2179,  1261,  1261,  3106,  3109,  6022,
    3110,  5893,  3114,  2425,  3113,  3115,  3116,  3117,  3124,  3125,
    3133,  3134,   644,  3135,  3136,  3137,  3148,   805,  3138,  3140,
    3141,  3147,  2138,  2139,  2140,  3303,  3151,  3908,  3152,   805,
    3156,  3306,  3161,   805,  2128,  3168,  2129,  2130,  2131,   823,
    2132,  3589,  2133,  4514,  4515,  4516,  4517,  2963,  4519,  4520,
    3172,  2134,  3195,  3198,  3199,  3200,  3201,  2128,  3204,  2129,
    2130,  2131,  3214,  2132,  3226,  2133,  3212,  3213,  3227,  3222,
    3229,   823,   823,  3230,  2134,  3243,  6229,   542,  3242,  3246,
    3247,  3259,  3284, -2595,  3299,  3308,  3307,  3310,  3316,  1258,
    1258,  3312,  3311,  3346,  4567,  4568,  3363,  4570,   769,  4572,
    4573,  4574,  4575,  4576,  4577,  4578,  3365,  4580,  3394,  2606,
    4585,  3402,  3391,  3425,  4588,  3427,  4500,  4501,   543,  4503,
    4505,   823,  3000,  3440,  2138,  2139,  2140,  3441,  1442,  3445,
    3449,  5071,  3452,  3455,  3457,  3464,  3467,  4553,  3470,   770,
    3488,  3511,  3512,  3660,  3529,  3532,  5104,  3534,  3535,  3537,
    3546,  5138,  3547,  3548,  3551,   771,  3552,  2135,  3554,  3562,
    2128,  3573,  2129,  2130,  2131,  1846,  2132,  3569,  2133,  3576,
     717,  3586,  6165,  5151,  3587,  3591,  3592,  2134,  3600,  3601,
    2135,  2162,  3602,  3607,  3618,  3687,  2138,  2139,  2140,  3472,
    3472,  1490,  3625,  3628,  3643,  3629,  3634,  3696,  3636,  3703,
    2077,  3647,  3648,  4087,  3650,  2915,  3654,  3662,  4594,  2136,
    3667, -1511,  3655,  6556,  3674,  3680,  2103,  3487,  5153,  3689,
    1843, -1685,  3708,  4608,  2107,  3711,  3716,  1935,  3718,  3719,
    3713,  3726,  2136,  3722,  3748,  3727,  3761,  2128,   547,  2129,
    2130,  2131,  3764,  2132,   805,  2133,  3765,  3728,  3766,  3769,
    3773,  3774,  3776,  3788,  2134,  3792,  3800,  3804,  3803,   546,
    3810,  3826,   545,  3827,  3855,  3858,  2472,   823,   823,  3857,
    3859,  6273,   805,   772,  3862,  3863,  3895,  3902,  3906,  3920,
    3931,  3927,  3938,  2135,  3935,  3939,  1842,  3946,  3947,  5826,
    5827,  3948,  5829, -2129,  3949,  3951,  3952,  6482,  3953,  4004,
    4007,  4088,  4010,  4014,   544,  4018,   773,  4019,  4020,  4021,
    4022,  6297,  4068,  4023,  4024,  4025,  4042,  4026,  4096,  2137,
    1947,  4043,  4027,  4028,  1984,  4029,  4030,  4031,  6373,  4032,
    4033,  4034,  4035,  4036,  4037,  2136,  4436,  4038,  4039,  2138,
    2139,  2140,  2137,  4040,  1946,  4069,  4050,  4041,   623,   625,
    4076,  2138,  2139,  2140,  4075,  4074,  4098,  4070,  3544,  4071,
    2135,  2128,  4113,  2129,  2130,  2131,  4072,  2132,  3563,  2133,
    3564,  4117,  2032,  2128,  4120,  2129,  2130,  2131,  2134,  2132,
    1838,  2133,  4123,  4119,  4734,  4135,  1945,  4137,  2539,  4793,
    2134,  4149,  4140,  4141,  4138,  4139,  4145,  4150,   542,  3633,
    4151,  4152,  4164,  4196,  3638,  4197,  6381,  4198,  3691, -1728,
    5275,  4211,  2136,  4212,  4221,  4232,  4270,  4256,  4271,  4767,
    4284,  1841,  4300,  4291,  4269,  4285,   626,  4302,  6563,  4257,
    4306,  4308,  4290,   823,  2128,   805,  2129,  2130,  2131,   543,
    2132,  4292,  2133,   823,   823,  2137,  4794,  3697,   518,  4797,
    4798,  2134,  4309,  4313,  4316,  4317,  4329,  4321,  4481,  4322,
    4330,  3027,  2127,  2128,  3026,  2129,  2130,  2131,  3433,  2132,
    4368,  2133,  4354,  2128,  3477,  2129,  2130,  2131,  6373,  2132,
    2134,  2133,  4369,  5738,  2135,  4371,   624,  4375,  4370,  4383,
    2134,  4377,  4408,  4414,  4382,  4416,  2135,  4418,  4914,  4419,
    4420,  4446,  4838,  5983,  4447,  5984,  5985,   518,  4450,  4474,
    4451,  4533,  4534,  4487, -2080,  4478,  4488,  3472,  3472,  4535,
    4551,  1944,  2137,  4555,  4560,  4561,  4562,  4564,  4593, -3620,
    4603,  4609,  4612,  4619,  3450,  4624,  2136,  4626,  4613,  4631,
    4644,   805,  4632,   823,  4651,  6455,   805,   805,  2136,  4653,
    4660,  4661,  4724,  4665,  6381,  4735,  4737,  2135,  4668,  4669,
    4759,  2209,   644,  4670,  4671,  4788,  4802,  4747,  4748,  4751,
    4761,  4768,  4771,  4803,  4772,  4774,  4775,   805,   805,  4808,
    6545,  4828,  4830,  4821,  4947,  4826,  2135,  4859,  4827,  4841,
    4862,  4860,  4833,  4839,  6555,  4863,  2135,  4861,  5028,   625,
    6545, -1846,  4865,  4868,  4916,  4924, -1851,  6555,  3797,  2136,
    4945,  4950,  4953,  4970,  4954,  4975,  4959,  4988,  5033,  2128,
    5041,  2129,  2130,  2131,  5067,  2132,  4960,  2133,  5068,  5062,
    5073,  3818,  5092,  5081,  5095,  5096,  2134,  5098,  2136,  5107,
    5108,  5145,  3659,  5156,  5154,  4742,  2137,  4464,  2136,  2348,
    5160,  5157,  5159,  2973,    51,  5185,  5163,   774,  2137,  4106,
    5186,  5198,  5211,  5206,  5212,  5213,  5207,  5529,  5532,  5534,
    5536, -2129,  5218,  5539,  5540,  -163,   626,  5238,  5544,  5239,
    5240,  5550,  5252,  4999,  5554,  5282,  5283,  5529,  5287,  -247,
    5295,  5565,  5529,  5286,  5288,  5297,  5311,  5326,  3877, -3620,
    2128,  2960,  2129,  2130,  2131,  5324,  2132,  3886,  2133,  5325,
    5342,  5344,  1429,  5345,  5333,  5355,  5356,  2134,  1429,  2137,
    5055,   664,  5365,  5366,  5367,  4066,   627,  5368,  5369,  5370,
    5372,  5373,  5374,  1429,  5375,  5376,  5386,  4107,  5383,  5389,
    5064,  5397,  2135,  5066,  5407,  5390,  5412,  5408,  2137,   775,
    2457,  5411,  5415,  2457,  5417,  5404,  5435,  5423,  2137,  5072,
    5424,  5419,  5431,   518,  5436,  5437,  5443,  5445,  2138,  2139,
    2140,  5460,   628,  5448,   516,  5457,  5458,  5467,   518,  5474,
    5087,  5489,  5476,  5639,  4530,  3565,  5493,  3566,  5520,  5497,
    5475,  2138,  2139,  2140,  2136,  5477,  5492,  5770,  5500,  2128,
    5503,  2129,  2130,  2131,  5525,  2132,  5504,  2133,  3645,  5594,
    3646,  5602,  5596,  5603,  5604,  5607,  2134,  5614,  5609,  5615,
    5616,  5617,  5624,  2135,  5048,  5626,  5051,  5627,  5054,  5625,
    5632,  2128,  4793,  2129,  2130,  2131,  5630,  2132,  2128,  2133,
    2129,  2130,  2131,  5641,  2132,  5646,  2133,  4549,  2134,  5677,
    5679,  5645,  5704,  5700,  5681,  2134,  5702,  5706,  5708,  5709,
    5712,  5179,  5143,  5715,  5728,  5746,  4091,  5752,  5736,  5759,
    5751,  5760,  5737,  5755,  5758,  2136,  5763,  5775,  5779,  5777,
    5800,  5810,  5808,  5713,  5812,  5809,  4921,  5629,  5823,  4794,
    5833,  5828,  5642,  5819,  2138,  2139,  2140,  4598,  5820,  5830,
    5831,  5835,  4767,  5851,  2137,  5508,  5173,  5850,  5855,  5861,
    5866,  3656,  5881,  3657,  5174,   823,  5894,  5512,  5180,  5895,
    5896,   629,  2135,   518,  4842,   630,  5898,  5888,  5889,  5899,
    5214,  4843,  4090,  5914,  5918,  2128,  5908,  2129,  2130,  2131,
    5920,  2132,  5513,  2133,  5930,  5936,  4844,  5956,  2907,  5924,
    5987,  5940,  2134,  5989,  2135,  5946,  4845,  4846,  4847,  5986,
    5205,  2135,  5952,  5954,  1429,  6003,  4848,  4125,   631,  6004,
    6005,  2138,  2139,  2140,  2136,  6014,  6010,  6013,  6015,  1846,
    6021,  6023,  1191,  6027,  6036,  2137,  6040,  6058,  4274,  1192,
    4275,  6037,   805,  6070,  6059,  6064,  4873,  6127,  5237,   632,
    6106,  6131,   805,  6132,  1193,  6133,  2136, -3620,  6134,  6139,
    6140,  6141,  6150,  2136,  1194,  1195,  1196,  1839,  6152,  6153,
    6156,  6157,  6160,  6166,  1197,  5265,  4086,  5502,  6170,  6012,
    6173,  6178,  6181,  5242,  5243,  5244,  5245,  5246,  5247,  5248,
    5249,  5250,  5251,  5322,  5253,  5254,  5255,  5256,  5257,  5258,
    5259,  5260,  5261,  5262,  1846,  6195,  5266,  5267,  2135,  6197,
    6209,  6215,  6217,  5545,  6221,  6219,  6220,  4089,   880,  6223,
    6226,  6240,  3910,  5762,  6227,  6242,  6241,  5767,  5768,  6225,
    5958,  2963,  6243,  2128,  2137,  2129,  2130,  2131,  6248,  2132,
    6250,  2133,  4087,  6228,  6255,  2138,  2139,  2140,  6277,  6284,
    2134,  6314,   823,  6299,  6319,  6344,  4849,  2138,  2139,  2140,
    2136,  6329,  4682,  6335,  4683,  1840,  2137,  6358,  4850,  6321,
    6345,  6322,  6332,  2137,  4698,  6359,  4699,  6352,  6362,  6360,
    6367,  2128,  6370,  2129,  2130,  2131,  4996,  2132,  5001,  2133,
    6395,  6419,  6427,  6432,  6398,  6401,  6469,  6409,  2134,  6410,
    5237,  6430,  6483,  5354,  6435,  6493,  6486,  6489,  5364,  6494,
     644,  6495,  6503,  6504,  1198,  5392,   881,  6497,  2138,  2139,
    2140,  6505,  6507,  6512,  6516,  6515,  1199,  6517,   518,  6519,
    6522,  6525,  6523,  6520,  6521,  3555,  6531,  6524,  5405,  6532,
    4088,  6546,  4334,  4587,  6559,  6311,  3825,  2138,  2139,  2140,
    5691,  5689,  5690,  2279,  4851,  4423,  2135,  2138,  2139,  2140,
     518,  6061,  4968,  6125,  4711,  5813,  4712,  6259,  6425,  4852,
    2137,   807,  3002,  5058,  3574,  5597,  2993,  1408,  2495,  2693,
    4312,  4607,  4602,  5491,  5063,  3434,  3836,  4856,  4648,  2981,
    4628,  1947,  3314,  1528,  3522,  2543,  3373,  3521,  4106,  3454,
    3523,  5943,  5942,  3298,  2135,  5781,  5015,  4853,  2136,  5162,
    5379,  5857,  1846,  5727,  2128,  1946,  2129,  2130,  2131,  5167,
    2132,  4854,  2133,  5466,  6283,  3701,  5900,  1200,  6375,  5732,
    6485,  2134,  6439,  6487,   880,  6180,  3942,  4767,  2486,  5633,
    5377,  6108,  6387,  5672,  5757,  5840,  5519,  5382,  6459,  6343,
    1839,  6347,  2907,  6275,  6264,  6265,  2136,  1945,  6266,  6267,
    5963,  5126,   518,  6281,  5926,  1201,  2570,  4659,  6349,  4739,
    5541,  5542,  2032,  5478,  3382,  3392,  4107,  5028,  5148,  1202,
    5555,  5578,  5150,  5146,  4838,  6488,   777,  2812,  2032,   778,
    6452,  6068,  6453,  6052,  5573,   823,  4415,  6318,  5237,  6310,
    5510,  6316,  5992,  2138,  2139,  2140,  3400,  5600,  5834,  5836,
    4867,  5380,  5670,  2511,  2696,   805,  3169,  4399,  2137,  6148,
    4717,  4013,  4718,  6279,  4398,  6431,  5996,  3348,  3817,  4641,
    4307,   823,   881,   806,  4146,  5080,  4272,  2135,  2467,  4361,
    1437,  1846,  2418,  2192,  2466,  4477,  5158,  5527,  1840,  5409,
    4235,  5574,  4233,  4318,  4066,  4441,  2901,  4763,  2961,  5543,
    4678,  5428,  4066,  6426,  6262,  2803,  2137,  1429,  2813,  6511,
    2128,  1429,  2129,  2130,  2131,  6509,  2132,  2748,  2133,  4087,
    3221,  2410,  5825,  3218,  2138,  2139,  2140,  2134,  2411,  2136,
    5613,  5195,  1944,  6270,  3211,  6271,  5636,  3922,  2203,  2412,
    2413,  4754,  5494,  4755,  2415,   880,  2757,  4473,  5237,  5651,
    5678,  3232,  4758,  5315,  5314,  5723,  4757,  6159,  6236,  5661,
    6002,  5205,  5488,  5714,  4480,  4476,  5664,  5741,  5665,  5666,
    2966,  5650,  5430,  2907,  5388,  1460,  6052,  2032,  2461,  2474,
     805,  5660,  3914,  5320,   788,  4115,  5205,   779,  1213,  2185,
    4144,  3480,  5079,  5205,  5177,  5909,  5499,  4511,  5237,  5192,
    6481,  1860,  3448,  3075,  1866,  6236,  3794,  1307,  3795,  4355,
    2468,  1310,   803,  5685,   878,  5941,  3830,  4088,  5745,  3159,
    3036,  5084,  6484,  2138,  2139,  2140,  5618,  2701,  6513,  5832,
    6558,   919,  6561,  2135,  1987,  3807,  4165,  4142,  5733,  2137,
    4346,  1266,  3549,   881,  4347,  1185,  3528,  6560,  3760,  4348,
    1267,  4340,  4339,  4343,  4801,  2138,  2139,  2140,  3509,  1221,
    3178,  2689,  2138,  2139,  2140,  1947,  1311,  2186,  2690,  3003,
    4976,  4314,  5323,  4003,  3550,  5414,  4417,  5882,  5029,  1356,
     797,  3559,  2364,   781,  1964,  2136,  3912,  5776,  5731,  1946,
     782,   783,  1185,  5173,  5735,  5077,  3524,  4650,  6353,  5960,
    1966,  1976,  5200,  5778,  6354,  6467,  4424,  6236,  4915,  5948,
    5205,  5953,  5945,  5944,  5949,  5817,     0,  5750,  1977,     0,
    5750,  5750,  1429,  1854,     0,  5756,     0,  5806,  2623,  5237,
       0,  1945,     0,     0,     0,     0,     0,  5766,     0,     0,
       0,     0,  5774,  2032,     0,     0,     0,     0,     0,     0,
    4642,     0,     0,     0,     0,     0,     0,     0,     0,  2138,
    2139,  2140,     0,     0,     0,     0,     0,  5837,     0,  5839,
    1843,     0,     0,  2128,     0,  2129,  2130,  2131,  3560,  2132,
       0,  2133,     0,     0,     0,     0,     0,     0,     0,     0,
    2134,     0,     0,     0,     0,  2137,     0,     0,  6557,     0,
    2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,     0,
       0,     0,     0,     0,  1185,     0,     0,  2134,     0,     0,
    6388,  5789,     0,  5838,  3910,     0,  3910,     0,     0,     0,
     919,     0,     0,     0,     0,  1836,  1842,     0,     0,     0,
       0,     0,     0,     0,     0,  4091,     0,  2457,     0,  3241,
       0,  5841,  5237,  5205,  5237,   878,   823,  5237,     0,  5205,
       0,     0,     0,     0,  5237,  5237,  1944,     0,  5205,     0,
       0,     0,     0,  5858,  5237,     0,     0,     0,     0,     0,
    5237,  5205,     0,  5205,     0,     0,     0,  5788,     0,     0,
    5867,     0,     0,     0,     0,  2128,  2135,  2129,  2130,  2131,
       0,  2132,     0,  2133,     0,     0,     0,  2138,  2139,  2140,
    5879,  4090,  2134,  4778,     0,     0,     0,     0,     0,   805,
       0,     0,     0,  2135,     0,     0,  3561,     0,     0,     0,
    1838,     0,     0,     0,     0,  1942,  1942,     0,  1942,  1942,
    1942,     0,     0,     0,     0,  1942,     0,  6424,  2136,     0,
       0,     0,     0,  5028,  2907,  2138,  2139,  2140,     0,     0,
    5968,     0,  5968,  6052,     0,     0,     0,     0,  5750,     0,
       0,  1841,  5923,     0,  3567,  2136,     0,     0,     0,  5928,
     805,  5786,     0,   763,  5237,  5237,     0,     0,     0,     0,
       0,     0,  2958,  1185,   805,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,  4086,     0,     0,   518,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2135,  4864,
       0,  1185,  5787,     0,  4869,  4870,  4066,     0,     0,     0,
    1185,     0,   644,     0,   644,     0,  5974,  5789,     0,     0,
       0,     0,     0,     0,     0,     0,  4089,     0,     0,     0,
       0,     0,     0,  1843,     0,  1429,  1429,     0,  2137,     0,
       0,  5237,     0,     0,     0,  5237,     0,  5999,     0,     0,
    2136,     0,  2907,     0,  6090,     0,  6298,     0,  6090,     0,
       0,  5205,     0,     0,     0,  2137,     0,     0,  2138,  2139,
    2140,     0,  6016,  6020,     0,     0,     0,     0,     0,     0,
    5968,     0,     0,  5788,     0,  3579,  5968,   885,     0,  1185,
    1185,  1185,  1185,     0,     0,     0,  6035,     0,     0,  1842,
       0,  1185,     0,     0,     0,  5143,     0,     0,  2128,     0,
    2129,  2130,  2131,  5750,  2132,     0,  2133,  6077,     4,     5,
    3530,  6065,     0,  5237,     0,  2134,     0,     0,  6562,     0,
       0,     0,     0,     0,     0,     0,     0,  6105,     0,   717,
       0,     0,     0,     0,     0,     0,     0,     0,  6116,     0,
    6117,     0,   644,     0,     0,     0,     0,     0,   644,     0,
    2137,     0,  4091,  2128,     0,  2129,  2130,  2131,     0,  2132,
       0,  2133,  6093,     0,     0,  6143,     0,  5786,     0,     0,
    2134,  4128,     0,     0,  5237,     0,     0,     0,   884,     0,
       0,     0,     0,  1838,     0,  2032,  3571,     0,  6094,     0,
    6144,  5237,   805,  6090,     0,     0,     0,     0,     0,   546,
       0,     0,   545,     0,     0,     0,     0,     0,  5787,     0,
    6222,  6090,     0,     0,  2138,  2139,  2140,     0,  4090,     0,
       0,  2135,     0,     0,  1841,     0,     0,     0,     0,     0,
       0,     0,     0,  3577,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   883,     0,  6196,     0,     0,  -994,
       0,  6208,     0,  6438,     0,     0,     0,  6214,     0,  6171,
    6172,     0,  6174,  6175,  6176,  6177,     0,     0,  1185,     0,
       0,  2340,     0,  2136,  3652,     0,  2135,     0,     0,     0,
     823,     0,     0,     0,     0,   718,     0,     0,  3669,     0,
    6095,     0,  6096,     0,     0,     0,     0,     0,     0,     0,
       0,  6292,  6293,     0,     0,     0,     0,     0,  6256,     0,
       0,   805,  4086,  6304,  6078,     0,  5974,     0,     0,     0,
    4838,  4838,     0,     0,     0,     0,     0,     0,  2136,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   879,     0,
       0,     0,  6020,     0,     0,     0,     0,     0,     0,     0,
       0,  6035,     0,  4089,     0,  6090,     0,     0,  6339,     0,
       0,     0,     0,     0,   823,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3725,  2128,   882,
    2129,  2130,  2131,  2137,  2132,  6079,  2133,  6291,     0,     0,
    6294,     0,     0,     0,  2209,  2134,  6320,     0,  6302,     0,
       0,  6305,     0,     0,  5750,  6548,  5750,  5750,  1185,     0,
    6550,     0,     0,     0,     0,  6340,     0,     0,     0,     0,
       0,  6382,     0,     0,  6383,     0,  2125,     0,     0,     0,
    2123,  2128,     0,  2129,  2130,  2131,  6097,  2132,  2137,  2133,
    5217,  6393,     0,     0,     0,     0,     0,     0,  2134,     0,
    5241,     0,     0,  1185,     0,     0,     0,  2128,  6090,  2129,
    2130,  2131,     0,  2132,     0,  2133,     0,  2907,  5968,     0,
       0,     0,     0,     0,  2134,  6080,     0,  2138,  2139,  2140,
    2693,     0,     0,     0,     0,     0,     0,     0,     0,   823,
       0,     0,     0,     0,     0,     0,  3578,     0,  6394,     0,
       0,  2135,     0,     0,  2138,  2139,  2140,     0,  5750,  5750,
       0,     0,  6402,     0,     0,     0,  2348,  2348,     0,  5750,
       0,  6090,  6090,  3583,     0,     0,     0,  5028,     0,     0,
    6465,  6465,     0,     0,     0,     0,     0,     0,     0,     0,
     644,     0,     0,     0,  6422,     0,     0,     0,     0,     0,
       0,     0,     0,  2136,  2135,     0,     0,     0,     0,     0,
       0,  2128,     0,  2129,  2130,  2131,  6090,  2132,     0,  2133,
       0,   823,  -771,     0,     0,  5331,     0,     0,  2134,     0,
    2135,     0,     0,     0, -1935,     0,     0,  6081,  5750,     0,
       0,     0,     0,     0,     0, -1935,     0,     0,     0,  2138,
    2139,  2140,  6464,  6464,     0,     0,  2136,     0,     0,     0,
       0,  5028,  2457,     0,  2457,  2457,  3934,  2907,  3584,     0,
       0,     0,     0,     0,     0,     0,  -771,     0,     0,   770,
    2705,     0,  2136,     0,     0,  2128,     0,  2129,  2130,  2131,
       0,  2132,     0,  2133,     0,  3821,     0,     0,     0,     0,
       0,     0,  2134,     0,     0,     0,     0,     0, -1935,     0,
    3822,     0,     0,  2137,     0,     0,  2128,     0,  2129,  2130,
    2131,     0,  2132,     0,  2133,     0,     0,     0,     0,     0,
       0,     0,     0,  2134,  2135,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1935,     0,     0,     0,
   -1935,     0,     0,     0, -1935,     0,     0,     0,     0,     0,
       0,     0,     0, -1935, -1935,     0,  2137,  5332,     0,  2907,
   -1935,     0,     0,   823, -1935,  -771,     0,     0,   823, -1935,
       0, -1935,     0,  2907,     0, -1935,  2136,     0,     0,  2907,
       0,     0,  2137, -1935,     0, -1935,  2907,     0,     0,     0,
   -1935,     0,  6099,     0,     0,     0,     0,     0,  2135,     0,
       0,     0,     0,   772,     0,     0,     0,     0,     0,     0,
   -1935,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1935,     0,     0, -1935,     0,     0,     0,     0,     0,  2135,
       0,     0,     0,     0,     0,     0,  -771,     0,     0,     0,
       0,     0,     0, -1935,     0,     0,     0,     0,     0,     0,
    2136,     0,     0,  5526,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1935,     0,     0,     0, -1935,     0,     0,
       0,     0,  2138,  2139,  2140,     0, -1935,     0,     0,     0,
       0,  2136,     0,     0,     0,  6082,  2137,  2693,     0,     0,
       0,  3585,     0,     0,     0, -1935,     0,     0,     0,     0,
       0,  1185,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0, -1935,     0,     0,     0,     0,     0, -1935, -1935,
       0,     0,     0,     0,  5333,     0,     0,  2138,  2139,  2140,
       0,     0, -1935,     0, -1935,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3603,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2137,     0,  1185,  1185,     0,     0,     0,     0,  1185,     0,
       0,     0,  1185,  1185,  1185,     0,     0,     0,  5658,     0,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,  1185,
       0,  2137,     0,  1185,  1185,  1185,     0,  1185,  1185,  1185,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,  1185,
       0,     0,  1185,  1185,  1185,  1185,     0,  1185,     0,  1185,
    1185,  1185,     0,     0,     0,     0,  1185,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,  1185,  1185,  1185,     0,
    1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,
       0,  1185,  1185,  1185,  1185,  1185,     0,  1185,  1185,     0,
    1185,  1185,  1185,     0,     0,  1185,  1185,  1185,     0,  1185,
    1185,  1185,     0,  1185,     0,  1185,     0,  1185,     0, -1935,
       0,  1185,  1185,  1185,     0,     0,  1185,  1185,  1185,  1185,
    1185,     0,  1185,     0,     0,     0,     0,     0,     0,  1185,
       0,  4288,  1185,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,  1185,  1185,  1185,  1185,  2032,  1185,
    1185,     0,     0,  1185,  1185,  1185,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,     0,  5334,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1879, -1123,
       0,     0,  2138,  2139,  2140,     0,     0,     0,     0, -1879,
    4873,     4,     5,     0,     0,     0,     0,     0,     0,     0,
       0,  3604,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3036,     0,     0,  4989,     0,
    4990,  4991,     0,     0,  2705,     0,     0, -1935,     0,     0,
       0,     0,     0,     0,     0,  2138,  2139,  2140,     0,     0,
       0,     0,  4992,     0,  4993,     0,     0,     0,     0,     0,
    4994,     0, -1879,     0,  3611,     0,     0,     0,     0,     0,
       0,  2138,  2139,  2140,     0,     0,     0,     0,     0,     0,
       0,  2484,     0,     0,     0,  5335,     0,     0,     0,     0,
    3613,     0,  4995,     0,     0,     0,     0,     0,  -671,     0,
   -1879,     0,  1185,     0, -1879,     0,     0,     0, -1879,  4873,
       4,     5,     0,     0,     0,     0,     0, -1879, -1879,     0,
       0,     0,     0,     0,     0,     0,     0,  4874, -1879,     0,
    1185,     0,  1185, -1879,     0, -1879,     0,     0,     0, -1879,
       0,     0,  2128,     0,  2129,  2130,  2131, -1879,  2132, -1879,
    2133,     0,     0,     0, -1879,  4996,     0,  5885,     0,  2134,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0, -1879,  2138,  2139,  2140,     0,     0,
       0,  2457,     0,     0, -1879,     0,  4997, -1879,  4998,     0,
    2484,     0,     0, -1935,  3616,     0,     0,  4876,     0,  4999,
       0,     0,     0,     0, -1935,     0,     0, -1879,     0,     0,
       0, -1935,     0,  2128,     0,  2129,  2130,  2131,  5929,  2132,
       0,  2133,  5000,     0,  2706,     0,     0, -1879,     0,     0,
    2134, -1879,     0,     0,     0,     0,  4874,     0,     0,  2705,
   -1879, -1935,     0, -1935,     0,     0, -1935, -1935,     0,  2138,
    2139,  2140,     0,     0,  1185,  4877,  4878,  4879,     0, -1879,
       0,     0,     0,     0,     0,  2135,     0, -1935,  3617,     0,
       0,     0,     0,     0,     0,     0, -1879,  4880,     0,     0,
    2138,  2139,  2140, -1879,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0, -1879,     0, -1879,  3619,
       0,     0,     0,     0,     0, -1935,  4876,     0,     0, -1935,
       0,     0,     0, -1935,     0,     0,     0,  2136,     0,     0,
       0,  5001, -1935, -1935,     0,     0,     0,     0,     0,  4881,
       0,  4882,     0, -1935,     0,     0,  2135,     0, -1935,  2128,
   -1935,  2129,  2130,  2131, -1935,  2132,     0,  2133,     0,     0,
    4883,     0, -1935,     0, -1935,     0,  2134,  5002,     0, -1935,
       0,     0,     0,     0,  4877,  4878,  4879,     0,  4884,     0,
    2457,     0,     0,     0,  2128,  4885,  2129,  2130,  2131, -1935,
    2132,     0,  2133,     0,     0,     0,  4880,     0,  2136, -1935,
    4886,  2134, -1935,     0,     0,     0,     0,     0,     0,     0,
    4887,     0,     0,     0,  5003,  5004,     0,     0,     0,   919,
       0,  5005, -1935,     0,  2128,  4888,  2129,  2130,  2131,     0,
    2132,     0,  2133,  5006,     0,     0,     0,  2137,     0,     0,
       0,  2134, -1935,     0,     0,     0, -1935,     0,  4881,     0,
    4882,     0,     0,     0,  5007, -1935,  2128,     0,  2129,  2130,
    2131,     0,  2132,     0,  2133,     0,     0,     0,     0,  4883,
    6146,     0,  2135,  2134, -1935,     0,     0,     0,  5008,     0,
       0,     0,  4889,     0,     0,     0,     0,  4884,     0,     0,
       0, -1935,  4890,  2128,  4885,  2129,  2130,  2131, -1935,  2132,
       0,  2133,     0,     0,     0,     0,     0,  2135,  2137,  4886,
    2134, -1935,     0, -1935,     0,     0,  4733,     0,     0,  4887,
    1185,     0,     0,     0,  2136,     0,     0,     0,     0,  4891,
    3492,  4873,     4,     5,  4888,     0,     0,     0,     0,     0,
       0,     0,  4892,     0,  5009,     0,     0,  2135,  2128,     0,
    2129,  2130,  2131,   919,  2132,     0,  2133,   878,     0,  2136,
       0,     0,     0,     0,  1185,  2134,     0,     0,     0,     0,
       0, -1879,  1185,  1185,     0,     0,     0,     0,     0,  2135,
       0,  4796,  4893,     0,  -960,     0,  -960,     0,  4894,  6258,
       0,  4889,  2128,     0,  2129,  2130,  2131,     0,  2132,  2136,
    2133,  4890,     0,     0,     0,     0,     0,     0,     0,  2134,
       0,     0,  2484,  5010,     0,     0,  2135,     0,     0,     0,
       0,     0,     0,     0,  5011,  5012,  5013,  1185,     0,     0,
       0,  2136,     0,     0,  2137,     0,     0,     0,  4891,     0,
       0,     0,     0,  2348,     0,     0,  4895,     0,     0,     0,
       0,  4892,     0,  4896,     0,     0,     0,     0,  4874,     0,
       0,     0,     0,     0,     0,  1185,  1185,  1185,  2136,  2137,
       0,  2135,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4897,     0,     0,     0,     0,
       0,  4893,     0,     0,     0,     0,     0,  4894,     0,     0,
    4898,  4899,     0,     0,     0,     0,     0,     0,     0,  2137,
       0,     0,     0,  4900,     0,  2135,     0,  5014,     0,     0,
       0,     0,     0,  2136,     0,     0,     0,     0,  4876,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
    2457,  2137,     0,     0,     0, -1879,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4895,  1185,     0,  2706,     0,
    1185,  1185,  4896,  1185,  1185,     0,     0,  2136,     0,     0,
       0,     0,  1185,     0,  1185, -1879, -1935, -1879,  2137,     0,
   -1879, -1879, -1123,     0,     0,     0,  4877,  4878,  4879,     0,
       0,     0,     0,     0,  4897,  2128,     0,  2129,  2130,  2131,
       0,  2132,  1185,  2133,     0,     0,     0,     0,  4880,  4898,
    4899,     0,  2134,     0,     0,  2128,     0,  2129,  2130,  2131,
       0,  2132,  4900,  2133,     0,     0,     0,     0,     0,     0,
    1185,     0,  2134,  2137,  3735,     0,     0,     0,     0,     0,
       0,     0,  2128,  1185,  2129,  2130,  2131,     0,  2132,     0,
    2133,     0,     0,     0,     0,     0,  1185,     0,     0,  2134,
    4881,     0,  4882,     0,     0,     0,  2128,     0,  2129,  2130,
    2131,     0,  2132,     0,  2133,     0,     0,  2137,     0,  -960,
       0,  4883,  1185,  2134,     0,     0,  2138,  2139,  2140,     0,
       0,  -671,     0,     0,     0,     0,     0,     0,     0,  4884,
       0,     0,     0,     0,     0,  3622,  4885,     0,     0,     0,
       0,  2128,     0,  2129,  2130,  2131,     0,  2132,  2135,  2133,
       0,  4886,     0,     0,     0,     0,  1185,     0,  2134,     0,
       0,  4887,     0,     0,     0,     0,     0,     0,  2135,  2128,
       0,  2129,  2130,  2131,     0,  2132,  4888,  2133,     0,     0,
   -1935,     0,     0,     0,     0,     0,  2134,  2138,  2139,  2140,
       0,     0,     0,  2706,  2340,  2135,     0,     0,     0,     0,
    2136,  2128,     0,  2129,  2130,  2131,  3623,  2132,     0,  2133,
   -1935,     0, -1935,     0,     0, -1935, -1935,     0,  2134,  2135,
    2136,     0,     0,  2128,     0,  2129,  2130,  2131,     0,  2132,
       0,  2133,     0,  4889,     0,     0,     0,     0,     0,     0,
    2134,     0,     0,  4890,     0,     0,     0,  2136,  2128,  1185,
    2129,  2130,  2131,     0,  2132,  2128,  2133,  2129,  2130,  2131,
       0,  2132,     0,  2133,  2135,  2134,     0,     0,     0,     0,
       0,  2136,  2134,     0,     0,     0,     0,     0,     0,     0,
    4891,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2135,  4892,  2128,     0,  2129,  2130,  2131,     0,
    2132,  1185,  2133,     0,     0,  1185,  1185,     0,     0,     0,
    2137,  2134,     0,  2138,  2139,  2140,  2136,  2128,     0,  2129,
    2130,  2131,     0,  2132,  2135,  2133,     0,     0,     0,     0,
    2137,     0,  3624,  4893,  2134,     0,     0,     0,     0,  4894,
       0,     0,     0,     0,  2136,     0,  2135,     0,  2138,  2139,
    2140,     0,     0,     0,     0,     0,     0,  2137,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,  3641,     0,     0,
       0,  2135,     0,     0,     0,     0,  2136,     0,  2135,     0,
       0,  2137,     0,     0,     0,     0,     0,     0,  2138,  2139,
    2140,     0,     0,     0,     0,     0,     0,  4895,  2136,     0,
       0,     0,     0,     0,  4896,     0,     0,  3644,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2135,     0,     0,
    2138,  2139,  2140,  2136,     0,     0,  2137,     0,     0,  2128,
    2136,  2129,  2130,  2131,     0,  2132,  4897,  2133,     0,  3651,
    2135,     0,     0,     0,     0,     0,  2134,     0,     0,     0,
       0,  4898,  4899,     0,  2137,     0,     0,  2138,  2139,  2140,
    4085,     0,  1185,  1185,  4900,     0,     0,     0,     0,  2136,
       0,     0,     0,     0,     0,     0,  4167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2137,     0,     0,     0,
       0,     0,  2136,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2137,     0,
       0,     0,  2138,  2139,  2140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5271,
       0,  4202,     0,  2137,     0,     0,     0,     0,     0,     0,
    2137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2135,     0,     0,     0,  2138,  2139,  2140,     0,
       0,  2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,
       0,     0,     0,  3580,     0,  1942,  1942,  1942,  2134,  2137,
       0,  3735,  1185,     0,     0,     0,  1185,     0,  2457,  1185,
       0,     0,     0,  4189,     0,     0,     0,  4189,  1185,     0,
       0,     0,  2137,     0,  2136,     0,     0,  1185,     0,  1185,
    1185,     0,  1185,  1185,  1185,  1185,     0,  1185,     0,  1185,
    1185,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    1185,  1185,     0,     0,     0,  1185,  1185,  1185,  1185,     0,
       0,  1185,  1185,     0,     0,     0,  1185,     0,  1185,     0,
    1185,     0,  1185,     0,     0,     0,  1185,  1185,     0,     0,
       0,     0,     0,     0,  1185,     0,  1185,     0,  1185,  1185,
    1185,  4288,  1185,     0,     0,  1185,  1185,  1185,  1185,     0,
       0,  1185,     0,     0,  2135,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,  1185,     0,  1185,
    1185,  1185,     0,  2128,  1185,  2129,  2130,  2131,     0,  2132,
    1185,  2133,     0,     0,  2137,  2128,     0,  2129,  2130,  2131,
    2134,  2132,     0,  2133,     0,     0,     0,     0,  1185,     0,
    1185,     0,  2134,  1185,     0,     0,  2136,     0,     0,     0,
       0,     0,     0,  1185,     0,  1185,     0,     0,     0,  2128,
    1185,  2129,  2130,  2131,     0,  2132,     0,  2133,     0,  2138,
    2139,  2140,     0,     0,     0,     0,  2134,     0,     0,  2128,
       0,  2129,  2130,  2131,     0,  2132,     0,  2133,  4442,  2138,
    2139,  2140,     0,     0,     0,     0,  2134,  2128,     0,  2129,
    2130,  2131,     0,  2132,     0,  2133,     0,     0,  4680,     0,
    1185,     0,     0,     0,  2134,     0,  2138,  2139,  2140,     0,
       0,  2128,  1185,  2129,  2130,  2131,     0,  2132,     0,  2133,
       0,     0,     0,     0,     0,  4681,  2135,     0,  2134,     0,
    2138,  2139,  2140,  2128,     0,  2129,  2130,  2131,  2135,  2132,
       0,  2133,     0,     0,     0,     0,  2137,     0,     0,  4694,
    2134,  2128,     0,  2129,  2130,  2131,     0,  2132,  1185,  2133,
       0,     0,     0,     0,     0,     0,     0,     0,  2134,     0,
       0,     0,  2135,     0,     0,  2138,  2139,  2140,  2136,  1185,
       0,  2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,
    2136,     0,  2135,     0,  4714,     0,     0,     0,  2134,     0,
       0,     0,     0,  2138,  2139,  2140,     0,     0,     0,  2128,
    2135,  2129,  2130,  2131,     0,  2132,     0,  2133,     0,     0,
       0,     0,  4730,     0,  2136,     0,  2134,     0,     0,     0,
       0,     0,     0,     0,  2135,  2138,  2139,  2140,     0,     0,
       0,     0,     0,     0,  2136,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,  4731,     0,  2135,  2138,  2139,  2140,
       0,     0,  2136,  2128,     0,  2129,  2130,  2131,     0,  2132,
       0,  2133,  1185,     0,  2135,     0,  5433,     0,     0,     0,
    2134,     0,  2138,  2139,  2140,     0,  2136,     0,  2137,  2138,
    2139,  2140,     0,     0,     0,     0,     0,     0,     0,  3581,
    2137,     0,     0,     0,  2135,     0,  3605,     0,  2136,  4498,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2136,     0,  2138,  2139,
    2140,     0,  2135,     0,  2137,  4498,  4498,     0,     0,     0,
       0,     0,     0,     0,     0,  3608,     0,     0,     0,     0,
       0,  2138,  2139,  2140,  2137,     0,  2136,     0,  2128,     0,
    2129,  2130,  2131,     0,  2132,     0,  2133,     0,  3610,     0,
       0,     0,  2137,     0,     0,  2134,     0,  2128,     0,  2129,
    2130,  2131,     0,  2132,  2136,  2133,  2135,  2128,     0,  2129,
    2130,  2131,     0,  2132,  2134,  2133,  2137,     0,     0,  4498,
    4498,     0,     0,     0,  2134,     0,     0,     0,  2128,     0,
    2129,  2130,  2131,     0,  2132,     0,  2133,  1836,  2137,     0,
       0,     0,     0,     0,     0,  2134,  2128,     0,  2129,  2130,
    2131,     0,  2132,     0,  2133,   919,  2137,     0,  2136,     0,
       0,     0,     0,  2134,     0,     0,     0,     0,     0,     0,
       0,  2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,
       0,     0,     0,  2138,  2139,  2140,  2137,     0,  2134,     0,
       0,  2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,
    3612,  2135,     0,     0,     0,     0,     0,  1185,  2134,     0,
       0,     0,     0,     0,  2137,     0,     0,     0,     0,     0,
    2135,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
    2135,     0,     0,     0,     0,     0,     0,  1942,     0,     0,
    1185,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,  2135,  2693,  2136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2137,  2135,
    1185,  1185,  2136,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,  2136,     0,     0,     0,     0,  2128,     0,  2129,
    2130,  2131,     0,  2132,  2135,  2133,  1185,     0,  1185,     0,
    1185,     0,  1185,  2136,  2134,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2135,  2138,  2139,  2140,     0,     0,
       0,  2136,     0,  1185,     0,  2128,     0,  2129,  2130,  2131,
       0,  2132,  3620,  2133,     0,     0,     0,     0,     0,     0,
       0,     0,  2134,  1185,  1185,     0,  2136,     0,  1185,     0,
    1185,     0,  1185,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,  2137,     0,     0,  2136,     0,     0,  1185,
       0,     0,     0,  2128,     0,  2129,  2130,  2131,     0,  2132,
       0,  2133,  2137,     0,     0,  2128,     0,  2129,  2130,  2131,
    2134,  2132,  2137,  2133,     0,     0,     0,     0,     0,     0,
    1185,     0,  2134,     0,     0,     0,     0,     0,     0,     0,
    2135,     0,     0,  2137,  1185,     0,     0,     0,  1185,     0,
       0,  2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,
       0,  2137,     0,     0,     0,     0,  1185,     0,  2134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2135,     0,
       0,     0,     0,     0,     0,     0,  2137,  2138,  2139,  2140,
       0,     0,  2136,     0,     0,     0,     0,     0,     0,  2138,
    2139,  2140,     0,     0,  3621,  2128,  2137,  2129,  2130,  2131,
       0,  2132,     0,  2133,     0,  2128,  3626,  2129,  2130,  2131,
       0,  2132,  2134,  2133,  4910,  4910,  2135,     0,     0,     0,
    2136,     0,  2134,  2138,  2139,  2140,     0,     0,  2135,  2128,
       0,  2129,  2130,  2131,     0,  2132,     0,  2133,     0,     0,
    3627,     0,     0,  2138,  2139,  2140,  2134,  1185,     0,     0,
    2128,     0,  2129,  2130,  2131,     0,  2132,  1185,  2133,     0,
    3630,  2138,  2139,  2140,  2135,     0,     0,  2134,  2136,     0,
       0,  1185,     0,  2128,  1185,  2129,  2130,  2131,  3631,  2132,
    2136,  2133,     0,     0,     0,  2138,  2139,  2140,     0,  1187,
    2134,     0,  2137,     0,     0,  2128,     0,  2129,  2130,  2131,
       0,  2132,  3632,  2133,     0,     0,     0,  2138,  2139,  2140,
       0,     0,  2134,     0,     0,     0,  2136,     0,  2135,     0,
       0,     0,     0,     0,  3635,  2138,  2139,  2140,  2135,     0,
    2137,     0,     0,     0,     0,     0,  1187,     0,     0,     0,
       0,  4910,  3637,  2128,     0,  2129,  2130,  2131,     0,  2132,
       0,  2133,  2135,     0,     0,  2138,  2139,  2140,     0,     0,
    2134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2136,     0,  3639,  2135,     0,     0,     0,     0,  2137,     0,
    2136,     0,     0,  2138,  2139,  2140,     0,  4498,     0,     0,
    2137,     0,     0,     0,     0,     0,  2135,     0,     0,  2128,
    3640,  2129,  2130,  2131,  2136,  2132,  2128,  2133,  2129,  2130,
    2131,     0,  2132,     0,  2133,     0,  2134,     0,  2135,     0,
       0,     0,     0,  2134,     0,  2136,  2137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2138,  2139,  2140,
       0,     0,     0,  2128,     0,  2129,  2130,  2131,  2136,  2132,
       0,  2133,     0,     0,  3642,     0,     0,     0,  1187,     0,
    2134,     0,     0,     0,     0,     0,  2135,     0,     0,     0,
    2136,     0,     0,  1185,  1185,     0,  1185,     0,     0,     0,
    2137,     0,     0,     0,     0,     0,     0,  1185,     0,  1185,
    2137,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4189,     0,  1185,     0,  1185,     0,  1185,
       0,  1185,     0,  2128,  2137,  2129,  2130,  2131,  2136,  2132,
       0,  2133,  2135,  1185,  1185,     0,     0,     0,     0,  2135,
    2134,     0,  2138,  2139,  2140,  2137,     0,  2128,     0,  2129,
    2130,  2131,     0,  2132,     0,  2133,     0,     0,  1185,  3649,
       0,  2138,  2139,  2140,  2134,     0,     0,     0,  2137,     0,
       0,  2138,  2139,  2140,     0,     0,  2135,     0,  3663,  2128,
       0,  2129,  2130,  2131,  2136,  2132,     0,  2133,  4675,     0,
    2137,  2136,  2138,  2139,  2140,     0,  2134,  2128,     0,  2129,
    2130,  2131,  1185,  2132,     0,  2133,     0,  1185,  1185,  4684,
    2138,  2139,  2140,     0,  2134,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,  4685,  2136,     0,
    1185,  1985,     0,     0,     0,  2138,  2139,  2140,  2137,     0,
       0,     0,     0,     0,     0,     0,  2135,  1187,     0,     0,
       0,  1187,  4686,     0,     0,  2138,  2139,  2140,     0,     0,
    2128,     0,  2129,  2130,  2131,     0,  2132,     0,  2133,     0,
    2135,     0,  4690,     0,     0,  1187,     0,  2134,     0,  1985,
       0,     0,     0,     0,  1187,     0,     0,  2128,     0,  2129,
    2130,  2131,     0,  2132,  2137,  2133,     0,     0,  2136,     0,
       0,  2137,  2135,     0,  2134,     0,     0,     0,  4910,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2135,     0,  2136,     0,  2128,     0,  2129,  2130,  2131,     0,
    2132,     0,  2133,     0,     0,     0,     0,     0,  2137,     0,
       0,  2134,  2128,     0,  2129,  2130,  2131,     0,  2132,     0,
    2133,  2138,  2139,  2140,  2136,     0,     0,     0,     0,  2134,
       0,     0,     0,  1187,  1187,  1187,  1187,     0,  4691,  1985,
       0,     0,  2136,     0,     0,  1187,     0,     0,  2128,     0,
    2129,  2130,  2131,  2135,  2132,     0,  2133,     0,     0,  2138,
    2139,  2140,     0,     0,     0,  2134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4692,     0,  2137,     0,
    2135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4910,     0,     0,  2128,     0,  2129,  2130,  2131,     0,  2132,
       0,  2133,  2137,  1185,  1185,  2136,     0,  2138,  2139,  2140,
    2134,     0,     0,     0,     0,     0,     0,  2135,     0,  2138,
    2139,  2140,     0,  2128,  4693,  2129,  2130,  2131,     0,  2132,
       0,  2133,  2136,     0,  2137,  2135,  4695,     0,  1985,     0,
    2134,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,
    1027,  1028,  2137,     0,     0,  2138,  2139,  2140,  1942,  2128,
       0,  2129,  2130,  2131,     0,  2132,     0,  2133,  1185,  2136,
       0,  2135,  4704,     0,  5716,     0,  2134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2138,
    2139,  2140,     0,     0,     0,  2137,  2135,     0,     0,  2138,
    2139,  2140,  1187,  2136,     0,     0,  1985,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,  4705,     0,     0,     0,
       0,  1051,  2137,  2138,  2139,  2140,  2135,     0,     0,     0,
       0,   972,     0,     0,  3599,     0,     0,     0,     0,     0,
    4713,     0,  1185,  1185,  2138,  2139,  2140,     0,  2136,     0,
       0,     0,     0,     0,     0,     0,     9,     0,     0,  2137,
       0,  4719,  2135,     0,     0,   973,  1185,  2138,  2139,  2140,
       0,     0,     0,     0,     0,     0,     0,  2137,  2136,     0,
       0,     0,     0,     0,  4720,     0,    13,     0,     0,  2138,
    2139,  2140,     0,     0,     0,     0,     0,     0,     0,     0,
    1071,     0,     0,     0,     0,     0,  4728,  1985,     0,     0,
    1985,   974,     0,  2137,  2136,    19,     0,  2128,   975,  2129,
    2130,  2131,     0,  2132,  4910,  2133,  4910,     0,     0,    22,
       0,     0,     0,     0,  2134,     0,     0,  2138,  2139,  2140,
       0,     0,  1187,     0,     0,   976,     0,  1185,     0,  1185,
       0,     0,     0,   977,  4729,  3536,     0,     0,  2137,     0,
       0,     0,     0,     0,     0,    27,     0,     0,  2128,     0,
    2129,  2130,  2131,     0,  2132,     0,  2133,     0,     0,     0,
       0,     0,     0,     0,     0,  2134,     0,  1187,  2137,   978,
       0,     0,  1088,  2138,  2139,  2140,     0,     0,     0,     0,
    2138,  2139,  2140,     0,     0,     0,     0,     0,     0,     0,
    4732,     0,     0,     0,     0,     0,     0,  4736,     0,     0,
       0,     0,     0,     0,  2137,     0,     0,     0,     0,    38,
       0,  4910,     0,     0,     0,   979,   980,  2138,  2139,  2140,
    2135,     0,     0,     0,  2128,     0,  2129,  2130,  2131,     0,
    2132,     0,  2133,     0,  5101,     0,     0,     0,     0,     0,
    1185,  2134,     0,  4223,     0,  2128,     0,  2129,  2130,  2131,
       0,  2132,  1942,  2133,     0,     0,     0,     0,     0,     0,
       0,     0,  2134,     0,     0,     0,  1185,     0,     0,     0,
       0,  2135,  2136,     0,     0,  2128,     0,  2129,  2130,  2131,
       0,  2132,  5717,  2133,    50,     0,     0,  2138,  2139,  2140,
    5718,     0,  2134,  1185,     0,  4707,     0,     0,     0,     0,
       0,     0,     0,     0,  5432,     0,     0,     0,     0,     0,
       0,  2138,  2139,  2140,     0,     0,     0,  1185,  1185,  4225,
       0,    82,     0,  2136,     0,     0,     0,     0,  5438,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4227,     0,   981,  2138,  2139,  2140,     0,  2135,     0,  4170,
    2128,     0,  2129,  2130,  2131,     0,  2132,  1836,  2133,     0,
    5439,  2138,  2139,  2140,     0,     0,     0,  2134,  2135,     0,
    4710,     0,     0,     0,     0,     0,     0,     0,  5440,     0,
       0,     0,  2137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2135,  2136,
       0,     0,     0,     0,     0,     0,     0,     0,  5785,     0,
       0,     0,     0,     0,     0,   982,     0,     0,     0,     0,
    2136,     0,     0,     0,  2138,  2139,  2140,     0,     0,     0,
       0,     0,  4085,  2137,     0,     0,     0,     0,     0,     0,
       0,  5449,     0,     0,     0,     0,     0,     0,     0,     0,
    2136,  2138,  2139,  2140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  5450,     0,
       0,     0,     0,  2135,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2138,  2139,
    2140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  5454,  2138,  2139,  2140,  2137,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  5455,     0,  2136,     0,     0,     0,     0,
    2137,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,  2138,  2139,  2140,     0,     0,     0,     0,     0,
       0,     0,     0,   983,     0,     0,     0,     0,     0,  5887,
    2137,  1185,     0,     0,     0,     0,  1985,     0,     0,     0,
       0,  1185,     0,     0,     0,  1187,     0,  1187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2138,  2139,  2140,
       0,  1185,     0,     0,     0,  5719,     0,     0,  5720,     0,
       0,     0,     0,     0,  6066,     0,     0,     0,  5721,     0,
    1155,     0,     0,     0,     0,     0,     0,  2138,  2139,  2140,
       0,     0,     0,     0,  5785,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2137,  1187,  1187,     0,     0,
    1836,     0,  1187,     0,     0,     0,  1187,  1187,  1187,     0,
       0,     0,     0,  2138,  2139,  2140,     0,  1187,  1187,  1985,
       0,     0,     0,  1187,     0,     0,     0,  1187,  1187,  1187,
       0,  1187,  1187,  1187,  1985,  1985,     0,     0,     0,     0,
       0,  1187,     0,  1187,     0,     0,  1187,  1187,  1187,  1187,
       0,  1187,     0,  1187,  1187,  1187,     0,     0,     0,     0,
    1187,     0,     0,  1187,     0,     0,     0,     0,     0,     0,
    1187,  1187,  1187,  1185,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,     0,  1187,  1187,  1187,  1187,  1187,
       0,  1187,  1187,     0,  1187,  1187,  1187,     0,     0,  1187,
    1187,  1187,     0,  1187,  1187,  1187,     0,  1187,     0,  1187,
       0,  1187,     0,     0,  4610,  1187,  1187,  1187,     0,     0,
    1187,  1187,  1187,  1187,  1187,     0,  1187,     0,  6091,  4085,
       0,     0,  6091,  1187,     0,     0,  1187,     0,     0,  1525,
       0,     0,     0,     0,  1187,     0,     0,     0,  1187,  1187,
    1187,  1187,     0,  1187,  1187,   878,     0,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
       0,     0,  1187,     0,     0,     0,     0,  1985,     0,  2128,
       0,  2129,  2130,  2131,  1985,  2132,     0,  2133,     0,     0,
       0,  2138,  2139,  2140,     0,     0,  2134,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,  1187,
    4871,     0,  4872,     0,     0,     0,     0,  4873,     4,     5,
       0,     0,     0,     0,     0,     0,     0,  1985,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2778,  2779,
    2780,  2781,  2138,  2139,  2140,  3317,     0,     0,     0,  6193,
       0,     0,     0,     0,     0,  6193,  6193,  1018,  1019,  1020,
    1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,     0,
    -960,     0,  -960,     0,     0,     0,     0,  6091,     0,  3318,
       0,     0,     0,     0,  2782,  2783,  2784,  6239,     0,     0,
       0,     0,     0,     0,     0,  6091,  1187,     0,  2484,     0,
       0,     0,  2135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3319,     0,  2138,  2139,
    2140,     0,  1996,     0,  1187,     0,  1187,     0,     0,     0,
       0,     0,     0,     0,  6239,  2785,  2786,     0,     0,  2138,
    2139,  2140,     0,  1185,  4874,     0,  2023,     0,     0,     0,
    1985,     0,     0,     0,  2136,  2037,     0,  1051,     0,     0,
       0,  1187,     0,     0,     0,     0,  4875,     0,     0,  2138,
    2139,  2140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  6193,     0,     0,     0,     4,     5,     0,     0,     0,
       0,     0,     0,     0,  6193,     0,     0,     0,  6193,     0,
    2787,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4876,     4,     5,     0,     0,     0,
       0,     0,     0,  2320,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1071,  2124,     0,  6091,
       0,     0,     0,  1269,  2138,  2139,  2140,     0,  1187,     0,
       0,     0,     0,   684,  1985,     0,  1985,     0,     4,     5,
       0,     0,     0,     0,  2137,  2788,     0,  1238,     0,     0,
       0,     0,  4877,  4878,  4879,  1270,  1271,     0,     0,     0,
    1185,     0,     0,  1187,     0,  1272,     0,     0,     0,     0,
       0,     0,     0,     0,  4880,     0,  2320,     0,     0,    15,
      16,     0,     0,     0,     0,     0,  6193,  6397,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1088,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1273,  6091,     0,     0,     0,  4881,     0,  4882,     0,
       0,     0,     0,     0,     0,  1274,     0,     0,  2789,     0,
       0,     0,     0,     0,     0,  -960,     0,  4883,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4884,     0,  4873,     4,     5,
       0,     0,  4885,     0,     0,     0,     0,     0,  6193,     0,
    6193,  6193,     0,     0,     0,     0,     0,  4886,     0,     0,
    1275,     0,     0,     0,     0,     0,     0,  4887,     0,     0,
       0,  3320,  1276,  2318,  1185,     0,     0,  2790,  1185,     0,
       0,     0,  4888,     0,     0,     0,     0,  2321,  5717,     0,
    -960,     0,  -960,     0,  6193,     0,  5718,     0,     0,   677,
       0,  3321,  3322,     0,  3323,  3324,  3325,  3326,  3327,     0,
    3328,  3329,  3330,  3331,  3332,  3333,  3334,  3335,  2484,  3336,
    3337,  3338,     0,     0,     0,     0,     0,     0,     0,  1277,
       0,     0,  6193,  2778,  2779,  2780,  2781,     0,     0,  4889,
     972,     0,  2791,     0,  2792,     0,     0,     0,     0,  4890,
    2793,     0,     0,     0,  1187,     0,     0,     0,  6193,     0,
    2321,     0,     0,     0,  4874,     9,     0,     0,     0,     0,
       0,     0,     0,  1278,   973,     0,     0,     0,     0,  2782,
    2783,  2784,     0,     0,     0,     0,  4891,     0,     0,     0,
       0,  1279,     0,     0,     0,    13,     0,  1985,  1187,  4892,
    1280,     0,     0,     0,     0,  1185,  1187,  1187,     0,     0,
       0,  2794,  1281,  2479,     0,  3339,  3340,     0,     0,     0,
     974,     0,     0,  1282,    19,     0,     0,   975,     0,     0,
    2785,  2786,     0,     0,  4876,  2322,     0,     0,    22,  4893,
       0,     0,     0,     0,     0,  4894,  1283,     0,     0,  2323,
       0,  2324,     0,     0,   976,  2795,     0,     0,  2522,     0,
       0,  1187,   977,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1985,  1985,    27,     0,     0,     0, -2329,  1284,
       0,     0,  1285,  2325,  1286,     0,     0,     0,     0,     0,
       0,     0,  4877,  4878,  4879,  2787,  2326,     0,   978,  1187,
    1187,  1187,     0,  4895,     0,     0,     0,     0,  2322,     0,
    4896,  1287,  1288,     0,  4880,     0,     0,  1289,  1290,     0,
       0,     0,  2323,     0,  2324,     0,     0,     0,     0,  2327,
       0,     0,     0,     0,  1291,     0,     0,     0,    38,     0,
       0,     0,  4897,     0,   979,   980,     0,  2328,  2796,     0,
       0,     0,     0,     0,     0,  1292,  2325,  4898,  4899,  2797,
    2788,  1985,     0,  2138,  2139,  2140,  4881,     0,  4882,  2326,
    4900,     0,  1187,     0,     0,  1985,     0,  1293,     0,     0,
       0,     0,     0,     0,     0,  -960,     0,  4883,     0,     0,
    1187,     0,     0,     0,  1187,  1187,     0,  1187,  1187,     0,
       0,  5719,  2327,     0,  5720,  4884,  1187,     0,  1187,     0,
       0,     0,  4885,    50,  5890,     0,     0,     0,     0,     0,
    2328, -3892,     0,     0,     0,  2329,     0,  4886,     0,     0,
       0,  1294,  2330,     0,     0,     0,  1187,  4887,     0,     0,
       0,     0,  2331,     0,     0,     0,  1295,     0,     0,     0,
      82,     0,  4888,  2789,     0,  1296,  2332,     0,  1297,  1298,
       0,     0,     0,     0,  1187,     0,     0,     0,     0,     0,
       0,   981,     0,  1299,     0,     0,     0,  1187,     0,     0,
       0,  1985,     0,     0,     0,     0,     0,     0,  2333,     0,
    1187,  2334,     0,     0,     0,     0,     0,     0,  2329,     0,
       0,     0,     0,     0,     0,  2330,     0,  2335,     0,  4889,
    1300,     0,     0,     0,     0,  2331,  1187,     0,  1301,  4890,
       0,     0,  2790,   678,     0,     0,     0, -3892,     0,  2332,
       0,     0,     0,     0,     0,     0,     0, -3348,  2336,  1302,
       0,     0,     0,     0,   982,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4891,     0,     0,     0,
    1187,  2333,     0,     0,  2334,     0,     0,  1985,     0,  4892,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2335,     0,     0,     0,     0,     0,     0,  2791,     0,  2792,
   -3348,     0,     0,     0,     0,  2793,     0,  1303,     0,     0,
       0,     0,     0,  1985,  1985,     0,     0,     0,     0,  4893,
       0,  2336,     0,     0,     0,  4894,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1187,     0,     0,  2794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2699,     0,  2699,     0,
       0,     0,     0,  4895,     0,     0,     0,     0,     0,     0,
    4896,     0,   983,     0,     0,     0,  1187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1985,
    2795,  1985,  1985,  1985,     0,  1187,     0,     0,     0,  1187,
    1187,     0,  4897,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4898,  4899,     0,
       0,     0,     0,  2747,     0,     0,     0,  2752,     0,  2754,
    4900,     0,     0,     0,     0,     0,     0,     0,  2770,  2771,
       0,     0,     0,     0,  2800,     0,     0,     0,  2805,  2806,
    2807,     0,  2809,  2810,  2811,     0,     0,     0,  1187,     0,
       0,     0,  2819,     0,  2822,     0,     0,  2823,  2824,  2825,
    2826,     0,     0,     0,  2830,  2831,  2832,     0,     0,     0,
       0,  2837,     0,  2796,  2845,     0,     0,     0,     0,     0,
       0,  2849,  2850,  2851,  2797,  2854,     0,  2856,  2857,  2858,
    2859,  2862,  2863,     0,  2866,     0,  2867,  2868,  2869,  2870,
    2871,     0,  2877,  2878,     0,  2881,  2882,  2883,     0,     0,
    2886,     0,  2888,     0,  2890,  2891,  2892,     0,  2894,     0,
    2896,     0,  2897,     0,     0,     0,  2900,  2845,  2902,     0,
       0,  2908,  2909,     0,  2911,  2912,     0,  2913,     0,     0,
       0,     0,     0,     0,  2917,     0,  1187,  1187,     0,     0,
       0,     0,     0,     0,     0,  2925,     0,     0,     0,  2926,
    2927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1985,     0,     0,     0,     0,     0,
    3017,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1187,     0,     0,     0,
    1187,     0,     0,  1187,     0,     0,     0,     0,     0,     0,
       0,     0,  1187,     0,   972,     0,     0,     0,     0,     0,
       0,  1187,     0,  1187,  1187,     0,  1187,  1187,  1187,  1187,
       0,  1187,     0,  1187,  1187,     0,  1187,  3096,     0,     9,
       0,     0,     0,     0,  1187,  1187,     0,     0,   973,  1187,
    1187,  1187,  1187,     0,     0,  1187,  1187,     0,     0,     0,
    1187,     0,  1187,     0,  1187,  3126,  1187,  3131,     0,    13,
    1187,  1187,     0,     0,     0,     0,     0,     0,  1187,     0,
    1187,     0,  1187,  1187,  1187,     0,  1187,     0,     0,  1187,
    1187,  1187,  1187,     0,   974,  1187,     0,     0,    19,     0,
       0,   975,  3153,     0,     0,     0,     0,     0,  1187,     0,
       0,  1187,    22,  1187,  1187,  1187,     0,     0,  1187,     0,
       0,     0,     0,     0,  1187,     0,     0,     0,   976,     0,
       0,     0,     0,     0,     0,     0,   977,     0,     0,     0,
    1549,  1550,  1187,     0,  1187,  1554,  1555,  1187,    27,     0,
       0,   972,     0,     0,     0,  1564,     0,  1187,  1985,  1187,
       0,     0,     0,     0,  1187,     0,     0,     0,     0,     0,
       0,     0,   978,     0,     0,  1985,     9,     0,     0,     0,
    1587,     0,     0,     0,     0,   973,     0,     0,     0,  3228,
       0,     0,     0,  1600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,     0,  1615,
       0,  6263,    38,     0,  1187,     0,     0,     0,   979,   980,
       0, -3733, -3733, -3733,     0,     0,  1187,     0,     0,     0,
       0,   974,     0,     0,     0,    19,     0,     0,   975,  1639,
       0,     0,  1985,     0,     0,     0,     0,     0,     0,    22,
       0,     0,     0,     0,     0,     0,     0,     0,  1658,  1659,
    1660,     0,     0,     0,     0,   976,     0,     0,  1668,  1669,
    1670,     0,  1187,   977,     0,     0,     0,     0,     0,     0,
     923,     0,     0,     0,     0,    27,  1685,    50,     0,     0,
       0,     0,     0,  1187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   978,
       0,     0,   924,     0,     0,     0,     0,     0,  1714,     0,
       0,     0,     0,     0,    82,     0,     0,     0,     0,     0,
       0,     0,     0,   926,     0,     0,     0,     0,     0,  4873,
       4,     5,   927,     0,     0,   981,  1742,     0,     0,    38,
       0,     0,     0,     0,     0,   979,   980,     0,     0,     0,
       0,     0,     0,   928,     0,  1187,     0,  5668,     0,  4990,
    1765,  1766,  1767,     0,     0,     0,     0,   929,     0,     0,
       0,     0,   930,     0,     0,     0,  1187,     0,     0,     0,
       0,  4992,     0,  1787,  1788,     0,     0,     0,  1985,  4994,
       0,     0,     0,     0,     0,   931,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   982,     0,
    2484,     0, -3733,     0,    50,     0,     0,     0,     0,     0,
       0,  5669,     0,     0,     0,     0,     0,     0,     0,  1799,
       0,  1800,  1801,     0,     0,  3481,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1802,     0,     0,
       0,    82,     0,     0,   932,     0,  4874,     0,   933,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   981,     0,     0,     0,     0,   934,     0,  3531,
       0,   935,   936,  1803,  4996,  1804,     0,  3538,  3539,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   937,     0,     0,     0,  4998,     0,     0,
       0,   938,   939,     0,     0,     0,  4876,     0, -3733,     0,
       0,     0,  1806,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3558,     0,     0,   982,   983,     0,     0,     0,
       0,  5000,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1807,     0,     0,  2676,  1985,     0,     0,
    3594,  3596,  3598,     0,  4877,  4878,  4879,     0,     0,     0,
       0,  1187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4880,     0,   972,     0,
    1187,     0,     0,     0,     0,  2677,     0,     0,     0,     0,
       0,     0,     0,     0,  1187,     0,     0,  1187,     0,     0,
       0,     0,     0,     9,  1808,  1809,     0,     0,     0,     0,
       0,     0,   973,     0,     0,     0,     0,     0,     0,     0,
    5001,  1810,  1811,     0,  1187,  1187,     0,     0,  4881,  1187,
    4882,  2678,     0,    13,     0,     0,  2679,     0,     0,     0,
       0,  3676,     0,     0,     0,     0,     0,  2680,  2681,  4883,
    1187,     0,  1187,   983,  1187,     0,  1187,  3684,   974,  3685,
       0,     0,    19,  1813,     0,   975,     0,  4884,  2183,     0,
    4873,     4,     5,     0,  4885,     0,    22,  1187,     0,     0,
       0,     0,   972,  1985,     0,     0,     0,  3707,     0,  4886,
       0,     0,   976,     0,     0,     0,     0,  1187,  1187,  4887,
     977,     0,  1187,  5003,  1187,     0,  1187,     9,     0,     0,
    5005,  1187,    27,     0,  4888,  3723,   973,     0,     0,     0,
       0,     0,     0,  1187,     0,     0,     0,     0,  2479,     0,
       0,     0,     0,     0,     0,     0,   978,    13,     0,     0,
       0,  2479,     0,  5007,     0,     0,     0,     0,  1985,     0,
       0,  2484,     0,     0,  1187,     0,     0,  1815,     0,     0,
    1816,     0,   974,  1817,     0,     0,    19,  3781,  1187,   975,
       0,  4889,  1187,     0,     0,     0,    38,     0,     0,     0,
      22,  4890,   979,   980,     0,     0,     0,  1818,     0,     0,
    1187,     0,     0,     0,     0,     0,   976,  4874,     0,     0,
       0,     0,  2682,     0,   977,     0,     0,  1820,     0,     0,
    1985,  3131,  2683,     0,     0,     0,    27,     0,  4891,     0,
       0,     0,     0,  2684,     0,     0,     0,     0,     0,  2685,
       0,  4892,     0,  5009,     0,     0,     0,     0,     0,     0,
     978,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
    2686,     0,     0,     0,  2687,     0,     0,  4876,     0,     0,
       0,  4893,     0,     0,     0,     0,     0,  4894,     0,     0,
      38,  1187,     0,     0,     0,     0,   979,   980,    82,     0,
       0,  1187,     0,  2688,     0,     0,   972,     0,     0,     0,
       0,     0,     0,     0,  3891,  1187,     0,  1985,  1187,   981,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     9,     0,     0,     0,  4877,  4878,  4879,     0,     0,
     973,     0,     0,     0,     0,  4895,     0,  3916,     0,     0,
       0,     0,  4896,     0,     0,     0,     0,  4880,     0,     0,
       0,    13,     0,     0,     0,    50,  3916,     0,     0,     0,
    2479,  2479,     0,     0,     0,  1962,     0,     0,     0,     0,
       0,     0,     0,     0,  4897,     0,   974,     0,     0,     0,
      19,     0,   982,   975,     0,     0,     0,     0,     0,  4898,
    4899,     0,    82,     0,    22,     0,     0,     0,     0,  4881,
       0,  4882,  4900,     0,     0,     0,     0,     0,     0,     0,
     976,     0,     0,   981,     0,     0,     0,     0,   977,  4015,
    4883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      27,     0,     0,     0,     0,     0,     0,     0,  4884,     0,
       0,     0,     0,     0,     0,  4885,     0,     0,     0,     0,
       0,     0,     0,     0,   978,     0,     0,     0,     0,     0,
    4886,     0,     0,     0,     0,     0,     0,     0,     0,  4131,
    4887,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4888,   982,     0,     0,     0,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
     979,   980,     0,     0,     0,     0,     0,  1187,  1187,     0,
    1187,     0,     0,     0,     0,     0,     0,  4092,  4093,     0,
     983,  1187,     0,  1187,     0,     0,  1187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1187,
       0,  1187,  4889,  1187,     0,  1187,     0,     0,     0,     0,
       0,     0,  4890,     0,     0,     0,     0,  1187,  1187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1187,     0,     0,     0,     0,     0,     0,  4891,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     972,     0,  4892,     0,     0,     0,    82,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   983,     9,  1187,   981,     0,     0,
       0,  1187,  1187,     0,   973,     0,     0,  4166,     0,     0,
       0,  4168,  4893,     0,  4169,     0,     0,     0,  4894,     0,
    1187,     0,     0,     0,  1187,    13,     0,     0,     0,     0,
       0,     0,  4199,     0,     0,     0,     0,  4203,  4204,  4205,
    4206,     0,  4207,     0,  4208,  4209,     0,     0,     0,     0,
     974,     0,     0,  4367,    19,  4213,  4214,   975,     0,     0,
    4215,  4216,  4217,  4218,     0,   972,  4219,  4220,    22,     0,
     982,  4222,     0,  4224,     0,  4226,  4895,  4228,     0,     0,
       0,  4230,  4231,  4896,   976,     0,     0,     0,     0,  2859,
       9,  4234,   977,  2859,     0,  4237,     0,  4238,     0,   973,
    4239,  4240,  4242,  4243,    27,     0,  4244,     0,     0,     0,
       0,     0,     0,     0,     0,  4897,     0,     0,     0,     0,
   -3718,     0,  4251,     0,  4252,  4253,  4254,     0,   978,  4255,
    4898,  4899,     0,     0,     0,  4259,     0,     0,     0,     0,
       0,     0,     0,  4900,     0,   974,     0,     0,     0, -3717,
       0,     0,   975,     0,     0,     0,     0,     0,  4278,     0,
       0,     0,     0,    22,     0,     0,     0,     0,    38,     0,
    4289,     0,     0,     0,   979,   980,     0,     0,     0,   976,
       0,     0,     0,     0,     0,     0,     0,   977,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3717,
       0,     0,     0,     0,     0,     0,     0,     0,   983,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   978,     0,  4325,     0,  1187,  1187,     0,
       0,     0,     0,     0,     0,     0,     0,  2479,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3717,     0,     0,     0,     0,     0,   979,
     980,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      82,     0,     0,  3131,     0,     0,     0,     0,     0,     0,
       0,     0,  1187,     0,     0,  1985,     0,     0,     0,     0,
       0,   981,     0,     0,  3131,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3717,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   982, -3718,     0,     0,  1985,     0,
       0,     0,     0,     0,     0,     0,  1187,  1187,     0,     0,
       0,     0,     0,     0,     0,     0,   981,  4469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   982,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1187,     0,  1187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   983,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1187,     0,     0,   983,     0,     0,
       0,     0,  4627,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1187,  4647,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4654,     0,     0,  4655,     0,
       0,     0,     0,     0,     0,     0,     0,  1187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4673,  4674,     0,     0,     0,
    4679,  1187,  1187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4700,     0,  4701,     0,  4702,     0,  4703,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4749,  4750,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3916,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4769,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2479,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2479,
       0,     0,     0,  2479,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3131,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1187,     0,     0,     0,     0,
       0,     0,  4944,     0,     0,  1187,     0,     0,     0,  1985,
       0,     0,  3916,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1187,  3916,     0,     0,  4958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  5102,  5103,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5110,     0,  5111,     0,     0,  5112,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    5132,     0,  5133,     0,  5134,     0,  5135,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1187,  5141,  5142,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2479,     0,     0,
       0,     0,  2479,  2479,     0,     0,     0,     0,     0,     0,
       0,  1985,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3131,     0,     0,     0,  3131,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1985,     0,
       0,     0,     0,     0,     0,     0,     0,  1187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  5384,  5385,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3916,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1187,     0,
       0,     0,  1187,     0,  3916,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2479,  2479,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3131,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5606,     0,  5608,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  5707,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3916,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2479,  2479,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3916,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3131,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  6149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1013,     0,     0,
       0,  1014,  1015,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,
    1023,  1024,  1025,  1026,  1027,  1028,     0,     0,  6278,     0,
       0,     0,     0,  1029,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1030,  1031,  1032,  1033,     0,     0,     0,     0,     0,     0,
       0,  1034,  1035,     0,  1036,     0,     0,     0,     0,     0,
       0,  1037,  1038,     0,     0,  1039,  1040,  1041,  1042,     0,
    1043,  1044,     0,  1045,  1046,     0,     0,     0,     0,     0,
       0,     0,  1047,     0,     0,  1048,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    18,
    2124,     0,     0,  1049,  1050,  1051,     0,  1052,     0,     0,
       0,     0,     0,     0,     0,  1053,  1054,  1055,    21,     0,
       0,     0,     0,     0,  1056,     0,     0,   572,     0,     0,
       0,     0,     0,  1057,     0,     0,  1058,     0,     0,     0,
       0,     0,     0,     0,     0,  1059,     0,  1060,     0,  1061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,  1063,     0,  1064,     0,     0,     0,
    1065,     0,     0,     0,     0,  1066,     0,     0,    28,  1067,
       0,  1068,  1069,  1070,  1071,     0,     0,     0,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    33,  1072,  1073,  1074,     0,  1075,     0,     0,     0,
       0,     0,     0,  1076,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1077,  1078,     0,     0,     0,     0,
       0,     0,     0,  1079,  1080,     0,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1081,     0,     0,     0,     0,     0,     0,  1082,
    1083,     0,  1084,  1085,  1086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1087,  1088,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1089,  1090,  1091,     0,
       0,    49,     0,     0,  1092,  1093,     0,     0,     0,  3131,
      51,     0,     0,     0,    52,    53,    54,   573,    55,    56,
      57,    58,    59,  1094,    60,    61,    62,  1095,  1096,    65,
      66,    67,    68,    69,    70,  1097,    72,    73,    74,    75,
      76,    77,    78,  1098,   574,     0,   575,   576,    84,    85,
      86,    87,    88,    89,   577,    91,    92,    93,    94,  1099,
      95,   579,    97,    98,    99,   100,   101,   580,  1100,   103,
    1101,   105,  1102,  1103,  1104,  1105,  1106,     0,   111,   112,
     113,   581,   115,   116,   117,   118,   119,   120,   121,   122,
     123,  1107,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,  1108,  1109,  1110,   583,  1111,  1112,   141,
       0,   142,   143,   144,   145,   146,   147,   148,   584,   150,
     151,   152,   153,   585,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   586,   168,     0,
    3131,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   587,   588,   181,     0,  1113,   183,   184,   589,
     186,   187,  1114,   590,   190,   191,   591,   193,   194,   592,
       0,   196,   197,   198,  1115,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   593,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   594,   219,  1116,  1117,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,  1118,
     264,  1119,   266,   267,   268,   269,   270,  1120,   272,   273,
     274,   275,   276,   277,   278,   279,   280,  1121,  1122,   283,
     284,   285,   286,   287,   595,   288,   289,   290,   291,   292,
     293,   294,   295,     0,  1123,   297,   298,   299,   596,   300,
     301,  1124,   303,   304,   305,   306,   307,   308,   309,  1125,
     311,   312,   313,   314,   315,   316,   597,   317,   598,   319,
     320,  1126,   322,   323,   324,   325,   326,   327,  1127,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   599,   348,   349,
     350,   600,   352,   353,   354,   355,   356,   357,   358,  1128,
     360,   601,   362,   363,   364,  1129,  1130,   367,   368,   602,
     370,   371,  1131,   373,   374,   375,   376,   377,   378,  1132,
     380,   603,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,     0,   397,   398,
     399,   400,   604,   402,   403,   605,   405,   406,   407,   408,
    1133,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,  1134,
    1135,  1136,  1137,   432,   433,   434,   435,  1138,  1139,   438,
     439,   440,   441,   442,   443,   444,   445,   446,   607,   448,
     449,   450,  1140,   452,  1141,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,  1142,  1143,   608,  1144,   468,
     469,   470,     0,   471,   609,   473,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,  1147,     0,     0,     0,
    1013,  1148,     0,     0,  1014,  1015,  1149,     0,     0,     0,
    1150,  1151,     0,     0,  1152,  1016,  1017,     0,  1018,  1019,
    1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,
       0,     0,     0,     0,     0,     0,  1029,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1030,  1031,  1032,  1033,     0,     0,     0,
    2842,     0,     0,     0,  1034,  1035,     0,  1036,     0,     0,
       0,     0,     0,     0,  1037,  1038,     0,     0,  1039,  1040,
    1041,  1042,     0,  1043,  1044,     0,  1045,  1046,     0,     0,
       0,     0,     0,     0,     0,  1047,     0,     0,  1048,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,  1049,  1050,  1051,     0,
    1052,     0,     0,     0,     0,     0,     0,     0,  1053,  1054,
    1055,    21,     0,     0,     0,     0,     0,  1056,     0,     0,
     572,     0,     0,     0,     0,     0,  1057,     0,     0,  1058,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,  2843,
    1060,     0,  1061,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1062,  1063,     0,  1064,
       0,     0,     0,  1065,     0,     0,     0,     0,  1066,     0,
       0,    28,  1067,     0,  1068,  1069,  1070,  1071,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,  1072,  1073,  1074,     0,  1075,
       0,     0,     0,     0,     0,     0,  1076,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1077,  1078,     0,
       0,     0,     0,     0,     0,     0,  1079,  1080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1081,     0,     0,     0,     0,
       0,     0,  1082,  1083,     0,  1084,  1085,  1086,     0,     0,
       0,     0,     0,     0,     0,     0,  2844,     0,  1087,  1088,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1089,
    1090,  1091,     0,     0,     0,     0,     0,  1092,  1093,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,  1094,    60,    61,    62,
    1095,  1096,    65,    66,    67,    68,    69,    70,  1097,    72,
      73,    74,    75,    76,    77,    78,  1098,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,  1099,    95,   579,    97,    98,    99,   100,   101,
     580,  1100,   103,  1101,   105,  1102,  1103,  1104,  1105,  1106,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,  1107,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,  1108,  1109,  1110,   583,
    1111,  1112,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,  1113,
     183,   184,   589,   186,   187,  1114,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,  1115,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,  1116,
    1117,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,  1118,   264,  1119,   266,   267,   268,   269,   270,
    1120,   272,   273,   274,   275,   276,   277,   278,   279,   280,
    1121,  1122,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,  1123,   297,   298,
     299,   596,   300,   301,  1124,   303,   304,   305,   306,   307,
     308,   309,  1125,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,  1126,   322,   323,   324,   325,   326,
     327,  1127,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,  1128,   360,   601,   362,   363,   364,  1129,  1130,
     367,   368,   602,   370,   371,  1131,   373,   374,   375,   376,
     377,   378,  1132,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,  1133,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,  1134,  1135,  1136,  1137,   432,   433,   434,   435,
    1138,  1139,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,  1140,   452,  1141,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,  1142,  1143,
     608,  1144,   468,   469,   470,     0,   471,   609,   473,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,  1146,  1147,
       0,     0,     0,  1013,  1148,     0,     0,  1014,  1015,  1149,
       0,     0,     0,  1150,  1151,     0,     0,  1152,  1016,  1017,
       0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,
    1027,  1028,     0,     0,     0,     0,     0,     0,     0,  1029,
       0,     0,     0,     0,     0,     0,  2475,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2476,  1031,  1032,  1033,
       0,     0,     0,     0,     0,     0,     0,  1034,  1035,     0,
    1036,     0,     0,     0,     0,     0,     0,  1037,  1038,     0,
       0,  1039,  1040,  1041,  1042,     0,  1043,  1044,     0,  1045,
    1046,     0,     0,     0,     0,     0,     0,     0,  2477,     0,
       0,  1048,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,     0,     0,  1049,
    1050,  1051,     0,  1052,     0,     0,     0,     0,     0,     0,
       0,  1053,  1054,  1055,    21,     0,     0,     0,     0,     0,
    1056,     0,     0,   572,     0,     0,     0,     0,     0,  1057,
       0,     0,  1058,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,  1060,     0,  1061,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
    1063,     0,  1064,     0,     0,     0,  1065,     0,     0,     0,
       0,  1066,     0,     0,    28,  1067,     0,  1068,  1069,  1070,
    1071,     0,  2478,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,  1072,  1073,
    1074,     0,  1075,     0,     0,     0,     0,     0,     0,  1076,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1077,  1078,     0,     0,     0,     0,     0,     0,     0,  1079,
    1080,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1081,     0,
       0,     0,     0,     0,     0,  1082,  1083,     0,  1084,  1085,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1087,  1088,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1089,  1090,  1091,     0,     0,     0,     0,     0,
    1092,  1093,     0,     0,     0,     0,     0,     0,     0,     0,
      52,    53,    54,   573,    55,    56,    57,    58,    59,  1094,
      60,    61,    62,  1095,  1096,    65,    66,    67,    68,    69,
      70,  1097,    72,    73,    74,    75,    76,    77,    78,  1098,
     574,     0,   575,   576,    84,    85,    86,    87,    88,    89,
     577,    91,    92,    93,    94,  1099,    95,   579,    97,    98,
      99,   100,   101,   580,  1100,   103,  1101,   105,  1102,  1103,
    1104,  1105,  1106,     0,   111,   112,   113,   581,   115,   116,
     117,   118,   119,   120,   121,   122,   123,  1107,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,  1108,
    1109,  1110,   583,  1111,  1112,   141,     0,   142,   143,   144,
     145,   146,   147,   148,   584,   150,   151,   152,   153,   585,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   586,   168,     0,     0,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   587,   588,
     181,     0,  1113,   183,   184,   589,   186,   187,  1114,   590,
     190,   191,   591,   193,   194,   592,     0,   196,   197,   198,
    1115,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     593,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     594,   219,  1116,  1117,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,  1118,   264,  1119,   266,   267,
     268,   269,   270,  1120,   272,   273,   274,   275,   276,   277,
     278,   279,   280,  1121,  1122,   283,   284,   285,   286,   287,
     595,   288,   289,   290,   291,   292,   293,   294,   295,     0,
    1123,   297,   298,   299,   596,   300,   301,  1124,   303,   304,
     305,   306,   307,   308,   309,  1125,   311,   312,   313,   314,
     315,   316,   597,   317,   598,   319,   320,  1126,   322,   323,
     324,   325,   326,   327,  1127,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   599,   348,   349,   350,   600,   352,   353,
     354,   355,   356,   357,   358,  1128,   360,   601,   362,   363,
     364,  1129,  1130,   367,   368,   602,   370,   371,  1131,   373,
     374,   375,   376,   377,   378,  1132,   380,   603,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,     0,   397,   398,   399,   400,   604,   402,
     403,   605,   405,   406,   407,   408,  1133,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,  1134,  1135,  1136,  1137,   432,
     433,   434,   435,  1138,  1139,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   607,   448,   449,   450,  1140,   452,
    1141,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,  1142,  1143,   608,  1144,   468,   469,   470,     0,   471,
     609,   473,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,  1146,  1147,     0,     0,     0,  1013,  1148,     0,     0,
    1014,  1015,  1149,     0,     0,     0,  1150,  1151,     0,     0,
    1152,  1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,  1023,
    1024,  1025,  1026,  1027,  1028,     0,     0,     0,     0,     0,
       0,     0,  1029,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1030,
    1031,  1032,  1033,     0,     0,     0,     0,     0,     0,     0,
    1034,  1035,     0,  1036,     0,     0,     0,     0,     0,     0,
    1037,  1038,     0,     0,  1039,  1040,  1041,  1042,     0,  1043,
    1044,     0,  1045,  1046,     0,     0,     0,     0,     0,     0,
       0,  1047,     0,     0,  1048,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    18,     0,
       0,     0,  1049,  1050,  1051,     0,  1052,     0,     0,     0,
       0,     0,     0,     0,  1053,  1054,  1055,    21,     0,     0,
       0,     0,     0,  1056,     0,     0,   572,     0,     0,     0,
       0,     0,  1057,     0,     0,  1058,     0,     0,     0,     0,
       0,     0,     0,     0,  1059,     0,  1060,     0,  1061,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1062,  1063,     0,  1064,     0,     0,     0,  1065,
       0,     0,     0,     0,  1066,     0,     0,    28,  1067,     0,
    1068,  1069,  1070,  1071,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,  1072,  1073,  1074,     0,  1075,     0,     0,     0,     0,
       0,     0,  1076,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1077,  1078,     0,     0,     0,     0,     0,
       0,     0,  1079,  1080,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1081,     0,     0,     0,     0,     0,     0,  1082,  1083,
       0,  1084,  1085,  1086,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1087,  1088,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1089,  1090,  1091,     0,     0,
       0,     0,     0,  1092,  1093,     0,  1995,     0,     0,     0,
       0,     0,     0,    52,    53,    54,   573,    55,    56,    57,
      58,    59,  1094,    60,    61,    62,  1095,  1096,    65,    66,
      67,    68,    69,    70,  1097,    72,    73,    74,    75,    76,
      77,    78,  1098,   574,     0,   575,   576,    84,    85,    86,
      87,    88,    89,   577,    91,    92,    93,    94,  1099,    95,
     579,    97,    98,    99,   100,   101,   580,  1100,   103,  1101,
     105,  1102,  1103,  1104,  1105,  1106,     0,   111,   112,   113,
     581,   115,   116,   117,   118,   119,   120,   121,   122,   123,
    1107,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,  1108,  1109,  1110,   583,  1111,  1112,   141,     0,
     142,   143,   144,   145,   146,   147,   148,   584,   150,   151,
     152,   153,   585,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   586,   168,     0,     0,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   587,   588,   181,     0,  1113,   183,   184,   589,   186,
     187,  1114,   590,   190,   191,   591,   193,   194,   592,     0,
     196,   197,   198,  1115,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   593,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   594,   219,  1116,  1117,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,  1118,   264,
    1119,   266,   267,   268,   269,   270,  1120,   272,   273,   274,
     275,   276,   277,   278,   279,   280,  1121,  1122,   283,   284,
     285,   286,   287,   595,   288,   289,   290,   291,   292,   293,
     294,   295,     0,  1123,   297,   298,   299,   596,   300,   301,
    1124,   303,   304,   305,   306,   307,   308,   309,  1125,   311,
     312,   313,   314,   315,   316,   597,   317,   598,   319,   320,
    1126,   322,   323,   324,   325,   326,   327,  1127,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,   599,   348,   349,   350,
     600,   352,   353,   354,   355,   356,   357,   358,  1128,   360,
     601,   362,   363,   364,  1129,  1130,   367,   368,   602,   370,
     371,  1131,   373,   374,   375,   376,   377,   378,  1132,   380,
     603,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,     0,   397,   398,   399,
     400,   604,   402,   403,   605,   405,   406,   407,   408,  1133,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,  1134,  1135,
    1136,  1137,   432,   433,   434,   435,  1138,  1139,   438,   439,
     440,   441,   442,   443,   444,   445,   446,   607,   448,   449,
     450,  1140,   452,  1141,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,  1142,  1143,   608,  1144,   468,   469,
     470,     0,   471,   609,   473,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,  1146,  1147,     0,     0,     0,  1013,
    1148,     0,     0,  1014,  1015,  1149,     0,     0,     0,  1150,
    1151,     0,     0,  1152,  1016,  1017,     0,  1018,  1019,  1020,
    1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,     0,
       0,     0,     0,     0,     0,  1029,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1030,  1031,  1032,  1033,     0,     0,     0,     0,
       0,     0,     0,  1034,  1035,     0,  1036,     0,     0,     0,
       0,     0,     0,  1037,  1038,     0,     0,  1039,  1040,  1041,
    1042,     0,  1043,  1044,     0,  1045,  1046,     0,     0,     0,
       0,     0,     0,     0,  3128,     0,     0,  1048,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,  1049,  1050,  1051,     0,  1052,
       0,     0,     0,     0,     0,     0,     0,  1053,  1054,  1055,
      21,     0,     0,     0,     0,     0,  1056,     0,  3129,   572,
       0,     0,     0,     0,     0,  1057,     0,     0,  1058,     0,
       0,     0,     0,     0,     0,     0,     0,  1059,     0,  1060,
       0,  1061,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,  1063,     0,  1064,     0,
       0,     0,  1065,     0,     0,     0,     0,  1066,     0,     0,
      28,  1067,     0,  1068,  1069,  1070,  1071,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,  1072,  1073,  1074,     0,  1075,     0,
       0,     0,     0,     0,     0,  1076,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1077,  1078,     0,     0,
       0,     0,     0,     0,     0,  1079,  1080,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1081,     0,     0,     0,     0,     0,
       0,  1082,  1083,     0,  1084,  1085,  1086,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1087,  1088,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1089,  1090,
    1091,     0,     0,     0,     0,     0,  1092,  1093,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,  1094,    60,    61,    62,  1095,
    1096,    65,    66,    67,    68,    69,    70,  1097,    72,    73,
      74,    75,    76,    77,    78,  1098,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,  1099,    95,   579,    97,    98,    99,   100,   101,   580,
    1100,   103,  1101,   105,  1102,  1103,  1104,  1105,  1106,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,  1107,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,  1108,  1109,  1110,   583,  1111,
    1112,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,  1113,   183,
     184,   589,   186,   187,  1114,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,  1115,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,  1116,  1117,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,  1118,   264,  1119,   266,   267,   268,   269,   270,  1120,
     272,   273,   274,   275,   276,   277,   278,   279,   280,  1121,
    1122,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,  1123,   297,   298,   299,
     596,   300,   301,  1124,   303,   304,   305,   306,   307,   308,
     309,  1125,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,  1126,   322,   323,   324,   325,   326,   327,
    1127,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,  1128,   360,   601,   362,   363,   364,  1129,  1130,   367,
     368,   602,   370,   371,  1131,   373,   374,   375,   376,   377,
     378,  1132,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,  1133,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,  1134,  1135,  1136,  1137,   432,   433,   434,   435,  1138,
    1139,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,  1140,   452,  1141,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,  1142,  1143,   608,
    1144,   468,   469,   470,     0,   471,   609,   473,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,  1146,  1147,     0,
       0,     0,  1013,  1148,     0,     0,  1014,  1015,  1149,     0,
       0,     0,  1150,  1151,     0,     0,  1152,  1016,  1017,     0,
    1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,
    1028,     0,     0,     0,     0,     0,     0,     0,  1029,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1030,  1031,  1032,  1033,     0,
       0,     0,     0,     0,     0,     0,  1034,  1035,     0,  1036,
       0,     0,     0,     0,     0,     0,  1037,  1038,     0,     0,
    1039,  1040,  1041,  1042,     0,  1043,  1044,     0,  1045,  1046,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,     0,
    1048,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    18,     0,     0,     0,  1049,  1050,
    1051,     0,  1052,     0,     0,     0,  3593,     0,     0,     0,
    1053,  1054,  1055,    21,     0,     0,     0,     0,     0,  1056,
       0,     0,   572,     0,     0,     0,     0,     0,  1057,     0,
       0,  1058,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,     0,  1060,     0,  1061,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1062,  1063,
       0,  1064,     0,     0,     0,  1065,     0,     0,     0,     0,
    1066,     0,     0,    28,  1067,     0,  1068,  1069,  1070,  1071,
       0,     0,     0,     0,     0,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,  1072,  1073,  1074,
       0,  1075,     0,     0,     0,     0,     0,     0,  1076,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1077,
    1078,     0,     0,     0,     0,     0,     0,     0,  1079,  1080,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1081,     0,     0,
       0,     0,     0,     0,  1082,  1083,     0,  1084,  1085,  1086,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1087,  1088,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1089,  1090,  1091,     0,     0,     0,     0,     0,  1092,
    1093,     0,     0,     0,     0,     0,     0,     0,     0,    52,
      53,    54,   573,    55,    56,    57,    58,    59,  1094,    60,
      61,    62,  1095,  1096,    65,    66,    67,    68,    69,    70,
    1097,    72,    73,    74,    75,    76,    77,    78,  1098,   574,
       0,   575,   576,    84,    85,    86,    87,    88,    89,   577,
      91,    92,    93,    94,  1099,    95,   579,    97,    98,    99,
     100,   101,   580,  1100,   103,  1101,   105,  1102,  1103,  1104,
    1105,  1106,     0,   111,   112,   113,   581,   115,   116,   117,
     118,   119,   120,   121,   122,   123,  1107,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,  1108,  1109,
    1110,   583,  1111,  1112,   141,     0,   142,   143,   144,   145,
     146,   147,   148,   584,   150,   151,   152,   153,   585,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   586,   168,     0,     0,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   587,   588,   181,
       0,  1113,   183,   184,   589,   186,   187,  1114,   590,   190,
     191,   591,   193,   194,   592,     0,   196,   197,   198,  1115,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   593,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   594,
     219,  1116,  1117,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,  1118,   264,  1119,   266,   267,   268,
     269,   270,  1120,   272,   273,   274,   275,   276,   277,   278,
     279,   280,  1121,  1122,   283,   284,   285,   286,   287,   595,
     288,   289,   290,   291,   292,   293,   294,   295,     0,  1123,
     297,   298,   299,   596,   300,   301,  1124,   303,   304,   305,
     306,   307,   308,   309,  1125,   311,   312,   313,   314,   315,
     316,   597,   317,   598,   319,   320,  1126,   322,   323,   324,
     325,   326,   327,  1127,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   599,   348,   349,   350,   600,   352,   353,   354,
     355,   356,   357,   358,  1128,   360,   601,   362,   363,   364,
    1129,  1130,   367,   368,   602,   370,   371,  1131,   373,   374,
     375,   376,   377,   378,  1132,   380,   603,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,     0,   397,   398,   399,   400,   604,   402,   403,
     605,   405,   406,   407,   408,  1133,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,  1134,  1135,  1136,  1137,   432,   433,
     434,   435,  1138,  1139,   438,   439,   440,   441,   442,   443,
     444,   445,   446,   607,   448,   449,   450,  1140,   452,  1141,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
    1142,  1143,   608,  1144,   468,   469,   470,     0,   471,   609,
     473,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
    1146,  1147,     0,     0,     0,  1013,  1148,     0,     0,  1014,
    1015,  1149,     0,     0,     0,  1150,  1151,     0,     0,  1152,
    1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,     0,     0,     0,     0,     0,     0,
       0,  1029,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1030,  1031,
    1032,  1033,     0,     0,     0,     0,     0,     0,     0,  1034,
    1035,     0,  1036,     0,     0,     0,     0,     0,     0,  1037,
    1038,     0,     0,  1039,  1040,  1041,  1042,     0,  1043,  1044,
       0,  1045,  1046,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,     0,  1048,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,  1049,  1050,  1051,     0,  1052,     0,     0,     0,  3595,
       0,     0,     0,  1053,  1054,  1055,    21,     0,     0,     0,
       0,     0,  1056,     0,     0,   572,     0,     0,     0,     0,
       0,  1057,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,  1060,     0,  1061,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,  1063,     0,  1064,     0,     0,     0,  1065,     0,
       0,     0,     0,  1066,     0,     0,    28,  1067,     0,  1068,
    1069,  1070,  1071,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
    1072,  1073,  1074,     0,  1075,     0,     0,     0,     0,     0,
       0,  1076,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1077,  1078,     0,     0,     0,     0,     0,     0,
       0,  1079,  1080,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1081,     0,     0,     0,     0,     0,     0,  1082,  1083,     0,
    1084,  1085,  1086,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1087,  1088,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1089,  1090,  1091,     0,     0,     0,
       0,     0,  1092,  1093,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,  1094,    60,    61,    62,  1095,  1096,    65,    66,    67,
      68,    69,    70,  1097,    72,    73,    74,    75,    76,    77,
      78,  1098,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,  1099,    95,   579,
      97,    98,    99,   100,   101,   580,  1100,   103,  1101,   105,
    1102,  1103,  1104,  1105,  1106,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,  1107,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,  1108,  1109,  1110,   583,  1111,  1112,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,  1113,   183,   184,   589,   186,   187,
    1114,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,  1115,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,  1116,  1117,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,  1118,   264,  1119,
     266,   267,   268,   269,   270,  1120,   272,   273,   274,   275,
     276,   277,   278,   279,   280,  1121,  1122,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,  1123,   297,   298,   299,   596,   300,   301,  1124,
     303,   304,   305,   306,   307,   308,   309,  1125,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,  1126,
     322,   323,   324,   325,   326,   327,  1127,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,  1128,   360,   601,
     362,   363,   364,  1129,  1130,   367,   368,   602,   370,   371,
    1131,   373,   374,   375,   376,   377,   378,  1132,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,  1133,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,  1134,  1135,  1136,
    1137,   432,   433,   434,   435,  1138,  1139,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
    1140,   452,  1141,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,  1142,  1143,   608,  1144,   468,   469,   470,
       0,   471,   609,   473,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,  1146,  1147,     0,     0,     0,  1013,  1148,
       0,     0,  1014,  1015,  1149,     0,     0,     0,  1150,  1151,
       0,     0,  1152,  1016,  1017,     0,  1018,  1019,  1020,  1021,
    1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,     0,     0,
       0,     0,     0,     0,  1029,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1030,  1031,  1032,  1033,     0,     0,     0,     0,     0,
       0,     0,  1034,  1035,     0,  1036,     0,     0,     0,     0,
       0,     0,  1037,  1038,     0,     0,  1039,  1040,  1041,  1042,
       0,  1043,  1044,     0,  1045,  1046,     0,     0,     0,     0,
       0,     0,     0,  1047,     0,     0,  1048,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      18,     0,     0,     0,  1049,  1050,  1051,     0,  1052,     0,
       0,     0,  3597,     0,     0,     0,  1053,  1054,  1055,    21,
       0,     0,     0,     0,     0,  1056,     0,     0,   572,     0,
       0,     0,     0,     0,  1057,     0,     0,  1058,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,  1060,     0,
    1061,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1062,  1063,     0,  1064,     0,     0,
       0,  1065,     0,     0,     0,     0,  1066,     0,     0,    28,
    1067,     0,  1068,  1069,  1070,  1071,     0,     0,     0,     0,
       0,    30,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    33,  1072,  1073,  1074,     0,  1075,     0,     0,
       0,     0,     0,     0,  1076,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1077,  1078,     0,     0,     0,
       0,     0,     0,     0,  1079,  1080,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1081,     0,     0,     0,     0,     0,     0,
    1082,  1083,     0,  1084,  1085,  1086,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1087,  1088,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1089,  1090,  1091,
       0,     0,     0,     0,     0,  1092,  1093,     0,     0,     0,
       0,     0,     0,     0,     0,    52,    53,    54,   573,    55,
      56,    57,    58,    59,  1094,    60,    61,    62,  1095,  1096,
      65,    66,    67,    68,    69,    70,  1097,    72,    73,    74,
      75,    76,    77,    78,  1098,   574,     0,   575,   576,    84,
      85,    86,    87,    88,    89,   577,    91,    92,    93,    94,
    1099,    95,   579,    97,    98,    99,   100,   101,   580,  1100,
     103,  1101,   105,  1102,  1103,  1104,  1105,  1106,     0,   111,
     112,   113,   581,   115,   116,   117,   118,   119,   120,   121,
     122,   123,  1107,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,  1108,  1109,  1110,   583,  1111,  1112,
     141,     0,   142,   143,   144,   145,   146,   147,   148,   584,
     150,   151,   152,   153,   585,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   586,   168,
       0,     0,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   587,   588,   181,     0,  1113,   183,   184,
     589,   186,   187,  1114,   590,   190,   191,   591,   193,   194,
     592,     0,   196,   197,   198,  1115,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   593,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   594,   219,  1116,  1117,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
    1118,   264,  1119,   266,   267,   268,   269,   270,  1120,   272,
     273,   274,   275,   276,   277,   278,   279,   280,  1121,  1122,
     283,   284,   285,   286,   287,   595,   288,   289,   290,   291,
     292,   293,   294,   295,     0,  1123,   297,   298,   299,   596,
     300,   301,  1124,   303,   304,   305,   306,   307,   308,   309,
    1125,   311,   312,   313,   314,   315,   316,   597,   317,   598,
     319,   320,  1126,   322,   323,   324,   325,   326,   327,  1127,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   599,   348,
     349,   350,   600,   352,   353,   354,   355,   356,   357,   358,
    1128,   360,   601,   362,   363,   364,  1129,  1130,   367,   368,
     602,   370,   371,  1131,   373,   374,   375,   376,   377,   378,
    1132,   380,   603,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,     0,   397,
     398,   399,   400,   604,   402,   403,   605,   405,   406,   407,
     408,  1133,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
    1134,  1135,  1136,  1137,   432,   433,   434,   435,  1138,  1139,
     438,   439,   440,   441,   442,   443,   444,   445,   446,   607,
     448,   449,   450,  1140,   452,  1141,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,  1142,  1143,   608,  1144,
     468,   469,   470,     0,   471,   609,   473,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,  1147,     0,     0,
       0,  1013,  1148,     0,     0,  1014,  1015,  1149,     0,     0,
       0,  1150,  1151,     0,     0,  1152,  1016,  1017,     0,  1018,
    1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,
       0,     0,     0,     0,     0,     0,     0,  1029,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1030,  1031,  1032,  1033,     0,     0,
       0,     0,     0,     0,     0,  1034,  1035,     0,  1036,     0,
       0,     0,     0,     0,     0,  1037,  1038,     0,     0,  1039,
    1040,  1041,  1042,     0,  1043,  1044,     0,  1045,  1046,     0,
       0,     0,     0,     0,     0,     0,  1047,     0,     0,  1048,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    18,     0,     0,     0,  1049,  1050,  1051,
       0,  1052,     0,     0,     0,     0,     0,     0,     0,  1053,
    1054,  1055,    21,     0,     0,     0,     0,     0,  1056,     0,
       0,   572,     0,     0,     0,     0,     0,  1057,     0,     0,
    1058,     0,     0,     0,     0,     0,     0,     0,     0,  1059,
       0,  1060,     0,  1061,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1062,  1063,     0,
    1064,     0,     0,     0,  1065,     0,     0,     0,     0,  1066,
       0,     0,    28,  1067,     0,  1068,  1069,  1070,  1071,     0,
       0,     0,     0,     0,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    33,  1072,  1073,  1074,     0,
    1075,     0,     0,     0,     0,     0,     0,  1076,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1077,  1078,
       0,     0,     0,     0,     0,     0,     0,  1079,  1080,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1081,     0,     0,     0,
       0,     0,     0,  1082,  1083,     0,  1084,  1085,  1086,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1087,
    1088,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1089,  1090,  1091,     0,     0,     0,     0,     0,  1092,  1093,
       0,     0,     0,     0,     0,     0,     0,     0,    52,    53,
      54,   573,    55,    56,    57,    58,    59,  1094,    60,    61,
      62,  1095,  1096,    65,    66,    67,    68,    69,    70,  1097,
      72,    73,    74,    75,    76,    77,    78,  1098,   574,     0,
     575,   576,    84,    85,    86,    87,    88,    89,   577,    91,
      92,    93,    94,  1099,    95,   579,    97,    98,    99,   100,
     101,   580,  1100,   103,  1101,   105,  1102,  1103,  1104,  1105,
    1106,     0,   111,   112,   113,   581,   115,   116,   117,   118,
     119,   120,   121,   122,   123,  1107,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,  1108,  1109,  1110,
     583,  1111,  1112,   141,     0,   142,   143,   144,   145,   146,
     147,   148,   584,   150,   151,   152,   153,   585,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   586,   168,     0,     0,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   587,   588,   181,     0,
    1113,   183,   184,   589,   186,   187,  1114,   590,   190,   191,
     591,   193,   194,   592,     0,   196,   197,   198,  1115,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   593,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   594,   219,
    1116,  1117,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,  1118,   264,  1119,   266,   267,   268,   269,
     270,  1120,   272,   273,   274,   275,   276,   277,   278,   279,
     280,  1121,  1122,   283,   284,   285,   286,   287,   595,   288,
     289,   290,   291,   292,   293,   294,   295,     0,  1123,   297,
     298,   299,   596,   300,   301,  1124,   303,   304,   305,   306,
     307,   308,   309,  1125,   311,   312,   313,   314,   315,   316,
     597,   317,   598,   319,   320,  1126,   322,   323,   324,   325,
     326,   327,  1127,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   599,   348,   349,   350,   600,   352,   353,   354,   355,
     356,   357,   358,  1128,   360,   601,   362,   363,   364,  1129,
    1130,   367,   368,   602,   370,   371,  1131,   373,   374,   375,
     376,   377,   378,  1132,   380,   603,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,     0,   397,   398,   399,   400,   604,   402,   403,   605,
     405,   406,   407,   408,  1133,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,  1134,  1135,  1136,  1137,   432,   433,   434,
     435,  1138,  1139,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   607,   448,   449,   450,  1140,   452,  1141,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,  1142,
    1143,   608,  1144,   468,   469,   470,     0,   471,   609,   473,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,  1146,
    1147,     0,     0,     0,  1013,  1148,     0,     0,  1014,  1015,
    1149,     0,     0,     0,  1150,  1151,     0,     0,  1152,  1016,
    1017,     0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,
    1026,  1027,  1028,     0,     0,     0,     0,     0,     0,     0,
    1029,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1030,  1031,  1032,
    1033,     0,     0,     0,     0,     0,     0,     0,  1034,  1035,
       0,  1036,     0,     0,     0,     0,     0,     0,  1037,  1038,
       0,     0,  1039,  1040,  1041,  1042,     0,  1043,  1044,     0,
    1045,  1046,     0,     0,     0,     0,     0,     0,     0,  1047,
       0,     0,  1048,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
    1049,  1050,  1051,     0,  1052,     0,     0,     0,     0,     0,
       0,     0,  1053,  1054,  1055,    21,     0,     0,     0,     0,
       0,  1056,     0,     0,   572,     0,     0,     0,     0,     0,
    1057,     0,     0,  1058,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,  1060,     0,  1061,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,  1063,     0,  1064,     0,     0,     0,  1065,     0,     0,
       0,     0,  1066,     0,     0,    28,  1067,     0,  1068,  1069,
    1070,  1071,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,  1072,
    1073,  1074,     0,  1075,     0,     0,     0,     0,     0,     0,
    1076,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1077,  1078,     0,     0,     0,     0,     0,     0,     0,
    1079,  1080,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1081,
       0,     0,     0,     0,     0,     0,  1082,  1083,     0,  1084,
    1085,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1087,  1088,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1089,  1090,  1091,     0,     0,     0,     0,
       0,  1092,  1093,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
    1094,    60,    61,    62,  1095,  1096,    65,    66,    67,    68,
      69,    70,  1097,    72,    73,    74,    75,    76,    77,    78,
    1098,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,  1099,    95,   579,    97,
      98,    99,   100,   101,   580,  1100,   103,  1101,   105,  1102,
    1103,  1104,  1105,  1106,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,  1107,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
    1108,  1109,  1110,   583,  1111,  1112,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,  1113,   183,   184,   589,   186,   187,  1114,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,  1115,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,  1116,  1117,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,  1118,   264,  1119,   266,
     267,   268,   269,   270,  1120,   272,   273,   274,   275,   276,
     277,   278,   279,   280,  1121,  1122,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,  1123,   297,   298,   299,   596,   300,   301,  1124,   303,
     304,   305,   306,   307,   308,   309,  1125,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,  1126,   322,
     323,   324,   325,   326,   327,  1127,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,  1128,   360,   601,   362,
     363,   364,  1129,  1130,   367,   368,   602,   370,   371,  1131,
     373,   374,   375,   376,   377,   378,  1132,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,  1133,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,  1134,  1135,  1136,  1137,
     432,   433,   434,   435,  1138,  1139,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,  1140,
     452,  1141,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,  1142,  1143,   608,  1144,   468,   469,   470,     0,
     471,   609,   473,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,  1146,  1147,     0,     0,     0,  1013,  1148,     0,
       0,  1014,  1015,  2022,     0,     0,     0,  1150,  1151,     0,
       0,  1152,  1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,
    1023,  1024,  1025,  1026,  1027,  1028,     0,     0,     0,     0,
       0,     0,     0,  1029,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1030,  1031,  1032,  1033,     0,     0,     0,     0,     0,     0,
       0,  1034,  1035,     0,  1036,     0,     0,     0,     0,     0,
       0,  1037,  1038,     0,     0,  1039,  1040,  1041,  1042,     0,
    1043,  1044,     0,  1045,  1046,     0,     0,     0,     0,     0,
       0,     0,  1047,     0,     0,  1048,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    18,
       0,     0,     0,  1049,  1050,  1051,     0,  1052,     0,     0,
       0,     0,     0,     0,     0,  1053,  1054,  1055,    21,     0,
       0,     0,     0,     0,  1056,     0,     0,   572,     0,     0,
       0,     0,     0,  1057,     0,     0,  1058,     0,     0,     0,
       0,     0,     0,     0,     0,  1059,     0,  1060,     0,  1061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,  1063,     0,  1064,     0,     0,     0,
    1065,     0,     0,     0,     0,  1066,     0,     0,    28,  1067,
       0,  1068,  1069,  1070,  1071,     0,     0,     0,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    33,  1072,  1073,  1074,     0,  1075,     0,     0,     0,
       0,     0,     0,  1076,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1077,  1078,     0,     0,     0,     0,
       0,     0,     0,  1079,  1080,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1081,     0,     0,     0,     0,     0,     0,  1082,
    1083,     0,  1084,  1085,  1086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1087,  1088,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1089,  1090,  1091,     0,
       0,     0,     0,     0,  1092,  1093,     0,     0,     0,     0,
       0,     0,     0,     0,    52,    53,    54,   573,    55,    56,
      57,    58,    59,  1094,    60,    61,    62,  1095,  1096,    65,
      66,    67,    68,    69,    70,  1097,    72,    73,    74,    75,
      76,    77,    78,  1098,   574,     0,   575,   576,    84,    85,
      86,    87,    88,    89,   577,    91,    92,    93,    94,  1099,
      95,   579,    97,    98,    99,   100,   101,   580,  1100,   103,
    1101,   105,  1102,  1103,  1104,  1105,  1106,     0,   111,   112,
     113,   581,   115,   116,   117,   118,   119,   120,   121,   122,
     123,  1107,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,  1108,  1109,  1110,   583,  1111,  1112,   141,
       0,   142,   143,   144,   145,   146,   147,   148,   584,   150,
     151,   152,   153,   585,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   586,   168,     0,
       0,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   587,   588,   181,     0,  1113,   183,   184,   589,
     186,   187,  1114,   590,   190,   191,   591,   193,   194,   592,
       0,   196,   197,   198,  1115,  2697,   201,   202,   203,   204,
     205,   206,   207,   208,   593,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   594,   219,  1116,  1117,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,  1118,
     264,  1119,   266,   267,   268,   269,   270,  1120,   272,   273,
     274,   275,   276,   277,   278,   279,   280,  1121,  1122,   283,
     284,   285,   286,   287,   595,   288,   289,   290,   291,   292,
     293,   294,   295,     0,  1123,   297,   298,   299,   596,   300,
     301,  1124,   303,   304,   305,   306,   307,   308,   309,  1125,
     311,   312,   313,   314,   315,   316,   597,   317,   598,   319,
     320,  1126,   322,   323,   324,   325,   326,   327,  1127,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   599,   348,   349,
     350,   600,   352,   353,   354,   355,   356,   357,   358,  1128,
     360,   601,   362,   363,   364,  1129,  1130,   367,   368,   602,
     370,   371,  1131,   373,   374,   375,   376,   377,   378,  1132,
     380,   603,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,     0,   397,   398,
     399,   400,   604,   402,   403,   605,   405,   406,   407,   408,
    1133,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,  1134,
    1135,  1136,  1137,   432,   433,   434,   435,  1138,  1139,   438,
     439,   440,   441,   442,   443,   444,   445,   446,   607,   448,
     449,   450,  2698,   452,  1141,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,  1142,  1143,   608,  1144,   468,
     469,   470,     0,   471,   609,   473,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,  1147,     0,     0,     0,
    1013,  1148,     0,     0,  1014,  1015,  1149,     0,     0,     0,
    1150,  1151,     0,     0,  1152,  1016,  1017,     0,  1018,  1019,
    1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,
       0,     0,     0,     0,     0,     0,  1029,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1030,  1031,  1032,  1033,     0,     0,     0,
       0,     0,     0,     0,  1034,  1035,     0,  1036,     0,     0,
       0,     0,     0,     0,  1037,  1038,     0,     0,  1039,  1040,
    1041,  1042,     0,  1043,  1044,     0,  1045,  1046,     0,     0,
       0,     0,     0,     0,     0,  1047,     0,     0,  1048,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,  1049,  1050,  1051,     0,
    1052,     0,     0,     0,     0,     0,     0,     0,  1053,  1054,
    1055,    21,     0,     0,     0,     0,     0,  1056,     0,     0,
     572,     0,     0,     0,     0,     0,  1057,     0,     0,  1058,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,     0,
    1060,     0,  1061,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1062,  1063,     0,  1064,
       0,     0,     0,  1065,     0,     0,     0,     0,  1066,     0,
       0,    28,  1067,     0,  1068,  1069,  1070,  1071,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,  1072,  1073,  1074,     0,  1075,
       0,     0,     0,     0,     0,     0,  1076,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1077,  1078,     0,
       0,     0,     0,     0,     0,     0,  1079,  1080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1081,     0,     0,     0,     0,
       0,     0,  1082,  1083,     0,  1084,  1085,  1086,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1087,  1088,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1089,
    1090,  1091,     0,     0,     0,     0,     0,  1092,  1093,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,  1094,    60,    61,    62,
    1095,  1096,    65,    66,    67,    68,    69,    70,  1097,    72,
      73,    74,    75,    76,    77,    78,  1098,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,  1099,    95,   579,    97,    98,    99,   100,   101,
     580,  1100,   103,  1101,   105,  1102,  1103,  1104,  1105,  1106,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,  1107,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,  1108,  1109,  1110,   583,
    1111,  1112,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,  1113,
     183,   184,   589,   186,   187,  1114,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,  1115,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,  1116,
    1117,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,  1118,   264,  1119,   266,   267,   268,   269,   270,
    1120,   272,   273,   274,   275,   276,   277,   278,   279,   280,
    1121,  1122,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,  1123,   297,   298,
     299,   596,   300,   301,  1124,   303,   304,   305,   306,   307,
     308,   309,  1125,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,  1126,   322,   323,   324,   325,   326,
     327,  1127,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,  1128,   360,   601,   362,   363,   364,  1129,  1130,
     367,   368,   602,   370,   371,  1131,   373,   374,   375,   376,
     377,   378,  1132,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,  1133,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,  1134,  1135,  1136,  1137,   432,   433,   434,   435,
    1138,  1139,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,  2698,   452,  1141,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,  1142,  1143,
     608,  1144,   468,   469,   470,     0,   471,   609,   473,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,  1146,  1147,
       0,     0,     0,  1013,  1148,     0,     0,  1014,  1015,  1149,
       0,     0,     0,  1150,  1151,     0,     0,  1152,  1016,  1017,
       0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,
    1027,  1028,     0,     0,     0,     0,     0,     0,     0,  1029,
       0,     0,     0,     0,     0,     0,  2928,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1030,  1031,  1032,  1033,
       0,     0,     0,     0,     0,     0,     0,  1034,  1035,     0,
    1036,     0,     0,     0,     0,     0,     0,  1037,  1038,     0,
       0,  1039,  1040,  1041,  1042,     0,  1043,  1044,     0,  1045,
    1046,     0,     0,     0,     0,     0,     0,     0,  1047,     0,
       0,  1048,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,     0,     0,  1049,
    1050,  1051,     0,  1052,     0,     0,     0,     0,     0,     0,
       0,  1053,  1054,  1055,    21,     0,     0,     0,     0,     0,
    1056,     0,     0,   572,     0,     0,     0,     0,     0,  1057,
       0,     0,  1058,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,  1060,     0,  1061,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
    1063,     0,  1064,     0,     0,     0,  1065,     0,     0,     0,
       0,  1066,     0,     0,    28,     0,     0,  1068,  1069,  1070,
    1071,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,  1072,  1073,
    1074,     0,  1075,     0,     0,     0,     0,     0,     0,  1076,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1077,  1078,     0,     0,     0,     0,     0,     0,     0,  1079,
    1080,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1081,     0,
       0,     0,     0,     0,     0,  1082,  1083,     0,  1084,  1085,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1087,  1088,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1089,  1090,  1091,     0,     0,     0,     0,     0,
    1092,  1093,     0,     0,     0,     0,     0,     0,     0,     0,
      52,    53,    54,   573,    55,    56,    57,    58,    59,  1094,
      60,    61,    62,  1095,  1096,    65,    66,    67,    68,    69,
    2929,  1097,    72,    73,    74,    75,    76,    77,    78,  1098,
     574,     0,   575,   576,    84,    85,    86,    87,    88,    89,
     577,    91,    92,    93,    94,  1099,    95,   579,    97,    98,
      99,   100,   101,   580,  1100,   103,  1101,   105,  1102,  1103,
    1104,  1105,  1106,     0,   111,   112,   113,   581,   115,   116,
     117,   118,   119,   120,   121,   122,   123,  1107,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,  1108,
    1109,  1110,   583,  1111,  1112,   141,     0,   142,   143,   144,
     145,   146,   147,   148,   584,   150,   151,   152,   153,   585,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   586,   168,     0,     0,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   587,   588,
     181,     0,  1113,   183,   184,   589,   186,   187,  1114,   590,
     190,   191,   591,   193,   194,   592,     0,   196,   197,   198,
    1115,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     593,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     594,   219,  1116,  1117,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,  1118,   264,  1119,   266,   267,
     268,   269,   270,  1120,   272,   273,   274,   275,   276,   277,
     278,   279,   280,  1121,  1122,   283,   284,   285,   286,   287,
     595,   288,   289,   290,   291,   292,   293,   294,   295,     0,
    1123,   297,   298,   299,   596,   300,   301,  1124,   303,   304,
     305,   306,   307,   308,   309,  1125,   311,   312,   313,   314,
     315,   316,   597,   317,   598,   319,   320,  1126,   322,   323,
     324,   325,   326,   327,  1127,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   599,   348,   349,   350,   600,   352,   353,
     354,   355,   356,   357,   358,  1128,   360,   601,   362,   363,
     364,  1129,  1130,   367,   368,   602,   370,   371,  1131,   373,
     374,   375,   376,   377,   378,  1132,   380,   603,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,     0,   397,   398,   399,   400,   604,   402,
     403,   605,   405,   406,   407,   408,  1133,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,  1134,  1135,  1136,  1137,   432,
     433,   434,   435,  1138,  1139,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   607,   448,   449,   450,  1140,   452,
    1141,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,  1142,  1143,   608,  1144,   468,   469,   470,     0,   471,
     609,   473,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,  1146,  1147,     0,     0,     0,  1013,  1148,     0,     0,
    1014,  1015,  1149,     0,     0,     0,  1150,  1151,     0,     0,
    1152,  1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,  1023,
    1024,  1025,  1026,  1027,  1028,     0,     0,     0,     0,     0,
       0,     0,  1029,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1030,
    1031,  1032,  1033,     0,     0,     0,     0,     0,     0,     0,
    1034,  1035,     0,  1036,     0,     0,     0,     0,     0,     0,
    1037,  1038,     0,     0,  1039,  1040,  1041,  1042,     0,  1043,
    1044,     0,  1045,  1046,     0,     0,     0,     0,     0,     0,
       0,  1047,     0,     0,  1048,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    18,     0,
       0,     0,  1049,  1050,  1051,     0,  1052,     0,     0,     0,
       0,     0,     0,     0,  1053,  1054,  1055,    21,     0,     0,
       0,     0,     0,  1056,     0,     0,   572,     0,     0,     0,
       0,     0,  1057,     0,     0,  4229,     0,     0,     0,     0,
       0,     0,     0,     0,  1059,     0,  1060,     0,  1061,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1062,  1063,     0,  1064,     0,     0,     0,  1065,
       0,     0,     0,     0,  1066,     0,     0,    28,  1067,     0,
    1068,  1069,  1070,  1071,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,  1072,  1073,  1074,     0,  1075,     0,     0,     0,     0,
       0,     0,  1076,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1077,  1078,     0,     0,     0,     0,     0,
       0,     0,  1079,  1080,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1081,     0,     0,     0,     0,     0,     0,  1082,  1083,
       0,  1084,  1085,  1086,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1087,  1088,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1089,  1090,  1091,     0,     0,
       0,     0,     0,  1092,  1093,     0,     0,     0,     0,     0,
       0,     0,     0,    52,    53,    54,   573,    55,    56,    57,
      58,    59,  1094,    60,    61,    62,  1095,  1096,    65,    66,
      67,    68,    69,    70,  1097,    72,    73,    74,    75,    76,
      77,    78,  1098,   574,     0,   575,   576,    84,    85,    86,
      87,    88,    89,   577,    91,    92,    93,    94,  1099,    95,
     579,    97,    98,    99,   100,   101,   580,  1100,   103,  1101,
     105,  1102,  1103,  1104,  1105,  1106,     0,   111,   112,   113,
     581,   115,   116,   117,   118,   119,   120,   121,   122,   123,
    1107,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,  1108,  1109,  1110,   583,  1111,  1112,   141,     0,
     142,   143,   144,   145,   146,   147,   148,   584,   150,   151,
     152,   153,   585,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   586,   168,     0,     0,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   587,   588,   181,     0,  1113,   183,   184,   589,   186,
     187,  1114,   590,   190,   191,   591,   193,   194,   592,     0,
     196,   197,   198,  1115,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   593,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   594,   219,  1116,  1117,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,  1118,   264,
    1119,   266,   267,   268,   269,   270,  1120,   272,   273,   274,
     275,   276,   277,   278,   279,   280,  1121,  1122,   283,   284,
     285,   286,   287,   595,   288,   289,   290,   291,   292,   293,
     294,   295,     0,  1123,   297,   298,   299,   596,   300,   301,
    1124,   303,   304,   305,   306,   307,   308,   309,  1125,   311,
     312,   313,   314,   315,   316,   597,   317,   598,   319,   320,
    1126,   322,   323,   324,   325,   326,   327,  1127,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,   599,   348,   349,   350,
     600,   352,   353,   354,   355,   356,   357,   358,  1128,   360,
     601,   362,   363,   364,  1129,  1130,   367,   368,   602,   370,
     371,  1131,   373,   374,   375,   376,   377,   378,  1132,   380,
     603,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,     0,   397,   398,   399,
     400,   604,   402,   403,   605,   405,   406,   407,   408,  1133,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,  1134,  1135,
    1136,  1137,   432,   433,   434,   435,  1138,  1139,   438,   439,
     440,   441,   442,   443,   444,   445,   446,   607,   448,   449,
     450,  1140,   452,  1141,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,  1142,  1143,   608,  1144,   468,   469,
     470,     0,   471,   609,   473,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,  1146,  1147,     0,     0,     0,  1013,
    1148,     0,     0,  1014,  1015,  1149,     0,     0,     0,  1150,
    1151,     0,     0,  1152,  1016,  1017,     0,  1018,  1019,  1020,
    1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,     0,
       0,     0,     0,     0,     0,  1029,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1030,  1031,  1032,  1033,     0,     0,     0,     0,
       0,     0,     0,  1034,  1035,     0,  1036,     0,     0,     0,
       0,     0,     0,  1037,  1038,     0,     0,  1039,  1040,  1041,
    1042,     0,  1043,  1044,     0,  1045,  1046,     0,     0,     0,
       0,     0,     0,     0,  1047,     0,     0,  1048,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,  1049,  1050,  1051,     0,  1052,
       0,     0,     0,     0,     0,     0,     0,  1053,  1054,  1055,
      21,     0,     0,     0,     0,     0,  1056,     0,     0,   572,
       0,     0,     0,     0,     0,  1057,     0,     0,  4250,     0,
       0,     0,     0,     0,     0,     0,     0,  1059,     0,  1060,
       0,  1061,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,  1063,     0,  1064,     0,
       0,     0,  1065,     0,     0,     0,     0,  1066,     0,     0,
      28,  1067,     0,  1068,  1069,  1070,  1071,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,  1072,  1073,  1074,     0,  1075,     0,
       0,     0,     0,     0,     0,  1076,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1077,  1078,     0,     0,
       0,     0,     0,     0,     0,  1079,  1080,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1081,     0,     0,     0,     0,     0,
       0,  1082,  1083,     0,  1084,  1085,  1086,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1087,  1088,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1089,  1090,
    1091,     0,     0,     0,     0,     0,  1092,  1093,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,  1094,    60,    61,    62,  1095,
    1096,    65,    66,    67,    68,    69,    70,  1097,    72,    73,
      74,    75,    76,    77,    78,  1098,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,  1099,    95,   579,    97,    98,    99,   100,   101,   580,
    1100,   103,  1101,   105,  1102,  1103,  1104,  1105,  1106,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,  1107,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,  1108,  1109,  1110,   583,  1111,
    1112,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,  1113,   183,
     184,   589,   186,   187,  1114,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,  1115,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,  1116,  1117,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,  1118,   264,  1119,   266,   267,   268,   269,   270,  1120,
     272,   273,   274,   275,   276,   277,   278,   279,   280,  1121,
    1122,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,  1123,   297,   298,   299,
     596,   300,   301,  1124,   303,   304,   305,   306,   307,   308,
     309,  1125,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,  1126,   322,   323,   324,   325,   326,   327,
    1127,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,  1128,   360,   601,   362,   363,   364,  1129,  1130,   367,
     368,   602,   370,   371,  1131,   373,   374,   375,   376,   377,
     378,  1132,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,  1133,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,  1134,  1135,  1136,  1137,   432,   433,   434,   435,  1138,
    1139,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,  1140,   452,  1141,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,  1142,  1143,   608,
    1144,   468,   469,   470,     0,   471,   609,   473,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,  1146,  1147,     0,
       0,     0,  1013,  1148,     0,     0,  1014,  1015,  1149,     0,
       0,     0,  1150,  1151,     0,     0,  1152,  1016,  1017,     0,
    1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,
    1028,     0,     0,     0,     0,     0,     0,     0,  1029,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1030,  1031,  1032,  1033,     0,
       0,     0,     0,     0,     0,     0,  1034,  1035,     0,  1036,
       0,     0,     0,     0,     0,     0,  1037,  1038,     0,     0,
    1039,  1040,  1041,  1042,     0,  1043,  1044,     0,  1045,  1046,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,     0,
    1048,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    18,     0,     0,     0,  1049,  1050,
    1051,     0,  1052,     0,     0,     0,     0,     0,     0,     0,
    1053,  1054,  1055,    21,     0,     0,     0,     0,     0,  1056,
       0,     0,   572,     0,     0,     0,     0,     0,  1057,     0,
       0,  1058,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,     0,  1060,     0,  1061,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1062,  1063,
    6378,  1064,     0,     0,     0,  1065,     0,     0,     0,     0,
    1066,     0,     0,    28,     0,     0,  1068,  1069,  1070,  1071,
       0,     0,     0,     0,     0,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,  1072,  1073,  1074,
       0,  1075,     0,     0,     0,     0,     0,     0,  1076,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1077,
    1078,     0,     0,     0,     0,     0,     0,     0,  1079,  1080,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1081,     0,     0,
       0,     0,     0,     0,  1082,  1083,     0,  1084,  1085,  1086,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1087,  1088,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1089,  1090,  1091,     0,     0,     0,     0,     0,  1092,
    1093,     0,     0,     0,     0,     0,     0,     0,     0,    52,
      53,    54,   573,    55,    56,    57,    58,    59,  1094,    60,
      61,    62,  1095,  1096,    65,    66,    67,    68,    69,    70,
    1097,    72,    73,    74,    75,    76,    77,    78,  1098,   574,
       0,   575,   576,    84,    85,    86,    87,    88,    89,   577,
      91,    92,    93,    94,  1099,    95,   579,    97,    98,    99,
     100,   101,   580,  1100,   103,  1101,   105,  1102,  1103,  1104,
    1105,  1106,     0,   111,   112,   113,   581,   115,   116,   117,
     118,   119,   120,   121,   122,   123,  1107,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,  1108,  1109,
    1110,   583,  1111,  1112,   141,     0,   142,   143,   144,   145,
     146,   147,   148,   584,   150,   151,   152,   153,   585,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   586,   168,     0,     0,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   587,   588,   181,
       0,  1113,   183,   184,   589,   186,   187,  1114,   590,   190,
     191,   591,   193,   194,   592,     0,   196,   197,   198,  1115,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   593,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   594,
     219,  1116,  1117,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,  1118,   264,  1119,   266,   267,   268,
     269,   270,  1120,   272,   273,   274,   275,   276,   277,   278,
     279,   280,  1121,  1122,   283,   284,   285,   286,   287,   595,
     288,   289,   290,   291,   292,   293,   294,   295,     0,  1123,
     297,   298,   299,   596,   300,   301,  1124,   303,   304,   305,
     306,   307,   308,   309,  1125,   311,   312,   313,   314,   315,
     316,   597,   317,   598,   319,   320,  1126,   322,   323,   324,
     325,   326,   327,  1127,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   599,   348,   349,   350,   600,   352,   353,   354,
     355,   356,   357,   358,  1128,   360,   601,   362,   363,   364,
    1129,  1130,   367,   368,   602,   370,   371,  1131,   373,   374,
     375,   376,   377,   378,  1132,   380,   603,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,     0,   397,   398,   399,   400,   604,   402,   403,
     605,   405,   406,   407,   408,  1133,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,  1134,  1135,  1136,  1137,   432,   433,
     434,   435,  1138,  1139,   438,   439,   440,   441,   442,   443,
     444,   445,   446,   607,   448,   449,   450,  1140,   452,  1141,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
    1142,  1143,   608,  1144,   468,   469,   470,     0,   471,   609,
     473,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
    1146,  1147,     0,     0,     0,  1013,  1148,     0,     0,  1014,
    1015,  1149,     0,     0,     0,  1150,  1151,     0,     0,  1152,
    1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,     0,     0,     0,     0,     0,     0,
       0,  1029,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1030,  1031,
    1032,  1033,     0,     0,     0,     0,     0,     0,     0,  1034,
    1035,     0,  1036,     0,     0,     0,     0,     0,     0,  1037,
    1038,     0,     0,  1039,  1040,  1041,  1042,     0,  1043,  1044,
       0,  1045,  1046,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,     0,  1048,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,  1049,  1050,  1051,     0,  1052,     0,     0,     0,     0,
       0,     0,     0,  1053,  1054,  1055,    21,     0,     0,     0,
       0,     0,  1056,     0,     0,   572,     0,     0,     0,     0,
       0,  1057,     0,     0,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,  1060,     0,  1061,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,  1063,     0,  1064,     0,     0,     0,  1065,     0,
       0,     0,     0,  1066,     0,     0,    28,     0,     0,  1068,
    1069,  1070,  1071,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
    1072,  1073,  1074,     0,  1075,     0,     0,     0,     0,     0,
       0,  1076,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1077,  1078,     0,     0,     0,     0,     0,     0,
       0,  1079,  1080,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1081,     0,     0,     0,     0,     0,     0,  1082,  1083,     0,
    1084,  1085,  1086,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1087,  1088,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1089,  1090,  1091,     0,     0,     0,
       0,     0,  1092,  1093,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,  1094,    60,    61,    62,  1095,  1096,    65,    66,    67,
      68,    69,    70,  1097,    72,    73,    74,    75,    76,    77,
      78,  1098,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,  1099,    95,   579,
      97,    98,    99,   100,   101,   580,  1100,   103,  1101,   105,
    1102,  1103,  1104,  1105,  1106,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,  1107,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,  1108,  1109,  1110,   583,  1111,  1112,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,  1113,   183,   184,   589,   186,   187,
    1114,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,  1115,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,  1116,  1117,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,  1118,   264,  1119,
     266,   267,   268,   269,   270,  1120,   272,   273,   274,   275,
     276,   277,   278,   279,   280,  1121,  1122,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,  1123,   297,   298,   299,   596,   300,   301,  1124,
     303,   304,   305,   306,   307,   308,   309,  1125,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,  1126,
     322,   323,   324,   325,   326,   327,  1127,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,  1128,   360,   601,
     362,   363,   364,  1129,  1130,   367,   368,   602,   370,   371,
    1131,   373,   374,   375,   376,   377,   378,  1132,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,  1133,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,  1134,  1135,  1136,
    1137,   432,   433,   434,   435,  1138,  1139,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
    1140,   452,  1141,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,  1142,  1143,   608,  1144,   468,   469,   470,
       0,   471,   609,   473,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,  1989,  1990,     0,     0,     0,  1013,  1148,
       0,     0,  1014,  1015,  1149,     0,     0,     0,  1150,  1151,
       0,     0,  1152,  1016,  1017,     0,  1018,  1019,  1020,  1021,
    1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,     0,     0,
       0,     0,     0,     0,  1029,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1030,  1031,  1032,  1033,     0,     0,     0,     0,     0,
       0,     0,  1034,  1035,     0,  1036,     0,     0,     0,     0,
       0,     0,  1037,  1038,     0,     0,  1039,  1040,  1041,  1042,
       0,  1043,  1044,     0,  1045,  1046,     0,     0,     0,     0,
       0,     0,     0,  1047,     0,     0,  1048,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      18,     0,     0,     0,  1049,  1050,  1051,     0,  1052,     0,
       0,     0,     0,     0,     0,     0,  1053,  1054,  1055,    21,
       0,     0,     0,     0,     0,  1056,     0,     0,   572,     0,
       0,     0,     0,     0,  1057,     0,     0,  2117,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,  1060,     0,
    1061,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1062,  1063,     0,  1064,     0,     0,
       0,  1065,     0,     0,     0,     0,  1066,     0,     0,    28,
       0,     0,  1068,  1069,  1070,  1071,     0,     0,     0,     0,
       0,    30,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    33,  1072,  1073,  1074,     0,  1075,     0,     0,
       0,     0,     0,     0,  1076,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1077,  1078,     0,     0,     0,
       0,     0,     0,     0,  1079,  1080,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1081,     0,     0,     0,     0,     0,     0,
    1082,  1083,     0,  1084,  1085,  1086,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1087,  1088,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1089,  1090,  1091,
       0,     0,     0,     0,     0,  1092,  1093,     0,     0,     0,
       0,     0,     0,     0,     0,    52,    53,    54,   573,    55,
      56,    57,    58,    59,  1094,    60,    61,    62,  1095,  1096,
      65,    66,    67,    68,    69,    70,  1097,    72,    73,    74,
      75,    76,    77,    78,  1098,   574,     0,   575,   576,    84,
      85,    86,    87,    88,    89,   577,    91,    92,    93,    94,
    1099,    95,   579,    97,    98,    99,   100,   101,   580,  1100,
     103,  1101,   105,  1102,  1103,  1104,  1105,  1106,     0,   111,
     112,   113,   581,   115,   116,   117,   118,   119,   120,   121,
     122,   123,  1107,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,  1108,  1109,  1110,   583,  1111,  1112,
     141,     0,   142,   143,   144,   145,   146,   147,   148,   584,
     150,   151,   152,   153,   585,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   586,   168,
       0,     0,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   587,   588,   181,     0,  1113,   183,   184,
     589,   186,   187,  1114,   590,   190,   191,   591,   193,   194,
     592,     0,   196,   197,   198,  1115,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   593,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   594,   219,  1116,  1117,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
    1118,   264,  1119,   266,   267,   268,   269,   270,  1120,   272,
     273,   274,   275,   276,   277,   278,   279,   280,  1121,  1122,
     283,   284,   285,   286,   287,   595,   288,   289,   290,   291,
     292,   293,   294,   295,     0,  1123,   297,   298,   299,   596,
     300,   301,  1124,   303,   304,   305,   306,   307,   308,   309,
    1125,   311,   312,   313,   314,   315,   316,   597,   317,   598,
     319,   320,  1126,   322,   323,   324,   325,   326,   327,  1127,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   599,   348,
     349,   350,   600,   352,   353,   354,   355,   356,   357,   358,
    1128,   360,   601,   362,   363,   364,  1129,  1130,   367,   368,
     602,   370,   371,  1131,   373,   374,   375,   376,   377,   378,
    1132,   380,   603,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,     0,   397,
     398,   399,   400,   604,   402,   403,   605,   405,   406,   407,
     408,  1133,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
    1134,  1135,  1136,  1137,   432,   433,   434,   435,  1138,  1139,
     438,   439,   440,   441,   442,   443,   444,   445,   446,   607,
     448,   449,   450,  1140,   452,  1141,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,  1142,  1143,   608,  1144,
     468,   469,   470,     0,   471,   609,   473,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,  1989,  1990,     0,     0,
       0,  1013,  1148,     0,     0,  1014,  1015,  1149,     0,     0,
       0,  1150,  1151,     0,     0,  1152,  1016,  1017,     0,  1018,
    1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,
       0,     0,     0,     0,     0,     0,     0,  1029,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1030,  1031,  1032,  1033,     0,     0,
       0,     0,     0,     0,     0,  1034,  1035,     0,  1036,     0,
       0,     0,     0,     0,     0,  1037,  1038,     0,     0,  1039,
    1040,  1041,  1042,     0,  1043,  1044,     0,  1045,  1046,     0,
       0,     0,     0,     0,     0,     0,  1047,     0,     0,  1048,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    18,     0,     0,     0,  1049,  1050,  1051,
       0,  1052,     0,     0,     0,     0,     0,     0,     0,  1053,
    1054,  1055,    21,     0,     0,     0,     0,     0,  1056,     0,
       0,   572,     0,     0,     0,     0,     0,  1057,     0,     0,
    2119,     0,     0,     0,     0,     0,     0,     0,     0,  1059,
       0,  1060,     0,  1061,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1062,  1063,     0,
    1064,     0,     0,     0,  1065,     0,     0,     0,     0,  1066,
       0,     0,    28,     0,     0,  1068,  1069,  1070,  1071,     0,
       0,     0,     0,     0,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    33,  1072,  1073,  1074,     0,
    1075,     0,     0,     0,     0,     0,     0,  1076,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1077,  1078,
       0,     0,     0,     0,     0,     0,     0,  1079,  1080,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1081,     0,     0,     0,
       0,     0,     0,  1082,  1083,     0,  1084,  1085,  1086,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1087,
    1088,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1089,  1090,  1091,     0,     0,     0,     0,     0,  1092,  1093,
       0,     0,     0,     0,     0,     0,     0,     0,    52,    53,
      54,   573,    55,    56,    57,    58,    59,  1094,    60,    61,
      62,  1095,  1096,    65,    66,    67,    68,    69,    70,  1097,
      72,    73,    74,    75,    76,    77,    78,  1098,   574,     0,
     575,   576,    84,    85,    86,    87,    88,    89,   577,    91,
      92,    93,    94,  1099,    95,   579,    97,    98,    99,   100,
     101,   580,  1100,   103,  1101,   105,  1102,  1103,  1104,  1105,
    1106,     0,   111,   112,   113,   581,   115,   116,   117,   118,
     119,   120,   121,   122,   123,  1107,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,  1108,  1109,  1110,
     583,  1111,  1112,   141,     0,   142,   143,   144,   145,   146,
     147,   148,   584,   150,   151,   152,   153,   585,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   586,   168,     0,     0,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   587,   588,   181,     0,
    1113,   183,   184,   589,   186,   187,  1114,   590,   190,   191,
     591,   193,   194,   592,     0,   196,   197,   198,  1115,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   593,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   594,   219,
    1116,  1117,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,  1118,   264,  1119,   266,   267,   268,   269,
     270,  1120,   272,   273,   274,   275,   276,   277,   278,   279,
     280,  1121,  1122,   283,   284,   285,   286,   287,   595,   288,
     289,   290,   291,   292,   293,   294,   295,     0,  1123,   297,
     298,   299,   596,   300,   301,  1124,   303,   304,   305,   306,
     307,   308,   309,  1125,   311,   312,   313,   314,   315,   316,
     597,   317,   598,   319,   320,  1126,   322,   323,   324,   325,
     326,   327,  1127,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   599,   348,   349,   350,   600,   352,   353,   354,   355,
     356,   357,   358,  1128,   360,   601,   362,   363,   364,  1129,
    1130,   367,   368,   602,   370,   371,  1131,   373,   374,   375,
     376,   377,   378,  1132,   380,   603,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,     0,   397,   398,   399,   400,   604,   402,   403,   605,
     405,   406,   407,   408,  1133,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,  1134,  1135,  1136,  1137,   432,   433,   434,
     435,  1138,  1139,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   607,   448,   449,   450,  1140,   452,  1141,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,  1142,
    1143,   608,  1144,   468,   469,   470,     0,   471,   609,   473,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,  1989,
    1990,     0,     0,     0,  1013,  1148,     0,     0,  1014,  1015,
    1149,     0,     0,     0,  1150,  1151,     0,     0,  1152,  1016,
    1017,     0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,
    1026,  1027,  1028,     0,     0,     0,     0,     0,     0,     0,
    1029,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1030,  1031,  1032,
    1033,     0,     0,     0,     0,     0,     0,     0,  1034,  1035,
       0,  1036,     0,     0,     0,     0,     0,     0,  1037,  1038,
       0,     0,  1039,  1040,  1041,  1042,     0,  1043,  1044,     0,
    1045,  1046,     0,     0,     0,     0,     0,     0,     0,  1047,
       0,     0,  1048,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
    1049,  1050,  1051,     0,  1052,     0,     0,     0,     0,     0,
       0,     0,  1053,  1054,  1055,    21,     0,     0,     0,     0,
       0,  1056,     0,     0,   572,     0,     0,     0,     0,     0,
    1057,     0,     0,  1058,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,  1060,     0,  1061,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,  1063,     0,  1064,     0,     0,     0,  1065,     0,     0,
       0,     0,  1066,     0,     0,    28,     0,     0,  1068,  1069,
    1070,  1071,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,  1072,
    1073,  1074,     0,  1075,     0,     0,     0,     0,     0,     0,
    1076,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1077,  1078,     0,     0,     0,     0,     0,     0,     0,
    1079,  1080,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1081,
       0,     0,     0,     0,     0,     0,  1082,  1083,     0,  1084,
    1085,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1087,  1088,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1089,  1090,  1091,     0,     0,     0,     0,
       0,  1092,  1093,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
    1094,    60,    61,    62,  1095,  1096,    65,    66,    67,    68,
      69,    70,  1097,    72,    73,    74,    75,    76,    77,    78,
    1098,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,  1099,    95,   579,    97,
      98,    99,   100,   101,   580,  1100,   103,  1101,   105,  1102,
    1103,  1104,  1105,  1106,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,  1107,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
    1108,  1109,  1110,   583,  1111,  1112,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,  1113,   183,   184,   589,   186,   187,  1114,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,  1115,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,  1116,  1117,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,  1118,   264,  1119,   266,
     267,   268,   269,   270,  1120,   272,   273,   274,   275,   276,
     277,   278,   279,   280,  1121,  1122,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,  1123,   297,   298,   299,   596,   300,   301,  1124,   303,
     304,   305,   306,   307,   308,   309,  1125,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,  1126,   322,
     323,   324,   325,   326,   327,  1127,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,  1128,   360,   601,   362,
     363,   364,  1129,  1130,   367,   368,   602,   370,   371,  1131,
     373,   374,   375,   376,   377,   378,  1132,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,  1133,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,  1134,  1135,  1136,  1137,
     432,   433,   434,   435,  1138,  1139,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,  1140,
     452,  1141,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,  1142,  1143,   608,  1144,   468,   469,   470,     0,
     471,   609,   473,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,  1146,  1147,     0,     0,     0,  1013,  1148,     0,
       0,  1014,  1015,  1149,     0,     0,     0,  1150,  1151,     0,
       0,  1152,  1016,  1017,     0,  1018,  1019,  1020,  1021,  1022,
    1023,  1024,  1025,  1026,  1027,  1028,     0,     0,     0,     0,
       0,     0,     0,  1029,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1030,  1031,  1032,  1033,     0,     0,     0,     0,     0,     0,
       0,  1034,  1035,     0,  1036,     0,     0,     0,     0,     0,
       0,  1037,  1038,     0,     0,  1039,  1040,  1041,  1042,     0,
    1043,  1044,     0,  1045,  1046,     0,     0,     0,     0,     0,
       0,     0,  1047,     0,     0,  1048,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    18,
       0,     0,     0,  1049,  1050,  1051,     0,  1052,     0,     0,
       0,     0,     0,     0,     0,  1053,  1054,  1055,    21,     0,
       0,     0,     0,     0,  1056,     0,     0,   572,     0,     0,
       0,     0,     0,  1057,     0,     0,  2949,     0,     0,     0,
       0,     0,     0,     0,     0,  1059,     0,  1060,     0,  1061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,  1063,     0,  1064,     0,     0,     0,
    1065,     0,     0,     0,     0,  1066,     0,     0,    28,     0,
       0,  1068,  1069,  1070,  1071,     0,     0,     0,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    33,  1072,  1073,  1074,     0,  1075,     0,     0,     0,
       0,     0,     0,  1076,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1077,  1078,     0,     0,     0,     0,
       0,     0,     0,  1079,  1080,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1081,     0,     0,     0,     0,     0,     0,  1082,
    1083,     0,  1084,  1085,  1086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1087,  1088,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1089,  1090,  1091,     0,
       0,     0,     0,     0,  1092,  1093,     0,     0,     0,     0,
       0,     0,     0,     0,    52,    53,    54,   573,    55,    56,
      57,    58,    59,  1094,    60,    61,    62,  1095,  1096,    65,
      66,    67,    68,    69,    70,  1097,    72,    73,    74,    75,
      76,    77,    78,  1098,   574,     0,   575,   576,    84,    85,
      86,    87,    88,    89,   577,    91,    92,    93,    94,  1099,
      95,   579,    97,    98,    99,   100,   101,   580,  1100,   103,
    1101,   105,  1102,  1103,  1104,  1105,  1106,     0,   111,   112,
     113,   581,   115,   116,   117,   118,   119,   120,   121,   122,
     123,  1107,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,  1108,  1109,  1110,   583,  1111,  1112,   141,
       0,   142,   143,   144,   145,   146,   147,   148,   584,   150,
     151,   152,   153,   585,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   586,   168,     0,
       0,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   587,   588,   181,     0,  1113,   183,   184,   589,
     186,   187,  1114,   590,   190,   191,   591,   193,   194,   592,
       0,   196,   197,   198,  1115,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   593,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   594,   219,  1116,  1117,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,  1118,
     264,  1119,   266,   267,   268,   269,   270,  1120,   272,   273,
     274,   275,   276,   277,   278,   279,   280,  1121,  1122,   283,
     284,   285,   286,   287,   595,   288,   289,   290,   291,   292,
     293,   294,   295,     0,  1123,   297,   298,   299,   596,   300,
     301,  1124,   303,   304,   305,   306,   307,   308,   309,  1125,
     311,   312,   313,   314,   315,   316,   597,   317,   598,   319,
     320,  1126,   322,   323,   324,   325,   326,   327,  1127,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   599,   348,   349,
     350,   600,   352,   353,   354,   355,   356,   357,   358,  1128,
     360,   601,   362,   363,   364,  1129,  1130,   367,   368,   602,
     370,   371,  1131,   373,   374,   375,   376,   377,   378,  1132,
     380,   603,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,     0,   397,   398,
     399,   400,   604,   402,   403,   605,   405,   406,   407,   408,
    1133,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,  1134,
    1135,  1136,  1137,   432,   433,   434,   435,  1138,  1139,   438,
     439,   440,   441,   442,   443,   444,   445,   446,   607,   448,
     449,   450,  1140,   452,  1141,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,  1142,  1143,   608,  1144,   468,
     469,   470,     0,   471,   609,   473,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,  1147,     0,     0,     0,
    1013,  1148,     0,     0,  1014,  1015,  1149,     0,     0,     0,
    1150,  1151,     0,     0,  1152,  1016,  1017,     0,  1018,  1019,
    1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,     0,
       0,     0,     0,     0,     0,     0,  1029,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1030,  1031,  1032,  1033,     0,     0,     0,
       0,     0,     0,     0,  1034,  1035,     0,  1036,     0,     0,
       0,     0,     0,     0,  1037,  1038,     0,     0,  1039,  1040,
    1041,  1042,     0,  1043,  1044,     0,  1045,  1046,     0,     0,
       0,     0,     0,     0,     0,  1047,     0,     0,  1048,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,  1049,  1050,  1051,     0,
    1052,     0,     0,     0,     0,     0,     0,     0,  1053,  1054,
    1055,    21,     0,     0,     0,     0,     0,  1056,     0,     0,
     572,     0,     0,     0,     0,     0,  1057,     0,     0,  2951,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,     0,
    1060,     0,  1061,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1062,  1063,     0,  1064,
       0,     0,     0,  1065,     0,     0,     0,     0,  1066,     0,
       0,    28,     0,     0,  1068,  1069,  1070,  1071,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,  1072,  1073,  1074,     0,  1075,
       0,     0,     0,     0,     0,     0,  1076,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1077,  1078,     0,
       0,     0,     0,     0,     0,     0,  1079,  1080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1081,     0,     0,     0,     0,
       0,     0,  1082,  1083,     0,  1084,  1085,  1086,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1087,  1088,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1089,
    1090,  1091,     0,     0,     0,     0,     0,  1092,  1093,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,  1094,    60,    61,    62,
    1095,  1096,    65,    66,    67,    68,    69,    70,  1097,    72,
      73,    74,    75,    76,    77,    78,  1098,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,  1099,    95,   579,    97,    98,    99,   100,   101,
     580,  1100,   103,  1101,   105,  1102,  1103,  1104,  1105,  1106,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,  1107,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,  1108,  1109,  1110,   583,
    1111,  1112,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,  1113,
     183,   184,   589,   186,   187,  1114,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,  1115,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,  1116,
    1117,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,  1118,   264,  1119,   266,   267,   268,   269,   270,
    1120,   272,   273,   274,   275,   276,   277,   278,   279,   280,
    1121,  1122,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,  1123,   297,   298,
     299,   596,   300,   301,  1124,   303,   304,   305,   306,   307,
     308,   309,  1125,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,  1126,   322,   323,   324,   325,   326,
     327,  1127,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,  1128,   360,   601,   362,   363,   364,  1129,  1130,
     367,   368,   602,   370,   371,  1131,   373,   374,   375,   376,
     377,   378,  1132,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,  1133,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,  1134,  1135,  1136,  1137,   432,   433,   434,   435,
    1138,  1139,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,  1140,   452,  1141,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,  1142,  1143,
     608,  1144,   468,   469,   470,     0,   471,   609,   473,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,  1146,  1147,
       0,     0,     0,  1013,  1148,     0,     0,  1014,  1015,  1149,
       0,     0,     0,  1150,  1151,     0,     0,  1152,  1016,  1017,
       0,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,
    1027,  1028,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1031,  1032,  1033,
       0,     0,     0,     0,     0,     0,     0,  1034,  1035,     0,
    1036,     0,     0,     0,     0,     0,     0,  1037,  1038,     0,
       0,  1039,  1040,  1041,  1042,     0,  1043,  1044,     0,  1045,
    1046,     0,     0,     0,     0,     0,     0,     0,  1047,     0,
       0,  1048,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,     0,     0,  1049,
    1050,  1051,     0,  1052,     0,     0,     0,     0,     0,     0,
       0,  1053,  1054,  1055,    21,     0,     0,     0,     0,     0,
    1056,     0,     0,   572,     0,     0,     0,     0,     0,  1057,
       0,     0,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,  1060,     0,  1061,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
    1063,     0,  1064,     0,     0,     0,  1065,     0,     0,     0,
       0,  1066,     0,     0,    28,     0,     0,  1068,  1069,  1070,
    1071,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,  1072,  1073,
    1074,     0,  1075,     0,     0,     0,     0,     0,     0,  1076,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1077,  1078,     0,     0,     0,     0,     0,     0,     0,  1079,
    1080,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1081,     0,
       0,     0,     0,     0,     0,  1082,  1083,     0,  1084,  1085,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1087,  1088,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1089,  1090,  1091,     0,     0,     0,     0,     0,
    1092,  1093,     0,     0,     0,     0,     0,     0,     0,     0,
      52,    53,    54,   573,    55,    56,    57,    58,    59,  1094,
      60,    61,    62,  1095,  1096,    65,    66,    67,    68,    69,
      70,  1097,    72,    73,    74,    75,    76,    77,    78,  1098,
     574,     0,   575,   576,    84,    85,    86,    87,    88,    89,
     577,    91,    92,    93,    94,  1099,    95,   579,    97,    98,
      99,   100,   101,   580,  1100,   103,  1101,   105,  1102,  1103,
    1104,  1105,  1106,     0,   111,   112,   113,   581,   115,   116,
     117,   118,   119,   120,   121,   122,   123,  1107,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,  1108,
    1109,  1110,   583,  1111,  1112,   141,     0,   142,   143,   144,
     145,   146,   147,   148,   584,   150,   151,   152,   153,   585,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   586,   168,     0,     0,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   587,   588,
     181,     0,  1113,   183,   184,   589,   186,   187,  1114,   590,
     190,   191,   591,   193,   194,   592,     0,   196,   197,   198,
    1115,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     593,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     594,   219,  1116,  1117,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,  1118,   264,  1119,   266,   267,
     268,   269,   270,  1120,   272,   273,   274,   275,   276,   277,
     278,   279,   280,  1121,  1122,   283,   284,   285,   286,   287,
     595,   288,   289,   290,   291,   292,   293,   294,   295,     0,
    1123,   297,   298,   299,   596,   300,   301,  1124,   303,   304,
     305,   306,   307,   308,   309,  1125,   311,   312,   313,   314,
     315,   316,   597,   317,   598,   319,   320,  1126,   322,   323,
     324,   325,   326,   327,  1127,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   599,   348,   349,   350,   600,   352,   353,
     354,   355,   356,   357,   358,  1128,   360,   601,   362,   363,
     364,  1129,  1130,   367,   368,   602,   370,   371,  1131,   373,
     374,   375,   376,   377,   378,  1132,   380,   603,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,     0,   397,   398,   399,   400,   604,   402,
     403,   605,   405,   406,   407,   408,  1133,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,  1134,  1135,  1136,  1137,   432,
     433,   434,   435,  1138,  1139,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   607,   448,   449,   450,  1140,   452,
    1141,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,  1142,  1143,   608,  1144,   468,   469,   470,     0,   471,
     609,   473,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,  6230,  6231,  1013,     0,     0,     0,  2027,     0,     0,
       0,     0,  6232,     0,     0,     0,     0,  1151,  1981,  1982,
    1152,  1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1026,
    1027,  1028,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,     0,     0,     0,
       0,  1051,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,     0,     0,     0,     0,
       0,     0,     0,   572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,     0,     0,
    1071,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1088,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      52,    53,    54,   573,    55,    56,    57,    58,    59,     0,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
     574,     0,   575,   576,    84,    85,    86,    87,    88,    89,
     577,    91,    92,    93,    94,   578,    95,   579,    97,    98,
      99,   100,   101,   580,   102,   103,   104,   105,   106,   107,
     108,   109,   110,     0,   111,   112,   113,   581,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   582,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
    2982,   137,   583,   139,   140,   141,     0,   142,   143,   144,
     145,   146,   147,   148,   584,   150,   151,   152,   153,   585,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   586,   168,     0,     0,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   587,   588,
     181,     0,   182,   183,   184,   589,   186,   187,   188,   590,
     190,   191,   591,   193,   194,   592,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     593,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     594,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     595,   288,   289,   290,   291,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   596,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   597,   317,   598,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   599,   348,   349,   350,   600,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   601,   362,   363,
     364,   365,   366,   367,   368,   602,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   603,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,     0,   397,   398,   399,   400,   604,   402,
     403,   605,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,  2983,   429,   430,  2984,   432,
     433,   434,   435,   436,   606,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   607,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,   465,   608,   467,   468,   469,   470,     0,   471,
     609,   473,   474,  6541,     0,     0,     0,  2904,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,     0,     0,     0,     0,
       0,     0,     0,   572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      52,    53,    54,   573,    55,    56,    57,    58,    59,     0,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
     574,     0,   575,   576,    84,    85,    86,    87,    88,    89,
     577,    91,    92,    93,    94,   578,    95,   579,    97,    98,
      99,   100,   101,   580,   102,   103,   104,   105,   106,   107,
     108,   109,   110,     0,   111,   112,   113,   581,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   582,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   583,   139,   140,   141,     0,   142,   143,   144,
     145,   146,   147,   148,   584,   150,   151,   152,   153,   585,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   586,   168,     0,     0,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   587,   588,
     181,     0,   182,   183,   184,   589,   186,   187,   188,   590,
     190,   191,   591,   193,   194,   592,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     593,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     594,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     595,   288,   289,   290,   291,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   596,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   597,   317,   598,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   599,   348,   349,   350,   600,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   601,   362,   363,
     364,   365,   366,   367,   368,   602,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   603,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,     0,   397,   398,   399,   400,   604,   402,
     403,   605,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,   428,   429,   430,   431,   432,
     433,   434,   435,   436,   606,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   607,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,   465,   608,   467,   468,   469,   470,     0,   471,
     609,   473,   474,  6541,     0,     0,     0,  2904,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     5,
       0,     0,     0,  6542,     0,     0,     0,     0,     0,     0,
    2905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,     0,     0,     0,     0,
       0,     0,     0,   572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      52,    53,    54,   573,    55,    56,    57,    58,    59,     0,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
     574,     0,   575,   576,    84,    85,    86,    87,    88,    89,
     577,    91,    92,    93,    94,   578,    95,   579,    97,    98,
      99,   100,   101,   580,   102,   103,   104,   105,   106,   107,
     108,   109,   110,     0,   111,   112,   113,   581,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   582,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   583,   139,   140,   141,     0,   142,   143,   144,
     145,   146,   147,   148,   584,   150,   151,   152,   153,   585,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   586,   168,     0,     0,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   587,   588,
     181,     0,   182,   183,   184,   589,   186,   187,   188,   590,
     190,   191,   591,   193,   194,   592,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     593,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     594,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     595,   288,   289,   290,   291,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   596,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   597,   317,   598,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   599,   348,   349,   350,   600,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   601,   362,   363,
     364,   365,   366,   367,   368,   602,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   603,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,     0,   397,   398,   399,   400,   604,   402,
     403,   605,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,   428,   429,   430,   431,   432,
     433,   434,   435,   436,   606,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   607,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,   465,   608,   467,   468,   469,   470,  2027,   471,
     609,   473,   474,     0,     0,     0,     0,     0,     0,  1981,
    1982,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,  2027,
     471,   609,   473,   474,     0,     0,     0,     0,     0,     0,
    1981,  1982,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2028,     0,     0,     0,     0,     0,     0,
       0,  1152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
    2904,   471,   609,   473,   474,     0,     0,     0,     0,     0,
       0,     4,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    18,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    21,     0,     0,
       0,     0,     0,     0,     0,     0,   572,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    28,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    52,    53,    54,   573,    55,    56,    57,
      58,    59,     0,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,   574,     0,   575,   576,    84,    85,    86,
      87,    88,    89,   577,    91,    92,    93,    94,   578,    95,
     579,    97,    98,    99,   100,   101,   580,   102,   103,   104,
     105,   106,   107,   108,   109,   110,     0,   111,   112,   113,
     581,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     582,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   583,   139,   140,   141,     0,
     142,   143,   144,   145,   146,   147,   148,   584,   150,   151,
     152,   153,   585,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   586,   168,     0,     0,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   587,   588,   181,     0,   182,   183,   184,   589,   186,
     187,   188,   590,   190,   191,   591,   193,   194,   592,     0,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   593,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   594,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   595,   288,   289,   290,   291,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   596,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   597,   317,   598,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,   599,   348,   349,   350,
     600,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     601,   362,   363,   364,   365,   366,   367,   368,   602,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     603,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,     0,   397,   398,   399,
     400,   604,   402,   403,   605,   405,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,   428,   429,
     430,   431,   432,   433,   434,   435,   436,   606,   438,   439,
     440,   441,   442,   443,   444,   445,   446,   607,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   608,   467,   468,   469,
     470,     0,   471,   609,   473,   474,     1,     2,     3,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,     9,     0,
      10,     0,    11,     0,     0,     0,     0,     0,     0,     0,
      12,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    13,     0,
       0,    14,     0,    15,    16,     0,     0,     0,     0,     0,
      17,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    19,     0,     0,
       0,    20,     0,     0,     0,    21,     0,     0,     0,     0,
       0,    22,     0,     0,     0,     0,     0,     0,     0,     0,
      23,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    25,     0,    26,     0,     0,     0,    27,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,    31,    32,    33,     0,
       0,     0,     0,     0,     0,     0,     0,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,    39,     0,    40,     0,     0,     0,     0,    41,
       0,     0,     0,     0,     0,    42,     0,     0,     0,    43,
      44,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,    47,
       0,    48,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,    52,    53,    54,     0,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,     0,    95,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,     0,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
       0,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,     0,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,     0,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,     0,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   447,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,     0,
     471,   472,   473,   474,     1,     0,     3,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     5,     0,
       0,     0,     0,   475,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     8,     0,     9,     0,    10,     0,
      11,     0,     0,     0,     0,     0,     0,     0,    12,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,     0,    14,
       0,    15,    16,     0,     0,     0,     0,     0,    17,     0,
       0,     0,     0,     0,    18,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    19,     0,     0,     0,    20,
       0,     0,     0,    21,     0,     0,     0,     0,     0,    22,
       0,     0,     0,     0,     0,     0,     0,     0,    23,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    25,
       0,    26,     0,     0,     0,    27,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    28,     0,     0,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    30,     0,     0,     0,     0,
       0,     0,     0,     0,    31,    32,    33,     0,     0,     0,
       0,     0,     0,     0,     0,    34,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,    37,    38,
      39,     0,    40,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,    42,     0,     0,     0,    43,    44,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,    47,     0,    48,
       0,     0,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,    52,
      53,    54,     0,    55,    56,    57,    58,    59,     0,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,     0,    95,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   104,   105,   106,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,     0,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,     0,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,     0,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,     0,     0,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
       0,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,     0,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,     0,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,     0,
     288,   289,   290,   291,   292,   293,   294,   295,     0,   296,
     297,   298,   299,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,     0,   397,   398,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,   446,   447,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,     0,   471,   472,
     473,   474,     1,     0,     3,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     5,     0,     0,     0,
       0,   475,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     8,     0,     0,     0,    10,     0,    11,     0,
       0,     0,     0,     0,     0,     0,    12,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    14,     0,    15,
      16,     0,     0,     0,     0,     0,    17,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    20,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    23,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    24,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    25,     0,    26,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,     0,     0,     0,     0,     0,
       0,     0,     0,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,    37,     0,    39,     0,
      40,     0,     0,     0,     0,    41,     0,     0,     0,     0,
       0,    42,     0,     0,     0,    43,    44,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,    47,     0,    48,     0,     0,
       0,     0,     0,     0,    49,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,    52,    53,    54,
       0,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,     0,     0,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,     0,    95,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,     0,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,     0,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,     0,   182,
     183,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,     0,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,     0,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   447,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,     0,   471,   472,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   475,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5221,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     770,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,  3821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3822,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   772,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,  5222,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
       0,   471,   609,   473,   474,     4,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1411,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1412,
       0,     0,     0,     0,     0,     0,     0,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1410,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1411,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
       0,   471,   609,   473,   474,     4,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1412,     0,     0,     0,     0,  1413,
       0,     0,   801,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1411,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1412,
       0,     0,     0,     0,  1413,     0,     0,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1411,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
       0,   471,   609,   473,   474,     4,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1412,     0,     0,     0,     0,     0,
       0,     0,   801,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
    3471,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
       0,   471,   609,   473,   474,     4,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5381,     0,     0,     0,     0,     0,
       0,     0,  5223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,  5628,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5223,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   798,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   799,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   800,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
       0,   471,   609,   473,   474,     4,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   801,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
       0,   471,   609,   473,   474,     4,     5,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2111,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
    1237,   471,   609,   473,   474,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     5,     0,     0,     0,
       0,     0,     0,     0,  2960,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1238,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
    1240,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
    1241,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,  1242,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,  1243,   186,   187,   188,   590,  1244,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,  1245,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,  1246,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,  1247,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,  1248,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,  1249,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
    1250,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,  1251,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,  1252,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
    1253,   467,   468,   469,   470,  1237,   471,   609,   473,   474,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1238,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,  1240,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,  1241,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,  1242,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,  1243,   186,   187,
     188,   590,  1244,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
    1245,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,  1246,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,  1247,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,  1248,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,  1249,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,  1250,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,  1253,   467,   468,   469,   470,
    2193,   471,   609,   473,   474,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     5,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,  2435,   471,   609,   473,   474,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     5,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   723,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
    2737,   471,   609,   473,   474,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     5,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,  2342,   471,   609,   473,   474,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1981,  1982,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,     0,     0,     0,   572,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,    53,    54,   573,    55,    56,    57,    58,
      59,     0,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   574,     0,   575,   576,    84,    85,    86,    87,
      88,    89,   577,    91,    92,    93,    94,   578,    95,   579,
      97,    98,    99,   100,   101,   580,   102,   103,   104,   105,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   581,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   582,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   583,   139,   140,   141,     0,   142,
     143,   144,   145,   146,   147,   148,   584,   150,   151,   152,
     153,   585,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   586,   168,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     587,   588,   181,     0,   182,   183,   184,   589,   186,   187,
     188,   590,   190,   191,   591,   193,   194,   592,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   593,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   594,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   595,   288,   289,   290,   291,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   596,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   597,   317,   598,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   599,   348,   349,   350,   600,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   601,
     362,   363,   364,   365,   366,   367,   368,   602,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   603,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,     0,   397,   398,   399,   400,
     604,   402,   403,   605,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   606,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   607,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   608,   467,   468,   469,   470,
    2342,   471,   609,   473,   474,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1981,  1982,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,    53,    54,
     573,    55,    56,    57,    58,    59,     0,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,   574,     0,   575,
     576,    84,    85,    86,    87,    88,    89,   577,    91,    92,
      93,    94,   578,    95,   579,    97,    98,    99,   100,   101,
     580,   102,   103,   104,   105,   106,   107,   108,   109,   110,
       0,   111,   112,   113,   581,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   582,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   583,
     139,   140,   141,     0,   142,   143,   144,   145,   146,   147,
     148,   584,   150,   151,   152,   153,   585,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     586,   168,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   587,   588,   181,     0,   182,
     183,   184,   589,   186,   187,   188,   590,   190,   191,   591,
     193,   194,   592,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   593,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   594,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   595,   288,   289,
     290,   291,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   596,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   597,
     317,   598,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     599,   348,   349,   350,   600,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   601,   362,   363,   364,   365,   366,
     367,   368,   602,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   603,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
       0,   397,   398,   399,   400,   604,   402,   403,   605,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   606,   438,   439,   440,   441,   442,   443,   444,   445,
     446,   607,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     608,   467,   468,   469,   470,     0,   471,   609,   473,   474,
    2449,  1015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1981,  1982,     0,     0,     0,     0,     0,     0,     0,
    2450,     0,  2451,     0,  2452,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    18,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    21,     0,     0,
       0,     0,     0,     0,     0,     0,   572,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    28,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2453,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    52,    53,    54,   573,    55,    56,    57,
      58,    59,     0,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,   574,     0,   575,   576,    84,    85,    86,
      87,    88,    89,   577,    91,    92,    93,    94,   578,    95,
     579,    97,    98,    99,   100,   101,   580,   102,   103,   104,
     105,   106,   107,   108,   109,   110,     0,   111,   112,   113,
     581,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     582,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   583,   139,   140,   141,     0,
     142,   143,   144,   145,   146,   147,   148,   584,   150,   151,
     152,   153,   585,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   586,   168,     0,     0,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   587,   588,   181,     0,   182,   183,   184,   589,   186,
     187,   188,   590,   190,   191,   591,   193,   194,   592,     0,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   593,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   594,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   595,   288,   289,   290,   291,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   596,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   597,   317,   598,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,   599,   348,   349,   350,
     600,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     601,   362,   363,   364,   365,   366,   367,   368,   602,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     603,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,     0,   397,   398,   399,
     400,   604,   402,   403,   605,   405,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,   428,   429,
     430,   431,   432,   433,   434,   435,   436,   606,   438,   439,
     440,   441,   442,   443,   444,   445,   446,   607,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   608,   467,   468,   469,
     470,     0,   471,   609,   473,   474,  2449,  1015,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1981,  1982,     0,
       0,     0,     0,     0,     0,     0,  2450,     0,  2451,     0,
    2452,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    18,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    21,     0,     0,     0,     0,     0,     0,
       0,     0,   572,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    28,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3233,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    52,
      53,    54,   573,    55,    56,    57,    58,    59,     0,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,   574,
       0,   575,   576,    84,    85,    86,    87,    88,    89,   577,
      91,    92,    93,    94,   578,    95,   579,    97,    98,    99,
     100,   101,   580,   102,   103,   104,   105,   106,   107,   108,
     109,   110,     0,   111,   112,   113,   581,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   582,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   583,   139,   140,   141,     0,   142,   143,   144,   145,
     146,   147,   148,   584,   150,   151,   152,   153,   585,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   586,   168,     0,     0,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   587,   588,   181,
       0,   182,   183,   184,   589,   186,   187,   188,   590,   190,
     191,   591,   193,   194,   592,     0,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   593,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   594,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   595,
     288,   289,   290,   291,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   596,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   597,   317,   598,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   599,   348,   349,   350,   600,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   601,   362,   363,   364,
    3234,   366,   367,   368,   602,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   603,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,     0,   397,   398,   399,   400,   604,   402,   403,
     605,   405,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,   431,   432,   433,
     434,   435,   436,   606,   438,   439,   440,   441,   442,   443,
     444,   445,   446,   607,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   608,   467,   468,   469,   470,     0,   471,   609,
     473,   474,  2449,  1015,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1981,  1982,     0,     0,     0,     0,     0,
       0,     0,  2450,     0,  2451,     0,  2452,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      18,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    21,
       0,     0,     0,     0,     0,     0,     0,     0,   572,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    28,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    30,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    33,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4617,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    52,    53,    54,   573,    55,
      56,    57,    58,    59,     0,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,   574,     0,   575,   576,    84,
      85,    86,    87,    88,    89,   577,    91,    92,    93,    94,
     578,    95,   579,    97,    98,    99,   100,   101,   580,   102,
     103,   104,   105,   106,   107,   108,   109,   110,     0,   111,
     112,   113,   581,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   582,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   583,   139,   140,
     141,     0,   142,   143,   144,   145,   146,   147,   148,   584,
     150,   151,   152,   153,   585,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   586,   168,
       0,     0,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   587,   588,   181,     0,   182,   183,   184,
     589,   186,   187,   188,   590,   190,   191,   591,   193,   194,
     592,     0,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   593,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   594,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   595,   288,   289,   290,   291,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   596,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   597,   317,   598,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   599,   348,
     349,   350,   600,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   601,   362,   363,   364,   365,   366,   367,   368,
     602,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   603,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,     0,   397,
     398,   399,   400,   604,   402,   403,   605,   405,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   606,
     438,   439,   440,   441,   442,   443,   444,   445,   446,   607,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   608,   467,
     468,   469,   470,     0,   471,   609,   473,   474,  2449,  1015,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1981,
    1982,     0,     0,     0,     0,     0,     0,     0,  2450,     0,
    2451,     0,  2452,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,  3450,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,  1981,  1982,     0,     0,     0,     0,
       0,     0,     0,     0,  4633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,  1981,
    1982,     0,     0,     0,     0,     0,     0,     0,     0,  4795,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,  5483,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,  5734,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,  3432,     0,     0,  6053,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   717,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,   718,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,  4099,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4100,     0,   688,     0,  4101,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,  3433,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1478,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2198,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,   821,  1479,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1478,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,  1479,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1538,  1539,  1540,  1541,  1542,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,  1551,  1552,
    1553,  1554,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,
    1563,  1564,  1565,  1566,     0,  1567,  1568,  1569,  1570,  1571,
    1572,  1573,  1574,  1575,  1576,  1577,     0,  1578,  1579,  1580,
    1581,  1582,  1583,  1584,  1585,  1586,  1587,  1588,  1589,  1590,
    1591,  1592,  1593,  1594,  1595,  1596,  1597,  1598,  1599,  1600,
    1601,  1602,  1603,  1604,  1605,  1606,    18,  1607,  1608,  1609,
    1610,  1611,  1612,  1613,  1614,  1615,  1616,     0,  1617,  1618,
    1619,  1620,  1621,     0,     0,    21,  1622,  1623,  1624,  1625,
    1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,     0,  1634,
    1635,     0,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  1648,  1649,  1650,  1651,  1652,  1653,
    1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,  1663,
    1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1674,  1675,  1676,  1677,  1678,    28,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,  1688,  1689,    30,  1690,  1691,
    1692,  1693,     0,  1694,  1695,  1696,  1697,  1698,    33,  1699,
    1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,
    1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,
    1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,
    1760,     0,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,     0,  1777,
    1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,
    1788,  1789,  1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,
    1798,    52,    53,    54,     0,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,  1799,    85,  1800,  1801,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,     0,  1802,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,  1803,
     135,  1804,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,  1805,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,  1806,   587,
     588,   181,     0,   182,   183,   184,     0,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,  1807,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,     0,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
    1808,  1809,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,     0,  1810,  1811,   295,
    1812,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,  1813,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,  1814,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,     0,   377,   378,   379,   380,   603,     0,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,  1815,   426,   427,  1816,   429,   430,  1817,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,     0,  1818,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,  1819,   467,   468,   469,   470,     0,
     471,   609,   473,  1820,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1538,  1539,  1540,  1541,  1542,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,  1551,  1552,  1553,  1554,  1555,  1556,  1557,
    1558,  1559,  1560,  1561,  1562,  1563,  1564,  1565,  1566,     0,
    1567,  1568,  1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,
    1577,     0,  1578,  1579,  1580,  1581,  1582,  1583,  1584,  1585,
    1586,  1587,  1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,
    1596,  1597,  1598,  1599,  1600,  1601,  1602,  1603,  1604,  1605,
    1606,    18,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,
    1615,  1616,     0,  1617,  1618,  1619,  1620,  1621,     0,     0,
      21,  1622,  1623,  1624,  1625,  1626,  1627,  1628,  1629,  1630,
    1631,  1632,  1633,     0,  1634,  1635,     0,  1636,  1637,  1638,
    1639,  1640,  1641,  1642,  1643,  1644,  1645,  1646,  1647,  1648,
    1649,  1650,  1651,  1652,  1653,  1654,  1655,  1656,  1657,  1658,
    1659,  1660,  1661,  1662,  1663,  1664,  1665,  1666,  1667,  1668,
    1669,  1670,  1671,  1672,  1673,  1674,  1675,  1676,  1677,  1678,
      28,  1679,  1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,
    1688,  1689,    30,  1690,  1691,  1692,  1693,     0,  1694,  1695,
    1696,  1697,  1698,    33,  1699,  1700,  1701,  1702,  1703,  1704,
    1705,  1706,  1707,  1708,  1709,  1710,  1711,  1712,  1713,  1714,
    1715,  1716,  1717,  1718,  1719,  1720,  1721,  1722,  1723,  1724,
    1725,  1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,
    1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,
    1745,  1746,  1747,  1748,  1749,  1750,  1751,  1752,  1753,  1754,
    1755,  1756,  1757,  1758,  1759,  1760,     0,  1761,  1762,  1763,
    1764,  1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,
    1774,  1775,  1776,     0,  1777,  1778,  1779,  1780,  1781,  1782,
    1783,  1784,  1785,  1786,  1787,  1788,  1789,  1790,  1791,  1792,
    1793,  1794,  1795,  1796,  1797,  1798,    52,    53,    54,     0,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
    1799,    85,  1800,  1801,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,     0,  1802,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,  1803,   135,  1804,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,  1805,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,  1806,   587,   588,   181,     0,   182,   183,
     184,     0,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,  1807,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,     0,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,  1808,  1809,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,     0,  1810,  1811,   295,  1812,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,     0,  1813,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,  4599,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,     0,   377,
     378,   379,   380,   603,     0,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,  1815,   426,
     427,  1816,   429,   430,  1817,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,     0,  1818,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,  1819,
     467,   468,   469,   470,     0,   471,   609,   473,  1820,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1538,  1539,  1540,  1541,  1542,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,  1551,  1552,
    1553,  1554,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,
    1563,  1564,  1565,  1566,     0,  1567,  1568,  1569,  1570,  1571,
    1572,  1573,  1574,  1575,  1576,  1577,     0,  1578,  1579,  1580,
    1581,  1582,  1583,  1584,  1585,  1586,  1587,  1588,  1589,  1590,
    1591,  1592,  1593,  1594,  1595,  1596,  1597,  1598,  1599,  1600,
    1601,  1602,  1603,  1604,  1605,  1606,    18,  1607,  1608,  1609,
    1610,  1611,  1612,  1613,  1614,  1615,  1616,     0,  1617,  1618,
    1619,  1620,  1621,     0,     0,    21,  1622,  1623,  1624,  1625,
    1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,     0,  1634,
    1635,     0,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  1648,  1649,  1650,  1651,  1652,  1653,
    1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,  1663,
    1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1674,  1675,  1676,  1677,  1678,    28,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,  1688,  1689,    30,  1690,  1691,
    1692,  1693,     0,  1694,  1695,  1696,  1697,  1698,    33,  1699,
    1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,
    1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,
    1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,
    1760,     0,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,     0,  1777,
    1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,
    1788,  1789,  1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,
    1798,    52,    53,    54,     0,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,  1799,    85,  1800,  1801,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,     0,  1802,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,  1803,
     135,  1804,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,  1805,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,  1806,   587,
     588,   181,     0,   182,   183,   184,     0,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,  1807,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,     0,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
    1808,  1809,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,     0,  1810,  1811,   295,
    1812,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,  1813,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,     0,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,  5769,   377,   378,   379,   380,   603,     0,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,  1815,   426,   427,  1816,   429,   430,  1817,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,     0,  1818,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,  1819,   467,   468,   469,   470,     0,
     471,   609,   473,  1820,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1538,  1539,  1540,  1541,  1542,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,  1551,  1552,  1553,  1554,  1555,  1556,  1557,
    1558,  1559,  1560,  1561,  1562,  1563,  1564,  1565,  1566,     0,
    1567,  1568,  1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,
    1577,     0,  1578,  1579,  1580,  1581,  1582,  1583,  1584,  1585,
    1586,  1587,  1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,
    1596,  1597,  1598,  1599,  1600,  1601,  1602,  1603,  1604,  1605,
    1606,    18,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,
    1615,  1616,     0,  1617,  1618,  1619,  1620,  1621,     0,     0,
      21,  1622,  1623,  1624,  1625,  1626,  1627,  1628,  1629,  1630,
    1631,  1632,  1633,     0,  1634,  1635,     0,  1636,  1637,  1638,
    1639,  1640,  1641,  1642,  1643,  1644,  1645,  1646,  1647,  1648,
    1649,  1650,  1651,  1652,  1653,  1654,  1655,  1656,  1657,  1658,
    1659,  1660,  1661,  1662,  1663,  1664,  1665,  1666,  1667,  1668,
    1669,  1670,  1671,  1672,  1673,  1674,  1675,  1676,  1677,  1678,
      28,  1679,  1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,
    1688,  1689,    30,  1690,  1691,  1692,  1693,     0,  1694,  1695,
    1696,  1697,  1698,    33,  1699,  1700,  1701,  1702,  1703,  1704,
    1705,  1706,  1707,  1708,  1709,  1710,  1711,  1712,  1713,  1714,
    1715,  1716,  1717,  1718,  1719,  1720,  1721,  1722,  1723,  1724,
    1725,  1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,
    1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,
    1745,  1746,  1747,  1748,  1749,  1750,  1751,  1752,  1753,  1754,
    1755,  1756,  1757,  1758,  1759,  1760,     0,  1761,  1762,  1763,
    1764,  1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,
    1774,  1775,  1776,     0,  1777,  1778,  1779,  1780,  1781,  1782,
    1783,  1784,  1785,  1786,  1787,  1788,  1789,  1790,  1791,  1792,
    1793,  1794,  1795,  1796,  1797,  1798,    52,    53,    54,     0,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
    1799,    85,  1800,  1801,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,     0,  1802,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,  1803,   135,  1804,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,  1805,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,  1806,   587,   588,   181,     0,   182,   183,
     184,     0,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,  1807,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,     0,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,  1808,  1809,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,     0,  1810,  1811,   295,  1812,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,     0,  1813,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,  5957,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,     0,   377,
     378,   379,   380,   603,     0,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,  1815,   426,
     427,  1816,   429,   430,  1817,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,     0,  1818,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,  1819,
     467,   468,   469,   470,     0,   471,   609,   473,  1820,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1538,  1539,  1540,  1541,  1542,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,  1551,  1552,
    1553,  1554,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,
    1563,  1564,  1565,  1566,     0,  1567,  1568,  1569,  1570,  1571,
    1572,  1573,  1574,  1575,  1576,  1577,     0,  1578,  1579,  1580,
    1581,  1582,  1583,  1584,  1585,  1586,  1587,  1588,  1589,  1590,
    1591,  1592,  1593,  1594,  1595,  1596,  1597,  1598,  1599,  1600,
    1601,  1602,  1603,  1604,  1605,  1606,    18,  1607,  1608,  1609,
    1610,  1611,  1612,  1613,  1614,  1615,  1616,     0,  1617,  1618,
    1619,  1620,  1621,     0,     0,    21,  1622,  1623,  1624,  1625,
    1626,  1627,  1628,  1629,  4083,  1631,  1632,  1633,     0,  1634,
    1635,     0,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  1648,  1649,  1650,  1651,  1652,  1653,
    1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,  1663,
    1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1674,  1675,  1676,  1677,  1678,    28,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,  1688,  1689,    30,  1690,  1691,
    1692,  1693,     0,  1694,  1695,  1696,  1697,  1698,    33,  1699,
    1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,
    1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,
    1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,
    1760,     0,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,     0,  1777,
    1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,
    1788,  1789,  1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,
    1798,    52,    53,    54,     0,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,  1799,    85,  1800,  1801,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,     0,  1802,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,  1803,
     135,  1804,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,  1805,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,  1806,   587,
     588,   181,     0,   182,   183,   184,     0,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,  1807,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,     0,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
    1808,  1809,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,     0,  1810,  1811,   295,
    1812,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,     0,  1813,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,     0,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,     0,   377,   378,   379,   380,   603,     0,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,  1815,   426,   427,  1816,   429,   430,  1817,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,     0,  1818,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,     0,   467,   468,   469,   470,     0,
     471,   609,   473,  1820,     4,     5,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   922,   923,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   924,     0,     0,     0,   925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   926,     0,     0,     0,
       0,     0,     0,     0,     0,   927,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   928,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
     929,     0,     0,     0,     0,   930,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   931,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   932,     0,     0,
       0,   933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     934,     0,     0,     0,   935,   936,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   937,     0,     0,     0,
       0,     0,     0,     0,   938,   939,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   940,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   941,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   942,   163,   164,   165,   166,   943,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     944,   945,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   946,   324,   325,   326,   947,
     328,   329,   330,   331,   332,   948,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   949,   345,   346,   599,
     348,   349,   950,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   951,   382,   383,   384,   952,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   953,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1215,   923,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     924,     0,     0,     0,   925,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   926,     0,     0,     0,     0,     0,     0,     0,     0,
     927,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   928,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,   929,     0,     0,     0,     0,
     930,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   932,     0,     0,     0,   933,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   934,     0,     0,     0,   935,
     936,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   937,     0,     0,     0,     0,     0,     0,     0,   938,
     939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,  1216,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   940,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   941,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   942,
     163,   164,   165,   166,   943,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   944,   945,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     946,   324,   325,   326,  1217,   328,   329,   330,   331,   332,
     948,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   949,   345,   346,   599,   348,   349,   950,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   951,   382,
     383,   384,   952,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   953,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,  2759,
    2760,  4491,     0,  4492,     0,  4493,   723,  4494,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5571,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,  2759,  2760,  4491,     0,  4492,     0,
    4493,   723,  4494,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  6337,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,  2759,
    2760,  4491,     0,  4492,     0,  4493,   723,  4494,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  6391,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   925,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,  1372,     0,     0,  1373,  1374,     0,     0,
       0,  1375,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2198,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2248,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   925,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3383,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2198,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,     0,     0,     0,     0,
       0,     0,     0,   688,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   865,   866,     0,     0,     0,     0,     0,     0,     0,
       0,   867,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   868,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,     0,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,     0,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,     0,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,   869,   870,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   185,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   871,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,     0,     0,    21,  1952,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,  1953,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   688,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,  1981,
    1982,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1983,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,  1981,  1982,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2208,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,  1981,
    1982,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3034,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
    3035,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3046,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,  1981,  1982,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3034,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,  4834,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5649,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5659,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
    6017,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     730,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   811,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,  1981,  1982,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,  2362,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3051,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3729,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,  3730,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,  3731,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,  3732,   186,   187,   188,
     590,     0,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,     0,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
    3733,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,     0,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,  3734,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,   573,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,  3841,   179,   587,   588,   181,     0,   182,   183,
     184,   589,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,  3842,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   608,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  5971,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,   573,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,   589,   186,   187,   188,
     590,   190,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   608,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,  3489,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,  3490,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,   575,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,   585,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,  3491,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,     0,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,  3730,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,  3731,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,   575,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,   578,    95,   579,    97,
      98,    99,   100,   101,   580,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,   581,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   582,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,   584,   150,   151,   152,   153,
     585,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
     588,   181,     0,   182,   183,   184,  3732,   186,   187,   188,
     590,     0,   191,   591,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   594,   219,   220,   221,   222,   223,   224,   225,     0,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   595,   288,   289,   290,   291,   292,   293,   294,   295,
    3733,   296,   297,   298,   299,   596,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   597,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   599,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   601,   362,
     363,   364,   365,   366,   367,   368,   602,   370,   371,   372,
     373,   374,   375,   376,     0,   378,   379,   380,   603,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   606,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,  3734,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   867,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,   868,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,    53,    54,     0,
      55,    56,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   574,     0,     0,   576,
      84,    85,    86,    87,    88,    89,   577,    91,    92,    93,
      94,   578,    95,   579,    97,    98,    99,   100,   101,   580,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   581,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   582,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   583,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
     584,   150,   151,   152,   153,     0,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   586,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   587,   588,   181,     0,   182,   183,
     184,   185,   186,   187,   188,   590,   190,   191,   591,   193,
     194,   592,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   593,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   594,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   595,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     596,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   597,   317,
     598,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   599,
     348,   349,   350,   600,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   601,   362,   363,   364,   365,   366,   367,
     368,   602,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   603,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,     0,
     397,   398,   399,   400,   604,   402,   403,   605,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     606,   438,   439,   440,   441,   442,   443,   444,   445,   446,
     607,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   871,
     467,   468,   469,   470,     0,   471,   609,   473,   474,     4,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,    53,    54,     0,    55,    56,    57,    58,    59,
       0,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,   574,     0,     0,   576,    84,    85,    86,    87,    88,
      89,   577,    91,    92,    93,    94,     0,    95,   579,    97,
      98,    99,   100,   101,     0,   102,   103,   104,   105,   106,
     107,   108,   109,   110,     0,   111,   112,   113,     0,   115,
     116,   117,   118,   119,   120,   121,   122,   123,     0,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   583,   139,   140,   141,     0,   142,   143,
     144,   145,   146,   147,   148,     0,   150,   151,   152,   153,
       0,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   586,   168,     0,     0,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   587,
       0,   181,     0,   182,   183,   184,   185,   186,   187,   188,
     590,   190,   191,     0,   193,   194,   592,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   593,   210,   211,   212,   213,   214,   215,   216,   217,
     218,     0,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,     0,   288,   289,   290,   291,   292,   293,   294,   295,
       0,   296,   297,   298,   299,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   598,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,   348,   349,   350,   600,   352,
     353,   354,   355,   356,   357,   358,   359,   360,     0,   362,
     363,   364,   365,   366,   367,   368,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,     0,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,     0,   397,   398,   399,   400,   604,
     402,   403,   605,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,     0,   438,   439,   440,   441,
     442,   443,   444,   445,   446,   607,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,     0,
     471,   609,   473,   474,     4,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,     0,     0,     0,     0,  1938,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1949,
       0,     0,     0,     0,     0,     0,    52,    53,    54,  1939,
      55,     0,    57,    58,    59,     0,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,     0,    72,    73,
      74,    75,    76,    77,    78,    79,     0,     0,     0,     0,
      84,    85,    86,    87,    88,     0,     0,    91,    92,    93,
      94,     0,     0,     0,    97,    98,    99,   100,   101,     0,
     102,   103,   104,   105,     0,     0,     0,     0,     0,     0,
     111,     0,   113,     0,   115,   116,  1940,   118,   119,   120,
     121,   122,   123,     0,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,     0,   139,
     140,   141,     0,   142,   143,   144,   145,   146,   147,   148,
       0,   150,   151,   152,   153,     0,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,     0,     0,     0,
     168,     0,     0,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,     0,     0,     0,     0,     0,   183,
     184,  1941,   186,   187,   188,     0,   190,   191,     0,   193,
     194,     0,     0,   196,     0,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,     0,   210,   211,   212,
     213,   214,   215,   216,   217,   218,     0,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,     0,   288,   289,   290,
     291,   292,   293,   294,   295,     0,   296,   297,   298,   299,
       0,     0,     0,   302,     0,   304,   305,     0,   307,   308,
     309,   310,     0,   312,   313,   314,   315,     0,     0,     0,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,     0,   346,     0,
     348,   349,   350,     0,   352,   353,     0,   355,   356,   357,
     358,   359,   360,     0,   362,   363,   364,   365,   366,   367,
     368,     0,   370,   371,   372,     0,   374,   375,   376,   377,
       0,   379,   380,     4,     5,   383,   384,     0,     0,   387,
     388,   389,     0,   391,     0,   393,   394,   395,   396,     0,
     397,   398,   399,   400,     0,   402,   403,     0,   405,     0,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   428,   429,   430,   431,   432,   433,   434,   435,   436,
       0,   438,   439,   440,     0,   442,   443,   444,   445,     0,
       0,   448,   449,     0,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,     0,
       0,   468,   469,     0,     0,   471,     0,   473,   474,     0,
      18,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    21,
       0,     0,     0,     0,     0,     0,     0,     0,  1938,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    28,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    30,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    33,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1959,     0,
       0,     0,     0,     0,     0,    52,    53,    54,  1939,    55,
       0,    57,    58,    59,     0,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,     0,    72,    73,    74,
      75,    76,    77,    78,    79,     0,     0,     0,     0,    84,
      85,    86,    87,    88,     0,     0,    91,    92,    93,    94,
       0,     0,     0,    97,    98,    99,   100,   101,     0,   102,
     103,   104,   105,     0,     0,     0,     0,     0,     0,   111,
       0,   113,     0,   115,   116,  1940,   118,   119,   120,   121,
     122,   123,     0,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,     0,   139,   140,
     141,     0,   142,   143,   144,   145,   146,   147,   148,     0,
     150,   151,   152,   153,     0,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,     0,     0,     0,   168,
       0,     0,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,     0,     0,     0,     0,     0,   183,   184,
    1941,   186,   187,   188,     0,   190,   191,     0,   193,   194,
       0,     0,   196,     0,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,     0,   210,   211,   212,   213,
     214,   215,   216,   217,   218,     0,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,     0,   288,   289,   290,   291,
     292,   293,   294,   295,     0,   296,   297,   298,   299,     0,
       0,     0,   302,     0,   304,   305,     0,   307,   308,   309,
     310,     0,   312,   313,   314,   315,     0,     0,     0,     0,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,     0,   346,     0,   348,
     349,   350,     0,   352,   353,     0,   355,   356,   357,   358,
     359,   360,     0,   362,   363,   364,   365,   366,   367,   368,
       0,   370,   371,   372,     0,   374,   375,   376,   377,     0,
     379,   380,     4,     5,   383,   384,     0,     0,   387,   388,
     389,     0,   391,     0,   393,   394,   395,   396,     0,   397,
     398,   399,   400,     0,   402,   403,     0,   405,     0,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     428,   429,   430,   431,   432,   433,   434,   435,   436,     0,
     438,   439,   440,     0,   442,   443,   444,   445,     0,     0,
     448,   449,     0,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,     0,     0,
     468,   469,     0,     0,   471,     0,   473,   474,     0,    18,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,     0,
       0,     0,     0,     0,     0,     0,     0,  1938,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    28,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    33,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,