/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DiagnosabilityMXBean;
import oracle.jdbc.driver.OracleLog;

public class OracleDiagnosabilityMBean
extends StandardMBean
implements DiagnosabilityMXBean {
    OracleDiagnosabilityMBean() {
        super(DiagnosabilityMXBean.class, true);
    }

    @Override
    public boolean getLoggingEnabled() {
        return OracleLog.isEnabled();
    }

    @Override
    public void setLoggingEnabled(boolean bl) {
        OracleLog.setTrace(bl);
    }

    @Override
    public boolean stateManageable() {
        return false;
    }

    @Override
    public boolean statisticsProvider() {
        return false;
    }

    @Override
    protected String getDescription(MBeanInfo mBeanInfo) {
        return DatabaseError.findMessage("DiagnosabilityMBeanDescription", (Object)this);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return DatabaseError.findMessage("DiagnosabilityMBeanConstructor()", (Object)this);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = mBeanAttributeInfo.getName();
        if (string.equals("LoggingEnabled")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanLoggingEnabledDescription", (Object)this);
        }
        if (string.equals("stateManageable")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStateManageableDescription", (Object)this);
        }
        if (string.equals("statisticsProvider")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStatisticsProviderDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Got a request to describe an unexpected  Attribute: " + string);
        return super.getDescription(mBeanAttributeInfo);
    }
}

