/*
   Copyright (c) 2013, 2023, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */


#ifndef TABLE_REPLICATION_CONFIGURATION_H
#define TABLE_REPLICATION_CONFIGURATION_H

/**
  @file storage/perfschema/table_replication_connection_configuration.h
  Table replication_connection_configuration (declarations).
*/

#include "pfs_column_types.h"
#include "pfs_engine_table.h"
#include "rpl_mi.h"
#include "mysql_com.h"
#include "my_thread.h"

class Master_info;

/**
  @addtogroup Performance_schema_tables
  @{
*/

#ifndef ENUM_RPL_YES_NO
#define ENUM_RPL_YES_NO
enum enum_rpl_yes_no {
  PS_RPL_YES= 1,
  PS_RPL_NO
};
#endif

/** enum values for SSL_Allowed*/
enum enum_ssl_allowed {
    PS_SSL_ALLOWED_YES= 1,
    PS_SSL_ALLOWED_NO,
    PS_SSL_ALLOWED_IGNORED
};
enum enum_using_gtid {
    PS_USE_GTID_NO= 1,
    PS_USE_GTID_CURRENT_POS,
    PS_USE_GTID_SLAVE_POS
};


/**
  A row in the table. The fields with string values have an additional
  length field denoted by <field_name>_length.
*/
struct st_row_connect_config {
  char channel_name[CHANNEL_NAME_LENGTH];
  uint channel_name_length;
  char host[HOSTNAME_LENGTH];
  uint host_length;
  uint port;
  char user[USERNAME_LENGTH];
  uint user_length;
  enum_using_gtid using_gtid;
  enum_ssl_allowed ssl_allowed;
  char ssl_ca_file[FN_REFLEN];
  uint ssl_ca_file_length;
  char ssl_ca_path[FN_REFLEN];
  uint ssl_ca_path_length;
  char ssl_certificate[FN_REFLEN];
  uint ssl_certificate_length;
  char ssl_cipher[FN_REFLEN];
  uint ssl_cipher_length;
  char ssl_key[FN_REFLEN];
  uint ssl_key_length;
  enum_rpl_yes_no ssl_verify_server_certificate;
  char ssl_crl_file[FN_REFLEN];
  uint ssl_crl_file_length;
  char ssl_crl_path[FN_REFLEN];
  uint ssl_crl_path_length;
  uint connection_retry_interval;
  ulonglong connection_retry_count;
  double heartbeat_interval;
  char *ignore_server_ids;
  uint ignore_server_ids_length;
  char *do_domain_ids_str;
  uint do_domain_ids_str_length;
  char *ignore_domain_ids_str;
  uint ignore_domain_ids_str_length;
  void cleanup()
  {
    if (ignore_server_ids != NULL)
    {
      my_free(ignore_server_ids);
      ignore_server_ids= NULL;
    }
    if (do_domain_ids_str != NULL)
    {
      my_free(do_domain_ids_str);
      do_domain_ids_str= NULL;
    }
    if (ignore_domain_ids_str != NULL)
    {
      my_free(ignore_domain_ids_str);
      ignore_domain_ids_str= NULL;
    }
  }

};

/** Table PERFORMANCE_SCHEMA.TABLE_REPLICATION_CONNECTION_CONFIGURATION. */
class table_replication_connection_configuration: public PFS_engine_table
{
  typedef PFS_simple_index pos_t;

private:
  void make_row(Master_info *);

  /** Table share lock. */
  static THR_LOCK m_table_lock;
  /** Fields definition. */
  static TABLE_FIELD_DEF m_field_def;
  /** True if the current row exists. */
  bool m_row_exists;
  /** Current row */
  st_row_connect_config m_row;
  /** Current position. */
  pos_t m_pos;
  /** Next position. */
  pos_t m_next_pos;

protected:
  /**
    Read the current row values.
    @param table            Table handle
    @param buf              row buffer
    @param fields           Table fields
    @param read_all         true if all columns are read.
  */

  int read_row_values(TABLE *table,
                      unsigned char *buf,
                      Field **fields,
                      bool read_all) override;

  table_replication_connection_configuration();

public:
  ~table_replication_connection_configuration();

  static PFS_engine_table_share_state m_share_state;
  /** Table share. */
  static PFS_engine_table_share m_share;
  static PFS_engine_table* create();
  static ha_rows get_row_count();
  int rnd_next() override;
  int rnd_pos(const void *pos) override;
  void reset_position(void) override;

};

/** @} */
#endif
