/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.io.ServerSession;
import com.mysql.cj.api.jdbc.ResultSetInternalMethods;
import com.mysql.cj.api.jdbc.RowData;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.jdbc.ResultSetImpl;
import com.mysql.cj.jdbc.ResultSetRow;
import com.mysql.cj.jdbc.ServerPreparedStatement;
import com.mysql.cj.jdbc.exceptions.OperationNotSupportedException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RowDataCursor
implements RowData {
    private static final int BEFORE_START_OF_ROWS = -1;
    private List<ResultSetRow> fetchedRows;
    private int currentPositionInEntireResult = -1;
    private int currentPositionInFetchedRows = -1;
    private ResultSetImpl owner;
    private boolean lastRowFetched = false;
    private Field[] metadata;
    private ServerSession serverSession;
    private MysqlaProtocol mysql;
    private long statementIdOnServer;
    private ServerPreparedStatement prepStmt;
    private boolean firstFetchCompleted = false;
    private boolean wasEmpty = false;

    public RowDataCursor(ServerSession serverSession, MysqlaProtocol ioChannel, ServerPreparedStatement creatingStatement, Field[] metadata) {
        this.serverSession = serverSession;
        this.currentPositionInEntireResult = -1;
        this.metadata = metadata;
        this.mysql = ioChannel;
        this.statementIdOnServer = creatingStatement.getServerStatementId();
        this.prepStmt = creatingStatement;
    }

    @Override
    public boolean isAfterLast() {
        return this.lastRowFetched && this.currentPositionInFetchedRows > this.fetchedRows.size();
    }

    @Override
    public ResultSetRow getAt(int index) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentPositionInEntireResult < 0;
    }

    @Override
    public void setCurrentRow(int rowNumber) throws SQLException {
        this.notSupported();
    }

    @Override
    public int getCurrentRowNumber() throws SQLException {
        return this.currentPositionInEntireResult + 1;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return this.isBeforeFirst() && this.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentPositionInEntireResult == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.lastRowFetched && this.currentPositionInFetchedRows == this.fetchedRows.size() - 1;
    }

    @Override
    public void addRow(ResultSetRow row) throws SQLException {
        this.notSupported();
    }

    @Override
    public void afterLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void close() throws SQLException {
        this.metadata = null;
        this.owner = null;
    }

    @Override
    public boolean hasNext() throws SQLException {
        int maxRows;
        if (this.fetchedRows != null && this.fetchedRows.size() == 0) {
            return false;
        }
        if (this.owner != null && this.owner.owningStatement != null && (maxRows = this.owner.owningStatement.maxRows) != -1 && this.currentPositionInEntireResult + 1 > maxRows) {
            return false;
        }
        if (this.currentPositionInEntireResult != -1) {
            if (this.currentPositionInFetchedRows < this.fetchedRows.size() - 1) {
                return true;
            }
            if (this.currentPositionInFetchedRows == this.fetchedRows.size() && this.lastRowFetched) {
                return false;
            }
            this.fetchMoreRows();
            return this.fetchedRows.size() > 0;
        }
        this.fetchMoreRows();
        return this.fetchedRows.size() > 0;
    }

    @Override
    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    @Override
    public ResultSetRow next() throws SQLException {
        if (this.fetchedRows == null && this.currentPositionInEntireResult != -1) {
            throw SQLError.createSQLException(Messages.getString("ResultSet.Operation_not_allowed_after_ResultSet_closed_144"), "S1000", this.mysql.getExceptionInterceptor());
        }
        if (!this.hasNext()) {
            return null;
        }
        ++this.currentPositionInEntireResult;
        ++this.currentPositionInFetchedRows;
        if (this.fetchedRows != null && this.fetchedRows.size() == 0) {
            return null;
        }
        if (this.fetchedRows == null || this.currentPositionInFetchedRows > this.fetchedRows.size() - 1) {
            this.fetchMoreRows();
            this.currentPositionInFetchedRows = 0;
        }
        ResultSetRow row = this.fetchedRows.get(this.currentPositionInFetchedRows);
        row.setMetadata(this.metadata);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchMoreRows() throws SQLException {
        if (this.lastRowFetched) {
            this.fetchedRows = new ArrayList<ResultSetRow>(0);
            return;
        }
        Object object = this.owner.connection.getConnectionMutex();
        synchronized (object) {
            int numRowsToFetch;
            boolean oldFirstFetchCompleted = this.firstFetchCompleted;
            if (!this.firstFetchCompleted) {
                this.firstFetchCompleted = true;
            }
            if ((numRowsToFetch = this.owner.getFetchSize()) == 0) {
                numRowsToFetch = this.prepStmt.getFetchSize();
            }
            if (numRowsToFetch == Integer.MIN_VALUE) {
                numRowsToFetch = 1;
            }
            this.fetchedRows = this.mysql.getResultsHandler().fetchRowsViaCursor(this.fetchedRows, this.statementIdOnServer, this.metadata, numRowsToFetch);
            this.currentPositionInFetchedRows = -1;
            if (this.serverSession.isLastRowSent()) {
                this.lastRowFetched = true;
                if (!oldFirstFetchCompleted && this.fetchedRows.size() == 0) {
                    this.wasEmpty = true;
                }
            }
        }
    }

    @Override
    public void removeRow(int ind) throws SQLException {
        this.notSupported();
    }

    @Override
    public int size() {
        return -1;
    }

    private void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void setOwner(ResultSetImpl rs) {
        this.owner = rs;
    }

    @Override
    public ResultSetInternalMethods getOwner() {
        return this.owner;
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    @Override
    public void setMetadata(Field[] metadata) {
        this.metadata = metadata;
    }
}

