/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test for SKGTableWithGraph component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtesttablewithgraph.h"
#include "skgtablewithgraph.h"
#include "skgtestmacro.h"

void SKGTESTTableWithGraph::Test()
{
    KLocalizedString::setApplicationDomain("skrooge");

    SKGTableWithGraph graph(nullptr);

    SKGStringListList data;

    data.append(QStringList() << QLatin1String("Category") << QLatin1String("2013-01") << QLatin1String("2013-02") << QLatin1String("2013-03") << QLatin1String("2013-04") << QLatin1String("2013-05") << QLatin1String("2013-06"));
    data.append(QStringList() << QLatin1String("Auto") << QLatin1String("-50") << QLatin1String("-40.5") << QLatin1String("-40") << QLatin1String("-60") << QLatin1String("-70") << QLatin1String("-100"));
    data.append(QStringList() << QLatin1String("Food") << QLatin1String("-510.0") << QLatin1String("-520") << QLatin1String("-530.55") << QLatin1String("") << QLatin1String("-535") << QLatin1String("-520"));
    data.append(QStringList() << QLatin1String("s1") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s2") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s3") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s4") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s5") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s6") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s7") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s8") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s9") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s10") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s11") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));
    data.append(QStringList() << QLatin1String("s12") << QLatin1String("1") << QLatin1String("2") << QLatin1String("3") << QLatin1String("") << QLatin1String("4") << QLatin1String("5"));

    SKGServices::SKGUnitInfo info1;
    info1.Symbol = 'P';
    info1.Name = 'P';
    info1.Date = QDate::currentDate();
    info1.NbDecimal = 2;
    info1.Value = 1;

    SKGServices::SKGUnitInfo info2;
    info2.Symbol = 'S';
    info2.Name = 'S';
    info2.Date = QDate::currentDate();
    info2.NbDecimal = 4;
    info2.Value = 0.5;
    graph.setData(data, info1, info2);

    graph.setBackgroundColor(Qt::black);
    QCOMPARE(graph.isGraphVisible(), true);
    QCOMPARE(graph.isTableVisible(), true);
    QCOMPARE(graph.isTextReportVisible(), false);
    QCOMPARE(graph.isGraphTypeSelectorVisible(), true);

    QCOMPARE(graph.switchLegendVisibility(), true);

    QCOMPARE(graph.switchLinearRegressionVisibility(), false);
    QCOMPARE(graph.switchLinearRegressionVisibility(), true);

    QCOMPARE(graph.switchLimitsVisibility(), false);
    QCOMPARE(graph.switchLimitsVisibility(), true);

    QCOMPARE(graph.swithOriginVisibility(), false);
    QCOMPARE(graph.swithOriginVisibility(), true);

    QCOMPARE(graph.getAdditionalDisplayMode(), SKGTableWithGraph::ALL);

    graph.setShadowVisible(true);
    QCOMPARE(graph.isShadowVisible(), true);

    graph.setShadowVisible(false);
    QCOMPARE(graph.isShadowVisible(), false);

    graph.setSelectable(true);
    QCOMPARE(graph.isSelectable(), true);

    graph.setSelectable(false);
    QCOMPARE(graph.isSelectable(), false);

    for (int i = 0; i < 9; ++i) {
        graph.setGraphType(static_cast<SKGTableWithGraph::GraphType>(i));
        QCOMPARE(graph.getGraphType(), static_cast<SKGTableWithGraph::GraphType>(i));
        QTest::qWait(1000);
        graph.graph()->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGGraphicsView_" + SKGServices::intToString(i) + ".png");
    }

    // Graph
    QTest::qWait(2000);

    graph.resetColors();
    SKGGraphicsView* g = graph.graph();
    g->onCopy();
    g->onSwitchToolBarVisibility();
    g->onSwitchToolBarVisibility();
    g->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGGraphicsView.svg");
    g->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGGraphicsView.pdf");
    g->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGGraphicsView.jpeg");
    g->setAntialiasing(false);
    g->setAntialiasing(true);

    SKGShow* show = graph.getShowWidget();
    show->setState(QLatin1String("text"));
    show->getMode();
    show->setDisplayTitle(true);
    QCOMPARE(show->getDisplayTitle(), true);
    show->setDisplayTitle(false);
    QCOMPARE(show->getDisplayTitle(), false);

    /*QCOMPARE(graph.isGraphVisible(), true);
    QCOMPARE(graph.isTableVisible(), true);
    QCOMPARE(graph.isTextReportVisible(), true);*/

    SKGWebView* t = graph.textReport();
    QTest::qWait(2000);
    t->onZoomIn();
    t->onZoomOriginal();
    t->onZoomOut();
    t->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGWebView.odt");
    t->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGWebView.pdf");
    t->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGWebView.html");
    t->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGWebView.htm");
    t->exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGWebView.png");

    graph.exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGTableWithGraph.csv");
    graph.exportInFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtesttablewithgraph/SKGTableWithGraph.txt");

    graph.getTable();
}

QTEST_MAIN(SKGTESTTableWithGraph)

