/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"


struct test {
    QString fileName;
    QString password;
    QMap<QString, double> expectedAccountAmount;
};

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test import MNY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_MNY"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportmny1/A B/money2002.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params[QLatin1String("install_sunriise")] = 'Y';
            imp1.setImportParameters(params);
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)

            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MNY.setName"), account.setName(QLatin1String("None Investment")), true)
            SKGTESTERROR(QLatin1String("MNY.load"), account.load(), true)
            SKGTEST(QLatin1String("MNY.getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("1.49"))
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_MNY"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportmny1/A B/money2002.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params[QLatin1String("install_sunriise")] = 'Y';
            imp1.setImportParameters(params);
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)

            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MNY.setName"), account.setName(QLatin1String("None Investment")), true)
            SKGTESTERROR(QLatin1String("MNY.load"), account.load(), true)
            SKGTEST(QLatin1String("MNY.getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("1.49"))
        }
    }

    {
        // Test import MNY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_MNY"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportmny1/notreadable.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params[QLatin1String("install_sunriise")] = 'Y';
            imp1.setImportParameters(params);
            SKGTEST(QLatin1String("imp1.importFile"), imp1.importFile().getReturnCode(), ERR_READACCESS)
        }
    }

    {
        // Test import MNY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_MNY"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportmny3/transfer_and_mode.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params[QLatin1String("install_sunriise")] = 'Y';
            imp1.setImportParameters(params);
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        bool test2 = false;
        SKGTESTERROR(QLatin1String("MNY.existObjects"), document1.existObjects(QLatin1String("operation"), QLatin1String("t_comment='Mode should be ''text''' AND t_mode='text'"), test2), true)
        SKGTEST(QLatin1String("MNY.existObjects-test"), static_cast<unsigned int>(test2), static_cast<unsigned int>(true))

        SKGTESTERROR(QLatin1String("MNY.existObjects"), document1.existObjects(QLatin1String("operation"), QLatin1String("t_comment='Number should be 123456' AND t_number='123456'"), test2), true)
        SKGTEST(QLatin1String("MNY.existObjects-test"), static_cast<unsigned int>(test2), static_cast<unsigned int>(true))

        SKGTESTERROR(QLatin1String("MNY.existObjects"), document1.existObjects(QLatin1String("operation"), QLatin1String("t_comment='True transfert' AND i_group_id<>0"), test2), true)
        SKGTEST(QLatin1String("MNY.existObjects-test"), static_cast<unsigned int>(test2), static_cast<unsigned int>(true))

        SKGTESTERROR(QLatin1String("MNY.existObjects"), document1.existObjects(QLatin1String("operation"), QLatin1String("t_comment='Not a transfert, just same date/amount' AND i_group_id=0"), test2), true)
        SKGTEST(QLatin1String("MNY.existObjects-test"), static_cast<unsigned int>(test2), static_cast<unsigned int>(true))
    }

    // End test
    SKGENDTEST()
}
