/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test import GSK
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_MMB"), err)
            SKGImportExportManager impmissing(&document1, QUrl::fromLocalFile(QLatin1String("missingfile.mmb")));
            SKGTESTERROR(QLatin1String("imp1.importFile"), impmissing.importFile(), false)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportmmb/test.mmb"));
            SKGTESTERROR(QLatin1String("MMB.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MMB.setName"), account.setName(QLatin1String("COURANT")), true)
            SKGTESTERROR(QLatin1String("MMB.load"), account.load(), true)
            SKGTEST(QLatin1String("GSB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-144.05"))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MMB.setName"), account.setName(QLatin1String("CPT2")), true)
            SKGTESTERROR(QLatin1String("MMB.load"), account.load(), true)
            SKGTEST(QLatin1String("GSB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("40"))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MMB.setName"), account.setName(QLatin1String("NOTFAVORITE")), true)
            SKGTESTERROR(QLatin1String("MMB.load"), account.load(), true)
            SKGTEST(QLatin1String("GSB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("150"))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MMB.setName"), account.setName(QLatin1String("LEP")), true)
            SKGTESTERROR(QLatin1String("MMB.load"), account.load(), true)
            SKGTEST(QLatin1String("GSB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("6000"))
        }
    }

    {
        // Test import GSK
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_MMB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportmmb/jd.mmb"));
            SKGTESTERROR(QLatin1String("MMB.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("MMB.setName"), account.setName(QLatin1String("credit")), true)
            SKGTESTERROR(QLatin1String("MMB.load"), account.load(), true)
            SKGTEST(QLatin1String("GSB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-974.04"))
        }
    }
    // End test
    SKGENDTEST()
}
