/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test for SKGObjectModel component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmodel.h"
#include "modeltest.h"
#include "skgobjectmodel.h"
#include "skgsortfilterproxymodel.h"
#include "skgtestmacro.h"
#include <utility>

void SKGTESTModel::Test()
{
    KLocalizedString::setApplicationDomain("skrooge");

    int wait = 1;

    // Initialize document
    SKGDocumentBank doc;
    QVERIFY2(!doc.load(SKGTest::getTestPath(QLatin1String("IN")) % "/advice.skg"), "Load document failed");
    \
    QStringList tables;
    doc.getDistinctValues(QLatin1String("sqlite_master"), QLatin1String("name"), QLatin1String("type='view' AND name LIKE 'v_%_display' OR "
                          "name IN ('v_rule', 'v_account', 'v_recurrentoperation', 'v_operation_display_all', 'v_unit', 'v_operation_displayname', 'v_node')"), tables);

    {
        SKGError err;
        SKGBEGINTRANSACTION(doc, QLatin1String("DELETE"), err)
        doc.executeSqliteOrder(QLatin1String("DELETE FROM operation WHERE d_date<'") + SKGServices::dateToSqlString(QDate::currentDate().addMonths(-2)) + '\'');
    }

    for (const auto& table : std::as_const(tables)) {
        SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "..:: " << table << " ::.." << Qt::endl;

        // Initilialization  model
        auto model = new SKGObjectModel(&doc,
                                        table,
                                        (table == QLatin1String("v_account_display") || table == QLatin1String("v_refund_display") ? QLatin1String("t_close='N'") : QLatin1String("")),
                                        nullptr,
                                        (table == QLatin1String("v_category_display") ? QLatin1String("rd_category_id") : QLatin1String("")));

        if (table == QLatin1String("v_rule")) {
            model->setGroupBy(QLatin1String("t_action_type"));
        }
        if (table == QLatin1String("v_account")) {
            model->setGroupBy(QLatin1String("t_close"));
        }
        if (table == QLatin1String("v_recurrentoperation")) {
            model->setGroupBy(QLatin1String("i_nb_times"));
        }
        if (table == QLatin1String("v_operation_display_all")) {
            model->setGroupBy(QLatin1String("t_status"));
        }
        if (table == QLatin1String("v_operation")) {
            model->setGroupBy(QLatin1String("d_date"));
        }
        if (table == QLatin1String("v_unit")) {
            model->setGroupBy(QLatin1String("t_TYPENLS"));
        }
        if (table == QLatin1String("v_operation_displayname")) {
            model->setGroupBy(QLatin1String("p_myproperty"));
        }
        model->getGroupBy();
        model->refresh();
        model->supportedDragActions();
        QTest::qWait(wait);

        int nbCols = model->columnCount();
        SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "     Nb rows=" << model->rowCount() << Qt::endl;
        SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "     Nb Cols=" << nbCols  << Qt::endl;
        for (int i = 0; i < nbCols; ++i) {
            SKGTRACE << "         " << model->getAttribute(i)  << Qt::endl;
        }

        // Set Data
        if (table == QLatin1String("v_account_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_close, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_close"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);
        }
        if (table == QLatin1String("v_refund_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_close, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_close"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);
        }
        if (table == QLatin1String("v_operation_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_status, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_status"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);
        }
        if (table == QLatin1String("v_recurrentoperation_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(i_warn_days, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("i_warn_days"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);

            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(i_auto_write_days, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("i_auto_write_days"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);

            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(i_nb_times, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("i_nb_times"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);
        }
        if (table == QLatin1String("v_budgetrule_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(i_year, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("i_year"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);

            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(i_month, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("i_month"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);

            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_CATEGORYCONDITION, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_CATEGORYCONDITION"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);

            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_CATEGORY, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_CATEGORY"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);
        }
        if (table == QLatin1String("v_budget_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_CATEGORY, Checked)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_CATEGORY"))), QVariant(static_cast<unsigned int>(Qt::Checked)), Qt::CheckStateRole);
        }
        if (table == QLatin1String("node")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_name, new name)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_name"))), QVariant("new name"), Qt::EditRole);
        }
        if (table == QLatin1String("v_unit_display")) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             setData(t_name, new name)" << Qt::endl;
            model->setData(model->index(1, model->getIndexAttribute(QLatin1String("t_name"))), QVariant("new name"), Qt::EditRole);
        }

        if ((table == QLatin1String("v_node") || table.endsWith(QLatin1String("_display"))) && (model->supportedDragActions()&Qt::MoveAction) != 0u && (model->supportedDropActions()&Qt::MoveAction) != 0u) {
            SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             Drag & Drop" << Qt::endl;
            model->mimeTypes();
            QMimeData* md = model->mimeData(QModelIndexList() << model->index(0, 0));
            QCOMPARE(model->dropMimeData(md, Qt::MoveAction, 1, 0, model->index(1, 0)), true);
        }

        // test
        SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             new ModelTest" << Qt::endl;
        auto modeltest = new ModelTest(model);
        QTest::qWait(wait);

        delete modeltest;
        delete model;
        SKGTRACE << QDateTime::currentDateTime().toString(QLatin1String("yyyyMMdd-HHmmss-zzz")) << "             end" << Qt::endl;
    }
}

QTEST_MAIN(SKGTESTModel)

