/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    QDate d(1970, 1, 1);

    {
        // 275963
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGBankObject bank(&document1);
        SKGUnitObject unit_euro(&document1);
        SKGUnitObject unit_dollar(&document1);
        SKGError err;
        {
            SKGAccountObject account;

            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

            // Creation unit
            SKGTESTERROR("UNIT:setName", unit_euro.setName("euro"), true);
            SKGTESTERROR("UNIT:setSymbol", unit_euro.setSymbol("EUR"), true);
            SKGTESTERROR("UNIT:setType", unit_euro.setType(SKGUnitObject::PRIMARY), true);
            SKGTESTERROR("UNIT:save", unit_euro.save(), true);

            // Creation unitvalue
            SKGUnitValueObject unit_euro_val1;
            SKGTESTERROR("UNIT:addUnitValue", unit_euro.addUnitValue(unit_euro_val1), true);
            SKGTESTERROR("UNITVALUE:setQuantity", unit_euro_val1.setQuantity(1), true);
            SKGTESTERROR("UNITVALUE:setDate", unit_euro_val1.setDate(d), true);
            SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

            // Creation unit
            SKGTESTERROR("UNIT:setName", unit_dollar.setName("dollar"), true);
            SKGTESTERROR("UNIT:setSymbol", unit_dollar.setSymbol("USD"), true);
            SKGTESTERROR("UNIT:setType", unit_dollar.setType(SKGUnitObject::CURRENCY), true);
            SKGTESTERROR("UNIT:save", unit_dollar.save(), true);

            // Creation unitvalue
            SKGUnitValueObject unit_dollar_val1;
            SKGTESTERROR("UNIT:addUnitValue", unit_dollar.addUnitValue(unit_dollar_val1), true);
            SKGTESTERROR("UNITVALUE:setQuantity", unit_dollar_val1.setQuantity(2), true);
            SKGTESTERROR("UNITVALUE:setDate", unit_dollar_val1.setDate(d), true);
            SKGTESTERROR("UNITVALUE:save", unit_dollar_val1.save(), true);

            // Creation bank
            SKGTESTERROR("BANK:setName", bank.setName("CREDIT COOP"), true);
            SKGTESTERROR("BANK:setNumber", bank.setNumber("0003"), true);
            SKGTESTERROR("BANK:save", bank.save(), true);

            // Creation account
            SKGTESTERROR("BANK:addAccount", bank.addAccount(account), true);
            SKGTESTERROR("ACCOUNT:setName", account.setName("CODEVI"), true);
            SKGTESTERROR("ACCOUNT:save", account.save(), true);
            SKGTESTERROR("ACCOUNT:setInitialBalance", account.setInitialBalance(100, unit_dollar), true);
            SKGTESTERROR("ACCOUNT:save", account.save(), true);
        }


        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportqif2/t2.qif"));
            SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("QIF.setName", account.setName("CODEVI"), true);
            SKGTESTERROR("QIF.load", account.load(), true);
            SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-9335.94");
        }
    }

    {
        // 275963
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.load(SKGTest::getTestPath("IN") % "/skgtestimportqif2/export_qif.skg"), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_BP_QIF", err);
            SKGImportExportManager exp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("OUT") % "/skgtestimportqif2/export_qif.qif"));
            SKGTESTERROR("QIF.exportFile", exp1.exportFile(), true);
        }
    }

    {
        // Support qif file having Type:Class with description
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportqif2/MoneydanceExportExample.qif"));
            SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
        }
    }

    {
        // Defaut account
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportqif2/LA-1234567@ing.qif"));
            SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
        }

        {
            SKGBEGINTRANSACTION(document1, "MODIF", err);
            SKGObjectBase::SKGListSKGObjectBase result;
            SKGTESTERROR("DOC.getObjects", document1.getObjects("bank", "t_name='ing'", result), true);
            SKGTEST("DOC.getObjects.count", result.count(), 1);

            SKGBankObject bank(result.at(0));
            SKGTESTERROR("BANK.setName", bank.setName("ING Direct"), true);
            SKGTESTERROR("BANK.save", bank.save(), true);

            SKGTESTERROR("DOC.getObjects", document1.getObjects("account", "t_number='1234567'", result), true);
            SKGTEST("DOC.getObjects.count", result.count(), 1);

            SKGTESTERROR("DOC.getObjects", document1.getObjects("account", "t_name='LA'", result), true);
            SKGTEST("DOC.getObjects.count", result.count(), 1);

            SKGAccountObject acc(result.at(0));
            SKGTESTERROR("ACC.setName", acc.setName("Livret A"), true);
            SKGTESTERROR("ACC.save", acc.save(), true);
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportqif2/LA-1234567@ing.qif"));
            SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
        }

        document1.dump(DUMPACCOUNT);
        {
            SKGObjectBase::SKGListSKGObjectBase result;
            SKGTESTERROR("DOC.getObjects", document1.getObjects("account", "t_number='1234567'", result), true);
            SKGTEST("DOC.getObjects.count", result.count(), 1);
        }
    }

    {
        // Bug import date
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportqif2/date_money.qif"));
            SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
        }
    }

    {
        // Autorepair
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportqif2/autorepair.qif"));
            SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("QIF.setName", account.setName("autorepair"), true);
            SKGTESTERROR("QIF.load", account.load(), true);
            SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-400");
        }
    }

    // End test
    SKGENDTEST();
}
