% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rk.replace.function}
\alias{rk.replace.function}
\title{Replace a function inside its package environment / namespace}
\usage{
rk.replace.function(functionname, environment, replacement,
  copy.formals = TRUE)
}
\arguments{
\item{functionname}{name of the function to be replaced (character).}

\item{environment}{package environment or namespace, where replacment should
be done.}

\item{replacement}{the replacement. This should be a function.}

\item{copy.formals}{logical; whether to copy the \code{\link{formals}} from
the original function.}
}
\value{
Returns \code{NULL}, invisibly, unconditionally.
}
\description{
\code{rk.replace.function} can be used to replace a function inside a
different package / namespace. It is mainly intended for internal usage
inside rkward, e.g. to replace \code{menu} and \code{select.list} with
appropriate GUI implementations.
}
\details{
The original function is assigned to the environment
\code{rkward::.rk.backups} with the same name as the original, and can be
referred to from the replacement. WARNING: This mechanism does not support
several subsequent replacments of the same function, nor does it support
replacement of generics.

\bold{WARNING}: This function can be used to alter - and disrupt - internal
functions in arbitrary ways. You better know what you are doing.

\bold{WARNING}: Does not work well on generics!
}
\examples{
## Not run
rk.replace.function ("history", as.environment ("package:utils"),
  function () {
    cat ("This is what you typed:\\n")
    eval (body (.rk.backups$history))
  })
## End not run
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\seealso{
\code{\link{assignInNamespace}}, \code{\link{debug}}
}
\keyword{IO}
\keyword{utilities}

