// SPDX-FileCopyrightText: 2014 Antonis Tsiapaliokas <antonis.tsiapaliokas@kde.org>
// SPDX-FileCopyrightText: 2022 Devin Lin <devin@kde.org>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QAbstractListModel>
#include <QList>
#include <QObject>
#include <QQuickItem>
#include <QSet>

#include "foliodelegate.h"

/**
 * @short The base application list, used directly by the app drawer.
 */
class ApplicationListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        DelegateRole = Qt::UserRole + 1,
    };

    ApplicationListModel(QObject *parent = nullptr);
    ~ApplicationListModel() override;
    static ApplicationListModel *self();

    int rowCount(const QModelIndex &parent = QModelIndex()) const Q_DECL_OVERRIDE;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const Q_DECL_OVERRIDE;
    QHash<int, QByteArray> roleNames() const Q_DECL_OVERRIDE;

    Q_INVOKABLE void load();

public Q_SLOTS:
    void sycocaDbChanged();

Q_SIGNALS:
    void launchError(const QString &msg);

protected:
    QList<FolioDelegate *> m_delegates;
};
