/*
    Copyright 2015 Jan Grulich <jgrulich@redhat.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SSH_WIDGET_H
#define SSH_WIDGET_H

#include "settingwidget.h"

#include <NetworkManagerQt/VpnSetting>

class QComboBox;
class SshSettingWidgetPrivate;

class SshSettingWidget : public SettingWidget
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(SshSettingWidget)
public:
    explicit SshSettingWidget(const NetworkManager::VpnSetting::Ptr &setting, QWidget *parent = 0);
    ~SshSettingWidget();

    void loadConfig(const NetworkManager::Setting::Ptr &setting) Q_DECL_OVERRIDE;
    void loadSecrets(const NetworkManager::Setting::Ptr &setting) Q_DECL_OVERRIDE;

    virtual QVariantMap setting(bool agentOwned = false) const;
    virtual bool isValid() const;

private Q_SLOTS:
    void authTypeChanged(int index);
    void doAdvancedDialog();
    void passwordTypeChanged(int index);
    void setShowPassword(bool show);

private:
    SshSettingWidgetPrivate * const d_ptr;
    void fillOnePasswordCombo(QComboBox *, NetworkManager::Setting::SecretFlags);
    uint handleOnePasswordType(const QComboBox *, const QString &, NMStringMap &, bool agentOwned) const;
};

#endif // SSH_WIDGET_H
