// This file is generated by kconfig_compiler from ipv6.kcfg.
// All changes you do to this file will be lost.
#ifndef KNM_IPV6SETTING_H
#define KNM_IPV6SETTING_H

#include <QHostAddress>
#include <kglobal.h>
#include <kdebug.h>
#include <kcoreconfigskeleton.h>
#include "../solidcontrolfuture/networkipv6config.h"
#include "setting.h"
#include "knminternals_export.h"

namespace Knm {

class KNMINTERNALS_EXPORT Ipv6Setting : public Setting
{
  public:
    class EnumMethod
    {
      public:
      enum type { Automatic, LinkLocal, Manual, Shared, Ignore, Dhcp, COUNT };
    };
    class EnumPrivacy
    {
      public:
      enum type { Unknown = -1, Disabled, PreferPublic, PreferTemporary, COUNT };
    };

    Ipv6Setting( );
    Ipv6Setting(Ipv6Setting *);
    ~Ipv6Setting();

    QString name() const;

    bool hasSecrets() const;

    /**
      Set Method
    */
    void setMethod( int v )
    {
        mMethod = v;
    }

    /**
      Get Method
    */
    int method() const
    {
      return mMethod;
    }

    /**
      Set DNS Servers
    */
    void setDns( const QList<QHostAddress> & v )
    {
        mDns = v;
    }

    /**
      Get DNS Servers
    */
    QList<QHostAddress> dns() const
    {
      return mDns;
    }

    /**
      Set Search Domains
    */
    void setDnssearch( const QStringList & v )
    {
        mDnssearch = v;
    }

    /**
      Get Search Domains
    */
    QStringList dnssearch() const
    {
      return mDnssearch;
    }

    /**
      Set IP Addresses
    */
    void setAddresses( const QList<Solid::Control::IPv6Address> & v )
    {
        mAddresses = v;
    }

    /**
      Get IP Addresses
    */
    QList<Solid::Control::IPv6Address> addresses() const
    {
      return mAddresses;
    }

    /**
      Set Ignore DHCP DNS
    */
    void setIgnoredhcpdns( bool v )
    {
        mIgnoredhcpdns = v;
    }

    /**
      Get Ignore DHCP DNS
    */
    bool ignoredhcpdns() const
    {
      return mIgnoredhcpdns;
    }

    /**
      Set Ignore Automatic Routes
    */
    void setIgnoreautoroute( bool v )
    {
        mIgnoreautoroute = v;
    }

    /**
      Get Ignore Automatic Routes
    */
    bool ignoreautoroute() const
    {
      return mIgnoreautoroute;
    }

    /**
      Set Never Default Route
    */
    void setNeverdefault( bool v )
    {
        mNeverdefault = v;
    }

    /**
      Get Never Default Route
    */
    bool neverdefault() const
    {
      return mNeverdefault;
    }

    QList<Solid::Control::IPv6Route> routes() const
    {
        return mRoutes;
    }

    void setRoutes(QList<Solid::Control::IPv6Route> routes)
    {
        mRoutes = routes;
    }

    /**
      Set May Fail
    */
    void setMayfail( bool v )
    {
        mMayfail = v;
    }

    /**
      Get May Fail
    */
    bool mayfail() const
    {
      return mMayfail;
    }

    /**
      Set Privacy
    */
    void setPrivacy( EnumPrivacy::type i )
    {
        if (i >= EnumPrivacy::Unknown && i < EnumPrivacy::COUNT) {
            mPrivacy = i;
        } else {
            mPrivacy = EnumPrivacy::Unknown;
        }
    }

    /**
      Get Privacy
    */
    EnumPrivacy::type privacy() const
    {
      return mPrivacy;
    }


  protected:

    // ipv6
    int mMethod;
    QList<QHostAddress> mDns;
    QStringList mDnssearch;
    QList<Solid::Control::IPv6Address> mAddresses;
    QList<Solid::Control::IPv6Route> mRoutes;
    bool mIgnoredhcpdns;
    bool mIgnoreautoroute;
    bool mNeverdefault;
    bool mMayfail;
    EnumPrivacy::type mPrivacy;
  private:
};

}

#endif
