// SPDX-FileCopyrightText: Jonah Brüchert <jbb@kaidan.im>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "tools.h"

#include <QCoreApplication>
#include <QDir>
#include <QtDebug>

Q_LOGGING_CATEGORY(qtermwidgetLogger, "qtermwidget", QtWarningMsg)

/*! Helper function to get possible location of layout files.
By default the KB_LAYOUT_DIR is used (linux/BSD/macports).
But in some cases (apple bundle) there can be more locations).
*/
QString kbLayoutDir()
{
    return QStringLiteral(":/konsoleqml/kb-layouts/");
}

/*! Helper function to add custom location of color schemes.
 */
namespace
{
QStringList custom_color_schemes_dirs;
}
void add_custom_color_scheme_dir(const QString &custom_dir)
{
    if (!custom_color_schemes_dirs.contains(custom_dir))
        custom_color_schemes_dirs << custom_dir;
}

/*! Helper function to get possible locations of color schemes.
By default the COLORSCHEMES_DIR is used (linux/BSD/macports).
But in some cases (apple bundle) there can be more locations).
*/
const QStringList colorSchemesDirs()
{
    return {QStringLiteral(":/konsoleqml/color-schemes/")};
}
