/*
  SPDX-FileCopyrightText: 2022-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "translatorconfigurelanguagelistwidget_gui.h"
using namespace Qt::Literals::StringLiterals;

#include "translator/misc/translatorutil.h"
#include "translator/widgets/translatorconfigurelanguagelistwidget.h"

#include <QApplication>
#include <QCommandLineParser>
#include <QDebug>
#include <QDialogButtonBox>
#include <QStandardPaths>
#include <QVBoxLayout>

TranslatorConfigureLanguageListWidget_gui::TranslatorConfigureLanguageListWidget_gui(QWidget *parent)
    : QDialog(parent)
{
    auto mainLayout = new QVBoxLayout(this);

    auto w = new TextTranslator::TranslatorConfigureLanguageListWidget(u"from"_s, this);
    mainLayout->addWidget(w);

    auto buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    mainLayout->addWidget(buttonBox);
    connect(buttonBox, &QDialogButtonBox::accepted, this, [w]() {
        qDebug() << " select " << w->selectedLanguages();
    });
    connect(buttonBox, &QDialogButtonBox::accepted, this, &TranslatorConfigureLanguageListWidget_gui::accept);
    const QMap<TextTranslator::TranslatorUtil::Language, QString> languages; // = TextTranslator::TranslatorUtil::translatedLanguages();

    for (const auto &[key, value] : languages.asKeyValueRange()) {
        const QString languageCode = TextTranslator::TranslatorUtil::languageCode(key);
        w->addItem(value, languageCode);
    }
}

int main(int argc, char **argv)
{
    QApplication app(argc, argv);
    QStandardPaths::setTestModeEnabled(true);
    QCommandLineParser parser;
    parser.addVersionOption();
    parser.addHelpOption();
    parser.process(app);

    auto dialog = new TranslatorConfigureLanguageListWidget_gui;

    dialog->show();
    app.exec();
    delete dialog;
    return 0;
}

#include "moc_translatorconfigurelanguagelistwidget_gui.cpp"
