#ifndef PARSERDIALOG_H
#define PARSERDIALOG_H

#include <kdialogbase.h>

class KIntNumInput;
class KURLRequester;
class QLineEdit;
class QComboBox;
class QDateEdit;
class CupsParserView;
class QCheckBox;

class ParserDialog : public KDialogBase
{
	Q_OBJECT
public:
	ParserDialog( QWidget *parent = 0, const char *name = 0 );
	~ParserDialog();

	void setParser( CupsParserView* );
	void updateParser( CupsParserView* );

private:
	KIntNumInput *m_viewlimit;
	KURLRequester *m_filename;
	KIntNumInput *m_start;
	QComboBox *m_field;
	QLineEdit *m_match;
	QDateEdit *m_from, *m_to;
	KIntNumInput *m_interval;
	QCheckBox *m_startcheck, *m_datecheck, *m_fieldcheck, *m_restorecheck;
};

#endif /* PARSERDIALOG_H */
