#ifndef CUPSPARSER_H
#define CUPSPARSER_H

#include <qobject.h>
#include <qtextstream.h>
#include <qdatetime.h>
#include <qvariant.h>
#include <qvaluevector.h>
#include <qptrlist.h>
#include <qregexp.h>

class QTimer;
class QPopupMenu;
class QListViewItem;

class CupsParser : public QObject
{
	Q_OBJECT
public:
	CupsParser( const QString& name, const QString& filename, QObject *parent = 0 );
	~CupsParser();

	void setParseInterval( unsigned int msec );
	unsigned int parseInterval() const;
	void setFileName( const QString& );
	QString fileName() const;
	void setFilter( const QDateTime& from, const QDateTime& to = QDateTime() );
	void setFilter( int col, const QRegExp& match );
	void setStart( int = -1 );
	int start() const;
	QString parserName() const;
	int filterField() const;
	QString filterMatch() const;
	QDateTime filterFrom() const;
	QDateTime filterTo() const;

	virtual QStringList fields() = 0;
	virtual void setupRMB( QListViewItem*, QPopupMenu* );
	static QStringList parsers();

	struct Item
	{
		Item( int nfields ) : fields( nfields ) {}

		QDateTime date;
		QValueVector<QVariant> fields;
		QString fulldata;
		QString pixmap;

		void parseDate( const QString& );
	};
	typedef QPtrList<Item> ItemList;
	typedef QPtrListIterator<Item> ItemListIterator;

public slots:
	void startParsing( bool = false );
	void stopParsing();
	void resumeParsing();

protected slots:
	void slotCheck();

signals:
	void newItems( const CupsParser::ItemList& );
	void restarted();
	void error( const QString& );

protected:
	void parse( QTextStream& );
	virtual Item* lineToItem( const QString& ) = 0;
	bool filter( CupsParser::Item* );
	void initSeekPos( int = -1 );
	void restoreParser();
	void saveParser();

private:
	QString m_name;
	QString m_filename;
	unsigned int m_seekpos;
	unsigned int m_parseinterval;
	QDateTime m_lastcheck, m_filterfrom, m_filterto;
	int m_filterfield;
	QRegExp m_filtermatch;
	bool m_filterenabled;
	int m_start;
	QTimer *m_timer;
};

#endif /* CUPSPARSER_H */
