#ifndef _POPUPMENU_H_
#define _POPUPMENU_H_

#include <Python.h>
#include <qframe.h>
#include <qpopmenu.h>
#include "Baseobject.h"
#include <qintdict.h>
#include <qlist.h>
#include <qpixmap.h>


class PopupMenu : public QPopupMenu, BaseObject
{
    Q_OBJECT
public:

    PopupMenu(QWidget *parent=0, const char *name=0 );
   ~PopupMenu();

/*
signals:
    void	activated( int itemId );
    void	highlighted( int itemId );
*/

protected slots:

   void sigActivated(int id);
   void sigHighlighted(int id);


/* ---- QMenuData ---- */


public:
   
    int	_insertItem( const char *text,PyObject *slot,int accel=0 );
    int	_insertPixmap( const QPixmap &pixmap,PyObject *slot,int accel=0 );
    int	_insertItemPixmap( const QPixmap &pixmap,const char *text,PyObject *slot,int accel=0 );
 
    void _connectItem(int id, PyObject *slot);
    void _disconnectItem(int id, PyObject *slot);
    
private:

  QIntDict< QList<PyObject> > connections;

};



#endif