import libqtpythonc
from baseobject import *


class CursorPtr(BaseObjectPtr):

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QCursor(self.this)

    def shape(self):
        return libqtpythonc.QCursor_shape(self.this)

    def setShape(self,shape):
        return libqtpythonc.QCursor_setShape(self.this,shape)

    def bitmap(self):
        return BitmapPtr(libqtpythonc.QCursor_bitmap(self.this))

    def mask(self):
        return BitmapPtr(libqtpythonc.QCursor_mask(self.this))

    def hotSpot(self):
        return libqtpythonc.QCursor_hotSpot(self.this)

    def __repr__(self):
        return "<Cursor instance at %i>" % self.this

class Cursor(CursorPtr):
    def __init__(self,name=""):
        CursorPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QCursor()
        self.thisown = 1

def CursorShape(shape,name=""):
    val = CursorPtr(libqtpythonc.new_QCursorShape(shape),name)
    val.thisown = 1
    return val

def CursorBitmap(bitmap, mask, hotX=-1, hotY=-1, name="") :
    val = CursorPtr(libqtpythonc.new_QCursorBitmap(bitmap.this,mask.this,hotX,hotY),name)
    val.thisown = 1
    return val

def CursorCopy(cursor,name="") :
    val = CursorPtr(libqtpythonc.new_QCursorCopy(cursor.this),name)
    val.thisown = 1
    return val


ArrowCursor = libqtpythonc.ArrowCursor
UpArrowCursor = libqtpythonc.UpArrowCursor
CrossCursor = libqtpythonc.CrossCursor
WaitCursor = libqtpythonc.WaitCursor
IbeamCursor = libqtpythonc.IbeamCursor
SizeVerCursor = libqtpythonc.SizeVerCursor
SizeHorCursor = libqtpythonc.SizeHorCursor
SizeBDiagCursor = libqtpythonc.SizeBDiagCursor
SizeFDiagCursor = libqtpythonc.SizeFDiagCursor
SizeAllCursor = libqtpythonc.SizeAllCursor
BlankCursor = libqtpythonc.BlankCursor
LastCursor = libqtpythonc.LastCursor
BitmapCursor = libqtpythonc.BitmapCursor
