from object import *
from color import *
from paintdevice import *
from pixmap import *
import libqtpythonc


class BitmapPtr(PixmapPtr):
 
    def __init__(self,this,name=""):
        PixmapPtr.__init__(self,this,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QBitmap(self.this)

    def xForm(self,arg0):
        val = libqtpythonc.QBitmap_xForm(self.this,arg0)
        val = BitmapPtr(val)
        val.thisown = 1
        return val

    def __repr__(self):
        return "<Bitmap instance at %s>" % self.this

class Bitmap(BitmapPtr):

    def __init__(self,w,h,clear=0) :
        BitmapPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QBitmap(w,h,clear)
        self.thisown = 1



def BitmapFile(filename,format=0,name="") :
    val = BitmapPtr(libqtpythonc.new_QBitmapFile(filename,format),name)
    val.thisown = 1
    return val

def BitmapCopy(arg0,name="") :
    val = QBitmapPtr(libqtpythonc.new_QBitmapCopy(arg0.this),name)
    val.thisown = 1
    return val
