/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "klcombobox.h"

KLComboBox::KLComboBox() : QComboBox((QWidget *)0,0)
{
  setKLWidget(this); 
}

KLComboBox::KLComboBox(bool rw) : QComboBox(rw,(QWidget *)0,0)
{
  setKLWidget(this); 
}

bool KLComboBox::klAskMinMax(KLMinMaxSizes *minMaxSizes)
{
  if( !KLWidgetBase::klAskMinMax(minMaxSizes) )
    return false;
  QSize size = sizeHint();
  minMaxSizes->minX += size.height();
  minMaxSizes->minY += size.width();
  minMaxSizes->defX += size.height();
  minMaxSizes->defY += size.width();
  minMaxSizes->maxX += size.height();
  minMaxSizes->maxY += size.width() + KLMaxSize;
  return true;
}

#include "klcombobox.moc"

