/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLCHECKBOX_H
#define KLCHECKBOX_H

#include "klwidgetbase.h"
#include "qchkbox.h"

/**
* Checkbox object
*
* Note: It has initialy a weight of 1. 
*/
class KLCheckBox : public QCheckBox, public KLWidgetBase {
  Q_OBJECT
public:
  KLCheckBox(const char *text=0);
  void setText(const char *); 
  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);

  KLWDIGET_DELEGATES(KLCheckBox,QCheckBox);

  DECLARE_KLMETA_STANDALONE();
};

#endif 



