#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#**************************************************************************
#*   Copyright (C) 2017 by S. MANKOWSKI / G. DE BURE support@mankowski.fr
#*   Redistribution and use in source and binary forms, with or without
#*   modification, are permitted provided that the following conditions
#*   are met:
#*   
#*   1. Redistributions of source code must retain the above copyright
#*      notice, this list of conditions and the following disclaimer.
#*   2. Redistributions in binary form must reproduce the above copyright
#*      notice, this list of conditions and the following disclaimer in the
#*      documentation and/or other materials provided with the distribution.
#*   
#*   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
#*   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#*   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#*   IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
#*   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#*   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#*   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#*   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#*   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#*   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#**************************************************************************

import urllib.request
import json
import sys
import time

f = urllib.request.urlopen('https://api.coinmarketcap.com/v1/ticker/')
for item in json.loads(f.read().decode('utf-8')):
    if item["symbol"] != "BTC":
        print('        {')
        print('            // '+item["id"].upper())
        print('            SKGServices::SKGUnitInfo info;')
        print('            info.Name = i18nc("Noun, a cryptocurrency", "'+item["name"]+'");')
        print('            info.Symbol = QStringLiteral("'+item["symbol"]+'");')
        print('            info.Date = QDate(2009, 2, 4);')
        print('            info.Country = i18nc("Noun, the country of bitcoin", "Internet");')
        print('            info.Internet = QStringLiteral("'+item["symbol"]+'");')
        print('            info.Source = QStringLiteral("CoinMarketCap");')
        print('            info.Parent = QStringLiteral("USD");')
        print('            info.NbDecimal = 4;')
        print('            info.Value = -1;')
        print('            currencies.push_back(info);')
        print('        }')
