/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    {
        // Test import XHB
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_XHB", err);
            SKGImportExportManager impmissing(&document1, QUrl("missingfile.xhb"));
            SKGTESTERROR("imp1.importFile", impmissing.importFile(), false);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportxhb/test.xhb"));
            SKGTESTERROR("XHB.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("XHB.setName", account.setName("COURANT"), true);
            SKGTESTERROR("XHB.load", account.load(), true);
            SKGTEST("XHB:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "35");
        }

        // test multi import
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_XHB", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportxhb/test.xhb"));
            SKGTESTERROR("XHB.importFile", imp1.importFile(), true);
        }
    }

    {
        // Test import XHB
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_XHB", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportxhb/example_budget.xhb"));
            SKGTESTERROR("XHB.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("XHB.setName", account.setName("Cheque Account"), true);
            SKGTESTERROR("XHB.load", account.load(), true);
            SKGTEST("XHB:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "5758.22");
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("XHB.setName", account.setName("Savings Account"), true);
            SKGTESTERROR("XHB.load", account.load(), true);
            SKGTEST("XHB:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1024.66");
        }
    }

    {
        // Test import XHB
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_XHB", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportxhb/comptes.xhb"));
            SKGTESTERROR("XHB.importFile", imp1.importFile(), true);
        }

        {
            SKGStringListList result;
            SKGTESTERROR("XHB.executeSelectSqliteOrder", document1.executeSelectSqliteOrder("SELECT distinct t_type FROM account", result), true);
            SKGTEST("XHB:distinct t_type", result.count(), 6);
        }
    }


    {
        // Test import wallet
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_XHB", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportxhb/wallet.xhb"));
            SKGTESTERROR("XHB.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("XHB.setName", account.setName("Espece"), true);
            SKGTESTERROR("XHB.load", account.load(), true);
            SKGBankObject bank;
            SKGTESTERROR("XHB.load", account.getBank(bank), true);
            SKGTEST("XHB:getName", bank.getName(), "");
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("XHB.setName", account.setName("Courant"), true);
            SKGTESTERROR("XHB.load", account.load(), true);
            SKGBankObject bank;
            SKGTESTERROR("XHB.load", account.getBank(bank), true);
            SKGTEST("XHB:getName", bank.getName(), "HOMEBANK");
        }
    }

    {
        // Test import
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_XHB", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportxhb/error_import.xhb"));
            SKGTESTERROR("XHB.importFile", imp1.importFile(), true);
        }
    }
    // End test
    SKGENDTEST();
}
