/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    {
        // Test import AFB120
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_AFB120", err);

            SKGImportExportManager impmissing(&document1, QUrl("missingfile.cfo"));
            SKGTESTERROR("AFB120.importFile", impmissing.importFile(), false);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportafb120/gs_01139_021239S.cfo"));
            SKGTESTERROR("AFB120.importFile", imp1.importFile(), true);

            document1.dump(DUMPOPERATION | DUMPACCOUNT);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("AFB120.setName", account.setName("0000021239S"), true);
            SKGTESTERROR("AFB120.load", account.load(), true);
            SKGTEST("AFB120:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "2555.48");
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_AFB120", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportafb120/gs_01139_021239S.cfo"));
            SKGTESTERROR("AFB120.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("AFB120.setName", account.setName("0000021239S"), true);
            SKGTESTERROR("AFB120.load", account.load(), true);
            SKGTEST("AFB120:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "2555.48");
        }

        {
            QString f = SKGTest::getTestPath("OUT") % QString::fromUtf8("/anonymize.skg");
            QFile(f).remove();
            SKGTESTERROR("AFB120.saveAs", document1.saveAs(f), true);
            SKGImportExportManager imp1(&document1);
            SKGTESTERROR("AFB120:anonymize", imp1.anonymize(), true);
            SKGTEST("AFB120:getCurrentFileName", static_cast<unsigned int>(document1.getCurrentFileName() != f), static_cast<unsigned int>(true));
        }
    }
    // End test
    SKGENDTEST();
}
