/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A plugin to advice
 *
 * @author Stephane MANKOWSKI
 */
#include "skgadviceplugin.h"
#include "skgadviceboardwidget.h"
#include "skgtipofdayboardwidget.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>
#include <kaboutdata.h>
#include <kgenericfactory.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGAdvicePluginFactory, registerPlugin<SKGAdvicePlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGAdvicePluginFactory("skg_advice", "skg_advice"))

SKGAdvicePlugin::SKGAdvicePlugin(QWidget* /*iWidget*/, QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGAdvicePlugin::SKGAdvicePlugin");
}

SKGAdvicePlugin::~SKGAdvicePlugin()
{
    SKGTRACEIN(10, "SKGAdvicePlugin::~SKGAdvicePlugin");
    currentDocument = NULL;
}

bool SKGAdvicePlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGAdvicePlugin::setupActions");
    Q_UNUSED(iArgument);

    currentDocument = iDocument;

    setComponentData(KGlobal::mainComponent());
    setXMLFile("../skg_advice/skg_advice.rc");

    //Create yours actions here
    return true;
}

int SKGAdvicePlugin::getNbDashboardWidgets()
{
    SKGTRACEIN(1, "SKGAdvicePlugin::getNbDashboardWidgets");
    return 2;
}

QString SKGAdvicePlugin::getDashboardWidgetTitle(int iIndex)
{
    SKGTRACEIN(1, "SKGAdvicePlugin::getDashboardWidgetTitle");
    if (iIndex == 0) return i18nc("Noun, a list of items", "Advice");
    else if (iIndex == 1) return i18nc("Noun, a list of items", "Tip of the day");
    return "";
}

SKGBoardWidget* SKGAdvicePlugin::getDashboardWidget(int iIndex)
{
    if (iIndex == 0) return new SKGAdviceBoardWidget(currentDocument);
    else if (iIndex == 1) return new SKGTipOfDayBoardWidget(currentDocument);
    return NULL;
}


QString SKGAdvicePlugin::title() const
{
    return i18nc("The title", "Advice");
}

QString SKGAdvicePlugin::icon() const
{
    return "help-hint";
}

QString SKGAdvicePlugin::toolTip() const
{
    return i18nc("The tool tip", "Advice");
}


int SKGAdvicePlugin::getOrder() const
{
    return 1;
}

QStringList SKGAdvicePlugin::tips() const
{
    QStringList output;
    return output;
}

#include "skgadviceplugin.moc"
