# QJson
JSON (JavaScript Object Notation) is a lightweight data-interchange format.
It can represents integer, real number, string, an ordered sequence of value, and a collection of name/value pairs.

QJson is a qt-based library that maps JSON data to QVariant objects.
JSON arrays will be mapped to QVariantList instances, while JSON's objects will be mapped to QVariantMap.

# Install

QJson requires:
  - Qt 4.0 or greater
  - cmake 2.6 or greater

Some possible cmake options:
  - `-DCMAKE_BUILD_TYPE=DEBUG`: enables some debug output (other than making
     easier to debug the code)
  - `-DQJSON_BUILD_TESTS=yes` or `-DKDE4_BUILD_TESTS=yes`: builds the unit tests
  - `-DCMAKE_INSTALL_PREFIX=${HOME}/testinstall`: install qjson in a custom directory
  - `-DCMAKE_INCLUDE_PATH=${HOME}/testinstall/include`: include a custom include directory
  - `-DCMAKE_LIBRARY_PATH=${HOME}/testinstall/lib`: include a custom library directory
  - `-DLIB_DESTINATION=lib64`: if you have a 64 bit system with separate
     libraries for 64 bit libraries
  - `-DQJSON_VERBOSE_DEBUG_OUTPUT:BOOL=ON`: more debugging statements are
     generated by the parser. It's useful only if you are trying to fix
     the bison grammar.

For Unix/Linux/Mac:

    mkdir build
    cd build
    cmake -DCMAKE_INSTALL_PREFIX=_preferred_path_ ..
    make
    make install
    /sbin/ldconfig #if necessary

# License
  This library is licensed under the Lesser GNU General Public License version 2.1.
  See the COPYING.lib file for more information.

# Resources

* [Website](http://qjson.sourceforge.net/)
* [Mailing List](https://lists.sourceforge.net/mailman/listinfo/qjson-devel)
* Project Lead/Maintainer (2008-current): [Flavio Castelli](mailto:flavio@castelli.name).
