% File src/library/stats/man/acf2AR.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Team
% Distributed under GPL 2 or later

\name{acf2AR}
\alias{acf2AR}
\title{Compute an AR Process Exactly Fitting an ACF}
\description{
  Compute an AR process exactly fitting an autocorrelation function.
}
\usage{
acf2AR(acf)
}
\arguments{
  \item{acf}{An autocorrelation or autocovariance sequence.}
}
\value{
  A matrix, with one row for the computed AR(p) coefficients for
  \code{1 <= p <= length(acf)}.
}
\seealso{
  \code{\link{ARMAacf}}, \code{\link{ar.yw}} which does this from an
  empirical ACF.
}
\examples{
(Acf <- ARMAacf(c(0.6, 0.3, -0.2)))
acf2AR(Acf)
}
\keyword{ts}
