/*
    kopetelistviewsearchline.h - a widget for performing quick searches of Kopete::ListViews

    Copyright (c) 2004      by Richard Smith <kde@metafoo.co.uk>

    Kopete    (c) 2004      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETELISTVIEWSEARCHLINE_H
#define KOPETELISTVIEWSEARCHLINE_H

#include <ktreewidgetsearchline.h>
#include <libkopete_export.h>

namespace Kopete {
namespace UI {
namespace ListView {
class ListView;

class LIBKOPETE_EXPORT SearchLine : public KTreeWidgetSearchLine
{
    Q_OBJECT
public:
    /**
     * Constructs a SearchLine with \a listView being the
     * ListView to be filtered.
     *
     * If \a listView is null then the widget will be disabled until a listview
     * is set with setListView().
     */
    explicit SearchLine(QWidget *parent = nullptr, ListView *listView = 0);
    /**
     * Destroys the SearchLine.
     */
    ~SearchLine();

    void updateSearch(const QString &s) Q_DECL_OVERRIDE;

protected:
    virtual void checkItemParentsNotVisible();
    virtual bool checkItemParentsVisible(QTreeWidgetItem *it);
    virtual void setItemVisible(QTreeWidgetItem *it, bool visible);

private:
    QString search;
    bool searchEmpty;
};
} // end namespace ListView
} // end namespace UI
} // end namespace Kopete

#endif
