/*
 * SPDX-FileCopyrightText: 2014-2015 Kevin Ottens <ervin@kde.org>
 * SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 */


#ifndef TESTLIB_AKONADISTORAGETESTBASE_H
#define TESTLIB_AKONADISTORAGETESTBASE_H

#include "akonadi/akonadimonitorinterface.h"
#include "akonadi/akonadistorageinterface.h"

Q_DECLARE_METATYPE(Akonadi::StorageInterface::FetchDepth)

namespace Testlib {

class AkonadiStorageTestBase : public QObject
{
    Q_OBJECT
public:
    explicit AkonadiStorageTestBase(QObject *parent = nullptr);

protected:
    virtual Akonadi::StorageInterface::Ptr createStorage() = 0;
    virtual Akonadi::MonitorInterface::Ptr createMonitor() = 0;

private slots:
    void cleanupTestCase();

    void dumpTree();
    void shouldListCollections_data();
    void shouldListCollections();
    void shouldRetrieveAllCollectionAncestors();
    void shouldListFullItemsInACollection();
    void shouldNotifyCollectionAdded();
    void shouldNotifyCollectionRemoved();
    void shouldNotifyCollectionChanged();
    void shouldNotifyItemAdded();
    void shouldNotifyItemRemoved();
    void shouldNotifyItemChanged();
    void shouldReadDefaultCollectionFromSettings();

    // This test must be run before shouldCreateItem because createItem
    // sometimes notifies an itemChanged with a delay. So this test might
    // receive this notification in addition to the itemChanged generated by updateItem.
    void shouldUpdateItem();

    // This test must be run before shouldCreateItem because createItem
    // sometimes notifies an itemChanged with a delay. So this test might
    // receive this notification in addition to the itemChanged generated by updateItem.
    void shouldUseTransaction();

    void shouldCreateItem();
    void shouldRetrieveItem();
    void shouldMoveItem();
    void shouldMoveItems();
    void shouldDeleteItem();
    void shouldDeleteItems();
    void shouldUpdateCollection();
    void shouldNotifyCollectionTimestampChanges();
    void shouldNotifyCollectionSelectionChanges();

private:
    Akonadi::Item fetchItemByRID(const QString &remoteId, const Akonadi::Collection &collection);
    Akonadi::Collection fetchCollectionByRID(const QString &remoteId);

    Akonadi::Collection calendar1();
    Akonadi::Collection calendar2();
    Akonadi::Collection emails();
};

}

#endif // TESTLIB_AKONADISTORAGETESTBASE_H
