/*
    SPDX-FileCopyrightText: 2017 Nicolas Carion
    SPDX-License-Identifier: GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
*/

#pragma once

#include "assets/model/assetparametermodel.hpp"
#include <QQuickWidget>

/** @class TransitionParameterView
    @brief This class is the view of the properties of a transition
 */
class TransitionParameterView : public QQuickWidget
{
    Q_OBJECT

public:
    TransitionParameterView(QWidget *parent = nullptr);

    /** @brief Set the current model to be displayed */
    void setModel(const std::shared_ptr<AssetParameterModel> &model);

protected:
    std::shared_ptr<AssetParameterModel> m_model;
};
