/*
 *  Copyright 2019 David Redondo <kde@david-redondo.de>
 *  Copyright (C) 2015 Boudhayan Gupta <bgupta@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "GeneralOptionsPage.h"

#include "settings.h"
#include "ui_GeneralOptions.h"

#include <KWindowSystem>

#include <QCheckBox>

GeneralOptionsPage::GeneralOptionsPage(QWidget *parent)
    : QWidget(parent)
    , m_ui(new Ui_GeneralOptions)
{
    m_ui->setupUi(this);

    m_ui->runningTitle->setLevel(2);
    m_ui->regionTitle->setLevel(2);

    connect(m_ui->kcfg_copyImageToClipboard, &QCheckBox::stateChanged, this, &GeneralOptionsPage::updateAutomaticActions);
    connect(m_ui->kcfg_autoSaveImage, &QCheckBox::stateChanged, this, &GeneralOptionsPage::updateAutomaticActions);

    //On Wayland  we can't programmatically raise and focus the window so we have to hide the option
    if (KWindowSystem::isPlatformWayland() || qstrcmp(qgetenv("XDG_SESSION_TYPE"), "wayland") == 0) {
       delete m_ui->activateWindowButton;
    }
}

GeneralOptionsPage::~GeneralOptionsPage() = default;

void GeneralOptionsPage::updateAutomaticActions() {
    if (m_ui->kcfg_copyImageToClipboard->isChecked() && m_ui->kcfg_autoSaveImage->isChecked()) {
        m_ui->kcfg_copySaveLocation->setCheckState(Qt::CheckState::Unchecked);
        m_ui->kcfg_copySaveLocation->setCheckable(false);
        m_ui->kcfg_copySaveLocation->setDisabled(true);
    } else {
        m_ui->kcfg_copySaveLocation->setCheckable(true);
        m_ui->kcfg_copySaveLocation->setEnabled(true);
    }
}
