/*
   SPDX-FileCopyrightText: 2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "developertoolwidgettest.h"
#include "widgets/developertoolwidget.h"
#include <QTest>
#include <QVBoxLayout>
#include <QWebEngineView>
#include <QWebEngineSettings>
QTEST_MAIN(DeveloperToolWidgetTest)
DeveloperToolWidgetTest::DeveloperToolWidgetTest(QObject *parent)
    : QObject(parent)
{

}

void DeveloperToolWidgetTest::shouldHaveDefaultValues()
{
    MessageViewer::DeveloperToolWidget w;
    QVBoxLayout *mainLayout = w.findChild<QVBoxLayout *>(QStringLiteral("mainLayout"));
    QVERIFY(mainLayout);
    QCOMPARE(mainLayout->contentsMargins(), QMargins(0, 0, 0, 0));

    QWebEngineView *mWebEngineView = w.findChild<QWebEngineView *>(QStringLiteral("mWebEngineView"));
    QVERIFY(mWebEngineView);
    mainLayout->addWidget(mWebEngineView);
    QWebEnginePage *mEnginePage = w.findChild<QWebEnginePage *>(QStringLiteral("mEnginePage"));
    QVERIFY(mEnginePage);
    QCOMPARE(mWebEngineView->page(), mEnginePage);
    QVERIFY(mEnginePage->settings()->testAttribute(QWebEngineSettings::JavascriptEnabled));
}
