/*
   Copyright (C) 2013-2020 Laurent Montel <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "previewwidget.h"

using namespace GrantleeThemeEditor;

PreviewWidget::PreviewWidget(QWidget *parent)
    : QWidget(parent)
    , mPrinting(false)
{
}

PreviewWidget::~PreviewWidget()
{
}

void PreviewWidget::updateViewer()
{
}

void PreviewWidget::setPrinting(bool printMode)
{
    if (mPrinting != printMode) {
        mPrinting = printMode;
        updateViewer();
    }
}

bool PreviewWidget::printing() const
{
    return mPrinting;
}

void PreviewWidget::loadConfig()
{
}

void PreviewWidget::createScreenShot(const QStringList &lstFileName)
{
    Q_UNUSED(lstFileName);
}

void PreviewWidget::setThemePath(const QString &projectDirectory, const QString &mainPageFileName)
{
    Q_UNUSED(projectDirectory);
    Q_UNUSED(mainPageFileName);
}

void PreviewWidget::slotMainFileNameChanged(const QString &)
{
}

void PreviewWidget::slotExtraHeaderDisplayChanged(const QStringList &headers)
{
    Q_UNUSED(headers);
}
