/*
   Copyright (C) 2019-2020 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef DKIMMANAGERULESWIDGET_H
#define DKIMMANAGERULESWIDGET_H
#include "messageviewer_export.h"
#include <MessageViewer/DKIMRule>
#include <QTreeWidgetItem>
#include <QWidget>
class QTreeWidget;
namespace MessageViewer {
class DKIMManageRulesComboBox;
/**
 * @brief The DKIMManageRulesWidgetItem class
 * @author Laurent Montel <montel@kde.org>
 */
class MESSAGEVIEWER_EXPORT DKIMManageRulesWidgetItem : public QTreeWidgetItem
{
public:
    enum ColumnType {
        Enabled = 0,
        Domain = 1,
        ListId = 2,
        From = 3,
        SDid = 4,
        RuleType = 5,
        Priority = 6,
    };

    explicit DKIMManageRulesWidgetItem(QTreeWidget *parent = nullptr);
    ~DKIMManageRulesWidgetItem();

    Q_REQUIRED_RESULT MessageViewer::DKIMRule rule() const;
    void setRule(const MessageViewer::DKIMRule &rule);

private:
    void updateInfo();
    MessageViewer::DKIMRule mRule;
    DKIMManageRulesComboBox *mRuleTypeCombobox = nullptr;
};

/**
 * @brief The DKIMManageRulesWidget class
 * @author Laurent Montel <montel@kde.org>
 */
class MESSAGEVIEWER_EXPORT DKIMManageRulesWidget : public QWidget
{
    Q_OBJECT
public:
    explicit DKIMManageRulesWidget(QWidget *parent = nullptr);
    ~DKIMManageRulesWidget();
    void loadSettings();
    void saveSettings();
    Q_REQUIRED_RESULT QByteArray saveHeaders() const;
    void restoreHeaders(const QByteArray &header);

    void addRule();
private:
    void modifyRule(DKIMManageRulesWidgetItem *rulesItem);
    void slotCustomContextMenuRequested(const QPoint &);
    void duplicateRule(DKIMManageRulesWidgetItem *rulesItem);
    QTreeWidget *mTreeWidget = nullptr;
};
}
#endif // DKIMMANAGERULESWIDGET_H
