SET(CTEST_SOURCE_DIRECTORY "$ENV{MWSD}")
SET(CTEST_BINARY_DIRECTORY "$ENV{MWBD}")

INCLUDE(${CTEST_SOURCE_DIRECTORY}libmediawiki/CTestConfig.cmake)

SET(WITH_MEMCHECK TRUE)
SET(WITH_COVERAGE TRUE)

#######################################################################

FIND_PROGRAM(CTEST_GIT_COMMAND NAMES git)
FIND_PROGRAM(CTEST_COVERAGE_COMMAND NAMES gcov)

#IF(NOT EXISTS "${CTEST_SOURCE_DIRECTORY}")
#  SET(CTEST_CHECKOUT_COMMAND "${CTEST_GIT_COMMAND} pull ${CTEST_SOURCE_DIRECTORY}")
#ENDIF()

#SET(CTEST_UPDATE_COMMAND "${CTEST_GIT_COMMAND}")

SET(CTEST_CONFIGURE_COMMAND "${CMAKE_COMMAND} -DWITH_TESTING:BOOL=ON ${CTEST_BUILD_OPTIONS}")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} \"-G${CTEST_CMAKE_GENERATOR}\"")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} \"${CTEST_SOURCE_DIRECTORY}\"")

ctest_start("Nightly")
#ctest_update()
ctest_configure()
ctest_build()
ctest_test()

IF (WITH_COVERAGE AND CTEST_COVERAGE_COMMAND)
  ctest_coverage()
ENDIF (WITH_COVERAGE AND CTEST_COVERAGE_COMMAND)

#ctest_submit()
