/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };


#line 34 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqliteParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqliteParserARG_STORE     Code to store %extra_argument into yypParser
**    sqliteParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 221
#define YYACTIONTYPE unsigned short int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  TriggerStep * yy19;
  struct LimitVal yy124;
  Select* yy179;
  Expr * yy182;
  Expr* yy242;
  struct TrigEvent yy290;
  Token yy298;
  SrcList* yy307;
  IdList* yy320;
  ExprList* yy322;
  int yy372;
  struct {int value; int mask;} yy407;
  int yy441;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARG_SDECL Parse *pParse;
#define sqliteParserARG_PDECL ,Parse *pParse
#define sqliteParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqliteParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 563
#define YYNRULE 293
#define YYERRORSYMBOL 131
#define YYERRSYMDT yy441
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   264,    5,  262,  119,  123,  117,  121,  129,  131,  133,
 /*    10 */   135,  144,  146,  148,  150,  152,  154,  568,  106,  106,
 /*    20 */   143,  857,    1,  562,    3,  142,  129,  131,  133,  135,
 /*    30 */   144,  146,  148,  150,  152,  154,  174,  103,    8,  115,
 /*    40 */   104,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*    50 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*    60 */   150,  152,  154,   31,  361,  392,  263,  143,  363,  369,
 /*    70 */   374,   97,  142,  148,  150,  152,  154,   68,   75,  377,
 /*    80 */   167,   64,  218,   46,   20,  289,  115,  104,  139,  127,
 /*    90 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   100 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   110 */   193,   41,  336,  563,   44,   54,   60,   62,  308,  331,
 /*   120 */   175,   20,  560,  561,  572,  333,  640,   18,  359,  144,
 /*   130 */   146,  148,  150,  152,  154,  143,  181,  179,  303,   18,
 /*   140 */   142,   84,   86,   20,  177,   66,   67,  111,   21,   22,
 /*   150 */   112,  105,   83,  792,  115,  104,  139,  127,  125,  156,
 /*   160 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   170 */   133,  135,  144,  146,  148,  150,  152,  154,  790,  560,
 /*   180 */   561,   46,   13,  113,  183,   21,   22,  534,  361,    2,
 /*   190 */     3,   14,  363,  369,  374,  338,  361,  690,  544,  542,
 /*   200 */   363,  369,  374,  377,  836,  143,   15,   21,   22,   16,
 /*   210 */   142,  377,   44,   54,   60,   62,  308,  331,  396,  535,
 /*   220 */    17,    9,  191,  333,  115,  104,  139,  127,  125,  156,
 /*   230 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   240 */   133,  135,  144,  146,  148,  150,  152,  154,  571,  230,
 /*   250 */   340,  343,  143,   20,  536,  537,  538,  142,  402,  337,
 /*   260 */   398,  339,  357,   68,  346,  347,   32,   64,  266,  391,
 /*   270 */    37,  115,  104,  139,  127,  125,  156,  161,  157,  162,
 /*   280 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   290 */   146,  148,  150,  152,  154,  839,  193,  651,  291,  298,
 /*   300 */   300,  221,  357,   43,  173,  689,  175,  251,  330,   36,
 /*   310 */    37,  106,  232,   40,  335,   58,  137,   21,   22,  330,
 /*   320 */   411,  143,  181,  179,   47,   59,  142,  358,  390,  174,
 /*   330 */   177,   66,   67,  111,  448,   49,  112,  105,  583,  213,
 /*   340 */   115,  104,  139,  127,  125,  156,  161,  157,  162,  166,
 /*   350 */   119,  123,  117,  121,  129,  131,  133,  135,  144,  146,
 /*   360 */   148,  150,  152,  154,  306,  301,  106,  249,  259,  113,
 /*   370 */   183,  793,   70,  253,  281,  219,   20,  106,   20,   11,
 /*   380 */   106,  482,  454,  444,  299,  143,  169,   10,  171,  172,
 /*   390 */   142,  169,   73,  171,  172,  103,  688,   69,  174,  169,
 /*   400 */   252,  171,  172,   12,  115,  104,  139,  127,  125,  156,
 /*   410 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   420 */   133,  135,  144,  146,  148,  150,  152,  154,   95,  237,
 /*   430 */   313,   20,  143,  295,  244,  424,  169,  142,  171,  172,
 /*   440 */    21,   22,   21,   22,  219,  386,  316,  323,  325,  837,
 /*   450 */    19,  115,  104,  139,  127,  125,  156,  161,  157,  162,
 /*   460 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   470 */   146,  148,  150,  152,  154,  106,  661,   20,  264,  143,
 /*   480 */   262,  844,  315,  169,  142,  171,  172,  333,   38,  842,
 /*   490 */    10,  356,  348,  184,  421,   21,   22,  282,  115,  104,
 /*   500 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   510 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   520 */   152,  154,   69,  254,  262,  251,  143,  639,  663,   35,
 /*   530 */    65,  142,  726,  313,  283,  259,  185,  417,  419,  418,
 /*   540 */   284,   21,   22,  690,  263,  115,  104,  139,  127,  125,
 /*   550 */   156,  161,  157,  162,  166,  119,  123,  117,  121,  129,
 /*   560 */   131,  133,  135,  144,  146,  148,  150,  152,  154,  256,
 /*   570 */    20,  791,  424,  143,  169,   52,  171,  172,  142,  169,
 /*   580 */    24,  171,  172,  247,   53,  315,   26,  169,  263,  171,
 /*   590 */   172,  253,  115,  164,  139,  127,  125,  156,  161,  157,
 /*   600 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   610 */   144,  146,  148,  150,  152,  154,  426,  349,  252,  425,
 /*   620 */   143,  262,  575,  297,  591,  142,  169,  296,  171,  172,
 /*   630 */   169,  471,  171,  172,   21,   22,  427,  221,   91,  115,
 /*   640 */   227,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*   650 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*   660 */   150,  152,  154,  388,  312,  106,   89,  143,  720,  376,
 /*   670 */   387,  170,  142,  487,  666,  248,  320,  216,  319,  217,
 /*   680 */    28,  459,   30,  305,  189,  263,  209,  104,  139,  127,
 /*   690 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   700 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   710 */   106,  106,  809,  494,  143,  489,  106,  816,   33,  142,
 /*   720 */   395,  234,  273,  217,  274,  420,   20,  545,  114,  481,
 /*   730 */   137,  429,  576,  321,  116,  139,  127,  125,  156,  161,
 /*   740 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   750 */   135,  144,  146,  148,  150,  152,  154,    7,  322,   23,
 /*   760 */    25,   27,  394,   68,  415,  416,   10,   64,  197,  477,
 /*   770 */   577,  533,  266,  548,  578,  831,  276,  201,  520,    4,
 /*   780 */     6,  245,  430,  557,   29,  266,  491,  106,  441,  497,
 /*   790 */    21,   22,  205,  168,  443,  195,  193,  531,  276,  448,
 /*   800 */   276,  808,  267,  272,  529,  174,  175,  318,  440,  341,
 /*   810 */   344,  106,  342,  345,   69,  286,   68,  582,   69,   69,
 /*   820 */    64,  540,  181,  179,  541,  328,  302,  366,  217,  118,
 /*   830 */   177,   66,   67,  111,   34,  143,  112,  105,  445,  510,
 /*   840 */   142,  215,  278,  800,  467,  276,  498,  503,  444,  193,
 /*   850 */   106,  219,  486,  443,   42,   73,  231,   73,   45,  175,
 /*   860 */   449,   39,  225,  229,  278,  451,  278,   68,  174,  113,
 /*   870 */   183,   64,  371,   55,  106,  181,  179,  292,   69,  276,
 /*   880 */   276,   69,   48,  177,   66,   67,  111,  224,  276,  112,
 /*   890 */   105,  106,  481,  393,  106,  106,   63,  106,  106,  106,
 /*   900 */   193,  653,  106,  467,  233,   51,  380,  437,  526,  120,
 /*   910 */   175,  278,  122,  124,  219,  126,  128,  130,   69,  453,
 /*   920 */   132,  106,  113,  183,  451,  106,  181,  179,  159,  106,
 /*   930 */   106,  106,  518,  106,  177,   66,   67,  111,  106,  134,
 /*   940 */   112,  105,  422,  136,  106,  278,  278,  138,  141,  145,
 /*   950 */   720,  147,  106,  329,  275,  274,  149,  106,  852,  158,
 /*   960 */   106,  106,  151,  106,  106,  351,  106,  352,  106,  464,
 /*   970 */   153,  106,  106,  113,  183,  155,  106,  106,  163,  165,
 /*   980 */   106,  176,  178,  106,  180,  106,  182,  106,  401,  190,
 /*   990 */   192,  106,  106,  293,  210,  212,  106,  367,  214,  274,
 /*  1000 */   372,  226,  274,  228,  381,  241,  274,  106,  106,  246,
 /*  1010 */   280,  290,  106,   69,  375,  438,  472,  274,  422,  832,
 /*  1020 */   106,   73,  474,   73,  458,  412,  462,  480,  464,  478,
 /*  1030 */   466,  690,  515,  519,  475,  478,  516,   50,  479,  221,
 /*  1040 */   690,  221,   56,   57,   61,  592,   71,   69,  593,   73,
 /*  1050 */    72,   74,  245,  242,   93,   81,   76,   69,   77,  240,
 /*  1060 */    78,   82,   79,  245,   85,  554,   80,   88,   87,   90,
 /*  1070 */    92,   94,   96,  102,  100,   99,  101,  107,  109,  160,
 /*  1080 */   154,  667,   98,  508,  108,  668,  110,  220,  211,  669,
 /*  1090 */   137,  140,  188,  194,  186,  196,  187,  199,  198,  200,
 /*  1100 */   203,  204,  202,  207,  206,  208,  221,  223,  222,  235,
 /*  1110 */   236,  239,  238,  217,  250,  258,  243,  261,  279,  270,
 /*  1120 */   271,  255,  257,  260,  269,  265,  285,  294,  277,  268,
 /*  1130 */   287,  304,  309,  307,  327,  312,  288,  354,  389,  314,
 /*  1140 */   364,  365,  370,  378,  379,  382,  310,   49,  311,  362,
 /*  1150 */   368,  373,  317,  324,  326,  332,  350,  355,  383,  400,
 /*  1160 */   353,  397,  399,  403,  404,  334,  405,  406,  407,  384,
 /*  1170 */   413,  409,  824,  414,  360,  385,  829,  423,  410,  431,
 /*  1180 */   428,  432,  830,  433,  434,  436,  439,  798,  799,  447,
 /*  1190 */   442,  450,  727,  728,  446,  823,  452,  838,  455,  445,
 /*  1200 */   456,  457,  408,  435,  460,  461,  463,  840,  465,  468,
 /*  1210 */   470,  469,  476,  841,  483,  485,  843,  660,  662,  493,
 /*  1220 */   806,  496,  473,  849,  499,  719,  501,  484,  488,  490,
 /*  1230 */   492,  502,  504,  495,  500,  507,  505,  506,  509,  722,
 /*  1240 */   513,  511,  512,  514,  517,  725,  528,  522,  524,  525,
 /*  1250 */   527,  523,  807,  530,  810,  532,  811,  812,  813,  814,
 /*  1260 */   817,  819,  539,  820,  818,  815,  521,  543,  546,  552,
 /*  1270 */   556,  550,  850,  547,  549,  851,  555,  558,  551,  855,
 /*  1280 */   553,  559,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    21,    9,   23,   70,   71,   72,   73,   74,   75,   76,
 /*    10 */    77,   78,   79,   80,   81,   82,   83,    9,  140,  140,
 /*    20 */    41,  132,  133,  134,  135,   46,   74,   75,   76,   77,
 /*    30 */    78,   79,   80,   81,   82,   83,  158,  158,  138,   60,
 /*    40 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    50 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*    60 */    81,   82,   83,   19,   90,   21,   87,   41,   94,   95,
 /*    70 */    96,  192,   46,   80,   81,   82,   83,   19,  174,  105,
 /*    80 */    19,   23,  204,   62,   23,  181,   60,   61,   62,   63,
 /*    90 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   100 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   110 */    52,   90,   91,    0,   93,   94,   95,   96,   97,   98,
 /*   120 */    62,   23,    9,   10,    9,  104,   20,   12,   22,   78,
 /*   130 */    79,   80,   81,   82,   83,   41,   78,   79,   80,   12,
 /*   140 */    46,   78,   79,   23,   86,   87,   88,   89,   87,   88,
 /*   150 */    92,   93,   89,  127,   60,   61,   62,   63,   64,   65,
 /*   160 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   170 */    76,   77,   78,   79,   80,   81,   82,   83,   14,    9,
 /*   180 */    10,   62,   15,  125,  126,   87,   88,  140,   90,  134,
 /*   190 */   135,   24,   94,   95,   96,   23,   90,    9,   78,   79,
 /*   200 */    94,   95,   96,  105,   11,   41,   39,   87,   88,   42,
 /*   210 */    46,  105,   93,   94,   95,   96,   97,   98,   17,   99,
 /*   220 */    53,  139,  128,  104,   60,   61,   62,   63,   64,   65,
 /*   230 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   240 */    76,   77,   78,   79,   80,   81,   82,   83,    9,   19,
 /*   250 */    78,   79,   41,   23,  207,  208,  209,   46,   57,   87,
 /*   260 */    59,   89,  140,   19,   92,   93,  144,   23,  152,  147,
 /*   270 */   148,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   280 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   290 */    79,   80,   81,   82,   83,   14,   52,    9,  182,   20,
 /*   300 */    20,  113,  140,  156,   20,   20,   62,   22,  161,  147,
 /*   310 */   148,  140,   20,  155,  156,   26,  200,   87,   88,  161,
 /*   320 */   127,   41,   78,   79,   93,   36,   46,  165,  166,  158,
 /*   330 */    86,   87,   88,   89,   53,  104,   92,   93,    9,  128,
 /*   340 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   350 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   360 */    80,   81,   82,   83,   20,  194,  140,  183,  184,  125,
 /*   370 */   126,  127,  146,   88,   19,  204,   23,  140,   23,   31,
 /*   380 */   140,  100,  101,  102,  158,   41,  107,   99,  109,  110,
 /*   390 */    46,  107,  111,  109,  110,  158,   20,  171,  158,  107,
 /*   400 */   115,  109,  110,  170,   60,   61,   62,   63,   64,   65,
 /*   410 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   420 */    76,   77,   78,   79,   80,   81,   82,   83,  191,  192,
 /*   430 */    47,   23,   41,   80,  194,  140,  107,   46,  109,  110,
 /*   440 */    87,   88,   87,   88,  204,   62,  100,  101,  102,   11,
 /*   450 */   140,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   460 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   470 */    79,   80,   81,   82,   83,  140,    9,   23,   21,   41,
 /*   480 */    23,    9,   99,  107,   46,  109,  110,  104,  149,    9,
 /*   490 */    99,  152,  153,  158,  199,   87,   88,  146,   60,   61,
 /*   500 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   510 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   520 */    82,   83,  171,  115,   23,   22,   41,   20,    9,   22,
 /*   530 */    19,   46,    9,   47,  183,  184,  201,  100,  101,  102,
 /*   540 */   189,   87,   88,   19,   87,   60,   61,   62,   63,   64,
 /*   550 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   560 */    75,   76,   77,   78,   79,   80,   81,   82,   83,  115,
 /*   570 */    23,   14,  140,   41,  107,   34,  109,  110,   46,  107,
 /*   580 */   138,  109,  110,   22,   43,   99,  138,  107,   87,  109,
 /*   590 */   110,   88,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   600 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   610 */    78,   79,   80,   81,   82,   83,   25,   19,  115,   28,
 /*   620 */    41,   23,    9,  108,  113,   46,  107,  112,  109,  110,
 /*   630 */   107,  199,  109,  110,   87,   88,   45,  113,   22,   60,
 /*   640 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   650 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   660 */    81,   82,   83,  161,  162,  140,   50,   41,    9,  139,
 /*   670 */   168,  108,   46,   17,  111,  114,   91,   20,   93,   22,
 /*   680 */   138,   22,  142,  158,  127,   87,  129,   61,   62,   63,
 /*   690 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   700 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   710 */   140,  140,    9,   57,   41,   59,  140,    9,  145,   46,
 /*   720 */   143,   20,   20,   22,   22,   49,   23,   19,  158,  158,
 /*   730 */   200,   18,    9,   29,  158,   62,   63,   64,   65,   66,
 /*   740 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   750 */    77,   78,   79,   80,   81,   82,   83,   11,   54,   13,
 /*   760 */    14,   15,   16,   19,   55,   56,   99,   23,   15,  198,
 /*   770 */     9,   63,  152,   27,    9,   99,  140,   24,   32,  136,
 /*   780 */   137,  122,  205,   37,  141,  152,  130,  140,  211,  146,
 /*   790 */    87,   88,   39,  146,  146,   42,   52,   51,  140,   53,
 /*   800 */   140,    9,  182,  167,   58,  158,   62,  103,   95,   89,
 /*   810 */    89,  140,   92,   92,  171,  182,   19,    9,  171,  171,
 /*   820 */    23,   89,   78,   79,   92,  167,   20,  167,   22,  158,
 /*   830 */    86,   87,   88,   89,   20,   41,   92,   93,   60,  196,
 /*   840 */    46,  194,  206,  130,  196,  140,  100,  101,  102,   52,
 /*   850 */   140,  204,  106,  146,  140,  111,  146,  111,  139,   62,
 /*   860 */   212,  150,   68,   69,  206,  217,  206,   19,  158,  125,
 /*   870 */   126,   23,  167,   48,  140,   78,   79,   80,  171,  140,
 /*   880 */   140,  171,  139,   86,   87,   88,   89,   93,  140,   92,
 /*   890 */    93,  140,  158,  146,  140,  140,   19,  140,  140,  140,
 /*   900 */    52,  123,  140,  196,  194,   44,  167,  167,  116,  158,
 /*   910 */    62,  206,  158,  158,  204,  158,  158,  158,  171,  212,
 /*   920 */   158,  140,  125,  126,  217,  140,   78,   79,   62,  140,
 /*   930 */   140,  140,  198,  140,   86,   87,   88,   89,  140,  158,
 /*   940 */    92,   93,   22,  158,  140,  206,  206,  158,  158,  158,
 /*   950 */     9,  158,  140,   20,  206,   22,  158,  140,    9,   93,
 /*   960 */   140,  140,  158,  140,  140,   20,  140,   22,  140,  140,
 /*   970 */   158,  140,  140,  125,  126,  158,  140,  140,  158,  158,
 /*   980 */   140,  158,  158,  140,  158,  140,  158,  140,  146,  158,
 /*   990 */   158,  140,  140,  140,  158,  158,  140,   20,  158,   22,
 /*  1000 */    20,  158,   22,  158,   20,  158,   22,  140,  140,  158,
 /*  1010 */   158,  158,  140,  171,  158,   20,   20,   22,   22,   99,
 /*  1020 */   140,  111,  146,  111,  195,  158,  158,   20,  140,   22,
 /*  1030 */   158,  103,  146,   20,  124,   22,  124,  164,  158,  113,
 /*  1040 */   114,  113,  157,  139,  139,  113,  172,  171,  113,  111,
 /*  1050 */   171,  173,  122,  119,  117,  180,  175,  171,  176,  120,
 /*  1060 */   177,  121,  178,  122,   89,  116,  179,  154,   89,  154,
 /*  1070 */   154,  118,   22,  151,   98,  157,   23,  113,  113,   93,
 /*  1080 */    83,  111,  193,  195,  140,  111,  140,  140,  127,  111,
 /*  1090 */   200,  200,   14,   19,  202,   20,  203,  140,   22,   20,
 /*  1100 */   140,   20,   22,  140,   22,   20,  113,  186,  140,  140,
 /*  1110 */   186,  157,  193,   22,  185,  115,  118,  186,   99,  116,
 /*  1120 */    19,  140,  140,  140,  188,  140,   20,  113,  157,  187,
 /*  1130 */   187,   20,  140,  139,   19,  162,  188,   20,  166,  140,
 /*  1140 */    48,   19,   19,   48,   19,   97,  159,  104,  160,  140,
 /*  1150 */   139,  139,  163,  163,  163,  151,  154,  152,  140,   21,
 /*  1160 */   154,  140,  140,  140,  213,  164,  214,   99,  140,  159,
 /*  1170 */    40,  215,   11,   38,  166,  160,   99,  140,  216,  130,
 /*  1180 */    49,  140,   99,   99,  140,   19,  139,    9,  130,  169,
 /*  1190 */    11,   14,  123,  123,  170,    9,    9,   14,  169,   60,
 /*  1200 */   140,  103,  186,  186,  140,   63,  176,    9,   63,  123,
 /*  1210 */    19,  140,   19,    9,  114,  176,    9,    9,    9,  186,
 /*  1220 */     9,  186,  197,    9,  114,    9,  186,  140,  140,  140,
 /*  1230 */   140,  176,  169,  140,  140,  103,  140,  186,  176,    9,
 /*  1240 */   186,  123,  140,  197,   19,    9,   87,  140,  114,  140,
 /*  1250 */    35,  186,    9,  140,    9,  152,    9,    9,    9,    9,
 /*  1260 */     9,    9,  210,    9,    9,    9,  169,  210,  140,  140,
 /*  1270 */    33,  152,    9,   20,  218,    9,  152,  218,   21,    9,
 /*  1280 */   219,  140,
};
#define YY_SHIFT_USE_DFLT (-68)
static short yy_shift_ofst[] = {
 /*     0 */   170,  113,  -68,  746,   -8,  -68,    8,  127,  288,  239,
 /*    10 */   348,  167,  -68,  -68,  -68,  -68,  -68,  -68,  547,  -68,
 /*    20 */   -68,  -68,  -68,  115,  613,  115,  723,  115,  761,   44,
 /*    30 */   765,  547,  507,  814,  808,   98,  -68,  501,  -68,   21,
 /*    40 */   -68,  547,  119,  -68,  667,  -68,  231,  667,  -68,  861,
 /*    50 */   -68,  541,  -68,  -68,  825,  289,  667,  -68,  -68,  -68,
 /*    60 */   667,  -68,  877,  848,  511,   58,  932,  935,  744,  -68,
 /*    70 */   279,  938,  -68,  515,  -68,  561,  930,  934,  939,  937,
 /*    80 */   940,  -68,   63,  -68,  975,  -68,  979,  -68,  616,   63,
 /*    90 */   -68,   63,  -68,  953,  848, 1050,  848,  976,  289,  -68,
 /*   100 */  1053,  -68,  -68,  485,  848,  -68,  964,  547,  965,  547,
 /*   110 */   -68,  -68,  -68,  -68,  673,  848,  626,  848,  -48,  848,
 /*   120 */   -48,  848,  -48,  848,  -48,  848,  -67,  848,  -67,  848,
 /*   130 */    51,  848,   51,  848,   51,  848,   51,  848,  -67,  794,
 /*   140 */   848,  -67,  -68,  -68,  848,   -7,  848,   -7,  848,  997,
 /*   150 */   848,  997,  848,  997,  848,  -68,  -68,  866,  -68,  986,
 /*   160 */   -68,  -68,  848,  532,  848,  -67,   61,  744,  284,  563,
 /*   170 */   970,  974,  978,  -68,  485,  848,  673,  848,  -68,  848,
 /*   180 */   -68,  848,  -68,  244,   26,  961,  557, 1078,  -68,  848,
 /*   190 */    94,  848,  485, 1074,  753, 1075,  -68, 1076,  547, 1079,
 /*   200 */   -68, 1080,  547, 1081,  -68, 1082,  547, 1085,  -68,  848,
 /*   210 */   164,  848,  211,  848,  485,  657,  -68,  848,  -68,  -68,
 /*   220 */   993,  547,  -68,  -68,  -68,  848,  579,  848,  673,  230,
 /*   230 */   744,  292,  -68,  701,  -68,  993,  -68,  976,  289,  -68,
 /*   240 */   848,  485,  998,  848, 1091,  848,  485,  -68,  -68,  503,
 /*   250 */   -68,  -68,  -68,  408,  -68,  454,  -68, 1000,  -68,  355,
 /*   260 */   993,  457,  -68,  -68,  547,  -68,  -68, 1019, 1003,  -68,
 /*   270 */  1101,  547,  702,  -68,  547,  -68,  289,  -68,  -68,  848,
 /*   280 */   485,  938,  376,  285, 1106,  457, 1019, 1003,  -68,  797,
 /*   290 */   -21,  -68,  -68, 1014,  353,  -68,  -68,  -68,  -68,  280,
 /*   300 */   -68,  806,  -68, 1111,  -68,  344,  667,  -68,  547, 1115,
 /*   310 */   -68,  486,  -68,  547,  -68,  346,  704,  -68,  585,  -68,
 /*   320 */   -68,  -68,  -68,  704,  -68,  704,  -68,  547,  933,  -68,
 /*   330 */   -68, 1053,  -68,  861,  -68,  -68,  172,  -68,  -68,  -68,
 /*   340 */   720,  -68,  -68,  721,  -68,  -68,  -68,  -68,  598,   63,
 /*   350 */   945,  -68,   63, 1117,  -68,  -68,  -68,  -68,  106,  -26,
 /*   360 */   -68,  547,  -68, 1092, 1122,  547,  977,  667,  -68, 1123,
 /*   370 */   547,  980,  667,  -68,  848,  391,  -68, 1095, 1125,  547,
 /*   380 */   984, 1048,  547, 1115,  -68,  383, 1043,  -68,  -68,  -68,
 /*   390 */   -68,  -68,  938,  329,  713,  201,  547,  -68,  547, 1138,
 /*   400 */   938,  467,  547,  591,  437, 1068,  547,  993, 1130,  193,
 /*   410 */  1161,  848,  438, 1135,  709,  -68,  -68, 1077, 1083,  676,
 /*   420 */   547,  920,  547,  -68,  -68,  -68,  -68, 1131,  -68,  -68,
 /*   430 */  1049,  547, 1084,  547,  524, 1166,  547,  995,  288, 1178,
 /*   440 */  1058, 1179,  281,  472,  778,  167,  -68, 1069, 1070, 1177,
 /*   450 */  1186, 1187,  281, 1183, 1139,  547, 1098,  547,  659,  547,
 /*   460 */  1142,  848,  485, 1198, 1145,  848,  485, 1086,  547, 1191,
 /*   470 */   547,  996,  -68,  910,  480, 1193,  848, 1007,  848,  485,
 /*   480 */  1204,  485, 1100,  547,  941, 1207,  656,  547, 1208,  547,
 /*   490 */  1209,  547,  188, 1211,  547,  188, 1214,  519, 1110,  547,
 /*   500 */   993,  941, 1216, 1139,  547,  928, 1132,  547,  659, 1230,
 /*   510 */  1118,  547,  993, 1191,  912,  523, 1225,  848, 1013, 1236,
 /*   520 */  1139,  547,  926, 1134,  547,  792, 1215, 1159, 1243,  703,
 /*   530 */  1245,  501,  708,  120, 1247, 1248, 1249, 1250,  732, 1251,
 /*   540 */  1252, 1254,  732, 1255,  -68,  547, 1253, 1256, 1237,  501,
 /*   550 */  1257,  547,  949, 1263,  501, 1266,  -68, 1237,  547, 1270,
 /*   560 */   -68,  -68,  -68,
};
#define YY_REDUCE_USE_DFLT (-123)
static short yy_reduce_ofst[] = {
 /*     0 */  -111,   55, -123,  643, -123, -123, -123, -100,   82, -123,
 /*    10 */  -123,  233, -123, -123, -123, -123, -123, -123,  310, -123,
 /*    20 */  -123, -123, -123,  442, -123,  448, -123,  542, -123,  540,
 /*    30 */  -123,  122,  573, -123, -123,  162, -123,  339,  711,  158,
 /*    40 */  -123,  714,  147, -123,  719, -123, -123,  743, -123,  873,
 /*    50 */  -123, -123, -123, -123, -123,  885,  904, -123, -123, -123,
 /*    60 */   905, -123, -123,  525, -123,  171, -123, -123,  226, -123,
 /*    70 */   874,  879, -123,  878,  -96,  881,  882,  883,  884,  887,
 /*    80 */   875, -123,  913, -123, -123, -123, -123, -123, -123,  915,
 /*    90 */  -123,  916, -123, -123,  237, -123, -121,  889,  918, -123,
 /*   100 */   922, -123, -123,  890,  570, -123, -123,  944, -123,  946,
 /*   110 */  -123, -123, -123, -123,  890,  576,  890,  671,  890,  751,
 /*   120 */   890,  754,  890,  755,  890,  757,  890,  758,  890,  759,
 /*   130 */   890,  762,  890,  781,  890,  785,  890,  789,  890,  891,
 /*   140 */   790,  890, -123, -123,  791,  890,  793,  890,  798,  890,
 /*   150 */   804,  890,  812,  890,  817,  890, -123, -123, -123, -123,
 /*   160 */  -123, -123,  820,  890,  821,  890,  947,  647,  874, -123,
 /*   170 */  -123, -123, -123, -123,  890,  823,  890,  824,  890,  826,
 /*   180 */   890,  828,  890,  335,  890,  892,  893, -123, -123,  831,
 /*   190 */   890,  832,  890, -123, -123, -123, -123, -123,  957, -123,
 /*   200 */  -123, -123,  960, -123, -123, -123,  963, -123, -123,  836,
 /*   210 */   890,  837,  890,  840,  890, -123, -123, -122, -123, -123,
 /*   220 */   921,  968, -123, -123, -123,  843,  890,  845,  890,  969,
 /*   230 */   710,  874, -123, -123, -123,  924, -123,  919,  954, -123,
 /*   240 */   847,  890, -123,  240, -123,  851,  890, -123,  184,  929,
 /*   250 */  -123, -123, -123,  981, -123,  982, -123, -123, -123,  983,
 /*   260 */   931,  620, -123, -123,  985, -123, -123,  942,  936, -123,
 /*   270 */  -123,  636, -123, -123,  748, -123,  971, -123, -123,  852,
 /*   280 */   890,  351,  874,  929, -123,  633,  943,  948, -123,  853,
 /*   290 */   116, -123, -123, -123,  944, -123, -123, -123, -123,  890,
 /*   300 */  -123, -123, -123, -123, -123,  890,  994, -123,  992,  987,
 /*   310 */   988,  973, -123,  999, -123, -123,  989, -123, -123, -123,
 /*   320 */  -123, -123, -123,  990, -123,  991, -123,  658, -123, -123,
 /*   330 */  -123, 1004, -123, 1001, -123, -123, -123, -123, -123, -123,
 /*   340 */  -123, -123, -123, -123, -123, -123, -123, -123, 1005, 1002,
 /*   350 */  -123, -123, 1006, -123, -123, -123, -123, -123,  972, 1008,
 /*   360 */  -123, 1009, -123, -123, -123,  660, -123, 1011, -123, -123,
 /*   370 */   705, -123, 1012, -123,  856,  530, -123, -123, -123,  739,
 /*   380 */  -123, -123, 1018, 1010, 1015,  502, -123, -123, -123, -123,
 /*   390 */  -123, -123,  747,  874,  577, -123, 1021, -123, 1022, -123,
 /*   400 */   842,  874, 1023,  951,  952, -123, 1028, 1016,  956,  962,
 /*   410 */  -123,  867,  890, -123, -123, -123, -123, -123, -123, -123,
 /*   420 */   295, -123, 1037, -123, -123, -123, -123, -123, -123, -123,
 /*   430 */  -123, 1041, -123, 1044, 1017, -123,  740, -123, 1047, -123,
 /*   440 */  -123, -123,  648,  874, 1020, 1024, -123, -123, -123, -123,
 /*   450 */  -123, -123,  707, -123, 1029, 1060, -123,  829, 1030, 1064,
 /*   460 */  -123,  868,  890, -123, -123,  872,  890, -123, 1071, 1025,
 /*   470 */   432, -123, -123,  876,  874, -123,  571, -123,  880,  890,
 /*   480 */  -123,  890, -123, 1087, 1039, -123, -123, 1088, -123, 1089,
 /*   490 */  -123, 1090, 1033, -123, 1093, 1035, -123,  874, -123, 1094,
 /*   500 */  1040, 1055, -123, 1063, 1096, 1051, -123,  888, 1062, -123,
 /*   510 */  -123, 1102, 1054, 1046,  886,  874, -123,  734, -123, -123,
 /*   520 */  1097, 1107, 1065, -123, 1109, -123, -123, -123, -123, 1113,
 /*   530 */  -123, 1103, -123,   47, -123, -123, -123, -123, 1052, -123,
 /*   540 */  -123, -123, 1057, -123, -123, 1128, -123, -123, 1056, 1119,
 /*   550 */  -123, 1129, 1061, -123, 1124, -123, -123, 1059, 1141, -123,
 /*   560 */  -123, -123, -123,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   570,  570,  564,  856,  856,  566,  856,  572,  856,  856,
 /*    10 */   856,  856,  652,  655,  656,  657,  658,  659,  573,  574,
 /*    20 */   591,  592,  593,  856,  856,  856,  856,  856,  856,  856,
 /*    30 */   856,  856,  856,  856,  856,  856,  584,  594,  604,  586,
 /*    40 */   603,  856,  856,  605,  651,  616,  856,  651,  617,  636,
 /*    50 */   634,  856,  637,  638,  856,  708,  651,  618,  706,  707,
 /*    60 */   651,  619,  856,  856,  737,  797,  743,  738,  856,  664,
 /*    70 */   856,  856,  665,  673,  675,  682,  720,  711,  713,  701,
 /*    80 */   715,  670,  856,  600,  856,  601,  856,  602,  716,  856,
 /*    90 */   717,  856,  718,  856,  856,  702,  856,  709,  708,  703,
 /*   100 */   856,  588,  710,  705,  856,  736,  856,  856,  739,  856,
 /*   110 */   740,  741,  742,  744,  747,  856,  748,  856,  749,  856,
 /*   120 */   750,  856,  751,  856,  752,  856,  753,  856,  754,  856,
 /*   130 */   755,  856,  756,  856,  757,  856,  758,  856,  759,  856,
 /*   140 */   856,  760,  761,  762,  856,  763,  856,  764,  856,  765,
 /*   150 */   856,  766,  856,  767,  856,  768,  769,  856,  770,  856,
 /*   160 */   773,  771,  856,  856,  856,  779,  856,  797,  856,  856,
 /*   170 */   856,  856,  856,  782,  796,  856,  774,  856,  775,  856,
 /*   180 */   776,  856,  777,  856,  856,  856,  856,  856,  787,  856,
 /*   190 */   856,  856,  788,  856,  856,  856,  845,  856,  856,  856,
 /*   200 */   846,  856,  856,  856,  847,  856,  856,  856,  848,  856,
 /*   210 */   856,  856,  856,  856,  789,  856,  781,  797,  794,  795,
 /*   220 */   690,  856,  691,  785,  772,  856,  856,  856,  780,  856,
 /*   230 */   797,  856,  784,  856,  783,  690,  786,  709,  708,  704,
 /*   240 */   856,  714,  856,  797,  712,  856,  721,  674,  685,  683,
 /*   250 */   684,  692,  693,  856,  694,  856,  695,  856,  696,  856,
 /*   260 */   690,  681,  589,  590,  856,  679,  680,  698,  700,  686,
 /*   270 */   856,  856,  856,  699,  856,  803,  708,  805,  804,  856,
 /*   280 */   697,  685,  856,  856,  856,  681,  698,  700,  687,  856,
 /*   290 */   681,  676,  677,  856,  856,  678,  671,  672,  778,  856,
 /*   300 */   735,  856,  745,  856,  746,  856,  651,  620,  856,  801,
 /*   310 */   624,  621,  625,  856,  626,  856,  856,  627,  856,  630,
 /*   320 */   631,  632,  633,  856,  628,  856,  629,  856,  856,  802,
 /*   330 */   622,  856,  623,  636,  635,  606,  856,  607,  608,  609,
 /*   340 */   856,  610,  613,  856,  611,  614,  612,  615,  595,  856,
 /*   350 */   856,  596,  856,  856,  597,  599,  598,  587,  856,  856,
 /*   360 */   641,  856,  644,  856,  856,  856,  856,  651,  645,  856,
 /*   370 */   856,  856,  651,  646,  856,  651,  647,  856,  856,  856,
 /*   380 */   856,  856,  856,  801,  624,  649,  856,  648,  650,  642,
 /*   390 */   643,  585,  856,  856,  581,  856,  856,  579,  856,  856,
 /*   400 */   856,  856,  856,  828,  856,  856,  856,  690,  833,  856,
 /*   410 */   856,  856,  856,  856,  856,  834,  835,  856,  856,  856,
 /*   420 */   856,  856,  856,  733,  734,  825,  826,  856,  827,  580,
 /*   430 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   440 */   856,  856,  856,  856,  856,  856,  654,  856,  856,  856,
 /*   450 */   856,  856,  856,  856,  653,  856,  856,  856,  856,  856,
 /*   460 */   856,  856,  723,  856,  856,  856,  724,  856,  856,  731,
 /*   470 */   856,  856,  732,  856,  856,  856,  856,  856,  856,  729,
 /*   480 */   856,  730,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   490 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   500 */   690,  856,  856,  653,  856,  856,  856,  856,  856,  856,
 /*   510 */   856,  856,  690,  731,  856,  856,  856,  856,  856,  856,
 /*   520 */   653,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   530 */   856,  856,  856,  822,  856,  856,  856,  856,  856,  856,
 /*   540 */   856,  856,  856,  856,  821,  856,  856,  856,  854,  856,
 /*   550 */   856,  856,  856,  856,  856,  856,  853,  854,  856,  856,
 /*   560 */   567,  569,  565,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*    CLUSTER => ID */
   23,  /*   CONFLICT => ID */
   23,  /*       COPY => ID */
   23,  /*   DATABASE => ID */
   23,  /*   DEFERRED => ID */
   23,  /* DELIMITERS => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*       GLOB => ID */
   23,  /*     IGNORE => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*       LIKE => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         EQ => nothing */
    0,  /*         NE => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*         GT => nothing */
    0,  /*         GE => nothing */
    0,  /*         LT => nothing */
    0,  /*         LE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /*    INTEGER => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqliteParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CLUSTER",       "CONFLICT",    
  "COPY",          "DATABASE",      "DEFERRED",      "DELIMITERS",  
  "DESC",          "DETACH",        "EACH",          "FAIL",        
  "FOR",           "GLOB",          "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "OR",            "AND",           "NOT",           "EQ",          
  "NE",            "ISNULL",        "NOTNULL",       "IS",          
  "BETWEEN",       "IN",            "GT",            "GE",          
  "LT",            "LE",            "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "UMINUS",        "UPLUS",         "BITNOT",        "STRING",      
  "JOIN_KW",       "INTEGER",       "CONSTRAINT",    "DEFAULT",     
  "FLOAT",         "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "COLLATE",       "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "error",       
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "cmd",           "trans_opt",     "onconf",      
  "nm",            "create_table",  "create_table_args",  "temp",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typename",      "signed",        "carg",        
  "ccons",         "sortorder",     "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "dbnm",          "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "inscollist",  
  "likeop",        "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_num",    
  "minus_num",     "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt onconf",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 125 */ "seltablist_paren ::= select",
 /* 126 */ "seltablist_paren ::= seltablist",
 /* 127 */ "dbnm ::=",
 /* 128 */ "dbnm ::= DOT nm",
 /* 129 */ "joinop ::= COMMA",
 /* 130 */ "joinop ::= JOIN",
 /* 131 */ "joinop ::= JOIN_KW JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm JOIN",
 /* 133 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 134 */ "on_opt ::= ON expr",
 /* 135 */ "on_opt ::=",
 /* 136 */ "using_opt ::= USING LP idxlist RP",
 /* 137 */ "using_opt ::=",
 /* 138 */ "orderby_opt ::=",
 /* 139 */ "orderby_opt ::= ORDER BY sortlist",
 /* 140 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 141 */ "sortlist ::= sortitem collate sortorder",
 /* 142 */ "sortitem ::= expr",
 /* 143 */ "sortorder ::= ASC",
 /* 144 */ "sortorder ::= DESC",
 /* 145 */ "sortorder ::=",
 /* 146 */ "collate ::=",
 /* 147 */ "collate ::= COLLATE id",
 /* 148 */ "groupby_opt ::=",
 /* 149 */ "groupby_opt ::= GROUP BY exprlist",
 /* 150 */ "having_opt ::=",
 /* 151 */ "having_opt ::= HAVING expr",
 /* 152 */ "limit_opt ::=",
 /* 153 */ "limit_opt ::= LIMIT signed",
 /* 154 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 155 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 156 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 157 */ "where_opt ::=",
 /* 158 */ "where_opt ::= WHERE expr",
 /* 159 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 160 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 161 */ "setlist ::= nm EQ expr",
 /* 162 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 163 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 164 */ "insert_cmd ::= INSERT orconf",
 /* 165 */ "insert_cmd ::= REPLACE",
 /* 166 */ "itemlist ::= itemlist COMMA expr",
 /* 167 */ "itemlist ::= expr",
 /* 168 */ "inscollist_opt ::=",
 /* 169 */ "inscollist_opt ::= LP inscollist RP",
 /* 170 */ "inscollist ::= inscollist COMMA nm",
 /* 171 */ "inscollist ::= nm",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "expr ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "expr ::= INTEGER",
 /* 179 */ "expr ::= FLOAT",
 /* 180 */ "expr ::= STRING",
 /* 181 */ "expr ::= VARIABLE",
 /* 182 */ "expr ::= ID LP exprlist RP",
 /* 183 */ "expr ::= ID LP STAR RP",
 /* 184 */ "expr ::= expr AND expr",
 /* 185 */ "expr ::= expr OR expr",
 /* 186 */ "expr ::= expr LT expr",
 /* 187 */ "expr ::= expr GT expr",
 /* 188 */ "expr ::= expr LE expr",
 /* 189 */ "expr ::= expr GE expr",
 /* 190 */ "expr ::= expr NE expr",
 /* 191 */ "expr ::= expr EQ expr",
 /* 192 */ "expr ::= expr BITAND expr",
 /* 193 */ "expr ::= expr BITOR expr",
 /* 194 */ "expr ::= expr LSHIFT expr",
 /* 195 */ "expr ::= expr RSHIFT expr",
 /* 196 */ "expr ::= expr likeop expr",
 /* 197 */ "expr ::= expr NOT likeop expr",
 /* 198 */ "likeop ::= LIKE",
 /* 199 */ "likeop ::= GLOB",
 /* 200 */ "expr ::= expr PLUS expr",
 /* 201 */ "expr ::= expr MINUS expr",
 /* 202 */ "expr ::= expr STAR expr",
 /* 203 */ "expr ::= expr SLASH expr",
 /* 204 */ "expr ::= expr REM expr",
 /* 205 */ "expr ::= expr CONCAT expr",
 /* 206 */ "expr ::= expr ISNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOTNULL",
 /* 209 */ "expr ::= expr NOT NULL",
 /* 210 */ "expr ::= expr IS NOT NULL",
 /* 211 */ "expr ::= NOT expr",
 /* 212 */ "expr ::= BITNOT expr",
 /* 213 */ "expr ::= MINUS expr",
 /* 214 */ "expr ::= PLUS expr",
 /* 215 */ "expr ::= LP select RP",
 /* 216 */ "expr ::= expr BETWEEN expr AND expr",
 /* 217 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 218 */ "expr ::= expr IN LP exprlist RP",
 /* 219 */ "expr ::= expr IN LP select RP",
 /* 220 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 221 */ "expr ::= expr NOT IN LP select RP",
 /* 222 */ "expr ::= expr IN nm dbnm",
 /* 223 */ "expr ::= expr NOT IN nm dbnm",
 /* 224 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 225 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 226 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 227 */ "case_else ::= ELSE expr",
 /* 228 */ "case_else ::=",
 /* 229 */ "case_operand ::= expr",
 /* 230 */ "case_operand ::=",
 /* 231 */ "exprlist ::= exprlist COMMA expritem",
 /* 232 */ "exprlist ::= expritem",
 /* 233 */ "expritem ::= expr",
 /* 234 */ "expritem ::=",
 /* 235 */ "cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf",
 /* 236 */ "uniqueflag ::= UNIQUE",
 /* 237 */ "uniqueflag ::=",
 /* 238 */ "idxlist_opt ::=",
 /* 239 */ "idxlist_opt ::= LP idxlist RP",
 /* 240 */ "idxlist ::= idxlist COMMA idxitem",
 /* 241 */ "idxlist ::= idxitem",
 /* 242 */ "idxitem ::= nm sortorder",
 /* 243 */ "cmd ::= DROP INDEX nm dbnm",
 /* 244 */ "cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING",
 /* 245 */ "cmd ::= COPY orconf nm dbnm FROM nm",
 /* 246 */ "cmd ::= VACUUM",
 /* 247 */ "cmd ::= VACUUM nm",
 /* 248 */ "cmd ::= PRAGMA ids EQ nm",
 /* 249 */ "cmd ::= PRAGMA ids EQ ON",
 /* 250 */ "cmd ::= PRAGMA ids EQ plus_num",
 /* 251 */ "cmd ::= PRAGMA ids EQ minus_num",
 /* 252 */ "cmd ::= PRAGMA ids LP nm RP",
 /* 253 */ "cmd ::= PRAGMA ids",
 /* 254 */ "plus_num ::= plus_opt number",
 /* 255 */ "minus_num ::= MINUS number",
 /* 256 */ "number ::= INTEGER",
 /* 257 */ "number ::= FLOAT",
 /* 258 */ "plus_opt ::= PLUS",
 /* 259 */ "plus_opt ::=",
 /* 260 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 261 */ "trigger_decl ::= temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 262 */ "trigger_time ::= BEFORE",
 /* 263 */ "trigger_time ::= AFTER",
 /* 264 */ "trigger_time ::= INSTEAD OF",
 /* 265 */ "trigger_time ::=",
 /* 266 */ "trigger_event ::= DELETE",
 /* 267 */ "trigger_event ::= INSERT",
 /* 268 */ "trigger_event ::= UPDATE",
 /* 269 */ "trigger_event ::= UPDATE OF inscollist",
 /* 270 */ "foreach_clause ::=",
 /* 271 */ "foreach_clause ::= FOR EACH ROW",
 /* 272 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 273 */ "when_clause ::=",
 /* 274 */ "when_clause ::= WHEN expr",
 /* 275 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 276 */ "trigger_cmd_list ::=",
 /* 277 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 279 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 280 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 281 */ "trigger_cmd ::= select",
 /* 282 */ "expr ::= RAISE LP IGNORE RP",
 /* 283 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 284 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 285 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 286 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 287 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 288 */ "key_opt ::= USING ids",
 /* 289 */ "key_opt ::=",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 146:
#line 286 "parse.y"
{sqliteSelectDelete((yypminor->yy179));}
#line 1235 "parse.c"
      break;
    case 158:
#line 533 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1240 "parse.c"
      break;
    case 159:
#line 746 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1245 "parse.c"
      break;
    case 167:
#line 744 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1250 "parse.c"
      break;
    case 171:
#line 288 "parse.y"
{sqliteSelectDelete((yypminor->yy179));}
#line 1255 "parse.c"
      break;
    case 174:
#line 322 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1260 "parse.c"
      break;
    case 175:
#line 353 "parse.y"
{sqliteSrcListDelete((yypminor->yy307));}
#line 1265 "parse.c"
      break;
    case 176:
#line 483 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1270 "parse.c"
      break;
    case 177:
#line 459 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1275 "parse.c"
      break;
    case 178:
#line 464 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1280 "parse.c"
      break;
    case 179:
#line 431 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1285 "parse.c"
      break;
    case 181:
#line 324 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1290 "parse.c"
      break;
    case 183:
#line 349 "parse.y"
{sqliteSrcListDelete((yypminor->yy307));}
#line 1295 "parse.c"
      break;
    case 184:
#line 351 "parse.y"
{sqliteSrcListDelete((yypminor->yy307));}
#line 1300 "parse.c"
      break;
    case 187:
#line 420 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1305 "parse.c"
      break;
    case 188:
#line 425 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1310 "parse.c"
      break;
    case 189:
#line 400 "parse.y"
{sqliteSelectDelete((yypminor->yy179));}
#line 1315 "parse.c"
      break;
    case 191:
#line 433 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1320 "parse.c"
      break;
    case 192:
#line 435 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1325 "parse.c"
      break;
    case 194:
#line 719 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1330 "parse.c"
      break;
    case 195:
#line 489 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1335 "parse.c"
      break;
    case 197:
#line 520 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1340 "parse.c"
      break;
    case 198:
#line 514 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1345 "parse.c"
      break;
    case 199:
#line 522 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1350 "parse.c"
      break;
    case 202:
#line 702 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1355 "parse.c"
      break;
    case 204:
#line 721 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1360 "parse.c"
      break;
    case 212:
#line 828 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy19));}
#line 1365 "parse.c"
      break;
    case 214:
#line 812 "parse.y"
{sqliteIdListDelete((yypminor->yy290).b);}
#line 1370 "parse.c"
      break;
    case 217:
#line 836 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy19));}
#line 1375 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqliteParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 132, 1 },
  { 133, 2 },
  { 133, 1 },
  { 134, 3 },
  { 134, 1 },
  { 136, 1 },
  { 135, 1 },
  { 135, 0 },
  { 137, 3 },
  { 138, 0 },
  { 138, 1 },
  { 138, 2 },
  { 137, 2 },
  { 137, 2 },
  { 137, 2 },
  { 137, 2 },
  { 141, 4 },
  { 143, 1 },
  { 143, 0 },
  { 142, 4 },
  { 142, 2 },
  { 144, 3 },
  { 144, 1 },
  { 147, 3 },
  { 148, 1 },
  { 151, 1 },
  { 152, 1 },
  { 152, 1 },
  { 140, 1 },
  { 140, 1 },
  { 140, 1 },
  { 149, 0 },
  { 149, 1 },
  { 149, 4 },
  { 149, 6 },
  { 153, 1 },
  { 153, 2 },
  { 154, 1 },
  { 154, 2 },
  { 154, 2 },
  { 150, 2 },
  { 150, 0 },
  { 155, 3 },
  { 155, 1 },
  { 155, 2 },
  { 155, 2 },
  { 155, 2 },
  { 155, 3 },
  { 155, 3 },
  { 155, 2 },
  { 155, 3 },
  { 155, 3 },
  { 155, 2 },
  { 156, 2 },
  { 156, 3 },
  { 156, 4 },
  { 156, 2 },
  { 156, 5 },
  { 156, 4 },
  { 156, 1 },
  { 156, 2 },
  { 160, 0 },
  { 160, 2 },
  { 162, 2 },
  { 162, 3 },
  { 162, 3 },
  { 162, 3 },
  { 163, 2 },
  { 163, 2 },
  { 163, 1 },
  { 163, 1 },
  { 161, 3 },
  { 161, 2 },
  { 164, 0 },
  { 164, 2 },
  { 164, 2 },
  { 145, 0 },
  { 145, 2 },
  { 165, 3 },
  { 165, 2 },
  { 165, 1 },
  { 166, 2 },
  { 166, 6 },
  { 166, 5 },
  { 166, 3 },
  { 166, 10 },
  { 168, 0 },
  { 168, 1 },
  { 139, 0 },
  { 139, 3 },
  { 169, 0 },
  { 169, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 137, 3 },
  { 137, 6 },
  { 137, 3 },
  { 137, 1 },
  { 146, 1 },
  { 146, 3 },
  { 172, 1 },
  { 172, 2 },
  { 172, 1 },
  { 172, 1 },
  { 171, 9 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 181, 2 },
  { 181, 0 },
  { 174, 3 },
  { 174, 2 },
  { 174, 4 },
  { 182, 2 },
  { 182, 1 },
  { 182, 0 },
  { 175, 0 },
  { 175, 2 },
  { 184, 2 },
  { 184, 0 },
  { 183, 6 },
  { 183, 7 },
  { 189, 1 },
  { 189, 1 },
  { 186, 0 },
  { 186, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 2 },
  { 185, 3 },
  { 185, 4 },
  { 187, 2 },
  { 187, 0 },
  { 188, 4 },
  { 188, 0 },
  { 179, 0 },
  { 179, 3 },
  { 191, 5 },
  { 191, 3 },
  { 192, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 0 },
  { 193, 0 },
  { 193, 2 },
  { 177, 0 },
  { 177, 3 },
  { 178, 0 },
  { 178, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 4 },
  { 180, 4 },
  { 137, 5 },
  { 176, 0 },
  { 176, 2 },
  { 137, 7 },
  { 195, 5 },
  { 195, 3 },
  { 137, 9 },
  { 137, 6 },
  { 196, 2 },
  { 196, 1 },
  { 198, 3 },
  { 198, 1 },
  { 197, 0 },
  { 197, 3 },
  { 199, 3 },
  { 199, 1 },
  { 158, 3 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 3 },
  { 158, 5 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 4 },
  { 158, 4 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 4 },
  { 200, 1 },
  { 200, 1 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 5 },
  { 158, 6 },
  { 158, 5 },
  { 158, 5 },
  { 158, 6 },
  { 158, 6 },
  { 158, 4 },
  { 158, 5 },
  { 158, 5 },
  { 202, 5 },
  { 202, 4 },
  { 203, 2 },
  { 203, 0 },
  { 201, 1 },
  { 201, 0 },
  { 194, 3 },
  { 194, 1 },
  { 204, 1 },
  { 204, 0 },
  { 137, 11 },
  { 205, 1 },
  { 205, 0 },
  { 159, 0 },
  { 159, 3 },
  { 167, 3 },
  { 167, 1 },
  { 206, 2 },
  { 137, 4 },
  { 137, 9 },
  { 137, 6 },
  { 137, 1 },
  { 137, 2 },
  { 137, 4 },
  { 137, 4 },
  { 137, 4 },
  { 137, 4 },
  { 137, 5 },
  { 137, 2 },
  { 207, 2 },
  { 208, 2 },
  { 210, 1 },
  { 210, 1 },
  { 209, 1 },
  { 209, 0 },
  { 137, 5 },
  { 211, 10 },
  { 213, 1 },
  { 213, 1 },
  { 213, 2 },
  { 213, 0 },
  { 214, 1 },
  { 214, 1 },
  { 214, 1 },
  { 214, 3 },
  { 215, 0 },
  { 215, 3 },
  { 215, 3 },
  { 216, 0 },
  { 216, 2 },
  { 212, 3 },
  { 212, 0 },
  { 217, 6 },
  { 217, 8 },
  { 217, 5 },
  { 217, 4 },
  { 217, 1 },
  { 158, 4 },
  { 158, 6 },
  { 158, 6 },
  { 158, 6 },
  { 137, 4 },
  { 137, 6 },
  { 219, 2 },
  { 219, 0 },
  { 218, 1 },
  { 218, 0 },
  { 137, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqliteParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for cmdlist */
        break;
      case 1:
        /* No destructor defined for cmdlist */
        /* No destructor defined for ecmd */
        break;
      case 2:
        /* No destructor defined for ecmd */
        break;
      case 3:
        /* No destructor defined for explain */
        /* No destructor defined for cmdx */
        /* No destructor defined for SEMI */
        break;
      case 4:
        /* No destructor defined for SEMI */
        break;
      case 5:
#line 72 "parse.y"
{ sqliteExec(pParse); }
#line 1901 "parse.c"
        /* No destructor defined for cmd */
        break;
      case 6:
#line 73 "parse.y"
{ sqliteBeginParse(pParse, 1); }
#line 1907 "parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
#line 74 "parse.y"
{ sqliteBeginParse(pParse, 0); }
#line 1913 "parse.c"
        break;
      case 8:
#line 79 "parse.y"
{sqliteBeginTransaction(pParse,yymsp[0].minor.yy372);}
#line 1918 "parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 9:
        break;
      case 10:
        /* No destructor defined for TRANSACTION */
        break;
      case 11:
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for nm */
        break;
      case 12:
#line 83 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1934 "parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 13:
#line 84 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1941 "parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 14:
#line 85 "parse.y"
{sqliteRollbackTransaction(pParse);}
#line 1948 "parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 15:
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 16:
#line 90 "parse.y"
{
   sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy298,yymsp[-2].minor.yy372,0);
}
#line 1961 "parse.c"
        /* No destructor defined for TABLE */
        break;
      case 17:
#line 94 "parse.y"
{yygotominor.yy372 = 1;}
#line 1967 "parse.c"
        /* No destructor defined for TEMP */
        break;
      case 18:
#line 95 "parse.y"
{yygotominor.yy372 = 0;}
#line 1973 "parse.c"
        break;
      case 19:
#line 96 "parse.y"
{
  sqliteEndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1980 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 20:
#line 99 "parse.y"
{
  sqliteEndTable(pParse,0,yymsp[0].minor.yy179);
  sqliteSelectDelete(yymsp[0].minor.yy179);
}
#line 1991 "parse.c"
        /* No destructor defined for AS */
        break;
      case 21:
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 22:
        /* No destructor defined for column */
        break;
      case 23:
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 24:
#line 111 "parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy298);}
#line 2010 "parse.c"
        break;
      case 25:
#line 117 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2015 "parse.c"
        break;
      case 26:
#line 149 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2020 "parse.c"
        break;
      case 27:
#line 150 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2025 "parse.c"
        break;
      case 28:
#line 155 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2030 "parse.c"
        break;
      case 29:
#line 156 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2035 "parse.c"
        break;
      case 30:
#line 157 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2040 "parse.c"
        break;
      case 31:
        break;
      case 32:
#line 160 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy298,&yymsp[0].minor.yy298);}
#line 2047 "parse.c"
        break;
      case 33:
#line 161 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy298,&yymsp[0].minor.yy0);}
#line 2052 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 34:
#line 163 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy298,&yymsp[0].minor.yy0);}
#line 2059 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 35:
#line 165 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 2068 "parse.c"
        break;
      case 36:
#line 166 "parse.y"
{yygotominor.yy298 = yymsp[-1].minor.yy298;}
#line 2073 "parse.c"
        /* No destructor defined for ids */
        break;
      case 37:
#line 168 "parse.y"
{ yygotominor.yy372 = atoi(yymsp[0].minor.yy0.z); }
#line 2079 "parse.c"
        break;
      case 38:
#line 169 "parse.y"
{ yygotominor.yy372 = atoi(yymsp[0].minor.yy0.z); }
#line 2084 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 39:
#line 170 "parse.y"
{ yygotominor.yy372 = -atoi(yymsp[0].minor.yy0.z); }
#line 2090 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 40:
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 41:
        break;
      case 42:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        /* No destructor defined for ccons */
        break;
      case 43:
        /* No destructor defined for ccons */
        break;
      case 44:
#line 175 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2110 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 45:
#line 176 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2116 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 46:
#line 177 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2122 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 47:
#line 178 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2128 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 48:
#line 179 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2135 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 49:
#line 180 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2142 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
#line 181 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2148 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 51:
#line 182 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2155 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 52:
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 53:
        /* No destructor defined for NULL */
        /* No destructor defined for onconf */
        break;
      case 54:
#line 189 "parse.y"
{sqliteAddNotNull(pParse, yymsp[0].minor.yy372);}
#line 2170 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 55:
#line 190 "parse.y"
{sqliteAddPrimaryKey(pParse,0,yymsp[0].minor.yy372);}
#line 2177 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 56:
#line 191 "parse.y"
{sqliteCreateIndex(pParse,0,0,0,yymsp[0].minor.yy372,0,0);}
#line 2185 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 57:
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(158,&yymsp[-2].minor);
        /* No destructor defined for RP */
        /* No destructor defined for onconf */
        break;
      case 58:
#line 194 "parse.y"
{sqliteCreateForeignKey(pParse,0,&yymsp[-2].minor.yy298,yymsp[-1].minor.yy320,yymsp[0].minor.yy372);}
#line 2198 "parse.c"
        /* No destructor defined for REFERENCES */
        break;
      case 59:
#line 195 "parse.y"
{sqliteDeferForeignKey(pParse,yymsp[0].minor.yy372);}
#line 2204 "parse.c"
        break;
      case 60:
#line 196 "parse.y"
{
   sqliteAddCollateType(pParse, sqliteCollateType(yymsp[0].minor.yy298.z, yymsp[0].minor.yy298.n));
}
#line 2211 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 61:
#line 206 "parse.y"
{ yygotominor.yy372 = OE_Restrict * 0x010101; }
#line 2217 "parse.c"
        break;
      case 62:
#line 207 "parse.y"
{ yygotominor.yy372 = (yymsp[-1].minor.yy372 & yymsp[0].minor.yy407.mask) | yymsp[0].minor.yy407.value; }
#line 2222 "parse.c"
        break;
      case 63:
#line 209 "parse.y"
{ yygotominor.yy407.value = 0;     yygotominor.yy407.mask = 0x000000; }
#line 2227 "parse.c"
        /* No destructor defined for MATCH */
        /* No destructor defined for nm */
        break;
      case 64:
#line 210 "parse.y"
{ yygotominor.yy407.value = yymsp[0].minor.yy372;     yygotominor.yy407.mask = 0x0000ff; }
#line 2234 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for DELETE */
        break;
      case 65:
#line 211 "parse.y"
{ yygotominor.yy407.value = yymsp[0].minor.yy372<<8;  yygotominor.yy407.mask = 0x00ff00; }
#line 2241 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for UPDATE */
        break;
      case 66:
#line 212 "parse.y"
{ yygotominor.yy407.value = yymsp[0].minor.yy372<<16; yygotominor.yy407.mask = 0xff0000; }
#line 2248 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for INSERT */
        break;
      case 67:
#line 214 "parse.y"
{ yygotominor.yy372 = OE_SetNull; }
#line 2255 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for NULL */
        break;
      case 68:
#line 215 "parse.y"
{ yygotominor.yy372 = OE_SetDflt; }
#line 2262 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for DEFAULT */
        break;
      case 69:
#line 216 "parse.y"
{ yygotominor.yy372 = OE_Cascade; }
#line 2269 "parse.c"
        /* No destructor defined for CASCADE */
        break;
      case 70:
#line 217 "parse.y"
{ yygotominor.yy372 = OE_Restrict; }
#line 2275 "parse.c"
        /* No destructor defined for RESTRICT */
        break;
      case 71:
#line 219 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2281 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for DEFERRABLE */
        break;
      case 72:
#line 220 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2288 "parse.c"
        /* No destructor defined for DEFERRABLE */
        break;
      case 73:
#line 222 "parse.y"
{yygotominor.yy372 = 0;}
#line 2294 "parse.c"
        break;
      case 74:
#line 223 "parse.y"
{yygotominor.yy372 = 1;}
#line 2299 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for DEFERRED */
        break;
      case 75:
#line 224 "parse.y"
{yygotominor.yy372 = 0;}
#line 2306 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for IMMEDIATE */
        break;
      case 76:
        break;
      case 77:
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 78:
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 79:
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 80:
        /* No destructor defined for tcons */
        break;
      case 81:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        break;
      case 82:
#line 236 "parse.y"
{sqliteAddPrimaryKey(pParse,yymsp[-2].minor.yy320,yymsp[0].minor.yy372);}
#line 2335 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 83:
#line 238 "parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-2].minor.yy320,yymsp[0].minor.yy372,0,0);}
#line 2344 "parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 84:
        /* No destructor defined for CHECK */
  yy_destructor(158,&yymsp[-1].minor);
        /* No destructor defined for onconf */
        break;
      case 85:
#line 241 "parse.y"
{
    sqliteCreateForeignKey(pParse, yymsp[-6].minor.yy320, &yymsp[-3].minor.yy298, yymsp[-2].minor.yy320, yymsp[-1].minor.yy372);
    sqliteDeferForeignKey(pParse, yymsp[0].minor.yy372);
}
#line 2360 "parse.c"
        /* No destructor defined for FOREIGN */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        /* No destructor defined for REFERENCES */
        break;
      case 86:
#line 246 "parse.y"
{yygotominor.yy372 = 0;}
#line 2370 "parse.c"
        break;
      case 87:
#line 247 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2375 "parse.c"
        break;
      case 88:
#line 255 "parse.y"
{ yygotominor.yy372 = OE_Default; }
#line 2380 "parse.c"
        break;
      case 89:
#line 256 "parse.y"
{ yygotominor.yy372 = yymsp[0].minor.yy372; }
#line 2385 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for CONFLICT */
        break;
      case 90:
#line 257 "parse.y"
{ yygotominor.yy372 = OE_Default; }
#line 2392 "parse.c"
        break;
      case 91:
#line 258 "parse.y"
{ yygotominor.yy372 = yymsp[0].minor.yy372; }
#line 2397 "parse.c"
        /* No destructor defined for OR */
        break;
      case 92:
#line 259 "parse.y"
{ yygotominor.yy372 = OE_Rollback; }
#line 2403 "parse.c"
        /* No destructor defined for ROLLBACK */
        break;
      case 93:
#line 260 "parse.y"
{ yygotominor.yy372 = OE_Abort; }
#line 2409 "parse.c"
        /* No destructor defined for ABORT */
        break;
      case 94:
#line 261 "parse.y"
{ yygotominor.yy372 = OE_Fail; }
#line 2415 "parse.c"
        /* No destructor defined for FAIL */
        break;
      case 95:
#line 262 "parse.y"
{ yygotominor.yy372 = OE_Ignore; }
#line 2421 "parse.c"
        /* No destructor defined for IGNORE */
        break;
      case 96:
#line 263 "parse.y"
{ yygotominor.yy372 = OE_Replace; }
#line 2427 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 97:
#line 267 "parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy298,0);}
#line 2433 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 98:
#line 271 "parse.y"
{
  sqliteCreateView(pParse, &yymsp[-5].minor.yy0, &yymsp[-2].minor.yy298, yymsp[0].minor.yy179, yymsp[-4].minor.yy372);
}
#line 2442 "parse.c"
        /* No destructor defined for VIEW */
        /* No destructor defined for AS */
        break;
      case 99:
#line 274 "parse.y"
{
  sqliteDropTable(pParse, &yymsp[0].minor.yy298, 1);
}
#line 2451 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for VIEW */
        break;
      case 100:
#line 280 "parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy179, SRT_Callback, 0, 0, 0, 0);
  sqliteSelectDelete(yymsp[0].minor.yy179);
}
#line 2461 "parse.c"
        break;
      case 101:
#line 290 "parse.y"
{yygotominor.yy179 = yymsp[0].minor.yy179;}
#line 2466 "parse.c"
        break;
      case 102:
#line 291 "parse.y"
{
  if( yymsp[0].minor.yy179 ){
    yymsp[0].minor.yy179->op = yymsp[-1].minor.yy372;
    yymsp[0].minor.yy179->pPrior = yymsp[-2].minor.yy179;
  }
  yygotominor.yy179 = yymsp[0].minor.yy179;
}
#line 2477 "parse.c"
        break;
      case 103:
#line 299 "parse.y"
{yygotominor.yy372 = TK_UNION;}
#line 2482 "parse.c"
        /* No destructor defined for UNION */
        break;
      case 104:
#line 300 "parse.y"
{yygotominor.yy372 = TK_ALL;}
#line 2488 "parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 105:
#line 301 "parse.y"
{yygotominor.yy372 = TK_INTERSECT;}
#line 2495 "parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 106:
#line 302 "parse.y"
{yygotominor.yy372 = TK_EXCEPT;}
#line 2501 "parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 107:
#line 304 "parse.y"
{
  yygotominor.yy179 = sqliteSelectNew(yymsp[-6].minor.yy322,yymsp[-5].minor.yy307,yymsp[-4].minor.yy242,yymsp[-3].minor.yy322,yymsp[-2].minor.yy242,yymsp[-1].minor.yy322,yymsp[-7].minor.yy372,yymsp[0].minor.yy124.limit,yymsp[0].minor.yy124.offset);
}
#line 2509 "parse.c"
        /* No destructor defined for SELECT */
        break;
      case 108:
#line 312 "parse.y"
{yygotominor.yy372 = 1;}
#line 2515 "parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 109:
#line 313 "parse.y"
{yygotominor.yy372 = 0;}
#line 2521 "parse.c"
        /* No destructor defined for ALL */
        break;
      case 110:
#line 314 "parse.y"
{yygotominor.yy372 = 0;}
#line 2527 "parse.c"
        break;
      case 111:
#line 325 "parse.y"
{yygotominor.yy322 = yymsp[-1].minor.yy322;}
#line 2532 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 112:
#line 326 "parse.y"
{yygotominor.yy322 = 0;}
#line 2538 "parse.c"
        break;
      case 113:
#line 327 "parse.y"
{
   yygotominor.yy322 = sqliteExprListAppend(yymsp[-2].minor.yy322,yymsp[-1].minor.yy242,yymsp[0].minor.yy298.n?&yymsp[0].minor.yy298:0);
}
#line 2545 "parse.c"
        break;
      case 114:
#line 330 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-1].minor.yy322, sqliteExpr(TK_ALL, 0, 0, 0), 0);
}
#line 2552 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 115:
#line 333 "parse.y"
{
  Expr *pRight = sqliteExpr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy298);
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-3].minor.yy322, sqliteExpr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2562 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for STAR */
        break;
      case 116:
#line 343 "parse.y"
{ yygotominor.yy298 = yymsp[0].minor.yy298; }
#line 2569 "parse.c"
        /* No destructor defined for AS */
        break;
      case 117:
#line 344 "parse.y"
{ yygotominor.yy298 = yymsp[0].minor.yy298; }
#line 2575 "parse.c"
        break;
      case 118:
#line 345 "parse.y"
{ yygotominor.yy298.n = 0; }
#line 2580 "parse.c"
        break;
      case 119:
#line 357 "parse.y"
{yygotominor.yy307 = sqliteMalloc(sizeof(*yygotominor.yy307));}
#line 2585 "parse.c"
        break;
      case 120:
#line 358 "parse.y"
{yygotominor.yy307 = yymsp[0].minor.yy307;}
#line 2590 "parse.c"
        /* No destructor defined for FROM */
        break;
      case 121:
#line 363 "parse.y"
{
   yygotominor.yy307 = yymsp[-1].minor.yy307;
   if( yygotominor.yy307 && yygotominor.yy307->nSrc>0 ) yygotominor.yy307->a[yygotominor.yy307->nSrc-1].jointype = yymsp[0].minor.yy372;
}
#line 2599 "parse.c"
        break;
      case 122:
#line 367 "parse.y"
{yygotominor.yy307 = 0;}
#line 2604 "parse.c"
        break;
      case 123:
#line 368 "parse.y"
{
  yygotominor.yy307 = sqliteSrcListAppend(yymsp[-5].minor.yy307,&yymsp[-4].minor.yy298,&yymsp[-3].minor.yy298);
  if( yymsp[-2].minor.yy298.n ) sqliteSrcListAddAlias(yygotominor.yy307,&yymsp[-2].minor.yy298);
  if( yymsp[-1].minor.yy242 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pOn = yymsp[-1].minor.yy242; }
    else { sqliteExprDelete(yymsp[-1].minor.yy242); }
  }
  if( yymsp[0].minor.yy320 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pUsing = yymsp[0].minor.yy320; }
    else { sqliteIdListDelete(yymsp[0].minor.yy320); }
  }
}
#line 2620 "parse.c"
        break;
      case 124:
#line 381 "parse.y"
{
  yygotominor.yy307 = sqliteSrcListAppend(yymsp[-6].minor.yy307,0,0);
  yygotominor.yy307->a[yygotominor.yy307->nSrc-1].pSelect = yymsp[-4].minor.yy179;
  if( yymsp[-2].minor.yy298.n ) sqliteSrcListAddAlias(yygotominor.yy307,&yymsp[-2].minor.yy298);
  if( yymsp[-1].minor.yy242 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pOn = yymsp[-1].minor.yy242; }
    else { sqliteExprDelete(yymsp[-1].minor.yy242); }
  }
  if( yymsp[0].minor.yy320 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pUsing = yymsp[0].minor.yy320; }
    else { sqliteIdListDelete(yymsp[0].minor.yy320); }
  }
}
#line 2637 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 125:
#line 401 "parse.y"
{yygotominor.yy179 = yymsp[0].minor.yy179;}
#line 2644 "parse.c"
        break;
      case 126:
#line 402 "parse.y"
{
   yygotominor.yy179 = sqliteSelectNew(0,yymsp[0].minor.yy307,0,0,0,0,0,-1,0);
}
#line 2651 "parse.c"
        break;
      case 127:
#line 407 "parse.y"
{yygotominor.yy298.z=0; yygotominor.yy298.n=0;}
#line 2656 "parse.c"
        break;
      case 128:
#line 408 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 2661 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 129:
#line 412 "parse.y"
{ yygotominor.yy372 = JT_INNER; }
#line 2667 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 130:
#line 413 "parse.y"
{ yygotominor.yy372 = JT_INNER; }
#line 2673 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 131:
#line 414 "parse.y"
{ yygotominor.yy372 = sqliteJoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2679 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 132:
#line 415 "parse.y"
{ yygotominor.yy372 = sqliteJoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy298,0); }
#line 2685 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 133:
#line 417 "parse.y"
{ yygotominor.yy372 = sqliteJoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy298,&yymsp[-1].minor.yy298); }
#line 2691 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 134:
#line 421 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2697 "parse.c"
        /* No destructor defined for ON */
        break;
      case 135:
#line 422 "parse.y"
{yygotominor.yy242 = 0;}
#line 2703 "parse.c"
        break;
      case 136:
#line 426 "parse.y"
{yygotominor.yy320 = yymsp[-1].minor.yy320;}
#line 2708 "parse.c"
        /* No destructor defined for USING */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 137:
#line 427 "parse.y"
{yygotominor.yy320 = 0;}
#line 2716 "parse.c"
        break;
      case 138:
#line 437 "parse.y"
{yygotominor.yy322 = 0;}
#line 2721 "parse.c"
        break;
      case 139:
#line 438 "parse.y"
{yygotominor.yy322 = yymsp[0].minor.yy322;}
#line 2726 "parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 140:
#line 439 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-4].minor.yy322,yymsp[-2].minor.yy242,0);
  if( yygotominor.yy322 ) yygotominor.yy322->a[yygotominor.yy322->nExpr-1].sortOrder = yymsp[-1].minor.yy372+yymsp[0].minor.yy372;
}
#line 2736 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 141:
#line 443 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(0,yymsp[-2].minor.yy242,0);
  if( yygotominor.yy322 ) yygotominor.yy322->a[0].sortOrder = yymsp[-1].minor.yy372+yymsp[0].minor.yy372;
}
#line 2745 "parse.c"
        break;
      case 142:
#line 447 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2750 "parse.c"
        break;
      case 143:
#line 452 "parse.y"
{yygotominor.yy372 = SQLITE_SO_ASC;}
#line 2755 "parse.c"
        /* No destructor defined for ASC */
        break;
      case 144:
#line 453 "parse.y"
{yygotominor.yy372 = SQLITE_SO_DESC;}
#line 2761 "parse.c"
        /* No destructor defined for DESC */
        break;
      case 145:
#line 454 "parse.y"
{yygotominor.yy372 = SQLITE_SO_ASC;}
#line 2767 "parse.c"
        break;
      case 146:
#line 455 "parse.y"
{yygotominor.yy372 = SQLITE_SO_UNK;}
#line 2772 "parse.c"
        break;
      case 147:
#line 456 "parse.y"
{yygotominor.yy372 = sqliteCollateType(yymsp[0].minor.yy298.z, yymsp[0].minor.yy298.n);}
#line 2777 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 148:
#line 460 "parse.y"
{yygotominor.yy322 = 0;}
#line 2783 "parse.c"
        break;
      case 149:
#line 461 "parse.y"
{yygotominor.yy322 = yymsp[0].minor.yy322;}
#line 2788 "parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 150:
#line 465 "parse.y"
{yygotominor.yy242 = 0;}
#line 2795 "parse.c"
        break;
      case 151:
#line 466 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2800 "parse.c"
        /* No destructor defined for HAVING */
        break;
      case 152:
#line 469 "parse.y"
{yygotominor.yy124.limit = -1; yygotominor.yy124.offset = 0;}
#line 2806 "parse.c"
        break;
      case 153:
#line 470 "parse.y"
{yygotominor.yy124.limit = yymsp[0].minor.yy372; yygotominor.yy124.offset = 0;}
#line 2811 "parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 154:
#line 472 "parse.y"
{yygotominor.yy124.limit = yymsp[-2].minor.yy372; yygotominor.yy124.offset = yymsp[0].minor.yy372;}
#line 2817 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for OFFSET */
        break;
      case 155:
#line 474 "parse.y"
{yygotominor.yy124.limit = yymsp[0].minor.yy372; yygotominor.yy124.offset = yymsp[-2].minor.yy372;}
#line 2824 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for COMMA */
        break;
      case 156:
#line 478 "parse.y"
{
   sqliteDeleteFrom(pParse, sqliteSrcListAppend(0,&yymsp[-2].minor.yy298,&yymsp[-1].minor.yy298), yymsp[0].minor.yy242);
}
#line 2833 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 157:
#line 485 "parse.y"
{yygotominor.yy242 = 0;}
#line 2840 "parse.c"
        break;
      case 158:
#line 486 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2845 "parse.c"
        /* No destructor defined for WHERE */
        break;
      case 159:
#line 494 "parse.y"
{sqliteUpdate(pParse,sqliteSrcListAppend(0,&yymsp[-4].minor.yy298,&yymsp[-3].minor.yy298),yymsp[-1].minor.yy322,yymsp[0].minor.yy242,yymsp[-5].minor.yy372);}
#line 2851 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 160:
#line 497 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(yymsp[-4].minor.yy322,yymsp[0].minor.yy242,&yymsp[-2].minor.yy298);}
#line 2858 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 161:
#line 498 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(0,yymsp[0].minor.yy242,&yymsp[-2].minor.yy298);}
#line 2865 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 162:
#line 504 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-6].minor.yy298,&yymsp[-5].minor.yy298), yymsp[-1].minor.yy322, 0, yymsp[-4].minor.yy320, yymsp[-8].minor.yy372);}
#line 2871 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 163:
#line 506 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-3].minor.yy298,&yymsp[-2].minor.yy298), 0, yymsp[0].minor.yy179, yymsp[-1].minor.yy320, yymsp[-5].minor.yy372);}
#line 2880 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 164:
#line 509 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2886 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 165:
#line 510 "parse.y"
{yygotominor.yy372 = OE_Replace;}
#line 2892 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 166:
#line 516 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(yymsp[-2].minor.yy322,yymsp[0].minor.yy242,0);}
#line 2898 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 167:
#line 517 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(0,yymsp[0].minor.yy242,0);}
#line 2904 "parse.c"
        break;
      case 168:
#line 524 "parse.y"
{yygotominor.yy320 = 0;}
#line 2909 "parse.c"
        break;
      case 169:
#line 525 "parse.y"
{yygotominor.yy320 = yymsp[-1].minor.yy320;}
#line 2914 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 170:
#line 526 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(yymsp[-2].minor.yy320,&yymsp[0].minor.yy298);}
#line 2921 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 171:
#line 527 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(0,&yymsp[0].minor.yy298);}
#line 2927 "parse.c"
        break;
      case 172:
#line 535 "parse.y"
{yygotominor.yy242 = yymsp[-1].minor.yy242; sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2932 "parse.c"
        break;
      case 173:
#line 536 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 2937 "parse.c"
        break;
      case 174:
#line 537 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2942 "parse.c"
        break;
      case 175:
#line 538 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2947 "parse.c"
        break;
      case 176:
#line 539 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy298);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy298);
  yygotominor.yy242 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 2956 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 177:
#line 544 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-4].minor.yy298);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy298);
  Expr *temp3 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy298);
  Expr *temp4 = sqliteExpr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy242 = sqliteExpr(TK_DOT, temp1, temp4, 0);
}
#line 2968 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for DOT */
        break;
      case 178:
#line 551 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 2975 "parse.c"
        break;
      case 179:
#line 552 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 2980 "parse.c"
        break;
      case 180:
#line 553 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 2985 "parse.c"
        break;
      case 181:
#line 554 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_VARIABLE, 0, 0, &yymsp[0].minor.yy0);
  if( yygotominor.yy242 ) yygotominor.yy242->iTable = ++pParse->nVar;
}
#line 2993 "parse.c"
        break;
      case 182:
#line 558 "parse.y"
{
  yygotominor.yy242 = sqliteExprFunction(yymsp[-1].minor.yy322, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3001 "parse.c"
        /* No destructor defined for LP */
        break;
      case 183:
#line 562 "parse.y"
{
  yygotominor.yy242 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3010 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 184:
#line 566 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_AND, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3017 "parse.c"
        /* No destructor defined for AND */
        break;
      case 185:
#line 567 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_OR, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3023 "parse.c"
        /* No destructor defined for OR */
        break;
      case 186:
#line 568 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_LT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3029 "parse.c"
        /* No destructor defined for LT */
        break;
      case 187:
#line 569 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_GT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3035 "parse.c"
        /* No destructor defined for GT */
        break;
      case 188:
#line 570 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_LE, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3041 "parse.c"
        /* No destructor defined for LE */
        break;
      case 189:
#line 571 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_GE, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3047 "parse.c"
        /* No destructor defined for GE */
        break;
      case 190:
#line 572 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_NE, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3053 "parse.c"
        /* No destructor defined for NE */
        break;
      case 191:
#line 573 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3059 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 192:
#line 574 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_BITAND, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3065 "parse.c"
        /* No destructor defined for BITAND */
        break;
      case 193:
#line 575 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_BITOR, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3071 "parse.c"
        /* No destructor defined for BITOR */
        break;
      case 194:
#line 576 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_LSHIFT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3077 "parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 195:
#line 577 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_RSHIFT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3083 "parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 196:
#line 578 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[-2].minor.yy242, 0);
  yygotominor.yy242 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->op = yymsp[-1].minor.yy372;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-2].minor.yy242->span, &yymsp[0].minor.yy242->span);
}
#line 3095 "parse.c"
        break;
      case 197:
#line 585 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[-3].minor.yy242, 0);
  yygotominor.yy242 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->op = yymsp[-1].minor.yy372;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy242->span,&yymsp[0].minor.yy242->span);
}
#line 3107 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 198:
#line 594 "parse.y"
{yygotominor.yy372 = TK_LIKE;}
#line 3113 "parse.c"
        /* No destructor defined for LIKE */
        break;
      case 199:
#line 595 "parse.y"
{yygotominor.yy372 = TK_GLOB;}
#line 3119 "parse.c"
        /* No destructor defined for GLOB */
        break;
      case 200:
#line 596 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3125 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 201:
#line 597 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3131 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 202:
#line 598 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3137 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 203:
#line 599 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3143 "parse.c"
        /* No destructor defined for SLASH */
        break;
      case 204:
#line 600 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_REM, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3149 "parse.c"
        /* No destructor defined for REM */
        break;
      case 205:
#line 601 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3155 "parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 206:
#line 602 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3164 "parse.c"
        break;
      case 207:
#line 606 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3172 "parse.c"
        /* No destructor defined for IS */
        break;
      case 208:
#line 610 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3181 "parse.c"
        break;
      case 209:
#line 614 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3189 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 210:
#line 618 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOTNULL, yymsp[-3].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3198 "parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 211:
#line 622 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOT, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3208 "parse.c"
        break;
      case 212:
#line 626 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_BITNOT, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3216 "parse.c"
        break;
      case 213:
#line 630 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3224 "parse.c"
        break;
      case 214:
#line 634 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_UPLUS, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3232 "parse.c"
        break;
      case 215:
#line 638 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = yymsp[-1].minor.yy179;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3241 "parse.c"
        break;
      case 216:
#line 643 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy242, 0);
  yygotominor.yy242 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = pList;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,&yymsp[0].minor.yy242->span);
}
#line 3252 "parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 217:
#line 650 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy242, 0);
  yygotominor.yy242 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = pList;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-5].minor.yy242->span,&yymsp[0].minor.yy242->span);
}
#line 3266 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 218:
#line 658 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = yymsp[-1].minor.yy322;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3278 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 219:
#line 663 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = yymsp[-1].minor.yy179;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3289 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 220:
#line 668 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-5].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = yymsp[-1].minor.yy322;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-5].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3301 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 221:
#line 674 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-5].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = yymsp[-1].minor.yy179;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-5].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3314 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 222:
#line 680 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-1].minor.yy298, &yymsp[0].minor.yy298);
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-3].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = sqliteSelectNew(0,pSrc,0,0,0,0,0,-1,0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy242->span,yymsp[0].minor.yy298.z?&yymsp[0].minor.yy298:&yymsp[-1].minor.yy298);
}
#line 3327 "parse.c"
        /* No destructor defined for IN */
        break;
      case 223:
#line 686 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-1].minor.yy298, &yymsp[0].minor.yy298);
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = sqliteSelectNew(0,pSrc,0,0,0,0,0,-1,0);
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,yymsp[0].minor.yy298.z?&yymsp[0].minor.yy298:&yymsp[-1].minor.yy298);
}
#line 3339 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        break;
      case 224:
#line 696 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_CASE, yymsp[-3].minor.yy242, yymsp[-1].minor.yy242, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = yymsp[-2].minor.yy322;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3350 "parse.c"
        break;
      case 225:
#line 703 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-4].minor.yy322, yymsp[-2].minor.yy242, 0);
  yygotominor.yy322 = sqliteExprListAppend(yygotominor.yy322, yymsp[0].minor.yy242, 0);
}
#line 3358 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 226:
#line 707 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(0, yymsp[-2].minor.yy242, 0);
  yygotominor.yy322 = sqliteExprListAppend(yygotominor.yy322, yymsp[0].minor.yy242, 0);
}
#line 3368 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 227:
#line 712 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 3375 "parse.c"
        /* No destructor defined for ELSE */
        break;
      case 228:
#line 713 "parse.y"
{yygotominor.yy242 = 0;}
#line 3381 "parse.c"
        break;
      case 229:
#line 715 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 3386 "parse.c"
        break;
      case 230:
#line 716 "parse.y"
{yygotominor.yy242 = 0;}
#line 3391 "parse.c"
        break;
      case 231:
#line 724 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(yymsp[-2].minor.yy322,yymsp[0].minor.yy242,0);}
#line 3396 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 232:
#line 725 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(0,yymsp[0].minor.yy242,0);}
#line 3402 "parse.c"
        break;
      case 233:
#line 726 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 3407 "parse.c"
        break;
      case 234:
#line 727 "parse.y"
{yygotominor.yy242 = 0;}
#line 3412 "parse.c"
        break;
      case 235:
#line 732 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-5].minor.yy298, &yymsp[-4].minor.yy298);
  if( yymsp[-9].minor.yy372!=OE_None ) yymsp[-9].minor.yy372 = yymsp[0].minor.yy372;
  if( yymsp[-9].minor.yy372==OE_Default) yymsp[-9].minor.yy372 = OE_Abort;
  sqliteCreateIndex(pParse, &yymsp[-7].minor.yy298, pSrc, yymsp[-2].minor.yy320, yymsp[-9].minor.yy372, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 3422 "parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 236:
#line 740 "parse.y"
{ yygotominor.yy372 = OE_Abort; }
#line 3430 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 237:
#line 741 "parse.y"
{ yygotominor.yy372 = OE_None; }
#line 3436 "parse.c"
        break;
      case 238:
#line 749 "parse.y"
{yygotominor.yy320 = 0;}
#line 3441 "parse.c"
        break;
      case 239:
#line 750 "parse.y"
{yygotominor.yy320 = yymsp[-1].minor.yy320;}
#line 3446 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 240:
#line 751 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(yymsp[-2].minor.yy320,&yymsp[0].minor.yy298);}
#line 3453 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 241:
#line 752 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(0,&yymsp[0].minor.yy298);}
#line 3459 "parse.c"
        break;
      case 242:
#line 753 "parse.y"
{yygotominor.yy298 = yymsp[-1].minor.yy298;}
#line 3464 "parse.c"
        /* No destructor defined for sortorder */
        break;
      case 243:
#line 758 "parse.y"
{
  sqliteDropIndex(pParse, sqliteSrcListAppend(0,&yymsp[-1].minor.yy298,&yymsp[0].minor.yy298));
}
#line 3472 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 244:
#line 766 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-6].minor.yy298,&yymsp[-5].minor.yy298),&yymsp[-3].minor.yy298,&yymsp[0].minor.yy0,yymsp[-7].minor.yy372);}
#line 3479 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 245:
#line 768 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-3].minor.yy298,&yymsp[-2].minor.yy298),&yymsp[0].minor.yy298,0,yymsp[-4].minor.yy372);}
#line 3488 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 246:
#line 772 "parse.y"
{sqliteVacuum(pParse,0);}
#line 3495 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 247:
#line 773 "parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy298);}
#line 3501 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 248:
#line 777 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy298,0);}
#line 3507 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 249:
#line 778 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy0,0);}
#line 3514 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 250:
#line 779 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy298,0);}
#line 3521 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 251:
#line 780 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy298,1);}
#line 3528 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 252:
#line 781 "parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy298,&yymsp[-1].minor.yy298,0);}
#line 3535 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 253:
#line 782 "parse.y"
{sqlitePragma(pParse,&yymsp[0].minor.yy298,&yymsp[0].minor.yy298,0);}
#line 3543 "parse.c"
        /* No destructor defined for PRAGMA */
        break;
      case 254:
#line 783 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 3549 "parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 255:
#line 784 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 3555 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 256:
#line 785 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 3561 "parse.c"
        break;
      case 257:
#line 786 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 3566 "parse.c"
        break;
      case 258:
        /* No destructor defined for PLUS */
        break;
      case 259:
        break;
      case 260:
#line 792 "parse.y"
{
  Token all;
  all.z = yymsp[-4].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-4].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqliteFinishTrigger(pParse, yymsp[-1].minor.yy19, &all);
}
#line 3581 "parse.c"
        /* No destructor defined for trigger_decl */
        /* No destructor defined for BEGIN */
        break;
      case 261:
#line 800 "parse.y"
{
  SrcList *pTab = sqliteSrcListAppend(0, &yymsp[-3].minor.yy298, &yymsp[-2].minor.yy298);
  sqliteBeginTrigger(pParse, &yymsp[-7].minor.yy298, yymsp[-6].minor.yy372, yymsp[-5].minor.yy290.a, yymsp[-5].minor.yy290.b, pTab, yymsp[-1].minor.yy372, yymsp[0].minor.yy182, yymsp[-9].minor.yy372);
}
#line 3591 "parse.c"
        /* No destructor defined for TRIGGER */
        /* No destructor defined for ON */
        break;
      case 262:
#line 806 "parse.y"
{ yygotominor.yy372 = TK_BEFORE; }
#line 3598 "parse.c"
        /* No destructor defined for BEFORE */
        break;
      case 263:
#line 807 "parse.y"
{ yygotominor.yy372 = TK_AFTER;  }
#line 3604 "parse.c"
        /* No destructor defined for AFTER */
        break;
      case 264:
#line 808 "parse.y"
{ yygotominor.yy372 = TK_INSTEAD;}
#line 3610 "parse.c"
        /* No destructor defined for INSTEAD */
        /* No destructor defined for OF */
        break;
      case 265:
#line 809 "parse.y"
{ yygotominor.yy372 = TK_BEFORE; }
#line 3617 "parse.c"
        break;
      case 266:
#line 813 "parse.y"
{ yygotominor.yy290.a = TK_DELETE; yygotominor.yy290.b = 0; }
#line 3622 "parse.c"
        /* No destructor defined for DELETE */
        break;
      case 267:
#line 814 "parse.y"
{ yygotominor.yy290.a = TK_INSERT; yygotominor.yy290.b = 0; }
#line 3628 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 268:
#line 815 "parse.y"
{ yygotominor.yy290.a = TK_UPDATE; yygotominor.yy290.b = 0;}
#line 3634 "parse.c"
        /* No destructor defined for UPDATE */
        break;
      case 269:
#line 816 "parse.y"
{yygotominor.yy290.a = TK_UPDATE; yygotominor.yy290.b = yymsp[0].minor.yy320; }
#line 3640 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for OF */
        break;
      case 270:
#line 819 "parse.y"
{ yygotominor.yy372 = TK_ROW; }
#line 3647 "parse.c"
        break;
      case 271:
#line 820 "parse.y"
{ yygotominor.yy372 = TK_ROW; }
#line 3652 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for ROW */
        break;
      case 272:
#line 821 "parse.y"
{ yygotominor.yy372 = TK_STATEMENT; }
#line 3660 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for STATEMENT */
        break;
      case 273:
#line 824 "parse.y"
{ yygotominor.yy182 = 0; }
#line 3668 "parse.c"
        break;
      case 274:
#line 825 "parse.y"
{ yygotominor.yy182 = yymsp[0].minor.yy242; }
#line 3673 "parse.c"
        /* No destructor defined for WHEN */
        break;
      case 275:
#line 829 "parse.y"
{
  yymsp[-2].minor.yy19->pNext = yymsp[0].minor.yy19;
  yygotominor.yy19 = yymsp[-2].minor.yy19;
}
#line 3682 "parse.c"
        /* No destructor defined for SEMI */
        break;
      case 276:
#line 833 "parse.y"
{ yygotominor.yy19 = 0; }
#line 3688 "parse.c"
        break;
      case 277:
#line 839 "parse.y"
{ yygotominor.yy19 = sqliteTriggerUpdateStep(&yymsp[-3].minor.yy298, yymsp[-1].minor.yy322, yymsp[0].minor.yy242, yymsp[-4].minor.yy372); }
#line 3693 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 278:
#line 844 "parse.y"
{yygotominor.yy19 = sqliteTriggerInsertStep(&yymsp[-5].minor.yy298, yymsp[-4].minor.yy320, yymsp[-1].minor.yy322, 0, yymsp[-7].minor.yy372);}
#line 3700 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 279:
#line 847 "parse.y"
{yygotominor.yy19 = sqliteTriggerInsertStep(&yymsp[-2].minor.yy298, yymsp[-1].minor.yy320, 0, yymsp[0].minor.yy179, yymsp[-4].minor.yy372);}
#line 3709 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 280:
#line 851 "parse.y"
{yygotominor.yy19 = sqliteTriggerDeleteStep(&yymsp[-1].minor.yy298, yymsp[0].minor.yy242);}
#line 3715 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 281:
#line 854 "parse.y"
{yygotominor.yy19 = sqliteTriggerSelectStep(yymsp[0].minor.yy179); }
#line 3722 "parse.c"
        break;
      case 282:
#line 857 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy242->iColumn = OE_Ignore;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3731 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for IGNORE */
        break;
      case 283:
#line 862 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy298); 
  yygotominor.yy242->iColumn = OE_Rollback;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3742 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for COMMA */
        break;
      case 284:
#line 867 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy298); 
  yygotominor.yy242->iColumn = OE_Abort;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3754 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ABORT */
        /* No destructor defined for COMMA */
        break;
      case 285:
#line 872 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy298); 
  yygotominor.yy242->iColumn = OE_Fail;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3766 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for FAIL */
        /* No destructor defined for COMMA */
        break;
      case 286:
#line 879 "parse.y"
{
  sqliteDropTrigger(pParse,sqliteSrcListAppend(0,&yymsp[-1].minor.yy298,&yymsp[0].minor.yy298));
}
#line 3776 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TRIGGER */
        break;
      case 287:
#line 884 "parse.y"
{
  sqliteAttach(pParse, &yymsp[-3].minor.yy298, &yymsp[-1].minor.yy298, &yymsp[0].minor.yy298);
}
#line 3785 "parse.c"
        /* No destructor defined for ATTACH */
        /* No destructor defined for database_kw_opt */
        /* No destructor defined for AS */
        break;
      case 288:
#line 888 "parse.y"
{ yygotominor.yy298 = yymsp[0].minor.yy298; }
#line 3793 "parse.c"
        /* No destructor defined for USING */
        break;
      case 289:
#line 889 "parse.y"
{ yygotominor.yy298.z = 0; yygotominor.yy298.n = 0; }
#line 3799 "parse.c"
        break;
      case 290:
        /* No destructor defined for DATABASE */
        break;
      case 291:
        break;
      case 292:
#line 895 "parse.y"
{
  sqliteDetach(pParse, &yymsp[0].minor.yy298);
}
#line 3811 "parse.c"
        /* No destructor defined for DETACH */
        /* No destructor defined for database_kw_opt */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqliteParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqliteErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqliteErrorMsg(pParse, "incomplete SQL statement");
    }
  }

#line 3865 "parse.c"
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqliteParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
