/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 10:11:43 CST 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@pooh.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kimageio.h>
#include <dcopclient.h>

#include <qstringlist.h>
#include <qfileinfo.h>

#include "splashscreen.h"
#include "digikamapp.h"
#include "digikamfirstrun.h"


static const char *description =
	I18N_NOOP("A Photo Management Application for KDE");


static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "digikam", I18N_NOOP("Digikam"),
                          VERSION,
			  description,
			  KAboutData::License_GPL,
                          I18N_NOOP("(c) 2002-2003, Digikam developers team"),
			  0,
			  "http://digikam.sourceforge.net",
			  "digikam-users@list.sourceforge.net");

    aboutData.addAuthor ( "Renchi Raju",
                          I18N_NOOP("Main coordinator and developer"),
                          "renchi@pooh.tam.uiuc.edu",
                          "http://digikam.sourceforge.net");

    aboutData.addAuthor ( "Caulier Gilles",
                          I18N_NOOP("Developer, translations coordinator, French translations"),
                          "caulier.gilles@free.fr",
                          "http://caulier.gilles.free.fr");

    aboutData.addCredit ( "Todd Shoemaker",
                          I18N_NOOP("Developer"),
                          "todd@theshoemakers.net",
			  0);

    aboutData.addCredit ( "Gregory Kokanosky",
                          I18N_NOOP("Developer"),
                          "gregory.kokanosky@free.fr",
			  0);

    aboutData.addCredit ( "Rune Laursen",
                          I18N_NOOP("Danish translations"),
                          "runerl@skjoldhoej.dk",
			  0);

    aboutData.addCredit ( "Stefano Rivoir",
                          I18N_NOOP("Italian translations"),
                          "s.rivoir@gts.it",
			  0);

    aboutData.addCredit ( "Jan Toenjes",
                          I18N_NOOP("German translations"),
                          "jan.toenjes@web.de",
			  0);

    aboutData.addCredit ( "Oliver Doerr",
                          I18N_NOOP("German translations and beta tester"),
                          "oliver@doerr-privat.de",
			  0);

    aboutData.addCredit ( "Quique",
                          I18N_NOOP("Spanish translations"),
                          "quique@sindominio.net",
			  0);

    aboutData.addCredit ( "Marcus Meissner",
                          I18N_NOOP("Czech and Hungarian translations"),
                          "marcus@jet.franken.de",
			  0);

    aboutData.addCredit ( "Achim Bohnet",
                          I18N_NOOP("Bugs reports and patchs"),
                          "ach@mpe.mpg.de",
			  0);

    aboutData.addCredit ( "Charles Bouveyron",
                          I18N_NOOP("Beta tester"),
                          "c.bouveyron@tuxfamily.org",
			  0);

    aboutData.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication app;

    // get our DCOP client and attach so that we may use it
    DCOPClient *client = app.dcopClient();
    client->attach();
    app.dcopClient()->registerAs(app.name(), false);

    double currentVersion = 0.6;

    KConfig* config = KGlobal::config();
    config->setGroup("General Settings");
    double version = config->readDoubleNumEntry("Version");

    config->setGroup("Album Settings");
    QString albumPath = config->readEntry("Album Path");
    QFileInfo dirInfo(albumPath);

    if (version < currentVersion || !dirInfo.exists()
        || !dirInfo.isDir())
    {
        // Run the first run
        DigikamFirstRun *firstRun = new DigikamFirstRun(config);
        app.setMainWidget(firstRun);
        firstRun->show();
        return app.exec();
    }
    
    // Register image formats (especially for TIFF )
    KImageIO::registerFormats();

    SplashScreen *splash = new SplashScreen();

    DigikamApp *digikam = new DigikamApp();

    app.setMainWidget(digikam);
    digikam->show();

    splash->finish( digikam );

    return app.exec();
}
