#ifndef THUMBNAILREQUEST_H
#define THUMBNAILREQUEST_H

#include <qstring.h>

#include "thumbnailsize.h"

class ThumbnailRequest {

public:

    ThumbnailRequest(const QString& fileName,
                     const ThumbnailSize& thumbSize)
        : mFileName(fileName.latin1()),
          mThumbSize(thumbSize)
        {
        }
    ~ThumbnailRequest() {
    }

    QString getFileName() const {
        return mFileName;
    }

    ThumbnailSize getThumbnailSize() const {
        return mThumbSize;
    }


private:

    QString mFileName;
    ThumbnailSize mThumbSize;

};

#endif
