/***************************************************************************
                          camerainfodialog.cpp  -  description
                             -------------------
    begin                : Tue Aug 27 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtabwidget.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtextedit.h>

#include <klocale.h>

#include "camerainfodialog.h"

CameraInfoDialog::CameraInfoDialog(const QString& summary,
                                   const QString& manual,
                                   const QString& about,
                                   QWidget *parent, const char* name,
                                   WFlags fl)
    : QWidget(parent,name,fl)
{

    resize(300,200);
    setCaption(i18n("Camera Information"));

    QGridLayout *layout = new QGridLayout(this, 1, 1, 5, 5);

    QTabWidget *tabWidget = new QTabWidget(this);
    layout->addMultiCellWidget(tabWidget, 0, 0, 0, 2);

    QTextEdit *summaryView = new QTextEdit(summary, QString::null,
                                           tabWidget);
    summaryView->setWordWrap(QTextEdit::WidgetWidth);
    summaryView->setReadOnly(true);
    tabWidget->addTab(summaryView, i18n("Camera Summary"));

    QTextEdit *manualView = new QTextEdit(manual, QString::null,
                                          tabWidget);
    manualView->setWordWrap(QTextEdit::WidgetWidth);
    manualView->setReadOnly(true);
    tabWidget->addTab(manualView, i18n("Camera Manual"));

    QTextEdit *aboutView = new QTextEdit(about, QString::null,
                                         tabWidget);
    aboutView->setWordWrap(QTextEdit::WidgetWidth);
    aboutView->setReadOnly(true);
    tabWidget->addTab(aboutView, i18n("Camera About"));


    QPushButton *okButton = new QPushButton(i18n("Close"), this);
    layout->addWidget(okButton, 1, 1);

    connect(okButton, SIGNAL(clicked()),
            this, SLOT(slot_close()));

}

CameraInfoDialog::~CameraInfoDialog()
{
}

void CameraInfoDialog::slot_close()
{
    close();
}
