#include <klocale.h>

#include <qstring.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qheader.h>

#include "camerafileiteminfo.h"
#include "camerafileiteminfodialog.h"

CameraFileItemInfoDialog::CameraFileItemInfoDialog(const CameraFileItemInfo& _fileInfo,
                                               QWidget* parent,
                                               const char* name,
                                               WFlags fl)
    : QWidget(parent,name,fl)
{

    resize( 310, 230 );
    mFileInfo = new CameraFileItemInfo(_fileInfo);
    setCaption(mFileInfo->getName());


    mLayout = new QGridLayout(this, 1, 1, 5, 5);

    mListView = new QListView( this);
    mListView->addColumn("Column1");
    mListView->addColumn("Column2");
    mListView->header()->hide();
    mListView->setSorting(-1);
    mListView->setAllColumnsShowFocus(true);
    mLayout->addMultiCellWidget(mListView, 0, 0, 0, 2 );

    mOkButton = new QPushButton(this);
    mOkButton->setText(i18n("Ok"));
    mLayout->addWidget(mOkButton, 1, 1);


    connect(mOkButton, SIGNAL(clicked()),
            this, SLOT(slot_close()));

    fillInformation();
}

CameraFileItemInfoDialog::~CameraFileItemInfoDialog()
{
    delete mFileInfo;
}

void CameraFileItemInfoDialog::slot_close()
{
    close();
}

void CameraFileItemInfoDialog::fillInformation()
{

    //-----------------------------------------------------------

    QString downloaded;
    int downloadedVal = mFileInfo->getDownloaded();
    if (downloadedVal < 0)
        downloaded = i18n("Unknown");
    else if (downloadedVal == 0)
        downloaded = i18n("Not Downloaded");
    else
        downloaded = i18n("Downloaded");

    (void) new QListViewItem(mListView,i18n("Status :"),
                             downloaded);
    //-----------------------------------------------------------

    QString writePerms;
    int writePermsVal = mFileInfo->getReadPermissions();
    if (writePermsVal < 0)
        writePerms = i18n("Unknown");
    else if (writePermsVal == 0)
        writePerms = i18n("No");
    else
        writePerms = i18n("Yes");

    (void) new QListViewItem(mListView,i18n("Write Permissions :"),
                             writePerms);
    //-----------------------------------------------------------

    QString readPerms;
    int readPermsVal = mFileInfo->getReadPermissions();
    if (readPermsVal < 0)
        readPerms = i18n("Unknown");
    else if (readPermsVal == 0)
        readPerms = i18n("No");
    else
        readPerms = i18n("Yes");

    (void) new QListViewItem(mListView,i18n("Read Permissions :"),
                             readPerms);

    //-----------------------------------------------------------

    QString height;
    int heightVal = mFileInfo->getHeight();
    if (heightVal < 0)
        height = i18n("Unknown");
    else
        height.setNum(heightVal);

    (void) new QListViewItem(mListView,i18n("Height :"),
                             height);

    //-----------------------------------------------------------

    QString width;
    int widthVal = mFileInfo->getWidth();
    if (widthVal < 0)
        width = i18n("Unknown");
    else
        width.setNum(widthVal);

    (void) new QListViewItem(mListView,i18n("Width :"),
                             width);


    //-----------------------------------------------------------

    QString size;
    int sizeVal = mFileInfo->getSize();
    if (sizeVal < 0)
        size = i18n("Unknown");
    else {
        size.setNum(sizeVal);
        size += " Bytes";
    }

    (void) new QListViewItem(mListView,i18n("Size :"),
                             size);

    //-----------------------------------------------------------

    QString mime(mFileInfo->getMime());
    if (mime.isEmpty()) mime = i18n("Unknown");

    (void) new QListViewItem(mListView,i18n("Mime :"),
                             mime);

    QString time(mFileInfo->getTime().stripWhiteSpace());
    if (time.isEmpty()) time = i18n("Unknown");

    (void) new QListViewItem(mListView,i18n("Last Modified :"),
                             time);

    //-----------------------------------------------------------

    (void) new QListViewItem(mListView,i18n("Folder :"),
                             mFileInfo->getFolder());

    //-----------------------------------------------------------

    (void) new QListViewItem(mListView,i18n("File Name :"),
                             mFileInfo->getName());


}
