/***************************************************************************
                          image_lister.cpp  -  description
                             -------------------
    begin                : Mon Jan 14 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <kfileviewitem.h>

#include "image_lister.h"

Image_Lister::Image_Lister(): KFileReader(){
}

Image_Lister::~Image_Lister(){
}

bool Image_Lister::matchesFilter(const KFileItem* paramItem) const {
  KFileViewItem* item=(KFileViewItem*)paramItem;

  // Check that it's a file
  if (!item->isFile()) {
    return false;
  }

  // Check that file is an image
  if (QPixmap::imageFormat(item->url().path())==NULL) {
    return false;
  }

  // If it's an image, init its file type
  item->determineMimeType();
  return true;
}
