#ifndef _FILEOP_H
#define _FILEOP_H

#include <qdialog.h>
#include <qstring.h>
#include <qlineedit.h>
#include <kbuttonbox.h>

enum OpType{Rename=0, AutoRename, Skip, SkipAll, Overwrite, OverwriteAll, None};

class FileOpDialog : public QDialog
{
    Q_OBJECT
public:
    FileOpDialog(const QString &src, const QString &dest,
                    QWidget *parent=0, const char *name=0);
	 ~FileOpDialog();
    OpType fileOpSelection(){return(op);}
    QString renameString(){return(renameEdit->text());}
protected slots:
    void slotRename(){op=Rename; accept();}
    void slotSkip(){op=Skip; accept();}
    void slotSkipAll(){op=SkipAll; accept();}
    void slotOverwrite(){op=Overwrite; accept();}
    void slotOverwriteAll(){op=OverwriteAll; accept();}

    void slotRenameEnabled(const QString &){renameBtn->setEnabled(true); renameBtn->setDefault(true);}
protected:
    OpType op;
    QLineEdit *renameEdit;
    QPushButton *renameBtn;
};

#endif
