/***************************************************************************
                          digikam.h  -  description
                             -------------------
    begin                : Thu Dec 20 12:40:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIGIKAM_H
#define DIGIKAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kstatusbar.h>
#include <kprogress.h>
#include <ksimpleconfig.h>

#include <qmap.h>

#include "digikam_mainwindow.h"


extern "C" {
	#include <gphoto2.h>
}


/** Digikam is the base class of the project */
class Digikam : public Digikam_MainWindow
{
  Q_OBJECT 
  public:
    /** construtor */
    Digikam(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~Digikam();


    protected slots:

	void slot_connectToCamera();
	void slot_selectAll();
	void slot_downloadImages();
      //void slot_help();
	void slot_setup();
	void slot_close();
	void slot_browse();

    private slots:
      //void slot_receivedMessage(KProcess *proc, char *buffer, int buflen);
      //void slot_processDone(KProcess *proc);

 private:
    static int frontendCameraStatus(Camera *camera, char *status);
    static int frontendCameraProgress(Camera *camera, CameraFile *file, float progress);
    static QMap<Camera *, Digikam *> my_cameraMap;

    void initGlobals();
    int  initCamera();
    void getThumbNails();
    void updateThumbNails();

    Camera *my_camera;
    CameraList *my_cameraList;
    CameraList *my_cameraListFiles;
    QString globDir;

    void setStatusMsg(const QString &);
    void setProgressValue(int progress);

    KStatusBar *statusBar;
    KProgress  *progressBar;
    KSimpleConfig *config;

    bool my_cameraInitialised;

};

#endif
