#!/bin/sh

# Laurent Montel <montel@kde.org> (2014)
# Remove local file to export macro and use autogenerated file
# kde-dev-scripts/kf5/port_to_autogenerate_export_header.sh <file_export.h>

if test $# != 1; then
  echo "Usage : $0 <file_export.h>"
  exit 1
fi

path=$1;
echo "$1";
directoryName=$(dirname $path);
echo "directoryname : $directoryName";

fileName=$(basename $path);
echo "basename : $fileName";

cmakelists="$directoryName/CMakeLists.txt"

if test -f $cmakelists ; then
   echo " there is a cmakelists.txt";
else
   echo "can't determinate CMakeLists.txt path, can't continue.";
   exit 1;
fi

exportname=`echo "$fileName" |perl -pe 's/\_export.h//'`
echo "$exportname";

generateHeader="generate_export_header($exportname BASE_NAME $exportname)";
echo "$generateHeader";

perl -pi -e 'if ( /add_library\s*\($exportname/ ) { $_ = $_ . "REPLACE_TO_GENERATE_HEADER\n" }' $cmakelists

perl -pi -e "s/REPLACE_TO_GENERATE_HEADER/$generateHeader/" $cmakelists

echo "remove export for from source";
git rm $path
