/*
  Copyright (c) 2013-2018 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "othermailerutil.h"
#include <KLocalizedString>
#include <QStandardPaths>
#include <QDir>

using namespace MailImporter;
QStringList OtherMailerUtil::isMailerFound()
{
    QStringList lst;
    QDir directory(OtherMailerUtil::trojitaDefaultPath());
    if (directory.exists()) {
        lst << i18nc("name of trojira application", "Trojita");
    }
    directory = OtherMailerUtil::gearyDefaultPath();
    if (directory.exists()) {
        lst << i18nc("name of geary application", "Geary");
    }
    directory = OtherMailerUtil::nylasMailDefaultPath();
    if (directory.exists()) {
        lst << i18nc("name of geary application", "Geary");
    }
    return lst;
}

QString OtherMailerUtil::trojitaDefaultPath()
{
    const QString path = QStandardPaths::writableLocation(QStandardPaths::GenericConfigLocation) + QLatin1String("/flaska.net/");
    return path;
}

QString OtherMailerUtil::gearyDefaultPath()
{
    const QString path = QStandardPaths::writableLocation(QStandardPaths::GenericConfigLocation) + QLatin1String("/geary/");
    return path;
}

QString OtherMailerUtil::nylasMailDefaultPath()
{
    const QString path = QDir::homePath() + QLatin1String("/.nylas-mail/");
    return path;
}
