/*
  Copyright (c) 2015-2018 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef COLLECTIONACLWIDGET_H
#define COLLECTIONACLWIDGET_H

#include <QWidget>
class QCheckBox;
namespace PimCommon {
class AclManager;
class CollectionAclWidget : public QWidget
{
    Q_OBJECT
public:
    explicit CollectionAclWidget(QWidget *parent = nullptr);
    ~CollectionAclWidget();

    PimCommon::AclManager *aclManager() const;
    bool recursive() const;
    void setEnableRecursiveCheckBox(bool enable);

private Q_SLOTS:
    void slotRecursivePermissionChanged();
    void slotCollectionCanBeAdministrated(bool b);

private:
    PimCommon::AclManager *mAclManager = nullptr;
    QCheckBox *mRecursiveChk = nullptr;
};
}

#endif // COLLECTIONACLWIDGET_H
