/*
   Copyright (C) 2013-2017 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef SIEVEEDITORMAINWINDOW_H
#define SIEVEEDITORMAINWINDOW_H

#include <KXmlGuiWindow>
#include "libsieveeditor_export.h"

class QAction;
class SieveEditorCentralWidget;
class QLabel;
class SieveEditorBookmarks;
class KActionMenu;
namespace PimCommon
{
class KActionMenuChangeCase;
}

class LIBSIEVEEDITOR_EXPORT SieveEditorMainWindow : public KXmlGuiWindow
{
    Q_OBJECT
public:
    explicit SieveEditorMainWindow(QWidget *parent = nullptr);
    ~SieveEditorMainWindow();

    QString currentHelpTitle() const;
    QUrl currentHelpUrl() const;

protected:
    void closeEvent(QCloseEvent *e) Q_DECL_OVERRIDE;

private Q_SLOTS:
    void slotConfigure();
    void slotAddServerSieve();
    void slotCreateNewScript();
    void slotDeleteScript();
    void slotUpdateButtons(bool newScriptAction, bool editScriptAction, bool deleteScriptAction, bool desactivateScriptAction);
    void slotEditScript();
    void slotDesactivateScript();
    void slotRefreshList();
    void slotUploadScript();
    void slotUpdateActions();
    void slotSystemNetworkOnlineStateChanged(bool state);
    void slotUndoAvailable(bool);
    void slotRedoAvailable(bool);
    void slotCopyAvailable(bool b);
    void slotOpenBookmarkUrl(const QUrl &url);
    void slotImportImapSettings();
private:
    void initStatusBar();
    void readConfig();
    void setupActions();
    SieveEditorCentralWidget *mMainWidget;
    QAction *mDeleteScript;
    QAction *mNewScript;
    QAction *mEditScript;
    QAction *mDesactivateScript;
    QAction *mRefreshList;
    QAction *mUploadScript;
    QAction *mGoToLine;
    QAction *mFindAction;
    QAction *mReplaceAction;
    QAction *mUndoAction;
    QAction *mRedoAction;
    QAction *mCopyAction;
    QAction *mPasteAction;
    QAction *mCutAction;
    QAction *mSelectAllAction;
    QAction *mSaveAsAction;
    QAction *mImportAction;
    QAction *mShareAction;
    QAction *mSpellCheckAction;
    QAction *mCheckSyntaxAction;
    QAction *mCreateRulesGraphicallyAction;
    QAction *mCommentAction;
    QAction *mUncommentAction;
    QAction *mZoomInAction;
    QAction *mZoomOutAction;
    QAction *mZoomResetAction;
    QAction *mDebugSieveScriptAction;
    QAction *mWrapTextAction;
    QAction *mPrintAction;
    QAction *mPrintPreviewAction;
    PimCommon::KActionMenuChangeCase *mMenuChangeCaseAction;

    QLabel *mStatusBarInfo;
    SieveEditorBookmarks *mSieveEditorBookmarks;
    KActionMenu *mBookmarkMenu;
    bool mNetworkIsDown;
};

#endif // SIEVEEDITORMAINWINDOW_H
